<?php

/**
 * YouTube Feed Builder
 *
 * @since 2.0
 */
namespace Smashballoon\Customizer;

use SmashBalloon\YouTubeFeed\SBY_Vars;
use Smashballoon\Customizer\Tabs\Manager;
use SmashBalloon\YouTubeFeed\SBY_Settings;
use SmashBalloon\YouTubeFeed\Helpers\Util;
use Smashballoon\Customizer\Tabs\Builder_Customizer_Tab;
use SmashBalloon\YouTubeFeed\Services\LicenseNotification;
class Feed_Builder
{
    private static $instance;
    /**
     * @var Feed_Saver_Manager
     */
    private $saver_manager;
    private $preview_provider;
    protected $license_service;
    /**
     * @var Source
     */
    private $source;
    /**
     * @var Config
     */
    private $config;
    /**
     * @var string
     */
    private $screen_id;
    /**
     * @var Feed_Saver
     */
    private $feed_saver;
    /**
     * @var Feed_Locator
     */
    private $feed_locator;
    /**
     * @var DB
     */
    private $DB;
    public static function instance()
    {
        if (null === self::$instance) {
            self::$instance = \Smashballoon\Customizer\Container::getInstance()->get(self::class);
            return self::$instance;
        }
        return self::$instance;
    }
    /**
     * Constructor.
     *
     * @since 6.0
     */
    public function __construct(\Smashballoon\Customizer\Feed_Saver_Manager $saver_manager, \Smashballoon\Customizer\PreviewProvider $preview_provider, \Smashballoon\Customizer\Source $source, \Smashballoon\Customizer\Config $config, \Smashballoon\Customizer\Feed_Saver $feed_saver, \Smashballoon\Customizer\Feed_Locator $feed_locator, \Smashballoon\Customizer\DB $DB)
    {
        $this->saver_manager = $saver_manager;
        $this->preview_provider = $preview_provider;
        $this->source = $source;
        $this->config = $config;
        $this->feed_saver = $feed_saver;
        $this->feed_locator = $feed_locator;
        $this->DB = $DB;
        $this->license_service = new LicenseNotification();
        $this->screen_id = sprintf('%s-feed-builder', $this->config->plugin_slug);
        $this->init();
    }
    /**
     * Init the Builder.
     *
     * @since 6.0
     */
    public function init()
    {
        if (!is_admin()) {
            return;
        }
        // register admin menu for sby-feed-builder
        add_action('admin_menu', array($this, 'register_menu'), 99);
        // add ajax listeners
        $this->saver_manager->hooks();
        \Smashballoon\Customizer\Source::hooks();
        self::hooks();
    }
    /**
     * Mostly AJAX related hooks
     *
     * @since 6.0
     */
    public static function hooks()
    {
    }
    /**
     * Check users capabilities and maybe nonce before AJAX actions
     *
     * @param $check_nonce
     * @param string $action
     *
     * @since 6.0
     */
    public static function check_privilege($check_nonce = \false, $action = 'sby-admin')
    {
        $cap = current_user_can('manage_instagram_feed_options') ? 'manage_instagram_feed_options' : 'manage_options';
        $cap = apply_filters('sbi_settings_pages_capability', $cap);
        if (!current_user_can($cap)) {
            wp_die('You did not do this the right way!');
        }
        if ($check_nonce) {
            $nonce = !empty($_POST[$check_nonce]) ? $_POST[$check_nonce] : \false;
            if (!wp_verify_nonce($nonce, $action)) {
                wp_die('You did not do this the right way!');
            }
        }
    }
    /**
     * Register Menu.
     *
     * @since 6.0
     */
    public function register_menu()
    {
        add_action('load-toplevel_page_' . $this->screen_id, array($this, 'builder_enqueue_admin_scripts'));
        add_action('customizer_enqueue_scripts_main', function () {
            $this->global_enqueue_ressources_scripts();
            wp_enqueue_script('sbc-builder-init', isset($_ENV['CUSTOMIZER_DEVELOPMENT']) && $_ENV['CUSTOMIZER_DEVELOPMENT'] === 'true' ? 'http://localhost:8089/main.min.js' : CUSTOMIZER_PLUGIN_URL . 'assets/js/main.min.js', null, SBCVER);
        }, 0);
        add_action('customizer_enqueue_scripts', function () {
            $this->global_enqueue_ressources_scripts();
            wp_enqueue_script('sbc-builder-app', isset($_ENV['CUSTOMIZER_DEVELOPMENT']) && $_ENV['CUSTOMIZER_DEVELOPMENT'] === 'true' ? 'http://localhost:8089/builder.min.js' : CUSTOMIZER_PLUGIN_URL . 'assets/js/builder.min.js', null, SBCVER, \true);
            wp_enqueue_script('sbc-dialog-box', CUSTOMIZER_PLUGIN_URL . 'assets/js/confirm-dialog.js', null, SBCVER, \true);
        }, 99);
    }
    /**
     * Enqueue Builder CSS & Script.
     *
     * Loads only for builder pages
     *
     * @since 6.0
     */
    public function builder_enqueue_admin_scripts()
    {
        if (get_current_screen()) {
            $screen = get_current_screen();
            if (\false !== strpos($screen->id, $this->screen_id)) {
                do_action('customizer_enqueue_scripts_main');
                do_action('customizer_enqueue_scripts');
                $installed_plugins = get_plugins();
                $newly_retrieved_source_connection_data = \Smashballoon\Customizer\Source::maybe_source_connection_data();
                $license_key = get_option('sby_license_key', '');
                $upgrade_url = 'https://smashballoon.com/youtube-feed/demo/?utm_campaign=youtube-free&utm_source=lite-upgrade-bar';
                // YouTube License Tier
                $license_tier = new \Smashballoon\Customizer\YouTube_License_Tier();
                $sbc_builder = array('ajaxHandler' => admin_url('admin-ajax.php'), 'pluginType' => sby_is_pro() ? 'pro' : 'free', 'builderUrl' => admin_url('admin.php?page=' . $this->screen_id), 'nonce' => wp_create_nonce('sby-admin'), 'activeExtensions' => self::get_active_extensions(), 'adminPostURL' => admin_url('post.php'), 'widgetsPageURL' => admin_url('widgets.php'), 'supportPageUrl' => admin_url('admin.php?page=youtube-feed-support'), 'pluginURL' => CUSTOMIZER_PLUGIN_URL, 'upgradeUrl' => $upgrade_url, 'genericText' => self::get_generic_text(), 'feedTemplates' => self::get_feed_templates(), 'feedTypes' => self::get_feed_types(), 'advancedFeedTypes' => self::get_advanced_feed_types(), 'sourcesScreenText' => self::get_sources_screen_texts(), 'apiKeyPopupScreen' => self::api_key_popup_screen_texts(), 'apiKeyStatus' => self::check_api_key_status(), 'connectedAccountStatus' => self::check_connected_account_status(), 'youtubeAccountConnectURL' => self::oauth_connet_url(), 'youtubeAccountConnectParameters' => self::oauth_connet_parameters(), 'prefilledChannelId' => self::get_prefilled_channel_id(), 'feedtypesTooltipContent' => self::get_feedtypes_tooltip_content(), 'license_tier_features' => $license_tier->tier_features(), 'pluginsInfo' => ['social_wall' => ['installed' => isset($installed_plugins['social-wall/social-wall.php']) ? \true : \false, 'activated' => is_plugin_active('social-wall/social-wall.php'), 'settingsPage' => admin_url('admin.php?page=sbsw#/create-feed')]], 'selectFeedTypeScreen' => array('mainHeading' => __('Create a YouTube feed', 'feeds-for-youtube'), 'feedTypeHeading' => __('Select Feed Type', 'feeds-for-youtube'), 'feedTypeAdvancedHeading' => __('Advanced Feeds', 'feeds-for-youtube'), 'mainDescription' => __('Select one or more feed types. You can add or remove them later.', 'feeds-for-youtube'), 'updateHeading' => __('Update Feed Type', 'feeds-for-youtube'), 'updateSourceHeading' => __('Update Source Type', 'feeds-for-youtube'), 'anotherFeedTypeHeading' => __('Add Another Feed Type', 'feeds-for-youtube'), 'addSource' => __('Add Source', 'feeds-for-youtube'), 'updateHeadingWarning' => __('Changing a template will override your layout, header and button settings', 'youtube-feed-pro')), 'embedPopupScreen' => array('heading' => __('Embed Feed', 'feeds-for-youtube'), 'description' => __('Add the unique shortcode to any page, post, or widget:', 'feeds-for-youtube'), 'description_2' => __('Or use the built in WordPress block or widget', 'feeds-for-youtube'), 'addPage' => __('Add to a Page', 'feeds-for-youtube'), 'addWidget' => __('Add to a Widget', 'feeds-for-youtube'), 'selectPage' => __('Select Page', 'feeds-for-youtube')), 'welcomeScreen' => array('mainHeading' => __('All Feeds', 'feeds-for-youtube'), 'createFeed' => __('Create your Feed', 'feeds-for-youtube'), 'createFeedDescription' => __('Connect your YouTube account and choose a feed type', 'feeds-for-youtube'), 'customizeFeed' => __('Customize your feed type', 'feeds-for-youtube'), 'customizeFeedDescription' => __('Choose layouts, color schemes, filters and more', 'feeds-for-youtube'), 'embedFeed' => __('Embed your feed', 'feeds-for-youtube'), 'embedFeedDescription' => __('Easily add the feed anywhere on your website', 'feeds-for-youtube'), 'customizeImgPath' => CUSTOMIZER_PLUGIN_URL . 'assets/img/welcome-1.png', 'embedImgPath' => CUSTOMIZER_PLUGIN_URL . 'assets/img/welcome-2.png'), 'dialogBoxPopupScreen' => array('deleteSourceCustomizer' => array('heading' => __('Delete "#"?', 'feeds-for-youtube'), 'description' => __('You are going to delete this source. To retrieve it, you will need to add it again. Are you sure you want to continue?', 'feeds-for-youtube')), 'deleteSingleFeed' => array('heading' => __('Delete "#"?', 'feeds-for-youtube'), 'description' => __('You are going to delete this feed. You will lose all the settings. Are you sure you want to continue?', 'feeds-for-youtube')), 'deleteMultipleFeeds' => array('heading' => __('Delete Feeds?', 'feeds-for-youtube'), 'description' => __('You are going to delete these feeds. You will lose all the settings. Are you sure you want to continue?', 'feeds-for-youtube')), 'backAllToFeed' => array('heading' => __('Are you Sure?', 'feeds-for-youtube'), 'description' => __('Are you sure you want to leave this page, all unsaved settings will be lost, please make sure to save before leaving.', 'feeds-for-youtube')), 'unsavedFeedSources' => array('heading' => __('You have unsaved changes', 'feeds-for-youtube'), 'description' => __('If you exit without saving, all the changes you made will be reverted.', 'feeds-for-youtube'), 'customButtons' => array('confirm' => ['text' => __('Save and Exit', 'feeds-for-youtube'), 'color' => 'blue'], 'cancel' => ['text' => __('Exit without Saving', 'feeds-for-youtube'), 'color' => 'red']))), 'allFeedsScreen' => array('mainHeading' => __('All Feeds', 'feeds-for-youtube'), 'columns' => array('nameText' => __('Name', 'feeds-for-youtube'), 'shortcodeText' => __('Shortcode', 'feeds-for-youtube'), 'instancesText' => __('Instances', 'feeds-for-youtube'), 'actionsText' => __('Actions', 'feeds-for-youtube')), 'bulkActions' => __('Bulk Actions', 'feeds-for-youtube'), 'legacyFeeds' => array('heading' => __('Legacy Feeds', 'feeds-for-youtube'), 'toolTip' => __('What are Legacy Feeds?', 'feeds-for-youtube'), 'toolTipExpanded' => array(__('Legacy feeds are older feeds from before the version 6 update. You can edit settings for these feeds by using the "Settings" button to the right. These settings will apply to all legacy feeds, just like the settings before version 6, and work in the same way that they used to.', 'feeds-for-youtube'), __('You can also create a new feed, which will now have it\'s own individual settings. Modifying settings for new feeds will not affect other feeds.', 'feeds-for-youtube')), 'toolTipExpandedAction' => array(__('Legacy feeds represent shortcodes of old feeds found on your website before <br/>the version 6 update.', 'feeds-for-youtube'), __('To edit Legacy feed settings, you will need to use the "Settings" button above <br/>or edit their shortcode settings directly. To delete them, simply remove the <br/>shortcode wherever it is being used on your site.', 'feeds-for-youtube')), 'show' => __('Show Legacy Feeds', 'feeds-for-youtube'), 'hide' => __('Hide Legacy Feeds', 'feeds-for-youtube')), 'socialWallLinks' => self::get_social_wall_links(), 'onboarding' => $this->get_onboarding_text()), 'selectFeedTemplateScreen' => array('feedTemplateHeading' => __('Start with a template', 'youtube-feed-pro'), 'feedTemplateDescription' => __('Select a starting point for your feed. You can customize this later.', 'youtube-feed-pro'), 'updateHeading' => __('Select another template', 'youtube-feed-pro'), 'updateHeadingWarning' => __('Changing a template will override your layout, header and button settings', 'youtube-feed-pro')), 'svgIcons' => $this->builder_svg_icons(), 'feeds' => $this->get_feed_list(), 'legacyFeeds' => $this->get_legacy_feed_list(), 'licenseKey' => $license_key, 'extensionsPopup' => $this->get_extensions_popup($license_key, $license_tier), 'itemsPerPage' => $this->DB->get_results_per_page(), 'feedsCount' => $this->DB->feeds_count(), 'selectTemplate' => array('title' => __('Start with a template', 'feeds-for-youtube'), 'description' => __('What do you want your feed to look like? Don’t worry, you can always change this or further customize it later.', 'feeds-for-youtube')), 'sbyIsPro' => sby_is_pro() ? "1" : "0", 'sbyLicenseNoticeActive' => sby_license_notices_active() ? \true : \false, 'sbyLicenseInactiveState' => sby_license_inactive_state() ? \true : \false, 'whiteBalloonIcon' => $this->builder_svg_icons()['whiteBalloon']);
                if ($newly_retrieved_source_connection_data) {
                    $sbc_builder['newSourceData'] = $newly_retrieved_source_connection_data;
                }
                if (isset($_GET['manualsource']) && $_GET['manualsource'] == \true) {
                    $sbc_builder['manualSourcePopupInit'] = \true;
                }
                $maybe_feed_customizer_data = $this->saver_manager->maybe_feed_customizer_data();
                if ($maybe_feed_customizer_data) {
                    $sbc_builder['customizerFeedData'] = $maybe_feed_customizer_data;
                    $sbc_builder['customizerSidebarBuilder'] = Manager::getInstance()->get_tabs();
                    $sbc_builder['wordpressPageLists'] = $this->get_wp_pages();
                    $sbc_builder['youtube_feed_dismiss_lite'] = get_transient('youtube_feed_dismiss_lite');
                    if (!isset($_GET['feed_id']) || $_GET['feed_id'] === 'legacy') {
                        $feed_id = 'legacy';
                        $customizer_atts = $maybe_feed_customizer_data['settings'];
                        $customizer_atts['customizer'] = \true;
                    } elseif (intval($_GET['feed_id']) > 0) {
                        $feed_id = intval($_GET['feed_id']);
                        $customizer_atts = array('feed' => $feed_id, 'customizer' => \true);
                    }
                    if (!empty($feed_id)) {
                        $settings_preview = self::add_customizer_att($customizer_atts);
                        if ($feed_id === 'legacy') {
                            $preview_settings = SBY_Settings::get_legacy_feed_settings();
                            $customizer_atts = self::add_legacy_customizer_att();
                            $feed_data = $this->preview_provider->render($customizer_atts, $preview_settings);
                            $sbc_builder['headerData'] = isset($feed_data['header']) ? $feed_data['header'] : '';
                            $sbc_builder['feedInitOutput'] = htmlspecialchars($feed_data['feedInitOutput']);
                        } else {
                            $feed_data = $this->preview_provider->render($settings_preview, \false);
                            $sbc_builder['headerData'] = isset($feed_data['header']) ? $feed_data['header'] : '';
                            $sbc_builder['feedInitOutput'] = htmlspecialchars($feed_data['feedInitOutput']);
                        }
                    }
                }
                wp_enqueue_style('sby-builder-style', CUSTOMIZER_PLUGIN_URL . 'assets/css/builder.css', \false, SBYVER);
                // Customize screens
                $sbc_builder['customizeScreens'] = $this->get_customize_screens_text();
                wp_localize_script('sbc-builder-init', 'sbc_builder', $sbc_builder);
                wp_enqueue_media();
            }
        }
    }
    /**
     * Get WP Pages List
     *
     * @return array
     *
     * @since 6.0
     */
    public function get_wp_pages()
    {
        $pagesList = get_pages();
        $pagesResult = array();
        if (is_array($pagesList)) {
            foreach ($pagesList as $page) {
                array_push($pagesResult, array('id' => $page->ID, 'title' => $page->post_title));
            }
        }
        return $pagesResult;
    }
    /**
     * Global JS + CSS Files
     *
     * Shared JS + CSS ressources for the admin panel
     *
     * @since 6.0
     */
    public function global_enqueue_ressources_scripts($is_settings = \false)
    {
        wp_enqueue_style('feed-global-style', CUSTOMIZER_PLUGIN_URL . 'assets/css/global.css', \false, SBYVER);
        wp_enqueue_script('feed-builder-vue', 'https://cdn.jsdelivr.net/npm/vue@2.6.12', null, '2.6.12', \true);
        wp_enqueue_script('feed-colorpicker-vue', CUSTOMIZER_PLUGIN_URL . 'assets/js/vue-color.min.js', null, SBYVER, \true);
        wp_enqueue_script('feed-builder-resources', CUSTOMIZER_PLUGIN_URL . 'assets/js/resources.js', null, SBYVER, \true);
        // wp_enqueue_script(
        // 	'sb-dialog-box',
        // 	CUSTOMIZER_PLUGIN_URL . 'assets/js/confirm-dialog.js',
        // 	null,
        // 	SBYVER,
        // 	true
        // );
        // wp_enqueue_script(
        // 	'install-plugin-popup',
        // 	CUSTOMIZER_PLUGIN_URL . 'assets/js/install-plugin-popup.js',
        // 	null,
        // 	SBYVER,
        // 	true
        // );
        // wp_enqueue_script(
        // 	'sb-add-source',
        // 	CUSTOMIZER_PLUGIN_URL . 'assets/js/add-source.js',
        // 	null,
        // 	SBYVER,
        // 	true
        // );
        $newly_retrieved_source_connection_data = \Smashballoon\Customizer\Source::maybe_source_connection_data();
        $sbi_source = array('sources' => $this->saver_manager->get_source_list(), 'sourceConnectionURLs' => $this->source->get_connection_urls($is_settings), 'nonce' => wp_create_nonce('sby-admin'));
        if ($newly_retrieved_source_connection_data) {
            $sbi_source['newSourceData'] = $newly_retrieved_source_connection_data;
        }
        if (isset($_GET['manualsource']) && $_GET['manualsource'] == \true) {
            $sbi_source['manualSourcePopupInit'] = \true;
        }
        wp_localize_script('sb-add-source', 'sbi_source', $sbi_source);
    }
    /**
     * For types listed on the top of the select feed type screen
     *
     * @return array
     *
     * @since 4.0
     */
    public function get_feed_templates()
    {
        $feed_types = array(array('type' => 'default', 'title' => __('Default', 'feeds-for-youtube'), 'icon' => 'defaultFTIcon'), array('type' => 'carousel', 'title' => __('Carousel', 'feeds-for-youtube'), 'icon' => 'carouselFTIcon'), array('type' => 'cards', 'title' => __('Cards', 'feeds-for-youtube'), 'icon' => 'cardsFTIcon'), array('type' => 'list', 'title' => __('List', 'feeds-for-youtube'), 'icon' => 'listFTIcon'), array('type' => 'gallery', 'title' => __('Gallery', 'feeds-for-youtube'), 'icon' => 'galleryFTIcon'), array('type' => 'latest_video', 'title' => __('Latest Video', 'feeds-for-youtube'), 'icon' => 'latestVideoFTIcon'), array('type' => 'showcase_carousel', 'title' => __('Showcase Carousel', 'feeds-for-youtube'), 'icon' => 'showcaseCarouselFTIcon'), array('type' => 'widget', 'title' => __('Widget', 'feeds-for-youtube'), 'icon' => 'widgetFTIcon'));
        return $feed_types;
    }
    /**
     * Get active extensions
     * 
     * @since 2.0
     */
    public static function get_active_extensions()
    {
        return [
            //Fake
            ['type' => 'feedLayout', 'active' => \false, 'ids' => ['layout']],
            ['type' => 'subscribersCount', 'active' => \false, 'ids' => ['showsubscribe']],
            ['type' => 'videoElements', 'active' => \false, 'ids' => ['include']],
            ['type' => 'call_to_action', 'active' => \false, 'ids' => ['cta']],
            ['type' => 'advancedFilters', 'active' => \false, 'ids' => ['filters']],
            ['type' => 'feedTemplate', 'active' => \false, 'ids' => ['template']],
        ];
    }
    /**
     * Get extensions popup
     * 
     * @since 2.0
     * 
     * @return array 
     */
    public function get_extensions_popup($license_key, $license_tier)
    {
        $pro_text = __('Pro', 'feeds-for-youtube');
        $plus_text = __('Plus', 'feeds-for-youtube');
        $elite_text = __('Elite', 'feeds-for-youtube');
        return array(
            'playlist' => array('heading' => $this->get_extension_popup_dynamic_heading('Playlist Feeds </br>', $pro_text), 'description' => __('Use YouTube to create a curated list of related videos and display it on your site.', 'feeds-for-youtube'), 'popupContentBtn' => '<div class="sbc-extpp-lite-btn">' . self::builder_svg_icons()['tag'] . __('Lite Feed Users get a 50% OFF', 'feeds-for-youtube') . '</div>', 'img' => '<svg width="456" height="264" viewBox="0 0 456 264" fill="none" xmlns="http://www.w3.org/2000/svg"><g filter="url(#filter0_dddd_132_35313)"><g clip-path="url(#clip0_132_35313)"><rect x="98" y="49.9895" width="214.884" height="144.558" rx="2.60465" transform="rotate(-4 98 49.9895)" fill="#0068A0"/><circle cx="161.162" cy="179.688" r="106.323" fill="#0096CC"/><rect width="100.279" height="144.558" transform="translate(212.325 41.9929) rotate(-4)" fill="black" fill-opacity="0.7"/><path d="M261.239 102.788C263.951 102.598 265.464 101.161 265.318 99.0719C265.219 97.6533 264.282 96.7945 262.968 96.6044C264.048 96.1372 264.726 95.3065 264.639 94.0593C264.517 92.3132 262.993 91.1352 260.545 91.3063C258.004 91.484 256.659 93.082 256.677 95.133L258.906 94.9771C258.958 93.9239 259.568 93.2389 260.628 93.1648C261.657 93.0928 262.213 93.6493 262.269 94.4444C262.335 95.3953 261.842 95.9625 260.673 96.0442L259.862 96.1009L259.98 97.7846L260.853 97.7236C262.053 97.6396 262.684 98.1438 262.758 99.2039C262.828 100.202 262.278 100.851 261.015 100.939C259.675 101.033 259.043 100.294 258.874 99.2249L256.598 99.384C256.85 101.638 258.401 102.986 261.239 102.788ZM266.898 102.22L275.316 101.631L275.182 99.7138L270.848 100.017L272.809 97.8118C274.015 96.4742 274.788 95.1982 274.684 93.7172C274.544 91.7061 273.045 90.4323 270.582 90.6045C268.087 90.779 266.626 92.2911 266.681 94.8721L268.973 94.7118C269.042 93.2344 269.625 92.614 270.608 92.5453C271.574 92.4777 272.13 93.0341 272.194 93.9539C272.265 94.9673 271.648 95.9974 270.652 97.2107L266.869 101.815L266.898 102.22Z" fill="white"/><path d="M257.025 121.118L273.914 119.937L274.096 122.535L257.207 123.716L257.025 121.118ZM256.662 115.921L273.551 114.74L273.732 117.338L256.843 118.519L256.662 115.921ZM257.388 126.314L269.081 125.497L269.263 128.095L257.57 128.913L257.388 126.314ZM271.679 125.315L272.179 132.46L278.447 128.758L271.679 125.315Z" fill="white"/></g><rect x="94.6293" y="47.0594" width="221.2" height="150.874" rx="5.76275" transform="rotate(-4 94.6293 47.0594)" stroke="white" stroke-width="6.31621"/></g><g filter="url(#filter1_dddd_132_35313)"><g clip-path="url(#clip1_132_35313)"><rect x="142.171" y="72.4392" width="214.884" height="144.558" rx="2.60465" fill="#59AB46"/><circle cx="320.12" cy="70.2066" r="106.323" fill="#76C064"/><rect width="100.279" height="144.558" transform="translate(256.772 72.439)" fill="black" fill-opacity="0.7"/><path d="M289.516 133.262H292.811V118.715H289.922L286.565 121.095V123.903L289.516 121.97V133.262ZM301.329 133.486C304.686 133.486 306.904 131.512 306.904 128.42C306.904 125.327 305.093 123.516 302.448 123.516C300.8 123.516 299.783 124.167 299.213 124.859L299.274 121.217H306.029V118.715H296.813L296.609 126.995H298.44C299.03 126.324 299.864 125.836 301.228 125.836C302.692 125.836 303.588 126.812 303.588 128.379C303.588 129.925 302.794 130.963 301.309 130.963C299.641 130.963 299.152 130.149 298.969 128.928H295.938C296.08 131.532 297.748 133.486 301.329 133.486ZM315.905 133.262H319.1V130.373H321.012V128.013H319.1V118.715H315.051L308.764 129.172V130.373H315.905V133.262ZM312.06 128.013L315.966 121.197V128.013H312.06Z" fill="white"/><path d="M292.699 157.042H314.739V160.433H292.699V157.042ZM292.699 150.261H314.739V153.652H292.699V150.261ZM292.699 163.824H307.957V167.215H292.699V163.824ZM311.348 163.824V173.149L319.825 168.911L311.348 163.824Z" fill="white"/></g><rect x="139.539" y="69.8075" width="220.147" height="149.822" rx="5.2364" stroke="#F9F9FA" stroke-width="5.26351"/></g><defs><filter id="filter0_dddd_132_35313" x="82.7584" y="27.0386" width="254.927" height="189.679" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.90196"/><feGaussianBlur stdDeviation="0.563725"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.1137 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_132_35313"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="2.16754"/><feGaussianBlur stdDeviation="1.35471"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0484671 0"/><feBlend mode="normal" in2="effect1_dropShadow_132_35313" result="effect2_dropShadow_132_35313"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.08128"/><feGaussianBlur stdDeviation="2.5508"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.06 0"/><feBlend mode="normal" in2="effect2_dropShadow_132_35313" result="effect3_dropShadow_132_35313"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="7.2803"/><feGaussianBlur stdDeviation="4.55019"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0715329 0"/><feBlend mode="normal" in2="effect3_dropShadow_132_35313" result="effect4_dropShadow_132_35313"/><feBlend mode="normal" in="SourceGraphic" in2="effect4_dropShadow_132_35313" result="shape"/></filter><filter id="filter1_dddd_132_35313" x="127.807" y="65.3557" width="243.611" height="173.286" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.90196"/><feGaussianBlur stdDeviation="0.563725"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.1137 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_132_35313"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="2.16754"/><feGaussianBlur stdDeviation="1.35471"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0484671 0"/><feBlend mode="normal" in2="effect1_dropShadow_132_35313" result="effect2_dropShadow_132_35313"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.08128"/><feGaussianBlur stdDeviation="2.5508"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.06 0"/><feBlend mode="normal" in2="effect2_dropShadow_132_35313" result="effect3_dropShadow_132_35313"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="7.2803"/><feGaussianBlur stdDeviation="4.55019"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0715329 0"/><feBlend mode="normal" in2="effect3_dropShadow_132_35313" result="effect4_dropShadow_132_35313"/><feBlend mode="normal" in="SourceGraphic" in2="effect4_dropShadow_132_35313" result="shape"/></filter><clipPath id="clip0_132_35313"><rect x="98" y="49.9895" width="214.884" height="144.558" rx="2.60465" transform="rotate(-4 98 49.9895)" fill="white"/></clipPath><clipPath id="clip1_132_35313"><rect x="142.171" y="72.4392" width="214.884" height="144.558" rx="2.60465" fill="white"/></clipPath></defs></svg>', 'demoUrl' => 'https://smashballoon.com/youtube-feed/demo/?utm_campaign=youtube-free&utm_source=feed-type&utm_medium=youtube-feed&utm_content=view-demo', 'buyUrl' => $this->get_extension_popup_dynamic_buy_url($license_key), 'bullets' => ['heading' => __('And get much more!', 'feeds-for-youtube'), 'content' => [__('Covert videos to WP Posts', 'feeds-for-youtube'), __('Show subscribers', 'feeds-for-youtube'), __('Show video details', 'feeds-for-youtube'), __('Fast and Effective Support', 'feeds-for-youtube'), __('Always up to date', 'feeds-for-youtube'), __('30 day money back guarantee', 'feeds-for-youtube')]]),
            'favorites' => array('heading' => $this->get_extension_popup_dynamic_heading('Favorites Feed', $pro_text), 'description' => __('Build your brand and engage your followers by showing off your favorite videos from any channel on YouTube.', 'feeds-for-youtube'), 'popupContentBtn' => '<div class="sbc-extpp-lite-btn">' . self::builder_svg_icons()['tag'] . __('Lite Feed Users get a 50% OFF', 'feeds-for-youtube') . '</div>', 'img' => '<svg width="456" height="264" viewBox="0 0 456 264" fill="none" xmlns="http://www.w3.org/2000/svg"><g filter="url(#filter0_dddd_132_35329)"><g clip-path="url(#clip0_132_35329)"><rect x="98" y="49.9895" width="214.884" height="144.558" rx="2.60465" transform="rotate(-4 98 49.9895)" fill="#8C8F9A"/><circle cx="161.162" cy="179.688" r="106.323" fill="#2C324C"/><rect width="100.279" height="144.558" transform="translate(212.325 41.9929) rotate(-4)" fill="black" fill-opacity="0.7"/><path d="M261.239 102.788C263.951 102.598 265.464 101.161 265.318 99.0719C265.219 97.6533 264.282 96.7945 262.968 96.6044C264.048 96.1372 264.726 95.3065 264.639 94.0593C264.517 92.3132 262.993 91.1352 260.545 91.3063C258.004 91.484 256.659 93.082 256.677 95.133L258.906 94.9771C258.958 93.9239 259.568 93.2389 260.628 93.1648C261.657 93.0928 262.213 93.6493 262.269 94.4444C262.335 95.3953 261.842 95.9625 260.673 96.0442L259.862 96.1009L259.98 97.7846L260.853 97.7236C262.054 97.6396 262.684 98.1438 262.758 99.2039C262.828 100.202 262.278 100.851 261.015 100.939C259.675 101.033 259.043 100.294 258.875 99.2249L256.598 99.384C256.85 101.638 258.401 102.986 261.239 102.788ZM266.898 102.22L275.316 101.631L275.182 99.7138L270.848 100.017L272.809 97.8118C274.016 96.4742 274.788 95.1982 274.684 93.7172C274.544 91.7061 273.045 90.4323 270.582 90.6045C268.087 90.779 266.626 92.2911 266.681 94.8721L268.973 94.7118C269.042 93.2344 269.625 92.614 270.608 92.5453C271.574 92.4777 272.13 93.0341 272.194 93.9539C272.265 94.9673 271.648 95.9974 270.652 97.2107L266.869 101.815L266.898 102.22Z" fill="white"/><path d="M257.025 121.118L273.914 119.937L274.096 122.535L257.207 123.716L257.025 121.118ZM256.662 115.921L273.551 114.74L273.732 117.338L256.843 118.519L256.662 115.921ZM257.389 126.314L269.081 125.497L269.263 128.095L257.57 128.913L257.389 126.314ZM271.679 125.315L272.179 132.46L278.447 128.758L271.679 125.315Z" fill="white"/></g><rect x="94.6293" y="47.0594" width="221.2" height="150.874" rx="5.76275" transform="rotate(-4 94.6293 47.0594)" stroke="white" stroke-width="6.31621"/></g><g filter="url(#filter1_dddd_132_35329)"><g clip-path="url(#clip1_132_35329)"><rect x="142.171" y="72.4392" width="214.884" height="144.558" rx="2.60465" fill="#D72C2C"/><circle cx="320.12" cy="70.2066" r="106.323" fill="#DF5757"/><rect width="100.279" height="144.558" transform="translate(256.772 72.439)" fill="black" fill-opacity="0.7"/><path d="M289.516 133.262H292.811V118.715H289.922L286.565 121.095V123.903L289.516 121.97V133.262ZM301.329 133.486C304.686 133.486 306.904 131.512 306.904 128.42C306.904 125.327 305.093 123.516 302.448 123.516C300.8 123.516 299.783 124.167 299.213 124.859L299.274 121.217H306.029V118.715H296.813L296.609 126.995H298.44C299.03 126.324 299.864 125.836 301.228 125.836C302.692 125.836 303.588 126.812 303.588 128.379C303.588 129.925 302.794 130.963 301.309 130.963C299.641 130.963 299.152 130.149 298.969 128.928H295.938C296.08 131.532 297.748 133.486 301.329 133.486ZM315.905 133.262H319.1V130.373H321.012V128.013H319.1V118.715H315.051L308.764 129.172V130.373H315.905V133.262ZM312.06 128.013L315.967 121.197V128.013H312.06Z" fill="white"/><path d="M320.748 157.584C320.748 156.877 320.467 156.198 319.967 155.698C319.467 155.198 318.788 154.917 318.081 154.917H309.654L310.934 148.824C310.961 148.691 310.974 148.544 310.974 148.397C310.974 147.851 310.748 147.344 310.388 146.984L308.974 145.584L300.201 154.357C299.708 154.851 299.414 155.517 299.414 156.251V169.584C299.414 170.291 299.695 170.97 300.195 171.47C300.696 171.97 301.374 172.251 302.081 172.251H314.081C315.188 172.251 316.134 171.584 316.534 170.624L320.561 161.224C320.681 160.917 320.748 160.597 320.748 160.251V157.584ZM291.414 172.251H296.748V156.251H291.414V172.251Z" fill="white"/></g><rect x="139.539" y="69.8075" width="220.147" height="149.822" rx="5.2364" stroke="#F9F9FA" stroke-width="5.26351"/></g><defs><filter id="filter0_dddd_132_35329" x="82.7584" y="27.0386" width="254.927" height="189.679" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.90196"/><feGaussianBlur stdDeviation="0.563725"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.1137 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_132_35329"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="2.16754"/><feGaussianBlur stdDeviation="1.35471"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0484671 0"/><feBlend mode="normal" in2="effect1_dropShadow_132_35329" result="effect2_dropShadow_132_35329"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.08128"/><feGaussianBlur stdDeviation="2.5508"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.06 0"/><feBlend mode="normal" in2="effect2_dropShadow_132_35329" result="effect3_dropShadow_132_35329"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="7.2803"/><feGaussianBlur stdDeviation="4.55019"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0715329 0"/><feBlend mode="normal" in2="effect3_dropShadow_132_35329" result="effect4_dropShadow_132_35329"/><feBlend mode="normal" in="SourceGraphic" in2="effect4_dropShadow_132_35329" result="shape"/></filter><filter id="filter1_dddd_132_35329" x="127.807" y="65.3557" width="243.611" height="173.286" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.90196"/><feGaussianBlur stdDeviation="0.563725"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.1137 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_132_35329"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="2.16754"/><feGaussianBlur stdDeviation="1.35471"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0484671 0"/><feBlend mode="normal" in2="effect1_dropShadow_132_35329" result="effect2_dropShadow_132_35329"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.08128"/><feGaussianBlur stdDeviation="2.5508"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.06 0"/><feBlend mode="normal" in2="effect2_dropShadow_132_35329" result="effect3_dropShadow_132_35329"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="7.2803"/><feGaussianBlur stdDeviation="4.55019"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0715329 0"/><feBlend mode="normal" in2="effect3_dropShadow_132_35329" result="effect4_dropShadow_132_35329"/><feBlend mode="normal" in="SourceGraphic" in2="effect4_dropShadow_132_35329" result="shape"/></filter><clipPath id="clip0_132_35329"><rect x="98" y="49.9895" width="214.884" height="144.558" rx="2.60465" transform="rotate(-4 98 49.9895)" fill="white"/></clipPath><clipPath id="clip1_132_35329"><rect x="142.171" y="72.4392" width="214.884" height="144.558" rx="2.60465" fill="white"/></clipPath></defs></svg>', 'demoUrl' => 'https://smashballoon.com/youtube-feed/demo/?utm_campaign=youtube-free&utm_source=feed-type&utm_medium=youtube-feed&utm_content=view-demo', 'buyUrl' => $this->get_extension_popup_dynamic_buy_url($license_key), 'bullets' => ['heading' => __('And get much more!', 'feeds-for-youtube'), 'content' => [__('Covert videos to WP Posts', 'feeds-for-youtube'), __('Show subscribers', 'feeds-for-youtube'), __('Show video details', 'feeds-for-youtube'), __('Fast and Effective Support', 'feeds-for-youtube'), __('Always up to date', 'feeds-for-youtube'), __('30 day money back guarantee', 'feeds-for-youtube')]]),
            'search' => array('heading' => $this->get_extension_popup_dynamic_heading('Search Feeds', $plus_text), 'description' => __('Show a feed of videos from highly customizable search results.', 'feeds-for-youtube'), 'popupContentBtn' => '<div class="sbc-extpp-lite-btn">' . self::builder_svg_icons()['tag'] . __('Lite Feed Users get a 50% OFF', 'feeds-for-youtube') . '</div>', 'img' => '<svg width="456" height="264" viewBox="0 0 456 264" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_142_33011)"><g filter="url(#filter0_ddd_142_33011)"><rect x="46" y="41" width="364" height="49" rx="4.17014" fill="white"/><circle cx="67.9045" cy="63.4229" r="9" transform="rotate(-45 67.9045 63.4229)" stroke="#0096CC" stroke-width="2.57143"/><line x1="74.9572" y1="70.6963" x2="81.3212" y2="77.0603" stroke="#0096CC" stroke-width="2.57143"/><rect x="99" y="57" width="194" height="16" rx="2" fill="#DCDDE1"/></g><g filter="url(#filter1_dddd_142_33011)"><g clip-path="url(#clip1_142_33011)"><rect x="50" y="110" width="165" height="106" rx="2.60465" fill="#E2F5FF"/><circle cx="241" cy="211" r="127" fill="#BFE8FF"/><rect x="124" y="156" width="18" height="15" fill="white"/><path d="M128 169L138.38 163L128 157V169ZM151.12 153.34C151.38 154.28 151.56 155.54 151.68 157.14C151.82 158.74 151.88 160.12 151.88 161.32L152 163C152 167.38 151.68 170.6 151.12 172.66C150.62 174.46 149.46 175.62 147.66 176.12C146.72 176.38 145 176.56 142.36 176.68C139.76 176.82 137.38 176.88 135.18 176.88L132 177C123.62 177 118.4 176.68 116.34 176.12C114.54 175.62 113.38 174.46 112.88 172.66C112.62 171.72 112.44 170.46 112.32 168.86C112.18 167.26 112.12 165.88 112.12 164.68L112 163C112 158.62 112.32 155.4 112.88 153.34C113.38 151.54 114.54 150.38 116.34 149.88C117.28 149.62 119 149.44 121.64 149.32C124.24 149.18 126.62 149.12 128.82 149.12L132 149C140.38 149 145.6 149.32 147.66 149.88C149.46 150.38 150.62 151.54 151.12 153.34Z" fill="#EB2121"/></g><rect x="47.3682" y="107.368" width="170.264" height="111.264" rx="5.2364" stroke="#F9F9FA" stroke-width="5.26351"/></g><g filter="url(#filter2_dddd_142_33011)"><rect x="50" y="242" width="165" height="106" rx="2.60465" fill="#E6F4E3"/><rect x="47.3682" y="239.368" width="170.264" height="111.264" rx="5.2364" stroke="#F9F9FA" stroke-width="5.26351"/></g><g filter="url(#filter3_dddd_142_33011)"><g clip-path="url(#clip2_142_33011)"><rect x="240" y="110" width="165" height="106" rx="2.60465" fill="#FFE1E0"/><rect x="250" y="240.777" width="163.733" height="163.733" transform="rotate(-45 250 240.777)" fill="#FFCAC7"/><rect x="314" y="156" width="18" height="15" fill="white"/><path d="M318 169L328.38 163L318 157V169ZM341.12 153.34C341.38 154.28 341.56 155.54 341.68 157.14C341.82 158.74 341.88 160.12 341.88 161.32L342 163C342 167.38 341.68 170.6 341.12 172.66C340.62 174.46 339.46 175.62 337.66 176.12C336.72 176.38 335 176.56 332.36 176.68C329.76 176.82 327.38 176.88 325.18 176.88L322 177C313.62 177 308.4 176.68 306.34 176.12C304.54 175.62 303.38 174.46 302.88 172.66C302.62 171.72 302.44 170.46 302.32 168.86C302.18 167.26 302.12 165.88 302.12 164.68L302 163C302 158.62 302.32 155.4 302.88 153.34C303.38 151.54 304.54 150.38 306.34 149.88C307.28 149.62 309 149.44 311.64 149.32C314.24 149.18 316.62 149.12 318.82 149.12L322 149C330.38 149 335.6 149.32 337.66 149.88C339.46 150.38 340.62 151.54 341.12 153.34Z" fill="#EB2121"/></g><rect x="237.368" y="107.368" width="170.264" height="111.264" rx="5.2364" stroke="#F9F9FA" stroke-width="5.26351"/></g><g filter="url(#filter4_dddd_142_33011)"><rect x="240" y="242" width="165" height="106" rx="2.60465" fill="#F8D7D7"/><rect x="237.368" y="239.368" width="170.264" height="111.264" rx="5.2364" stroke="#F9F9FA" stroke-width="5.26351"/></g></g><defs><filter id="filter0_ddd_142_33011" x="18.8941" y="26.4045" width="418.212" height="103.212" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="12.5104"/><feGaussianBlur stdDeviation="13.5529"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33011"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="2.08507"/><feGaussianBlur stdDeviation="2.08507"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/><feBlend mode="normal" in2="effect1_dropShadow_142_33011" result="effect2_dropShadow_142_33011"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="6.25521"/><feGaussianBlur stdDeviation="6.25521"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="effect2_dropShadow_142_33011" result="effect3_dropShadow_142_33011"/><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow_142_33011" result="shape"/></filter><filter id="filter1_dddd_142_33011" x="35.6362" y="102.916" width="193.728" height="134.728" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.90196"/><feGaussianBlur stdDeviation="0.563725"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.1137 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33011"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="2.16754"/><feGaussianBlur stdDeviation="1.35471"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0484671 0"/><feBlend mode="normal" in2="effect1_dropShadow_142_33011" result="effect2_dropShadow_142_33011"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.08128"/><feGaussianBlur stdDeviation="2.5508"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.06 0"/><feBlend mode="normal" in2="effect2_dropShadow_142_33011" result="effect3_dropShadow_142_33011"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="7.2803"/><feGaussianBlur stdDeviation="4.55019"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0715329 0"/><feBlend mode="normal" in2="effect3_dropShadow_142_33011" result="effect4_dropShadow_142_33011"/><feBlend mode="normal" in="SourceGraphic" in2="effect4_dropShadow_142_33011" result="shape"/></filter><filter id="filter2_dddd_142_33011" x="35.6362" y="234.916" width="193.728" height="134.728" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.90196"/><feGaussianBlur stdDeviation="0.563725"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.1137 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33011"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="2.16754"/><feGaussianBlur stdDeviation="1.35471"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0484671 0"/><feBlend mode="normal" in2="effect1_dropShadow_142_33011" result="effect2_dropShadow_142_33011"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.08128"/><feGaussianBlur stdDeviation="2.5508"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.06 0"/><feBlend mode="normal" in2="effect2_dropShadow_142_33011" result="effect3_dropShadow_142_33011"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="7.2803"/><feGaussianBlur stdDeviation="4.55019"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0715329 0"/><feBlend mode="normal" in2="effect3_dropShadow_142_33011" result="effect4_dropShadow_142_33011"/><feBlend mode="normal" in="SourceGraphic" in2="effect4_dropShadow_142_33011" result="shape"/></filter><filter id="filter3_dddd_142_33011" x="225.636" y="102.916" width="193.728" height="134.728" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.90196"/><feGaussianBlur stdDeviation="0.563725"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.1137 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33011"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="2.16754"/><feGaussianBlur stdDeviation="1.35471"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0484671 0"/><feBlend mode="normal" in2="effect1_dropShadow_142_33011" result="effect2_dropShadow_142_33011"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.08128"/><feGaussianBlur stdDeviation="2.5508"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.06 0"/><feBlend mode="normal" in2="effect2_dropShadow_142_33011" result="effect3_dropShadow_142_33011"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="7.2803"/><feGaussianBlur stdDeviation="4.55019"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0715329 0"/><feBlend mode="normal" in2="effect3_dropShadow_142_33011" result="effect4_dropShadow_142_33011"/><feBlend mode="normal" in="SourceGraphic" in2="effect4_dropShadow_142_33011" result="shape"/></filter><filter id="filter4_dddd_142_33011" x="225.636" y="234.916" width="193.728" height="134.728" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.90196"/><feGaussianBlur stdDeviation="0.563725"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.1137 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33011"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="2.16754"/><feGaussianBlur stdDeviation="1.35471"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0484671 0"/><feBlend mode="normal" in2="effect1_dropShadow_142_33011" result="effect2_dropShadow_142_33011"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.08128"/><feGaussianBlur stdDeviation="2.5508"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.06 0"/><feBlend mode="normal" in2="effect2_dropShadow_142_33011" result="effect3_dropShadow_142_33011"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="7.2803"/><feGaussianBlur stdDeviation="4.55019"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0715329 0"/><feBlend mode="normal" in2="effect3_dropShadow_142_33011" result="effect4_dropShadow_142_33011"/><feBlend mode="normal" in="SourceGraphic" in2="effect4_dropShadow_142_33011" result="shape"/></filter><clipPath id="clip0_142_33011"><rect width="456" height="264" fill="white"/></clipPath><clipPath id="clip1_142_33011"><rect x="50" y="110" width="165" height="106" rx="2.60465" fill="white"/></clipPath><clipPath id="clip2_142_33011"><rect x="240" y="110" width="165" height="106" rx="2.60465" fill="white"/></clipPath></defs></svg>', 'demoUrl' => 'https://smashballoon.com/youtube-feed/demo/?utm_campaign=youtube-free&utm_source=feed-type&utm_medium=youtube-feed&utm_content=view-demo', 'buyUrl' => $this->get_extension_popup_dynamic_buy_url($license_key), 'bullets' => ['heading' => __('And get much more!', 'feeds-for-youtube'), 'content' => [__('Covert videos to WP Posts', 'feeds-for-youtube'), __('Show subscribers', 'feeds-for-youtube'), __('Show video details', 'feeds-for-youtube'), __('Fast and Effective Support', 'feeds-for-youtube'), __('Always up to date', 'feeds-for-youtube'), __('30 day money back guarantee', 'feeds-for-youtube')]]),
            'live' => array('heading' => $this->get_extension_popup_dynamic_heading('Live Stream Feeds', $elite_text), 'description' => __('Engage your site visitors with scheduled, live videos. Display current or past live streams.', 'feeds-for-youtube'), 'popupContentBtn' => '<div class="sbc-extpp-lite-btn">' . self::builder_svg_icons()['tag'] . __('Lite Feed Users get a 50% OFF', 'feeds-for-youtube') . '</div>', 'img' => '<svg width="456" height="264" viewBox="0 0 456 264" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_142_33143)"><g filter="url(#filter0_ddd_142_33143)"><rect x="93" y="37" width="269" height="189.424" rx="3.60697" fill="white"/><g clip-path="url(#clip1_142_33143)"><rect width="269" height="131.473" transform="translate(93 37)" fill="#FCF0EF"/><circle cx="335.187" cy="52.569" r="128.013" fill="#FFE1E0"/><line x1="93.8647" y1="167.473" x2="361.135" y2="167.473" stroke="#EB2121" stroke-width="2"/></g><circle cx="355.97" cy="167.606" r="6.025" fill="#EB2121"/><rect x="106.839" y="180.582" width="154.826" height="13.8392" rx="1.7299" fill="#E8E8EB"/><circle cx="111.164" cy="207.801" r="3.45981" fill="#EB2121"/><path d="M124.771 211.881V210.106H121.637V204.428H119.675V211.881H124.771ZM127.861 211.881V204.428H125.9V211.881H127.861ZM136.08 204.428H134.108L132.417 209.587L130.777 204.428H128.649L131.285 211.881H133.423L136.08 204.428ZM142.088 210.179H138.777V208.902H141.714V207.2H138.777V206.131H142.015V204.428H136.815V211.881H142.088V210.179Z" fill="#EB2121"/><rect x="91.2701" y="35.2701" width="272.46" height="192.884" rx="5.33687" stroke="white" stroke-width="3.45981"/></g></g><defs><filter id="filter0_ddd_142_33143" x="66.0947" y="20.9159" width="322.811" height="243.235" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="10.8209"/><feGaussianBlur stdDeviation="11.7226"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33143"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1.80348"/><feGaussianBlur stdDeviation="1.80348"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/><feBlend mode="normal" in2="effect1_dropShadow_142_33143" result="effect2_dropShadow_142_33143"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="5.41045"/><feGaussianBlur stdDeviation="5.41045"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="effect2_dropShadow_142_33143" result="effect3_dropShadow_142_33143"/><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow_142_33143" result="shape"/></filter><clipPath id="clip0_142_33143"><rect width="456" height="264" fill="white"/></clipPath><clipPath id="clip1_142_33143"><rect width="269" height="131.473" fill="white" transform="translate(93 37)"/></clipPath></defs></svg>', 'demoUrl' => 'https://smashballoon.com/youtube-feed/demo/?utm_campaign=youtube-free&utm_source=feed-type&utm_medium=youtube-feed&utm_content=view-demo', 'buyUrl' => $this->get_extension_popup_dynamic_buy_url($license_key), 'bullets' => ['heading' => __('And get much more!', 'feeds-for-youtube'), 'content' => [__('Covert videos to WP Posts', 'feeds-for-youtube'), __('Show subscribers', 'feeds-for-youtube'), __('Show video details', 'feeds-for-youtube'), __('Fast and Effective Support', 'feeds-for-youtube'), __('Always up to date', 'feeds-for-youtube'), __('30 day money back guarantee', 'feeds-for-youtube')]]),
            'single' => array('heading' => $this->get_extension_popup_dynamic_heading('Single Video Feeds', $pro_text), 'description' => __('Great for tutorials and product demonstrations. A better, more versatile version of YouTube\'s native embed feature.', 'feeds-for-youtube'), 'popupContentBtn' => '<div class="sbc-extpp-lite-btn">' . self::builder_svg_icons()['tag'] . __('Lite Feed Users get a 50% OFF', 'feeds-for-youtube') . '</div>', 'img' => '<svg width="456" height="264" viewBox="0 0 456 264" fill="none" xmlns="http://www.w3.org/2000/svg"><g filter="url(#filter0_dddd_142_33235)"><g clip-path="url(#clip0_142_33235)"><rect x="89" y="45" width="278" height="164" rx="2.60465" fill="#FFE1E0"/><rect x="117" y="264.605" width="254" height="254" transform="rotate(-45 117 264.605)" fill="#FFCAC7"/><rect x="214" y="109.5" width="29.1667" height="31.5" fill="white"/><path d="M221 137.5L239.165 127L221 116.5V137.5ZM261.46 110.095C261.915 111.74 262.23 113.945 262.44 116.745C262.685 119.545 262.79 121.96 262.79 124.06L263 127C263 134.665 262.44 140.3 261.46 143.905C260.585 147.055 258.555 149.085 255.405 149.96C253.76 150.415 250.75 150.73 246.13 150.94C241.58 151.185 237.415 151.29 233.565 151.29L228 151.5C213.335 151.5 204.2 150.94 200.595 149.96C197.445 149.085 195.415 147.055 194.54 143.905C194.085 142.26 193.77 140.055 193.56 137.255C193.315 134.455 193.21 132.04 193.21 129.94L193 127C193 119.335 193.56 113.7 194.54 110.095C195.415 106.945 197.445 104.915 200.595 104.04C202.24 103.585 205.25 103.27 209.87 103.06C214.42 102.815 218.585 102.71 222.435 102.71L228 102.5C242.665 102.5 251.8 103.06 255.405 104.04C258.555 104.915 260.585 106.945 261.46 110.095Z" fill="#EB2121"/></g><rect x="85" y="41" width="286" height="172" rx="6.60465" stroke="#F9F9FA" stroke-width="8"/></g><defs><filter id="filter0_dddd_142_33235" x="71.8996" y="35.1799" width="312.201" height="198.201" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.90196"/><feGaussianBlur stdDeviation="0.563725"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.1137 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33235"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="2.16754"/><feGaussianBlur stdDeviation="1.35471"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0484671 0"/><feBlend mode="normal" in2="effect1_dropShadow_142_33235" result="effect2_dropShadow_142_33235"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.08128"/><feGaussianBlur stdDeviation="2.5508"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.06 0"/><feBlend mode="normal" in2="effect2_dropShadow_142_33235" result="effect3_dropShadow_142_33235"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="7.2803"/><feGaussianBlur stdDeviation="4.55019"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0715329 0"/><feBlend mode="normal" in2="effect3_dropShadow_142_33235" result="effect4_dropShadow_142_33235"/><feBlend mode="normal" in="SourceGraphic" in2="effect4_dropShadow_142_33235" result="shape"/></filter><clipPath id="clip0_142_33235"><rect x="89" y="45" width="278" height="164" rx="2.60465" fill="white"/></clipPath></defs></svg>', 'demoUrl' => 'https://smashballoon.com/youtube-feed/demo/?utm_campaign=youtube-free&utm_source=feed-type&utm_medium=youtube-feed&utm_content=view-demo', 'buyUrl' => $this->get_extension_popup_dynamic_buy_url($license_key), 'bullets' => ['heading' => __('And get much more!', 'feeds-for-youtube'), 'content' => [__('Covert videos to WP Posts', 'feeds-for-youtube'), __('Show subscribers', 'feeds-for-youtube'), __('Show video details', 'feeds-for-youtube'), __('Fast and Effective Support', 'feeds-for-youtube'), __('Always up to date', 'feeds-for-youtube'), __('30 day money back guarantee', 'feeds-for-youtube')]]),
            'social_wall' => array('heading' => __('Combine all your social media channels into one ', 'feeds-for-youtube') . __('Social Wall', 'feeds-for-youtube') . '</span>', 'description' => __('Build an audience across all of your social media platforms with a sleek, engaging feed sourced from Instagram, Facebook, Twitter, and Youtube.', 'feeds-for-youtube'), 'popupContentBtn' => '<div class="sbc-extpp-lite-btn">' . self::builder_svg_icons()['tag'] . __('Lite Feed Users get a 50% OFF', 'feeds-for-youtube') . '</div>', 'img' => '<svg width="397" height="264" viewBox="0 0 397 264" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0)"><g filter="url(#filter0_ddd)"><rect x="18.957" y="63" width="113.812" height="129.461" rx="2.8453" fill="white"/></g><g clip-path="url(#clip1)"><path d="M18.957 63H132.769V176.812H18.957V63Z" fill="#0068A0"/><rect x="56.957" y="106" width="105" height="105" rx="9" fill="#005B8C"/></g><path d="M36.0293 165.701C31.4649 165.701 27.7305 169.427 27.7305 174.017C27.7305 178.166 30.7678 181.61 34.7347 182.232V176.423H32.6268V174.017H34.7347V172.183C34.7347 170.1 35.9712 168.954 37.8716 168.954C38.7762 168.954 39.7222 169.112 39.7222 169.112V171.162H38.6766C37.6475 171.162 37.3239 171.801 37.3239 172.456V174.017H39.6309L39.2575 176.423H37.3239V182.232C39.2794 181.924 41.0602 180.926 42.3446 179.419C43.629 177.913 44.3325 175.996 44.3281 174.017C44.3281 169.427 40.5936 165.701 36.0293 165.701Z" fill="#006BFA"/><rect x="53.1016" y="169.699" width="41.2569" height="9.95855" rx="1.42265" fill="#D0D1D7"/><g filter="url(#filter1_ddd)"><rect x="18.957" y="201" width="113.812" height="129.461" rx="2.8453" fill="white"/></g><g clip-path="url(#clip2)"><path d="M18.957 201H132.769V314.812H18.957V201Z" fill="#EC352F"/><circle cx="23.957" cy="243" r="59" fill="#FE544F"/></g><g filter="url(#filter2_ddd)"><rect x="139.957" y="23" width="113.812" height="129.461" rx="2.8453" fill="white"/></g><g clip-path="url(#clip3)"><path d="M139.957 23H253.769V136.812H139.957V23Z" fill="#8C8F9A"/><circle cx="127.457" cy="142.5" r="78.5" fill="#D0D1D7"/></g><path d="M157.026 129.493C154.537 129.493 152.553 131.516 152.553 133.967C152.553 136.456 154.537 138.44 157.026 138.44C159.477 138.44 161.5 136.456 161.5 133.967C161.5 131.516 159.477 129.493 157.026 129.493ZM157.026 136.884C155.431 136.884 154.109 135.601 154.109 133.967C154.109 132.372 155.392 131.088 157.026 131.088C158.621 131.088 159.905 132.372 159.905 133.967C159.905 135.601 158.621 136.884 157.026 136.884ZM162.706 129.338C162.706 128.754 162.239 128.287 161.655 128.287C161.072 128.287 160.605 128.754 160.605 129.338C160.605 129.921 161.072 130.388 161.655 130.388C162.239 130.388 162.706 129.921 162.706 129.338ZM165.662 130.388C165.584 128.987 165.273 127.743 164.262 126.731C163.25 125.72 162.005 125.409 160.605 125.331C159.166 125.253 154.848 125.253 153.408 125.331C152.008 125.409 150.802 125.72 149.752 126.731C148.74 127.743 148.429 128.987 148.351 130.388C148.274 131.827 148.274 136.145 148.351 137.585C148.429 138.985 148.74 140.191 149.752 141.241C150.802 142.253 152.008 142.564 153.408 142.642C154.848 142.719 159.166 142.719 160.605 142.642C162.005 142.564 163.25 142.253 164.262 141.241C165.273 140.191 165.584 138.985 165.662 137.585C165.74 136.145 165.74 131.827 165.662 130.388ZM163.795 139.102C163.523 139.88 162.9 140.463 162.161 140.774C160.994 141.241 158.271 141.124 157.026 141.124C155.742 141.124 153.019 141.241 151.891 140.774C151.113 140.463 150.53 139.88 150.219 139.102C149.752 137.974 149.868 135.25 149.868 133.967C149.868 132.722 149.752 129.999 150.219 128.832C150.53 128.093 151.113 127.509 151.891 127.198C153.019 126.731 155.742 126.848 157.026 126.848C158.271 126.848 160.994 126.731 162.161 127.198C162.9 127.47 163.484 128.093 163.795 128.832C164.262 129.999 164.145 132.722 164.145 133.967C164.145 135.25 164.262 137.974 163.795 139.102Z" fill="url(#paint0_linear)"/><rect x="174.102" y="129.699" width="41.2569" height="9.95855" rx="1.42265" fill="#D0D1D7"/><g filter="url(#filter3_ddd)"><rect x="139.957" y="161" width="114" height="109" rx="2.8453" fill="white"/></g><rect x="148.957" y="194" width="91" height="8" rx="1.42265" fill="#D0D1D7"/><rect x="148.957" y="208" width="51" height="8" rx="1.42265" fill="#D0D1D7"/><path d="M164.366 172.062C163.788 172.324 163.166 172.497 162.521 172.579C163.181 172.182 163.691 171.552 163.931 170.794C163.308 171.169 162.618 171.432 161.891 171.582C161.298 170.937 160.466 170.562 159.521 170.562C157.758 170.562 156.318 172.002 156.318 173.779C156.318 174.034 156.348 174.282 156.401 174.514C153.731 174.379 151.353 173.097 149.771 171.154C149.493 171.627 149.336 172.182 149.336 172.767C149.336 173.884 149.898 174.874 150.768 175.437C150.236 175.437 149.741 175.287 149.306 175.062V175.084C149.306 176.644 150.416 177.949 151.886 178.242C151.414 178.371 150.918 178.389 150.438 178.294C150.642 178.934 151.041 179.493 151.579 179.894C152.117 180.295 152.767 180.517 153.438 180.529C152.301 181.43 150.891 181.916 149.441 181.909C149.186 181.909 148.931 181.894 148.676 181.864C150.101 182.779 151.796 183.312 153.611 183.312C159.521 183.312 162.768 178.407 162.768 174.154C162.768 174.012 162.768 173.877 162.761 173.734C163.391 173.284 163.931 172.714 164.366 172.062Z" fill="#1B90EF"/><g filter="url(#filter4_ddd)"><rect x="260.957" y="63" width="113.812" height="129.461" rx="2.8453" fill="white"/></g><g clip-path="url(#clip4)"><rect x="260.957" y="63" width="113.812" height="113.812" fill="#D72C2C"/><path d="M283.359 103.308L373.461 193.41H208.793L283.359 103.308Z" fill="#DF5757"/></g><path d="M276.37 176.456L280.677 173.967L276.37 171.477V176.456ZM285.963 169.958C286.071 170.348 286.145 170.871 286.195 171.535C286.253 172.199 286.278 172.772 286.278 173.27L286.328 173.967C286.328 175.784 286.195 177.12 285.963 177.975C285.755 178.722 285.274 179.203 284.527 179.411C284.137 179.519 283.423 179.593 282.328 179.643C281.249 179.701 280.262 179.726 279.349 179.726L278.029 179.776C274.552 179.776 272.386 179.643 271.531 179.411C270.784 179.203 270.303 178.722 270.096 177.975C269.988 177.585 269.913 177.062 269.863 176.398C269.805 175.734 269.78 175.162 269.78 174.664L269.73 173.967C269.73 172.149 269.863 170.813 270.096 169.958C270.303 169.212 270.784 168.73 271.531 168.523C271.921 168.415 272.635 168.34 273.73 168.29C274.809 168.232 275.797 168.207 276.71 168.207L278.029 168.158C281.506 168.158 283.672 168.29 284.527 168.523C285.274 168.73 285.755 169.212 285.963 169.958Z" fill="#EB2121"/><rect x="295.102" y="169.699" width="41.2569" height="9.95855" rx="1.42265" fill="#D0D1D7"/><g filter="url(#filter5_ddd)"><rect x="260.957" y="201" width="113.812" height="129.461" rx="2.8453" fill="white"/></g><g clip-path="url(#clip5)"><rect x="260.957" y="201" width="113.812" height="113.812" fill="#59AB46"/><circle cx="374.457" cy="235.5" r="44.5" fill="#468737"/></g><g clip-path="url(#clip6)"><path d="M139.957 228H253.957V296C253.957 296.552 253.509 297 252.957 297H140.957C140.405 297 139.957 296.552 139.957 296V228Z" fill="#0068A0"/><circle cx="227.957" cy="245" r="34" fill="#004D77"/></g></g><defs><filter id="filter0_ddd" x="0.462572" y="53.0414" width="150.801" height="166.45" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="8.5359"/><feGaussianBlur stdDeviation="9.24723"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1.42265"/><feGaussianBlur stdDeviation="1.42265"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/><feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.26795"/><feGaussianBlur stdDeviation="4.26795"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/></filter><filter id="filter1_ddd" x="0.462572" y="191.041" width="150.801" height="166.45" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="8.5359"/><feGaussianBlur stdDeviation="9.24723"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1.42265"/><feGaussianBlur stdDeviation="1.42265"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/><feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.26795"/><feGaussianBlur stdDeviation="4.26795"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/></filter><filter id="filter2_ddd" x="121.463" y="13.0414" width="150.801" height="166.45" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="8.5359"/><feGaussianBlur stdDeviation="9.24723"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1.42265"/><feGaussianBlur stdDeviation="1.42265"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/><feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.26795"/><feGaussianBlur stdDeviation="4.26795"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/></filter><filter id="filter3_ddd" x="121.463" y="151.041" width="150.989" height="145.989" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="8.5359"/><feGaussianBlur stdDeviation="9.24723"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1.42265"/><feGaussianBlur stdDeviation="1.42265"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/><feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.26795"/><feGaussianBlur stdDeviation="4.26795"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/></filter><filter id="filter4_ddd" x="242.463" y="53.0414" width="150.801" height="166.45" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="8.5359"/><feGaussianBlur stdDeviation="9.24723"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1.42265"/><feGaussianBlur stdDeviation="1.42265"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/><feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.26795"/><feGaussianBlur stdDeviation="4.26795"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/></filter><filter id="filter5_ddd" x="242.463" y="191.041" width="150.801" height="166.45" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="8.5359"/><feGaussianBlur stdDeviation="9.24723"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1.42265"/><feGaussianBlur stdDeviation="1.42265"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/><feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.26795"/><feGaussianBlur stdDeviation="4.26795"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/></filter><linearGradient id="paint0_linear" x1="154.502" y1="158.603" x2="191.208" y2="121.133" gradientUnits="userSpaceOnUse"><stop stop-color="white"/><stop offset="0.147864" stop-color="#F6640E"/><stop offset="0.443974" stop-color="#BA03A7"/><stop offset="0.733337" stop-color="#6A01B9"/><stop offset="1" stop-color="#6B01B9"/></linearGradient><clipPath id="clip0"><rect width="396" height="264" fill="white" transform="translate(0.957031)"/></clipPath><clipPath id="clip1"><path d="M18.957 65.3711C18.957 64.0616 20.0186 63 21.3281 63H130.398C131.708 63 132.769 64.0616 132.769 65.3711V156.895H18.957V65.3711Z" fill="white"/></clipPath><clipPath id="clip2"><path d="M18.957 203.371C18.957 202.062 20.0186 201 21.3281 201H130.398C131.708 201 132.769 202.062 132.769 203.371V294.895H18.957V203.371Z" fill="white"/></clipPath><clipPath id="clip3"><path d="M139.957 25.3711C139.957 24.0616 141.019 23 142.328 23H251.398C252.708 23 253.769 24.0616 253.769 25.3711V116.895H139.957V25.3711Z" fill="white"/></clipPath><clipPath id="clip4"><path d="M260.957 65.3711C260.957 64.0616 262.019 63 263.328 63H372.398C373.708 63 374.769 64.0616 374.769 65.3711V156.895H260.957V65.3711Z" fill="white"/></clipPath><clipPath id="clip5"><path d="M260.957 203.371C260.957 202.062 262.019 201 263.328 201H372.398C373.708 201 374.769 202.062 374.769 203.371V294.895H260.957V203.371Z" fill="white"/></clipPath><clipPath id="clip6"><path d="M139.957 228H253.957V296C253.957 296.552 253.509 297 252.957 297H140.957C140.405 297 139.957 296.552 139.957 296V228Z" fill="white"/></clipPath></defs></svg>', 'demoUrl' => 'https://smashballoon.com/social-wall/demo/?utm_campaign=youtube-pro&utm_source=feed-type&utm_medium=social-wall&utm_content=view-demo', 'buyUrl' => sprintf('https://smashballoon.com/social-wall/pricing/?license_key=%s&upgrade=true&utm_campaign=youtube-pro&utm_source=feed-type&utm_medium=social-wall&utm_content=upgrade', $license_key), 'bullets' => ['heading' => __('Upgrade to the All Access Bundle and get:', 'feeds-for-youtube'), 'content' => [__('Custom Facebook Feed Pro', 'feeds-for-youtube'), __('All Pro Facebook Extensions', 'feeds-for-youtube'), __('Custom Twitter Feeds Pro', 'feeds-for-youtube'), __('Instagram Feed Pro', 'feeds-for-youtube'), __('YouTube Feeds Pro', 'feeds-for-youtube'), __('Social Wall Pro', 'feeds-for-youtube')]]),
            //Other Types
            'feedLayout' => ['heading' => $this->get_extension_popup_dynamic_heading('Carousel Layout', $pro_text), 'description' => __('An eye-catching rotating slider of your videos to add extra content in minimal space on your website.', 'feeds-for-youtube'), 'popupContentBtn' => '<div class="sbc-extpp-lite-btn">' . self::builder_svg_icons()['tag'] . __('Lite Feed Users get a 50% OFF', 'feeds-for-youtube') . '</div>', 'img' => '<svg width="396" height="264" viewBox="0 0 396 264" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M50.5998 136.122L48.2638 134.019L39.3134 143.959L49.2538 152.91L51.3572 150.574L43.7685 143.726L50.5998 136.122Z" fill="#8C8F9A"/><path d="M347.201 119.809L345.098 122.145L352.686 128.993L345.855 136.597L348.191 138.7L357.142 128.76L347.201 119.809Z" fill="#8C8F9A"/><g filter="url(#filter0_dddd_142_33251)"><g clip-path="url(#clip0_142_33251)"><rect x="62.6836" y="52.3921" width="261.925" height="173.162" rx="2" transform="rotate(-3 62.6836 52.3921)" fill="white"/><rect x="82.4844" y="187.06" width="93.129" height="5.82056" rx="1.45514" transform="rotate(-2 82.4844 187.06)" fill="#D0D1D7"/><rect x="83.1816" y="200.48" width="53.8402" height="5.82056" rx="1.45514" transform="rotate(-2 83.1816 200.48)" fill="#D0D1D7"/><g clip-path="url(#clip1_142_33251)"><rect x="62.6816" y="52.3921" width="262.169" height="173.162" transform="rotate(-3 62.6816 52.3921)" fill="#FCA7A1"/><rect x="191.141" y="20.5737" width="271.58" height="334.479" rx="55.73" transform="rotate(2.99107 191.141 20.5737)" fill="#FFCAC7"/><circle cx="141.742" cy="201.742" r="113.935" transform="rotate(-3 141.742 201.742)" fill="#FFE1E0"/><rect x="186.851" y="92.3271" width="24.0633" height="25.9883" transform="rotate(-3 186.851 92.3271)" fill="white"/><path d="M193.826 115.094L208.339 105.659L192.92 97.7921L193.826 115.094ZM225.978 90.768C226.424 92.1037 226.779 93.9068 227.072 96.2046C227.395 98.501 227.586 100.486 227.677 102.216L227.977 104.629C228.308 110.945 228.09 115.611 227.438 118.624C226.853 121.257 225.268 123.017 222.711 123.874C221.375 124.32 218.909 124.709 215.111 125.082C211.373 125.48 207.946 125.747 204.774 125.913L200.198 126.326C188.116 126.959 180.565 126.892 177.553 126.241C174.92 125.656 173.16 124.071 172.303 121.513C171.857 120.178 171.502 118.375 171.208 116.077C170.885 113.781 170.695 111.795 170.604 110.065L170.304 107.652C169.973 101.337 170.191 96.67 170.843 93.6575C171.428 91.0245 173.013 89.2643 175.57 88.4074C176.906 87.9615 179.372 87.572 183.169 87.1995C186.908 86.8012 190.335 86.5348 193.507 86.3686L198.082 85.9553C210.165 85.3221 217.715 85.389 220.728 86.0408C223.361 86.6257 225.121 88.2105 225.978 90.768Z" fill="#EB2121"/></g></g></g><defs><filter id="filter0_dddd_142_33251" x="54.0388" y="36.9551" width="287.918" height="203.922" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.856805"/><feGaussianBlur stdDeviation="0.535503"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.1137 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33251"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="2.05902"/><feGaussianBlur stdDeviation="1.28689"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0484671 0"/><feBlend mode="normal" in2="effect1_dropShadow_142_33251" result="effect2_dropShadow_142_33251"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="3.87696"/><feGaussianBlur stdDeviation="2.4231"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.06 0"/><feBlend mode="normal" in2="effect2_dropShadow_142_33251" result="effect3_dropShadow_142_33251"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="6.91583"/><feGaussianBlur stdDeviation="4.32239"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0.101961 0 0 0 0 0.466667 0 0 0 0.0715329 0"/><feBlend mode="normal" in2="effect3_dropShadow_142_33251" result="effect4_dropShadow_142_33251"/><feBlend mode="normal" in="SourceGraphic" in2="effect4_dropShadow_142_33251" result="shape"/></filter><clipPath id="clip0_142_33251"><rect x="62.6836" y="52.3921" width="261.925" height="173.162" rx="2" transform="rotate(-3 62.6836 52.3921)" fill="white"/></clipPath><clipPath id="clip1_142_33251"><rect width="262.15" height="121.608" fill="white" transform="translate(62.6826 52.3921) rotate(-3)"/></clipPath></defs></svg>', 'demoUrl' => 'https://smashballoon.com/youtube-feed/demo/carousel?utm_campaign=youtube-free&utm_source=feed-type&utm_medium=youtube-feed&utm_content=view-demo', 'buyUrl' => $this->get_extension_popup_dynamic_buy_url($license_key), 'bullets' => ['heading' => __('And get much more!', 'feeds-for-youtube'), 'content' => [__('Covert videos to WP Posts', 'feeds-for-youtube'), __('Show subscribers', 'feeds-for-youtube'), __('Show video details', 'feeds-for-youtube'), __('Fast and Effective Support', 'feeds-for-youtube'), __('Always up to date', 'feeds-for-youtube'), __('30 Day Money Back Guarantee', 'feeds-for-youtube')]]],
            'subscribersCount' => ['heading' => __('Show Subscriber </br> Count with Pro', 'feeds-for-youtube'), 'description' => __('Use social proof to show your authority by including the number of subscribers to your channel.', 'feeds-for-youtube'), 'popupContentBtn' => '<div class="sbc-extpp-lite-btn">' . self::builder_svg_icons()['tag'] . __('Lite Feed Users get a 50% OFF', 'feeds-for-youtube') . '</div>', 'img' => '<svg width="396" height="264" viewBox="0 0 396 264" fill="none" xmlns="http://www.w3.org/2000/svg"><g filter="url(#filter0_ddd_142_33269)"><rect x="80.1641" y="59.7183" width="258.142" height="126.371" rx="4.50413" transform="rotate(1 80.1641 59.7183)" fill="#0096CC"/><rect x="166.067" y="89.3044" width="145.392" height="12.9557" rx="1.43952" transform="rotate(1 166.067 89.3044)" fill="#E8E8EB"/><rect x="165.672" y="111.983" width="95.0481" height="12.9611" rx="1.43952" transform="rotate(1 165.672 111.983)" fill="#E8E8EB"/><path d="M174.168 150.48C176.289 150.517 178.036 148.83 178.073 146.709C178.11 144.588 176.423 142.841 174.302 142.804C172.182 142.767 170.434 144.454 170.397 146.575C170.36 148.696 172.048 150.443 174.168 150.48ZM174.135 152.399C171.573 152.355 166.436 153.551 166.391 156.103L166.358 158.022L181.711 158.29L181.744 156.371C181.789 153.819 176.697 152.444 174.135 152.399Z" fill="#141B38"/><path d="M195.863 158.439L198.805 158.49L199.052 144.292L196.101 144.241L192.386 146.725L192.34 149.362L196.004 146.965L196.063 146.967L195.863 158.439ZM202.597 158.556L212.918 158.736L212.959 156.375L206.524 156.263L206.527 156.145L209.545 153.481C212.035 151.271 212.871 150.163 212.901 148.441L212.901 148.422C212.943 146.001 210.907 144.253 207.906 144.201C204.905 144.149 202.649 145.989 202.602 148.665L202.601 148.744L205.356 148.792L205.367 148.704C205.429 147.425 206.429 146.488 207.886 146.513C209.145 146.535 210.016 147.377 210.006 148.539L210.005 148.558C209.988 149.542 209.592 150.234 207.732 151.914L202.632 156.52L202.597 158.556ZM218.914 158.841L221.856 158.892L222.104 144.695L219.152 144.643L215.438 147.128L215.392 149.764L219.055 147.368L219.114 147.369L218.914 158.841ZM225.678 158.959L228.551 159.009L228.612 155.517L229.364 154.713L232.309 159.075L235.625 159.133L231.549 153.048L235.612 148.582L232.356 148.525L228.72 152.684L228.661 152.683L228.799 144.812L225.926 144.762L225.678 158.959Z" fill="#141B38"/><circle cx="125.817" cy="104.795" r="26.6312" transform="rotate(1 125.817 104.795)" stroke="#DCDDE1" stroke-width="1.43952"/><g clip-path="url(#clip0_142_33269)"><rect x="102.685" y="80.6455" width="47.5241" height="47.5241" rx="23.762" transform="rotate(1 102.685 80.6455)" fill="#0068A0"/><circle cx="126.122" cy="99.4189" r="8.64074" transform="rotate(1 126.122 99.4189)" fill="#43A6DB"/><circle cx="125.633" cy="127.497" r="16.2014" transform="rotate(1 125.633 127.497)" fill="#43A6DB"/></g></g><g filter="url(#filter1_ddd_142_33269)"><rect x="69" y="54" width="258.142" height="126.371" rx="4.50413" fill="white"/><rect x="155.407" y="82.0825" width="145.392" height="12.9557" rx="1.43952" fill="#E8E8EB"/><rect x="155.407" y="104.764" width="95.0481" height="12.9611" rx="1.43952" fill="#E8E8EB"/><path d="M164.574 143.107C166.695 143.107 168.413 141.389 168.413 139.268C168.413 137.148 166.695 135.43 164.574 135.43C162.453 135.43 160.735 137.148 160.735 139.268C160.735 141.389 162.453 143.107 164.574 143.107ZM164.574 145.027C162.012 145.027 156.896 146.312 156.896 148.865V150.785H172.251V148.865C172.251 146.312 167.136 145.027 164.574 145.027Z" fill="#141B38"/><path d="M186.404 150.687H189.346V136.487H186.394L182.723 139.035V141.673L186.345 139.213H186.404V150.687ZM193.139 150.687H203.462V148.325H197.026V148.207L199.998 145.491C202.448 143.237 203.265 142.115 203.265 140.393V140.374C203.265 137.953 201.198 136.241 198.197 136.241C195.196 136.241 192.972 138.12 192.972 140.797V140.876H195.727L195.737 140.787C195.776 139.508 196.76 138.553 198.217 138.553C199.476 138.553 200.362 139.38 200.372 140.541V140.561C200.372 141.545 199.988 142.243 198.158 143.956L193.139 148.65V150.687ZM209.459 150.687H212.401V136.487H209.449L205.779 139.035V141.673L209.4 139.213H209.459V150.687ZM216.224 150.687H219.097V147.193L219.835 146.376L222.856 150.687H226.172L221.99 144.674L225.976 140.138H222.718L219.156 144.359H219.097V136.487H216.224V150.687Z" fill="#141B38"/><circle cx="115.433" cy="98.273" r="26.6312" stroke="#DCDDE1" stroke-width="1.43952"/><g clip-path="url(#clip1_142_33269)"><rect x="91.8838" y="74.531" width="47.5241" height="47.5241" rx="23.762" fill="#0068A0"/><circle cx="115.646" cy="92.8924" r="8.64074" fill="#2FC5FB"/><circle cx="115.646" cy="120.975" r="16.2014" fill="#2FC5FB"/></g></g><defs><filter id="filter0_ddd_142_33269" x="48.6821" y="43.9538" width="318.861" height="189.41" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="13.5124"/><feGaussianBlur stdDeviation="14.6384"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33269"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="2.25207"/><feGaussianBlur stdDeviation="2.25207"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/><feBlend mode="normal" in2="effect1_dropShadow_142_33269" result="effect2_dropShadow_142_33269"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="6.7562"/><feGaussianBlur stdDeviation="6.7562"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="effect2_dropShadow_142_33269" result="effect3_dropShadow_142_33269"/><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow_142_33269" result="shape"/></filter><filter id="filter1_ddd_142_33269" x="39.7231" y="38.2355" width="316.695" height="184.925" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="13.5124"/><feGaussianBlur stdDeviation="14.6384"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33269"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="2.25207"/><feGaussianBlur stdDeviation="2.25207"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/><feBlend mode="normal" in2="effect1_dropShadow_142_33269" result="effect2_dropShadow_142_33269"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="6.7562"/><feGaussianBlur stdDeviation="6.7562"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="effect2_dropShadow_142_33269" result="effect3_dropShadow_142_33269"/><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow_142_33269" result="shape"/></filter><clipPath id="clip0_142_33269"><rect x="102.685" y="80.6455" width="47.5241" height="47.5241" rx="23.762" transform="rotate(1 102.685 80.6455)" fill="white"/></clipPath><clipPath id="clip1_142_33269"><rect x="91.8838" y="74.531" width="47.5241" height="47.5241" rx="23.762" fill="white"/></clipPath></defs></svg>', 'demoUrl' => 'https://smashballoon.com/youtube-feed/demo/?utm_campaign=youtube-free&utm_source=feed-type&utm_medium=youtube-feed&utm_content=view-demo', 'buyUrl' => $this->get_extension_popup_dynamic_buy_url($license_key), 'bullets' => ['heading' => __('And get much more!', 'feeds-for-youtube'), 'content' => [__('Covert videos to WP Posts', 'feeds-for-youtube'), __('Show subscribers', 'feeds-for-youtube'), __('Show video details', 'feeds-for-youtube'), __('Fast and Effective Support', 'feeds-for-youtube'), __('Always up to date', 'feeds-for-youtube'), __('30 Day Money Back Guarantee', 'feeds-for-youtube')]]],
            'subscribeLink' => ['heading' => $this->get_extension_popup_dynamic_heading('Subscibe button', $plus_text), 'description' => __('Take the chance to grow you channel by displaying the subscribe bar link', 'feeds-for-youtube'), 'popupContentBtn' => '<div class="sbc-extpp-lite-btn">' . self::builder_svg_icons()['tag'] . __('Lite Feed Users get a 50% OFF', 'feeds-for-youtube') . '</div>', 'img' => '<svg width="396" height="264" viewBox="0 0 396 264" fill="none" xmlns="http://www.w3.org/2000/svg"><g filter="url(#filter0_ddd_2319_52691)"><g clip-path="url(#clip0_2319_52691)"><rect x="70.1992" y="51.4148" width="235.041" height="169.704" rx="3.17158" transform="rotate(-3 70.1992 51.4148)" fill="white"/><g clip-path="url(#clip1_2319_52691)"><rect width="236.53" height="115.603" transform="translate(69.1523 51.4692) rotate(-3)" fill="#696D80"/><circle cx="282.532" cy="53.9951" r="112.561" transform="rotate(-3 282.532 53.9951)" fill="#434960"/><path d="M75.9102 165.997L139.271 162.594" stroke="#EB2121" stroke-width="1.75859"/><line x1="311.519" y1="153.871" x2="139.312" y2="163.033" stroke="#E6E6EB" stroke-width="1.75859"/></g><circle cx="142.091" cy="161.429" r="5.29774" transform="rotate(-3 142.091 161.429)" fill="#EB2121"/><rect x="88.3516" y="182.539" width="101.119" height="11.4308" rx="1.52109" transform="rotate(-3 88.3516 182.539)" fill="#E6E6EB"/><g filter="url(#filter1_di_2319_52691)"><rect x="225.031" y="169.652" width="70.3435" height="28.1374" rx="4.39647" transform="rotate(-3 225.031 169.652)" fill="#EB2121"/><rect opacity="0.4" x="238.664" y="177.742" width="43.9647" height="9.67223" rx="1.75859" transform="rotate(-3 238.664 177.742)" fill="white"/></g></g></g><path d="M288.51 195.754L288.268 194.383L286.748 194.651L286.506 193.281L283.465 193.817L283.223 192.446L278.661 193.25L278.419 191.879L275.378 192.416L274.411 186.932L272.89 187.2L272.649 185.829L269.607 186.366L269.849 187.737L268.328 188.005L270.504 200.343L268.983 200.611L268.741 199.24L264.179 200.044L265.146 205.528L266.667 205.26L267.15 208.002L268.671 207.733L269.155 210.475L270.675 210.207L271.159 212.949L272.679 212.681L273.405 216.794L290.132 213.844L289.165 208.36L290.686 208.092L289.96 203.98L288.44 204.248L289.165 208.36L287.644 208.629L288.369 212.741L274.683 215.154L274.2 212.413L272.679 212.681L272.196 209.939L270.675 210.207L270.192 207.465L268.671 207.733L268.188 204.992L266.667 205.26L265.942 201.147L268.983 200.611L269.225 201.982L270.746 201.714L271.471 205.826L272.991 205.558L269.849 187.737L272.89 187.2L275.066 199.538L276.586 199.27L275.62 193.787L278.661 193.25L279.628 198.734L281.148 198.466L280.423 194.353L283.465 193.817L284.431 199.3L285.952 199.032L285.227 194.92L286.748 194.651L286.989 196.022L288.51 195.754L289.96 203.98L291.481 203.711L290.031 195.486L288.51 195.754Z" fill="#141B38"/><path d="M288.443 204.247L289.964 203.979L288.513 195.754L286.993 196.022L286.751 194.651L285.23 194.919L285.955 199.032L284.435 199.3L283.468 193.816L280.426 194.352L281.152 198.465L279.631 198.733L278.664 193.25L275.623 193.786L276.59 199.269L275.069 199.538L272.893 187.2L269.852 187.736L272.995 205.557L271.474 205.826L270.749 201.713L269.228 201.981L268.986 200.61L265.945 201.146L266.67 205.259L268.191 204.991L268.674 207.733L270.195 207.465L270.678 210.206L272.199 209.938L272.683 212.68L274.203 212.412L274.687 215.154L288.373 212.741L287.647 208.628L289.168 208.36L288.443 204.247Z" fill="white"/><path fill-rule="evenodd" clip-rule="evenodd" d="M275.793 203.651L277.314 203.383L278.453 209.846L276.933 210.114L275.793 203.651ZM280.351 202.847L278.831 203.115L279.97 209.578L281.491 209.31L280.351 202.847ZM283.398 202.31L281.877 202.578L283.017 209.041L284.537 208.773L283.398 202.31Z" fill="#141B38"/><defs><filter id="filter0_ddd_2319_52691" x="49.5839" y="28.0132" width="284.832" height="223.003" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="9.51475"/><feGaussianBlur stdDeviation="10.3077"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2319_52691"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1.58579"/><feGaussianBlur stdDeviation="1.58579"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/><feBlend mode="normal" in2="effect1_dropShadow_2319_52691" result="effect2_dropShadow_2319_52691"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.75738"/><feGaussianBlur stdDeviation="4.75738"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="effect2_dropShadow_2319_52691" result="effect3_dropShadow_2319_52691"/><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow_2319_52691" result="shape"/></filter><filter id="filter1_di_2319_52691" x="223.273" y="164.212" width="75.2359" height="36.1767" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.879294"/><feGaussianBlur stdDeviation="0.879294"/><feComposite in2="hardAlpha" operator="out"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.13 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2319_52691"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_2319_52691" result="shape"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="-1.75859"/><feGaussianBlur stdDeviation="0.879294"/><feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="shape" result="effect2_innerShadow_2319_52691"/></filter><clipPath id="clip0_2319_52691"><rect x="70.1992" y="51.4148" width="235.041" height="169.704" rx="3.17158" transform="rotate(-3 70.1992 51.4148)" fill="white"/></clipPath><clipPath id="clip1_2319_52691"><rect width="236.53" height="115.603" fill="white" transform="translate(69.1523 51.4692) rotate(-3)"/></clipPath></defs></svg>', 'demoUrl' => 'https://smashballoon.com/youtube-feed/demo/?utm_campaign=youtube-free&utm_source=feed-type&utm_medium=youtube-feed&utm_content=view-demo', 'buyUrl' => $this->get_extension_popup_dynamic_buy_url($license_key), 'bullets' => ['heading' => __('And get much more!', 'feeds-for-youtube'), 'content' => [__('Covert videos to WP Posts', 'feeds-for-youtube'), __('Show subscribers', 'feeds-for-youtube'), __('Show video details', 'feeds-for-youtube'), __('Fast and Effective Support', 'feeds-for-youtube'), __('Always up to date', 'feeds-for-youtube'), __('30 Day Money Back Guarantee', 'feeds-for-youtube')]]],
            'comments' => ['heading' => $this->get_extension_popup_dynamic_heading('<br> Viewer Comments ', $plus_text), 'description' => __('Display comments from your YouTube audience right on your website with a simple click.', 'feeds-for-youtube'), 'popupContentBtn' => '<div class="sbc-extpp-lite-btn">' . self::builder_svg_icons()['tag'] . __('Lite Feed Users get a 50% OFF', 'feeds-for-youtube') . '</div>', 'img' => '<svg width="396" height="264" viewBox="0 0 396 264" fill="none" xmlns="http://www.w3.org/2000/svg"><g filter="url(#filter0_d_2699_39089)"><rect x="66" y="60" width="262" height="72" rx="2" fill="white"/><g clip-path="url(#clip0_2699_39089)"><rect x="82" y="76" width="30" height="30" rx="15" fill="#BFE8FF"/><rect x="97.0679" y="84" width="37" height="30" rx="15" transform="rotate(15.6009 97.0679 84)" fill="#52D1FF"/></g><rect x="131" y="78" width="163" height="9" rx="2" fill="#E6E6EB"/><rect x="131" y="96" width="100" height="9" rx="2" fill="#E6E6EB"/></g><g filter="url(#filter1_d_2699_39089)"><rect x="65.2319" y="145.922" width="262" height="72" rx="2" transform="rotate(-1.27429 65.2319 145.922)" fill="white"/><rect x="130.616" y="162.472" width="163" height="9" rx="2" transform="rotate(-1.27429 130.616 162.472)" fill="#E6E6EB"/><rect x="131.017" y="180.468" width="100" height="9" rx="2" transform="rotate(-1.27429 131.017 180.468)" fill="#E6E6EB"/><g clip-path="url(#clip1_2699_39089)"><rect x="81" y="156" width="30" height="30" rx="15" fill="#FFCAC7"/><rect x="62.0679" y="140" width="37" height="30" rx="15" transform="rotate(15.6009 62.0679 140)" fill="#FFE1E0"/></g></g><defs><filter id="filter0_d_2699_39089" x="62" y="57" width="270" height="80" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1"/><feGaussianBlur stdDeviation="2"/><feComposite in2="hardAlpha" operator="out"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2699_39089"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_2699_39089" result="shape"/></filter><filter id="filter1_d_2699_39089" x="61.2319" y="137.096" width="271.537" height="85.8087" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1"/><feGaussianBlur stdDeviation="2"/><feComposite in2="hardAlpha" operator="out"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2699_39089"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_2699_39089" result="shape"/></filter><clipPath id="clip0_2699_39089"><rect x="82" y="76" width="30" height="30" rx="15" fill="white"/></clipPath><clipPath id="clip1_2699_39089"><rect x="81" y="156" width="30" height="30" rx="15" fill="white"/></clipPath></defs></svg>', 'demoUrl' => 'https://smashballoon.com/youtube-feed/demo/?utm_campaign=youtube-free&utm_source=feed-type&utm_medium=youtube-feed&utm_content=view-demo', 'buyUrl' => $this->get_extension_popup_dynamic_buy_url($license_key), 'bullets' => ['heading' => __('And get much more!', 'feeds-for-youtube'), 'content' => [__('Covert videos to WP Posts', 'feeds-for-youtube'), __('Show subscribers', 'feeds-for-youtube'), __('Show video details', 'feeds-for-youtube'), __('Fast and Effective Support', 'feeds-for-youtube'), __('Always up to date', 'feeds-for-youtube'), __('3sdasdrantee', 'feeds-for-youtube')]]],
            'videoElements' => ['heading' => __('Display video info and hover states by upgrading to Pro', 'feeds-for-youtube'), 'description' => __('Create a clean layout for your feed with additional information about videos displayed on hover.', 'feeds-for-youtube'), 'popupContentBtn' => '<div class="sbc-extpp-lite-btn">' . self::builder_svg_icons()['tag'] . __('Lite Feed Users get a 50% OFF', 'feeds-for-youtube') . '</div>', 'img' => '<svg width="396" height="264" viewBox="0 0 396 264" fill="none" xmlns="http://www.w3.org/2000/svg"><g filter="url(#filter0_d_142_33421)"><g clip-path="url(#clip0_142_33421)"><rect x="196.486" y="41.9883" width="139.542" height="147.818" rx="4" transform="rotate(3 196.486 41.9883)" fill="#434960"/><path opacity="0.4" d="M207.271 102.813C208.625 102.884 212.65 103.095 217.927 103.372C224.523 103.718 224.523 103.718 230.104 104.01C235.685 104.303 236.7 104.356 250.399 105.074C264.098 105.792 261.562 105.659 268.665 106.031C275.768 106.403 276.783 106.456 289.975 107.148C300.529 107.701 312.976 108.353 317.881 108.61" stroke="white" stroke-width="6.91919"/><path opacity="0.4" d="M208.186 85.395C209.539 85.4659 213.564 85.6769 218.841 85.9534C225.437 86.2991 225.437 86.2991 231.018 86.5916C236.599 86.8841 237.614 86.9373 251.313 87.6552C265.013 88.3732 262.476 88.2402 269.579 88.6125C276.682 88.9848 277.697 89.038 290.889 89.7293C301.443 90.2824 313.891 90.9348 318.795 91.1918" stroke="white" stroke-width="6.91919"/><path opacity="0.4" d="M206.359 120.232C207.711 120.303 211.732 120.514 217.003 120.79C223.593 121.136 223.593 121.136 229.168 121.428C234.744 121.72 234.237 121.693 247.922 122.411C261.607 123.128 260.593 123.075 268.196 123.473" stroke="white" stroke-width="6.91919"/><path d="M205.601 150.511L205.654 149.502L208.263 147.306C209.214 146.505 209.422 146.169 209.448 145.681L209.448 145.671C209.474 145.096 209.056 144.663 208.432 144.631C207.71 144.593 207.198 145.04 207.145 145.673L207.138 145.717L205.773 145.645L205.775 145.606C205.844 144.28 206.995 143.406 208.482 143.484C209.97 143.562 210.949 144.464 210.886 145.664L210.886 145.673C210.841 146.527 210.407 147.061 209.135 148.114L207.591 149.383L207.588 149.442L210.777 149.609L210.716 150.779L205.601 150.511ZM214.666 151.108C212.989 151.02 211.872 150.126 211.935 148.916L211.936 148.907C211.984 147.995 212.697 147.357 213.652 147.222L213.654 147.192C212.85 146.95 212.33 146.331 212.369 145.58L212.37 145.57C212.427 144.483 213.526 143.748 215.048 143.828C216.564 143.908 217.586 144.753 217.529 145.841L217.528 145.85C217.489 146.601 216.902 147.162 216.082 147.32L216.081 147.349C217.012 147.584 217.655 148.292 217.607 149.204L217.606 149.214C217.543 150.423 216.344 151.196 214.666 151.108ZM214.891 146.812C215.555 146.847 216.034 146.476 216.063 145.911L216.064 145.901C216.093 145.34 215.65 144.926 214.992 144.891C214.334 144.857 213.845 145.222 213.816 145.783L213.815 145.793C213.786 146.358 214.228 146.778 214.891 146.812ZM214.723 150.035C215.488 150.076 216.053 149.655 216.085 149.036L216.086 149.026C216.119 148.402 215.611 147.921 214.835 147.88C214.06 147.84 213.5 148.265 213.467 148.889L213.467 148.899C213.434 149.518 213.952 149.995 214.723 150.035ZM219.337 151.314C218.893 151.291 218.565 150.921 218.588 150.483C218.612 150.039 218.976 149.711 219.42 149.734C219.859 149.757 220.192 150.122 220.168 150.565C220.145 151.004 219.776 151.337 219.337 151.314ZM224.082 151.602C222.404 151.514 221.287 150.619 221.351 149.41L221.351 149.4C221.399 148.488 222.112 147.851 223.068 147.715L223.069 147.686C222.265 147.443 221.745 146.824 221.785 146.073L221.785 146.064C221.842 144.976 222.942 144.242 224.463 144.322C225.98 144.401 227.001 145.247 226.944 146.334L226.944 146.344C226.904 147.095 226.317 147.656 225.498 147.813L225.496 147.842C226.427 148.077 227.07 148.785 227.022 149.697L227.022 149.707C226.958 150.916 225.759 151.69 224.082 151.602ZM224.307 147.306C224.97 147.341 225.449 146.97 225.478 146.404L225.479 146.394C225.508 145.833 225.066 145.419 224.407 145.385C223.749 145.35 223.26 145.716 223.231 146.276L223.231 146.286C223.201 146.852 223.643 147.271 224.307 147.306ZM224.138 150.529C224.903 150.569 225.468 150.149 225.5 149.53L225.501 149.52C225.534 148.896 225.026 148.414 224.251 148.374C223.475 148.333 222.915 148.758 222.883 149.383L222.882 149.392C222.85 150.012 223.367 150.489 224.138 150.529ZM230.495 151.816L230.863 144.779L232.336 144.856L232.167 148.075L232.201 148.076L234.949 144.993L236.588 145.079L233.904 148.053L236.4 152.125L234.639 152.033L232.781 148.958L232.08 149.737L231.967 151.893L230.495 151.816ZM241.504 152.393L239.518 145.233L241.146 145.318L242.466 150.932L242.495 150.934L244.389 145.488L246.023 145.574L243.299 152.487L241.504 152.393ZM247.526 146.792C247.096 146.769 246.782 146.415 246.804 146.011C246.825 145.606 247.174 145.287 247.603 145.309C248.032 145.332 248.346 145.686 248.325 146.09C248.304 146.495 247.955 146.814 247.526 146.792ZM246.504 152.655L246.778 147.427L248.202 147.502L247.928 152.729L246.504 152.655ZM251.557 153.027C249.958 152.943 249.042 151.854 249.13 150.181L249.13 150.176C249.217 148.514 250.253 147.502 251.784 147.582C253.315 147.662 254.221 148.751 254.139 150.331L254.116 150.77L250.517 150.581C250.488 151.416 250.916 151.927 251.642 151.965C252.228 151.996 252.6 151.693 252.718 151.406L252.729 151.377L254.036 151.446L254.019 151.498C253.817 152.26 253.05 153.105 251.557 153.027ZM251.753 148.646C251.168 148.616 250.708 148.983 250.579 149.685L252.797 149.801C252.747 149.075 252.343 148.677 251.753 148.646ZM256.022 153.153L254.906 147.853L256.34 147.928L256.927 151.846L256.956 151.848L258.085 148.02L259.451 148.091L260.179 152.017L260.208 152.018L261.206 148.183L262.611 148.257L260.952 153.412L259.435 153.332L258.683 149.587L258.654 149.585L257.519 153.232L256.022 153.153ZM265.308 153.748C263.859 153.672 263.09 152.961 263.029 151.966L263.027 151.922L264.417 151.994L264.424 152.039C264.495 152.453 264.79 152.708 265.36 152.738C265.897 152.766 266.234 152.574 266.252 152.237L266.252 152.232C266.267 151.954 266.1 151.784 265.594 151.645L264.716 151.414C263.713 151.146 263.228 150.612 263.268 149.832L263.269 149.827C263.321 148.832 264.213 148.233 265.544 148.303C266.934 148.376 267.67 149.153 267.656 150.072L267.654 150.12L266.342 150.052L266.339 150.012C266.31 149.634 266.018 149.335 265.491 149.308C264.999 149.282 264.68 149.485 264.662 149.822L264.662 149.827C264.648 150.095 264.819 150.28 265.34 150.42L266.218 150.656C267.298 150.943 267.724 151.395 267.684 152.166L267.683 152.171C267.63 153.195 266.653 153.818 265.308 153.748Z" fill="white"/><circle cx="274.425" cy="150.613" r="1" transform="rotate(3 274.425 150.613)" fill="white"/><path d="M283.613 154.722C281.941 154.634 280.903 153.812 280.888 152.511L280.888 152.432L282.277 152.505L282.284 152.559C282.348 153.11 282.911 153.482 283.715 153.524C284.53 153.567 285.06 153.238 285.088 152.701L285.089 152.697C285.114 152.219 284.78 151.962 283.917 151.736L283.183 151.55C281.808 151.2 281.141 150.5 281.196 149.442L281.196 149.437C281.264 148.149 282.43 147.36 283.99 147.441C285.619 147.527 286.576 148.394 286.579 149.631L286.579 149.724L285.19 149.651L285.188 149.592C285.143 149.037 284.654 148.674 283.927 148.636C283.171 148.601 282.7 148.924 282.673 149.426L282.673 149.431C282.65 149.875 282.997 150.152 283.798 150.355L284.536 150.546C285.994 150.915 286.625 151.55 286.567 152.657L286.567 152.662C286.496 154.012 285.388 154.815 283.613 154.722ZM289.911 155.037C288.312 154.953 287.396 153.864 287.484 152.191L287.484 152.187C287.571 150.524 288.607 149.512 290.138 149.592C291.669 149.673 292.575 150.762 292.493 152.341L292.47 152.78L288.871 152.592C288.842 153.426 289.27 153.938 289.996 153.976C290.581 154.006 290.954 153.703 291.072 153.416L291.083 153.387L292.39 153.456L292.373 153.509C292.171 154.271 291.403 155.115 289.911 155.037ZM290.107 150.657C289.522 150.626 289.062 150.993 288.933 151.695L291.151 151.812C291.101 151.085 290.697 150.688 290.107 150.657ZM293.297 156.818L293.66 149.885L295.084 149.959L295.036 150.871L295.07 150.873C295.386 150.254 295.977 149.898 296.718 149.937C298.044 150.007 298.801 151.063 298.711 152.765L298.711 152.77C298.622 154.467 297.759 155.448 296.452 155.38C295.706 155.341 295.136 154.93 294.886 154.296L294.857 154.294L294.72 156.893L293.297 156.818ZM296.027 154.174C296.734 154.211 297.213 153.645 297.263 152.694L297.263 152.689C297.313 151.734 296.895 151.13 296.188 151.093C295.496 151.056 294.992 151.627 294.942 152.572L294.942 152.577C294.892 153.518 295.334 154.138 296.027 154.174ZM301.687 155.654C300.526 155.593 300.003 155.116 300.062 153.995L300.203 151.303L299.477 151.265L299.533 150.192L300.26 150.23L300.326 148.953L301.765 149.028L301.698 150.306L302.654 150.356L302.597 151.429L301.642 151.379L301.509 153.914C301.483 154.402 301.694 154.579 302.123 154.601C302.25 154.608 302.343 154.598 302.432 154.593L302.377 155.637C302.215 155.653 301.984 155.67 301.687 155.654ZM307.538 155.853L307.836 150.168L307.807 150.166L305.949 151.291L306.017 149.984L307.902 148.817L309.365 148.894L308.996 155.93L307.538 155.853ZM310.876 156.028L310.928 155.019L313.537 152.823C314.489 152.022 314.697 151.686 314.722 151.199L314.723 151.189C314.748 150.613 314.331 150.181 313.707 150.148C312.985 150.11 312.473 150.558 312.42 151.19L312.413 151.234L311.047 151.162L311.049 151.123C311.119 149.797 312.27 148.924 313.757 149.001C315.244 149.079 316.224 149.982 316.161 151.181L316.16 151.191C316.116 152.044 315.682 152.579 314.409 153.632L312.866 154.9L312.863 154.959L316.052 155.126L315.991 156.296L310.876 156.028Z" fill="white"/></g></g><g filter="url(#filter1_d_142_33421)"><g clip-path="url(#clip1_142_33421)"><rect x="63" y="55.1201" width="139.542" height="164.834" rx="4" fill="white"/><path d="M74.5781 156.849C75.7313 156.82 79.1621 156.769 83.6596 156.797C89.2814 156.832 89.2814 156.875 94.0383 156.849C98.7953 156.823 99.6602 156.77 111.336 156.823C123.012 156.875 120.85 156.875 126.904 156.849C132.959 156.823 133.824 156.81 145.067 156.849C154.062 156.881 164.672 156.877 168.852 156.871" stroke="#DCDDE1" stroke-width="6.91919"/><path d="M74.5781 171.754C75.7313 171.729 79.1621 171.684 83.6596 171.709C89.2814 171.739 89.2814 171.777 94.0383 171.754C98.7953 171.731 98.3628 171.709 110.039 171.754C121.715 171.799 120.85 171.789 127.337 171.782" stroke="#DCDDE1" stroke-width="6.91919"/><g clip-path="url(#clip2_142_33421)"><rect x="72.5938" y="52.5039" width="132.565" height="88.9581" fill="#FFE1E0"/><circle cx="97.5115" cy="88.7693" r="71.0037" fill="#FFCAC7"/><circle cx="209.411" cy="160.88" r="73.7586" fill="#FCA7A1"/><rect x="124.666" y="88.5835" width="17.3611" height="18.75" fill="white"/><path d="M128.833 105.25L139.645 98.9998L128.833 92.7498V105.25ZM152.916 88.9373C153.187 89.9165 153.374 91.229 153.499 92.8957C153.645 94.5623 153.708 95.9998 153.708 97.2498L153.833 98.9998C153.833 103.562 153.499 106.917 152.916 109.062C152.395 110.937 151.187 112.146 149.312 112.667C148.333 112.937 146.541 113.125 143.791 113.25C141.083 113.396 138.604 113.458 136.312 113.458L132.999 113.583C124.27 113.583 118.833 113.25 116.687 112.667C114.812 112.146 113.604 110.937 113.083 109.062C112.812 108.083 112.624 106.771 112.499 105.104C112.354 103.437 112.291 102 112.291 100.75L112.166 98.9998C112.166 94.4373 112.499 91.0832 113.083 88.9373C113.604 87.0623 114.812 85.854 116.687 85.3332C117.666 85.0623 119.458 84.8748 122.208 84.7498C124.916 84.604 127.395 84.5415 129.687 84.5415L132.999 84.4165C141.729 84.4165 147.166 84.7498 149.312 85.3332C151.187 85.854 152.395 87.0623 152.916 88.9373Z" fill="#EB2121"/><rect x="167" y="122" width="30" height="15" rx="3" fill="black" fill-opacity="0.38"/><path d="M173.12 133.122C171.523 133.122 170.479 132.282 170.381 131.066L170.376 131.003H171.782L171.792 131.057C171.855 131.56 172.354 131.936 173.115 131.936C173.872 131.936 174.36 131.53 174.36 130.954V130.944C174.36 130.271 173.857 129.899 173.008 129.899H172.202V128.85H172.988C173.726 128.85 174.204 128.459 174.204 127.888V127.878C174.204 127.307 173.799 126.965 173.105 126.965C172.417 126.965 171.948 127.321 171.89 127.868L171.885 127.912H170.532L170.537 127.854C170.635 126.633 171.626 125.832 173.105 125.832C174.624 125.832 175.601 126.574 175.601 127.683V127.692C175.601 128.571 174.956 129.143 174.131 129.313V129.343C175.176 129.44 175.859 130.046 175.859 131.003V131.013C175.859 132.272 174.766 133.122 173.12 133.122ZM177.805 128.527C177.361 128.527 177.014 128.181 177.014 127.736C177.014 127.297 177.361 126.945 177.805 126.945C178.244 126.945 178.596 127.297 178.596 127.736C178.596 128.181 178.244 128.527 177.805 128.527ZM177.805 132.004C177.361 132.004 177.014 131.652 177.014 131.213C177.014 130.769 177.361 130.422 177.805 130.422C178.244 130.422 178.596 130.769 178.596 131.213C178.596 131.652 178.244 132.004 177.805 132.004ZM183.168 133V131.706H179.663V130.476L182.49 125.954H184.57V130.529H185.497V131.706H184.57V133H183.168ZM180.947 130.568H183.198V127.019H183.163L180.947 130.529V130.568ZM189.289 133.122C187.755 133.122 186.74 132.229 186.652 131.052L186.647 130.979H188.009L188.019 131.013C188.122 131.545 188.615 131.955 189.294 131.955C190.065 131.955 190.607 131.428 190.607 130.676V130.666C190.602 129.924 190.06 129.401 189.298 129.401C188.937 129.401 188.629 129.509 188.39 129.699C188.249 129.807 188.136 129.943 188.053 130.09H186.769L187.091 125.954H191.588V127.126H188.263L188.092 129.108H188.122C188.415 128.635 188.996 128.347 189.709 128.347C191.046 128.347 192.013 129.309 192.013 130.637V130.646C192.013 132.121 190.9 133.122 189.289 133.122Z" fill="white"/></g><path d="M75.707 206.406V205.396L78.1973 203.066C79.1055 202.217 79.2959 201.87 79.2959 201.382V201.372C79.291 200.796 78.8516 200.386 78.2266 200.386C77.5039 200.386 77.0156 200.859 76.9961 201.494L76.9912 201.538H75.624V201.499C75.624 200.171 76.7275 199.238 78.2168 199.238C79.7061 199.238 80.7314 200.088 80.7314 201.289V201.299C80.7314 202.153 80.3262 202.71 79.1104 203.828L77.6357 205.176V205.234H80.8291V206.406H75.707ZM84.7912 206.528C83.1115 206.528 81.9494 205.693 81.9494 204.482V204.473C81.9494 203.56 82.6281 202.886 83.5754 202.7V202.671C82.76 202.471 82.2082 201.88 82.2082 201.128V201.118C82.2082 200.029 83.2678 199.238 84.7912 199.238C86.3098 199.238 87.3742 200.029 87.3742 201.118V201.128C87.3742 201.88 86.8176 202.471 86.007 202.671V202.7C86.9494 202.886 87.6281 203.56 87.6281 204.473V204.482C87.6281 205.693 86.4709 206.528 84.7912 206.528ZM84.7912 202.227C85.4553 202.227 85.9143 201.831 85.9143 201.265V201.255C85.9143 200.693 85.4504 200.303 84.7912 200.303C84.132 200.303 83.6633 200.693 83.6633 201.255V201.265C83.6633 201.831 84.1271 202.227 84.7912 202.227ZM84.7912 205.454C85.5578 205.454 86.0998 205.005 86.0998 204.385V204.375C86.0998 203.75 85.5676 203.296 84.7912 203.296C84.0148 203.296 83.4777 203.75 83.4777 204.375V204.385C83.4777 205.005 84.0197 205.454 84.7912 205.454ZM89.4662 206.489C89.0219 206.489 88.6752 206.138 88.6752 205.698C88.6752 205.254 89.0219 204.907 89.4662 204.907C89.9057 204.907 90.2572 205.254 90.2572 205.698C90.2572 206.138 89.9057 206.489 89.4662 206.489ZM94.2193 206.528C92.5396 206.528 91.3775 205.693 91.3775 204.482V204.473C91.3775 203.56 92.0562 202.886 93.0035 202.7V202.671C92.1881 202.471 91.6363 201.88 91.6363 201.128V201.118C91.6363 200.029 92.6959 199.238 94.2193 199.238C95.7379 199.238 96.8023 200.029 96.8023 201.118V201.128C96.8023 201.88 96.2457 202.471 95.4352 202.671V202.7C96.3775 202.886 97.0562 203.56 97.0562 204.473V204.482C97.0562 205.693 95.899 206.528 94.2193 206.528ZM94.2193 202.227C94.8834 202.227 95.3424 201.831 95.3424 201.265V201.255C95.3424 200.693 94.8785 200.303 94.2193 200.303C93.5602 200.303 93.0914 200.693 93.0914 201.255V201.265C93.0914 201.831 93.5553 202.227 94.2193 202.227ZM94.2193 205.454C94.9859 205.454 95.5279 205.005 95.5279 204.385V204.375C95.5279 203.75 94.9957 203.296 94.2193 203.296C93.443 203.296 92.9059 203.75 92.9059 204.375V204.385C92.9059 205.005 93.4479 205.454 94.2193 205.454ZM100.635 206.406V199.36H102.109V202.583H102.144L104.727 199.36H106.367L103.843 202.471L106.548 206.406H104.785L102.769 203.433L102.109 204.248V206.406H100.635ZM111.66 206.406L109.301 199.36H110.932L112.543 204.897H112.573L114.179 199.36H115.815L113.456 206.406H111.66ZM117.379 200.498C116.95 200.498 116.618 200.161 116.618 199.756C116.618 199.351 116.95 199.014 117.379 199.014C117.809 199.014 118.141 199.351 118.141 199.756C118.141 200.161 117.809 200.498 117.379 200.498ZM116.667 206.406V201.172H118.092V206.406H116.667ZM121.732 206.514C120.131 206.514 119.159 205.474 119.159 203.799V203.794C119.159 202.129 120.14 201.064 121.674 201.064C123.207 201.064 124.169 202.104 124.169 203.687V204.126H120.565C120.58 204.961 121.034 205.449 121.762 205.449C122.347 205.449 122.704 205.127 122.806 204.834L122.816 204.805H124.125L124.11 204.858C123.949 205.63 123.226 206.514 121.732 206.514ZM121.698 202.129C121.112 202.129 120.673 202.52 120.58 203.228H122.802C122.714 202.505 122.289 202.129 121.698 202.129ZM126.197 206.406L124.806 201.172H126.241L127.032 205.054H127.062L127.989 201.172H129.356L130.289 205.054H130.318L131.114 201.172H132.521L131.134 206.406H129.615L128.668 202.705H128.639L127.696 206.406H126.197ZM135.501 206.514C134.051 206.514 133.245 205.845 133.133 204.854L133.128 204.81H134.52L134.529 204.854C134.622 205.264 134.93 205.503 135.501 205.503C136.038 205.503 136.365 205.293 136.365 204.956V204.951C136.365 204.673 136.19 204.512 135.677 204.399L134.788 204.214C133.773 203.999 133.26 203.491 133.26 202.71V202.705C133.26 201.709 134.119 201.064 135.452 201.064C136.844 201.064 137.62 201.802 137.654 202.72V202.769H136.341L136.336 202.729C136.287 202.354 135.98 202.07 135.452 202.07C134.959 202.07 134.652 202.29 134.652 202.627V202.632C134.652 202.9 134.832 203.076 135.36 203.188L136.248 203.379C137.342 203.608 137.791 204.038 137.791 204.81V204.814C137.791 205.84 136.849 206.514 135.501 206.514Z" fill="#434960"/><circle cx="144.441" cy="202.906" r="1" fill="#CED0D9"/><path d="M153.833 206.528C152.158 206.528 151.079 205.762 150.996 204.463L150.991 204.385H152.383L152.393 204.438C152.485 204.985 153.066 205.327 153.872 205.327C154.688 205.327 155.2 204.971 155.2 204.434V204.429C155.2 203.95 154.854 203.711 153.979 203.53L153.237 203.384C151.846 203.105 151.143 202.441 151.143 201.382V201.377C151.143 200.088 152.266 199.238 153.828 199.238C155.459 199.238 156.46 200.054 156.528 201.289L156.533 201.382H155.142L155.137 201.323C155.063 200.771 154.556 200.435 153.828 200.435C153.071 200.439 152.617 200.786 152.617 201.289V201.294C152.617 201.738 152.979 201.997 153.789 202.158L154.536 202.31C156.011 202.603 156.675 203.203 156.675 204.312V204.316C156.675 205.669 155.61 206.528 153.833 206.528ZM160.139 206.514C158.537 206.514 157.566 205.474 157.566 203.799V203.794C157.566 202.129 158.547 201.064 160.08 201.064C161.613 201.064 162.575 202.104 162.575 203.687V204.126H158.972C158.987 204.961 159.441 205.449 160.168 205.449C160.754 205.449 161.111 205.127 161.213 204.834L161.223 204.805H162.531L162.517 204.858C162.356 205.63 161.633 206.514 160.139 206.514ZM160.105 202.129C159.519 202.129 159.079 202.52 158.987 203.228H161.208C161.12 202.505 160.696 202.129 160.105 202.129ZM163.613 208.115V201.172H165.038V202.085H165.073C165.356 201.45 165.927 201.064 166.669 201.064C167.997 201.064 168.808 202.08 168.808 203.784V203.789C168.808 205.488 167.997 206.514 166.689 206.514C165.942 206.514 165.351 206.133 165.068 205.513H165.038V208.115H163.613ZM166.201 205.332C166.909 205.332 167.358 204.741 167.358 203.789V203.784C167.358 202.827 166.909 202.246 166.201 202.246C165.507 202.246 165.034 202.842 165.034 203.789V203.794C165.034 204.736 165.507 205.332 166.201 205.332ZM171.93 206.514C170.768 206.514 170.221 206.064 170.221 204.941V202.246H169.494V201.172H170.221V199.893H171.662V201.172H172.619V202.246H171.662V204.785C171.662 205.273 171.881 205.439 172.311 205.439C172.438 205.439 172.531 205.425 172.619 205.415V206.46C172.458 206.484 172.228 206.514 171.93 206.514ZM177.784 206.406V200.713H177.755L175.958 201.934V200.625L177.779 199.36H179.244V206.406H177.784ZM181.126 206.406V205.396L183.616 203.066C184.525 202.217 184.715 201.87 184.715 201.382V201.372C184.71 200.796 184.271 200.386 183.646 200.386C182.923 200.386 182.435 200.859 182.415 201.494L182.41 201.538H181.043V201.499C181.043 200.171 182.147 199.238 183.636 199.238C185.125 199.238 186.151 200.088 186.151 201.289V201.299C186.151 202.153 185.745 202.71 184.529 203.828L183.055 205.176V205.234H186.248V206.406H181.126Z" fill="#434960"/></g></g><path d="M293.823 189.298L293.89 188.027L292.48 187.953L292.546 186.682L289.727 186.534L289.793 185.263L285.564 185.042L285.63 183.771L282.811 183.623L283.077 178.539L281.667 178.465L281.734 177.194L278.914 177.046L278.848 178.317L277.438 178.243L276.838 189.682L275.429 189.608L275.495 188.337L271.266 188.116L270.999 193.2L272.409 193.273L272.276 195.815L273.686 195.889L273.553 198.431L274.962 198.505L274.829 201.047L276.239 201.121L276.039 204.934L291.547 205.747L291.814 200.663L293.224 200.737L293.423 196.924L292.014 196.85L291.814 200.663L290.404 200.589L290.204 204.402L277.516 203.737L277.649 201.195L276.239 201.121L276.372 198.579L274.962 198.505L275.096 195.963L273.686 195.889L273.819 193.347L272.409 193.273L272.609 189.46L275.429 189.608L275.362 190.879L276.772 190.953L276.572 194.766L277.982 194.84L278.848 178.317L281.667 178.465L281.068 189.904L282.478 189.978L282.744 184.894L285.564 185.042L285.297 190.125L286.707 190.199L286.907 186.386L289.727 186.534L289.46 191.618L290.87 191.692L291.07 187.879L292.48 187.953L292.413 189.224L293.823 189.298L293.423 196.924L294.833 196.998L295.233 189.372L293.823 189.298Z" fill="#141B38"/><path d="M292.014 196.85L293.424 196.924L293.824 189.298L292.414 189.224L292.48 187.953L291.071 187.879L290.871 191.692L289.461 191.618L289.727 186.534L286.908 186.386L286.708 190.199L285.298 190.125L285.564 185.041L282.745 184.894L282.478 189.978L281.068 189.904L281.668 178.465L278.848 178.317L277.982 194.84L276.573 194.766L276.772 190.953L275.363 190.879L275.429 189.608L272.609 189.46L272.41 193.273L273.82 193.347L273.686 195.889L275.096 195.963L274.963 198.505L276.373 198.579L276.24 201.121L277.649 201.195L277.516 203.737L290.205 204.402L290.404 200.589L291.814 200.663L292.014 196.85Z" fill="white"/><path fill-rule="evenodd" clip-rule="evenodd" d="M280.869 193.717L282.279 193.791L281.965 199.782L280.555 199.709L280.869 193.717ZM285.098 193.938L283.689 193.865L283.374 199.856L284.784 199.93L285.098 193.938ZM287.918 194.086L286.508 194.012L286.194 200.004L287.604 200.078L287.918 194.086Z" fill="#141B38"/><defs><filter id="filter0_d_142_33421" x="181.831" y="38.5287" width="160.926" height="168.757" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feMorphology radius="2.5947" operator="erode" in="SourceAlpha" result="effect1_dropShadow_142_33421"/><feOffset dy="3.45959"/><feGaussianBlur stdDeviation="4.75694"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33421"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_142_33421" result="shape"/></filter><filter id="filter1_d_142_33421" x="56.0808" y="51.6605" width="153.381" height="178.672" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feMorphology radius="2.5947" operator="erode" in="SourceAlpha" result="effect1_dropShadow_142_33421"/><feOffset dy="3.45959"/><feGaussianBlur stdDeviation="4.75694"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33421"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_142_33421" result="shape"/></filter><clipPath id="clip0_142_33421"><rect x="196.486" y="41.9883" width="139.542" height="147.818" rx="4" transform="rotate(3 196.486 41.9883)" fill="white"/></clipPath><clipPath id="clip1_142_33421"><rect x="63" y="55.1201" width="139.542" height="164.834" rx="4" fill="white"/></clipPath><clipPath id="clip2_142_33421"><rect width="139.542" height="86.3416" fill="white" transform="translate(63 55.1201)"/></clipPath></defs></svg>', 'demoUrl' => 'https://smashballoon.com/youtube-feed/demo/?utm_campaign=youtube-free&utm_source=feed-type&utm_medium=youtube-feed&utm_content=view-demo', 'buyUrl' => $this->get_extension_popup_dynamic_buy_url($license_key), 'bullets' => ['heading' => __('And get much more!', 'feeds-for-youtube'), 'content' => [__('Covert videos to WP Posts', 'feeds-for-youtube'), __('Show subscribers', 'feeds-for-youtube'), __('Show video details', 'feeds-for-youtube'), __('Fast and Effective Support', 'feeds-for-youtube'), __('Always up to date', 'feeds-for-youtube'), __('30 Day Money Back Guarantee', 'feeds-for-youtube')]]],
            'call_to_action' => ['heading' => __('Get Custom Call to <br> Actions with ', 'feeds-for-youtube') . $plus_text, 'description' => __('Keep your visitors consuming your content or prompt them to buy your product or service with end-of-video call to actions.', 'feeds-for-youtube'), 'popupContentBtn' => '<div class="sbc-extpp-lite-btn">' . self::builder_svg_icons()['tag'] . __('Lite Feed Users get a 50% OFF', 'feeds-for-youtube') . '</div>', 'img' => '<svg width="396" height="264" viewBox="0 0 396 264" fill="none" xmlns="http://www.w3.org/2000/svg"><g filter="url(#filter0_ddd_142_33476)"><g clip-path="url(#clip0_142_33476)"><rect x="59.9766" y="41.748" width="269" height="178" rx="3.60697" transform="rotate(-2 59.9766 41.748)" fill="white"/><g clip-path="url(#clip1_142_33476)"><rect width="269" height="131.473" transform="translate(59.9766 41.748) rotate(-2)" fill="#8C8F9A"/><circle cx="302.559" cy="48.8555" r="128.013" transform="rotate(-2 302.559 48.8555)" fill="#434960"/><line x1="65.3948" y1="172.111" x2="332.502" y2="162.783" stroke="#EB2121" stroke-width="2"/><g filter="url(#filter1_ddddd_142_33476)"><rect x="133.572" y="86.2065" width="124" height="37" rx="3" transform="rotate(-2 133.572 86.2065)" fill="#2FC5FB"/></g><g clip-path="url(#clip2_142_33476)"><path d="M257.307 117.944L256.711 116.469L255.074 117.13L254.479 115.655L251.206 116.977L250.61 115.502L245.702 117.485L245.106 116.01L241.833 117.332L239.449 111.432L237.813 112.093L237.217 110.618L233.945 111.94L234.541 113.415L232.904 114.076L238.268 127.351L236.632 128.013L236.036 126.537L231.127 128.521L233.511 134.421L235.147 133.76L236.339 136.71L237.976 136.049L239.167 138.999L240.804 138.338L241.996 141.288L243.632 140.627L245.42 145.052L263.418 137.78L261.034 131.88L262.67 131.219L260.882 126.794L259.246 127.455L261.034 131.88L259.398 132.541L261.186 136.966L246.46 142.916L245.268 139.966L243.632 140.627L242.44 137.677L240.804 138.338L239.612 135.388L237.976 136.049L236.784 133.099L235.147 133.76L233.36 129.335L236.632 128.013L237.228 129.488L238.864 128.827L240.652 133.252L242.288 132.591L234.541 113.415L237.813 112.093L243.177 125.368L244.813 124.707L242.429 118.807L245.702 117.485L248.085 123.385L249.722 122.724L247.934 118.299L251.206 116.977L253.59 122.877L255.226 122.216L253.438 117.791L255.074 117.13L255.67 118.605L257.307 117.944L260.882 126.794L262.519 126.133L258.943 117.283L257.307 117.944Z" fill="#141B38"/><path d="M259.247 127.455L260.883 126.794L257.307 117.944L255.671 118.605L255.075 117.13L253.439 117.791L255.226 122.216L253.59 122.877L251.206 116.977L247.934 118.299L249.722 122.724L248.086 123.385L245.702 117.485L242.429 118.807L244.813 124.707L243.177 125.368L237.813 112.093L234.541 113.415L242.288 132.591L240.652 133.252L238.864 128.827L237.228 129.488L236.632 128.013L233.36 129.335L235.148 133.76L236.784 133.099L237.976 136.049L239.612 135.388L240.804 138.338L242.44 137.677L243.632 140.627L245.268 139.966L246.46 142.916L261.186 136.966L259.398 132.541L261.034 131.88L259.247 127.455Z" fill="white"/><path fill-rule="evenodd" clip-rule="evenodd" d="M244.965 129.793L246.601 129.132L249.411 136.086L247.774 136.747L244.965 129.793ZM249.873 127.81L248.237 128.471L251.046 135.425L252.683 134.764L249.873 127.81ZM253.145 126.488L251.509 127.149L254.319 134.103L255.955 133.442L253.145 126.488Z" fill="#141B38"/></g></g><circle cx="327.345" cy="163.097" r="6.025" transform="rotate(-2 327.345 163.097)" fill="#EB2121"/><rect x="79.0273" y="190.756" width="154.826" height="13.8392" rx="1.7299" transform="rotate(-2 79.0273 190.756)" fill="#E8E8EB"/></g><rect x="58.1873" y="40.0796" width="272.46" height="181.46" rx="5.33687" transform="rotate(-2 58.1873 40.0796)" stroke="white" stroke-width="3.45981"/></g><defs><filter id="filter0_ddd_142_33476" x="33.1953" y="16.3995" width="328.611" height="240.842" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="10.8209"/><feGaussianBlur stdDeviation="11.7226"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33476"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1.80348"/><feGaussianBlur stdDeviation="1.80348"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/><feBlend mode="normal" in2="effect1_dropShadow_142_33476" result="effect2_dropShadow_142_33476"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="5.41045"/><feGaussianBlur stdDeviation="5.41045"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="effect2_dropShadow_142_33476" result="effect3_dropShadow_142_33476"/><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow_142_33476" result="shape"/></filter><filter id="filter1_ddddd_142_33476" x="56.3872" y="31.431" width="279.587" height="195.676" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1.77104"/><feGaussianBlur stdDeviation="2.55971"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.0421718 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33476"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4.25607"/><feGaussianBlur stdDeviation="6.15134"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.0605839 0"/><feBlend mode="normal" in2="effect1_dropShadow_142_33476" result="effect2_dropShadow_142_33476"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="8.01379"/><feGaussianBlur stdDeviation="11.5824"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.075 0"/><feBlend mode="normal" in2="effect2_dropShadow_142_33476" result="effect3_dropShadow_142_33476"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="14.2952"/><feGaussianBlur stdDeviation="20.6611"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.0894161 0"/><feBlend mode="normal" in2="effect3_dropShadow_142_33476" result="effect4_dropShadow_142_33476"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="26.7377"/><feGaussianBlur stdDeviation="38.6443"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.107828 0"/><feBlend mode="normal" in2="effect4_dropShadow_142_33476" result="effect5_dropShadow_142_33476"/><feBlend mode="normal" in="SourceGraphic" in2="effect5_dropShadow_142_33476" result="shape"/></filter><clipPath id="clip0_142_33476"><rect x="59.9766" y="41.748" width="269" height="178" rx="3.60697" transform="rotate(-2 59.9766 41.748)" fill="white"/></clipPath><clipPath id="clip1_142_33476"><rect width="269" height="131.473" fill="white" transform="translate(59.9766 41.748) rotate(-2)"/></clipPath><clipPath id="clip2_142_33476"><rect width="40" height="40" fill="white" transform="translate(219.971 114.255) rotate(-22)"/></clipPath></defs></svg>', 'demoUrl' => 'https://smashballoon.com/youtube-feed/demo/?utm_campaign=youtube-free&utm_source=feed-type&utm_medium=youtube-feed&utm_content=view-demo', 'buyUrl' => $this->get_extension_popup_dynamic_buy_url($license_key), 'bullets' => ['heading' => __('And get much more!', 'feeds-for-youtube'), 'content' => [__('Covert videos to WP Posts', 'feeds-for-youtube'), __('Show subscribers', 'feeds-for-youtube'), __('Show video details', 'feeds-for-youtube'), __('Fast and Effective Support', 'feeds-for-youtube'), __('Always up to date', 'feeds-for-youtube'), __('30 Day Money Back Guarantee', 'feeds-for-youtube')]]],
            'advancedFilters' => ['heading' => __('Get Filters and Moderation with ', 'feeds-for-youtube') . $elite_text, 'description' => __('Take complete control of what videos show in the feed using keyword filters and specific video blocking.', 'feeds-for-youtube'), 'popupContentBtn' => '<div class="sbc-extpp-lite-btn">' . self::builder_svg_icons()['tag'] . __('Lite Feed Users get a 50% OFF', 'feeds-for-youtube') . '</div>', 'img' => '<svg width="396" height="264" viewBox="0 0 396 264" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_142_33498)"><g filter="url(#filter0_ddd_142_33498)"><rect x="139.98" y="52.5991" width="162.17" height="179.401" rx="3.96584" fill="white"/></g><path d="M156.197 174.881C157.549 174.847 161.569 174.786 166.84 174.819C173.428 174.86 173.428 174.912 179.002 174.881C184.577 174.85 185.591 174.789 199.274 174.85C212.957 174.912 210.423 174.912 217.518 174.881C224.613 174.85 225.626 174.835 238.803 174.881C249.344 174.918 261.777 174.913 266.676 174.907" stroke="#DCDDE1" stroke-width="8.10851"/><path d="M156.197 194.559C157.549 194.53 161.569 194.478 166.84 194.506C173.428 194.542 173.428 194.586 179.002 194.559C184.577 194.533 184.07 194.506 197.753 194.559C211.437 194.612 210.423 194.6 218.025 194.593" stroke="#DCDDE1" stroke-width="8.10851"/><g clip-path="url(#clip1_142_33498)"><rect x="151.131" y="65.7754" width="139.912" height="88.1801" fill="#8C8F9A"/><circle cx="157.01" cy="165.713" r="48.2051" fill="#F37036"/><circle cx="295.745" cy="112.805" r="65.8411" fill="#DCDDE1"/></g><circle cx="291.509" cy="58.1738" r="18.7509" fill="#D72C2C"/><path d="M290.886 55.6399L293.028 57.7752V57.6671C293.028 57.1294 292.815 56.6138 292.435 56.2337C292.054 55.8535 291.539 55.6399 291.001 55.6399H290.886ZM287.981 56.1805L289.028 57.2279C288.994 57.3698 288.974 57.5117 288.974 57.6671C288.974 58.2047 289.188 58.7203 289.568 59.1005C289.948 59.4806 290.464 59.6942 291.001 59.6942C291.15 59.6942 291.298 59.6739 291.44 59.6401L292.488 60.6875C292.035 60.9105 291.535 61.0456 291.001 61.0456C290.105 61.0456 289.246 60.6897 288.612 60.0561C287.979 59.4225 287.623 58.5631 287.623 57.6671C287.623 57.1333 287.758 56.6332 287.981 56.1805ZM284.244 52.4438L285.785 53.9845L286.089 54.2885C284.974 55.167 284.095 56.3157 283.568 57.6671C284.737 60.6334 287.623 62.7349 291.001 62.7349C292.049 62.7349 293.049 62.5322 293.961 62.1673L294.251 62.4511L296.224 64.4242L297.083 63.566L285.102 51.5857L284.244 52.4438ZM291.001 54.2885C291.897 54.2885 292.757 54.6445 293.39 55.2781C294.024 55.9117 294.38 56.771 294.38 57.6671C294.38 58.0995 294.292 58.5185 294.136 58.8969L296.116 60.8767C297.13 60.0321 297.941 58.9239 298.434 57.6671C297.265 54.7007 294.38 52.5993 291.001 52.5993C290.055 52.5993 289.15 52.7682 288.298 53.0723L289.765 54.525C290.15 54.3764 290.562 54.2885 291.001 54.2885Z" fill="white"/><g filter="url(#filter1_ddd_142_33498)"><rect x="85.7402" y="31.9814" width="162.17" height="179.401" rx="3.96584" fill="white"/><path d="M101.957 154.263C103.308 154.229 107.329 154.169 112.599 154.201C119.188 154.242 119.188 154.294 124.762 154.263C130.337 154.232 131.35 154.171 145.034 154.232C158.717 154.294 156.183 154.294 163.278 154.263C170.373 154.232 171.386 154.217 184.562 154.263C195.104 154.3 207.537 154.295 212.436 154.289" stroke="#DCDDE1" stroke-width="8.10851"/><path d="M101.957 173.942C103.308 173.912 107.329 173.86 112.599 173.889C119.188 173.924 119.188 173.968 124.762 173.942C130.337 173.915 129.83 173.889 143.513 173.942C157.196 173.995 156.183 173.982 163.784 173.975" stroke="#DCDDE1" stroke-width="8.10851"/><g clip-path="url(#clip2_142_33498)"><rect x="96.8887" y="45.1577" width="139.912" height="88.1801" fill="#2C324C"/><circle cx="125.771" cy="71.4144" r="83.2083" fill="#0068A0"/><circle cx="256.9" cy="155.92" r="86.4368" fill="#E34F0E"/><rect x="154.59" y="76.7024" width="24.0633" height="25.9883" fill="#0068A0"/><path d="M160.366 99.8032L175.353 91.1404L160.366 82.4776V99.8032ZM193.747 77.1933C194.122 78.5505 194.382 80.3697 194.555 82.6797C194.758 84.9898 194.844 86.9823 194.844 88.7148L195.017 91.1404C195.017 97.4642 194.555 102.113 193.747 105.087C193.025 107.686 191.35 109.361 188.751 110.083C187.394 110.458 184.911 110.718 181.099 110.892C177.345 111.094 173.909 111.18 170.733 111.18L166.142 111.354C154.043 111.354 146.506 110.891 143.532 110.083C140.933 109.361 139.258 107.686 138.536 105.087C138.161 103.73 137.901 101.911 137.728 99.601C137.526 97.2909 137.439 95.2985 137.439 93.566L137.266 91.1404C137.266 84.8166 137.728 80.1675 138.536 77.1933C139.258 74.5945 140.933 72.9197 143.532 72.1978C144.889 71.8224 147.372 71.5625 151.184 71.3893C154.938 71.1871 158.374 71.1005 161.55 71.1005L166.142 70.9272C178.241 70.9272 185.777 71.3893 188.751 72.1978C191.35 72.9197 193.025 74.5945 193.747 77.1933Z" fill="white"/></g></g><circle cx="234.382" cy="30.7509" r="18.7509" fill="#0096CC"/><g clip-path="url(#clip3_142_33498)"><path d="M233.874 28.2172C233.337 28.2172 232.821 28.4308 232.441 28.8109C232.061 29.1911 231.847 29.7067 231.847 30.2443C231.847 30.782 232.061 31.2976 232.441 31.6777C232.821 32.0579 233.337 32.2715 233.874 32.2715C234.412 32.2715 234.927 32.0579 235.308 31.6777C235.688 31.2976 235.901 30.782 235.901 30.2443C235.901 29.7067 235.688 29.1911 235.308 28.8109C234.927 28.4308 234.412 28.2172 233.874 28.2172ZM233.874 33.6229C232.978 33.6229 232.119 33.2669 231.485 32.6333C230.852 31.9997 230.496 31.1404 230.496 30.2443C230.496 29.3483 230.852 28.4889 231.485 27.8553C232.119 27.2217 232.978 26.8658 233.874 26.8658C234.77 26.8658 235.63 27.2217 236.263 27.8553C236.897 28.4889 237.253 29.3483 237.253 30.2443C237.253 31.1404 236.897 31.9997 236.263 32.6333C235.63 33.2669 234.77 33.6229 233.874 33.6229ZM233.874 25.1765C230.496 25.1765 227.61 27.278 226.441 30.2443C227.61 33.2107 230.496 35.3122 233.874 35.3122C237.253 35.3122 240.138 33.2107 241.307 30.2443C240.138 27.278 237.253 25.1765 233.874 25.1765Z" fill="white"/></g></g><defs><filter id="filter0_ddd_142_33498" x="114.203" y="38.7187" width="213.726" height="230.957" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="11.8975"/><feGaussianBlur stdDeviation="12.889"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33498"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1.98292"/><feGaussianBlur stdDeviation="1.98292"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/><feBlend mode="normal" in2="effect1_dropShadow_142_33498" result="effect2_dropShadow_142_33498"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="5.94876"/><feGaussianBlur stdDeviation="5.94876"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="effect2_dropShadow_142_33498" result="effect3_dropShadow_142_33498"/><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow_142_33498" result="shape"/></filter><filter id="filter1_ddd_142_33498" x="59.9623" y="18.101" width="213.726" height="230.957" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="11.8975"/><feGaussianBlur stdDeviation="12.889"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33498"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1.98292"/><feGaussianBlur stdDeviation="1.98292"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/><feBlend mode="normal" in2="effect1_dropShadow_142_33498" result="effect2_dropShadow_142_33498"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="5.94876"/><feGaussianBlur stdDeviation="5.94876"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="effect2_dropShadow_142_33498" result="effect3_dropShadow_142_33498"/><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow_142_33498" result="shape"/></filter><clipPath id="clip0_142_33498"><path d="M0 0H396V264H0V0Z" fill="white"/></clipPath><clipPath id="clip1_142_33498"><rect x="151.131" y="65.7754" width="139.912" height="88.1801" rx="2" fill="white"/></clipPath><clipPath id="clip2_142_33498"><rect x="96.8887" y="45.1577" width="139.912" height="88.1801" rx="2" fill="white"/></clipPath><clipPath id="clip3_142_33498"><rect width="16.217" height="16.217" fill="white" transform="translate(225.766 22.1357)"/></clipPath></defs></svg>', 'demoUrl' => 'https://smashballoon.com/youtube-feed/demo/?utm_campaign=youtube-free&utm_source=feed-type&utm_medium=youtube-feed&utm_content=view-demo', 'buyUrl' => $this->get_extension_popup_dynamic_buy_url($license_key), 'bullets' => ['heading' => __('And get much more!', 'feeds-for-youtube'), 'content' => [__('Covert videos to WP Posts', 'feeds-for-youtube'), __('Show subscribers', 'feeds-for-youtube'), __('Show video details', 'feeds-for-youtube'), __('Fast and Effective Support', 'feeds-for-youtube'), __('Always up to date', 'feeds-for-youtube'), __('30 Day Money Back Guarantee', 'feeds-for-youtube')]]],
            'feedTemplate' => ['heading' => $this->get_extension_popup_dynamic_heading('one-click templates!', $plus_text), 'description' => __('Quickly create and preview new feeds with pre-configured options based on popular feed types.', 'feeds-for-youtube'), 'popupContentBtn' => '<div class="sbc-extpp-lite-btn">' . self::builder_svg_icons()['tag'] . __('Lite Feed Users get a 50% OFF', 'feeds-for-youtube') . '</div>', 'img' => '<svg width="396" height="264" viewBox="0 0 396 264" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_142_33498)"><g filter="url(#filter0_ddd_142_33498)"><rect x="139.98" y="52.5991" width="162.17" height="179.401" rx="3.96584" fill="white"/></g><path d="M156.197 174.881C157.549 174.847 161.569 174.786 166.84 174.819C173.428 174.86 173.428 174.912 179.002 174.881C184.577 174.85 185.591 174.789 199.274 174.85C212.957 174.912 210.423 174.912 217.518 174.881C224.613 174.85 225.626 174.835 238.803 174.881C249.344 174.918 261.777 174.913 266.676 174.907" stroke="#DCDDE1" stroke-width="8.10851"/><path d="M156.197 194.559C157.549 194.53 161.569 194.478 166.84 194.506C173.428 194.542 173.428 194.586 179.002 194.559C184.577 194.533 184.07 194.506 197.753 194.559C211.437 194.612 210.423 194.6 218.025 194.593" stroke="#DCDDE1" stroke-width="8.10851"/><g clip-path="url(#clip1_142_33498)"><rect x="151.131" y="65.7754" width="139.912" height="88.1801" fill="#8C8F9A"/><circle cx="157.01" cy="165.713" r="48.2051" fill="#F37036"/><circle cx="295.745" cy="112.805" r="65.8411" fill="#DCDDE1"/></g><circle cx="291.509" cy="58.1738" r="18.7509" fill="#D72C2C"/><path d="M290.886 55.6399L293.028 57.7752V57.6671C293.028 57.1294 292.815 56.6138 292.435 56.2337C292.054 55.8535 291.539 55.6399 291.001 55.6399H290.886ZM287.981 56.1805L289.028 57.2279C288.994 57.3698 288.974 57.5117 288.974 57.6671C288.974 58.2047 289.188 58.7203 289.568 59.1005C289.948 59.4806 290.464 59.6942 291.001 59.6942C291.15 59.6942 291.298 59.6739 291.44 59.6401L292.488 60.6875C292.035 60.9105 291.535 61.0456 291.001 61.0456C290.105 61.0456 289.246 60.6897 288.612 60.0561C287.979 59.4225 287.623 58.5631 287.623 57.6671C287.623 57.1333 287.758 56.6332 287.981 56.1805ZM284.244 52.4438L285.785 53.9845L286.089 54.2885C284.974 55.167 284.095 56.3157 283.568 57.6671C284.737 60.6334 287.623 62.7349 291.001 62.7349C292.049 62.7349 293.049 62.5322 293.961 62.1673L294.251 62.4511L296.224 64.4242L297.083 63.566L285.102 51.5857L284.244 52.4438ZM291.001 54.2885C291.897 54.2885 292.757 54.6445 293.39 55.2781C294.024 55.9117 294.38 56.771 294.38 57.6671C294.38 58.0995 294.292 58.5185 294.136 58.8969L296.116 60.8767C297.13 60.0321 297.941 58.9239 298.434 57.6671C297.265 54.7007 294.38 52.5993 291.001 52.5993C290.055 52.5993 289.15 52.7682 288.298 53.0723L289.765 54.525C290.15 54.3764 290.562 54.2885 291.001 54.2885Z" fill="white"/><g filter="url(#filter1_ddd_142_33498)"><rect x="85.7402" y="31.9814" width="162.17" height="179.401" rx="3.96584" fill="white"/><path d="M101.957 154.263C103.308 154.229 107.329 154.169 112.599 154.201C119.188 154.242 119.188 154.294 124.762 154.263C130.337 154.232 131.35 154.171 145.034 154.232C158.717 154.294 156.183 154.294 163.278 154.263C170.373 154.232 171.386 154.217 184.562 154.263C195.104 154.3 207.537 154.295 212.436 154.289" stroke="#DCDDE1" stroke-width="8.10851"/><path d="M101.957 173.942C103.308 173.912 107.329 173.86 112.599 173.889C119.188 173.924 119.188 173.968 124.762 173.942C130.337 173.915 129.83 173.889 143.513 173.942C157.196 173.995 156.183 173.982 163.784 173.975" stroke="#DCDDE1" stroke-width="8.10851"/><g clip-path="url(#clip2_142_33498)"><rect x="96.8887" y="45.1577" width="139.912" height="88.1801" fill="#2C324C"/><circle cx="125.771" cy="71.4144" r="83.2083" fill="#0068A0"/><circle cx="256.9" cy="155.92" r="86.4368" fill="#E34F0E"/><rect x="154.59" y="76.7024" width="24.0633" height="25.9883" fill="#0068A0"/><path d="M160.366 99.8032L175.353 91.1404L160.366 82.4776V99.8032ZM193.747 77.1933C194.122 78.5505 194.382 80.3697 194.555 82.6797C194.758 84.9898 194.844 86.9823 194.844 88.7148L195.017 91.1404C195.017 97.4642 194.555 102.113 193.747 105.087C193.025 107.686 191.35 109.361 188.751 110.083C187.394 110.458 184.911 110.718 181.099 110.892C177.345 111.094 173.909 111.18 170.733 111.18L166.142 111.354C154.043 111.354 146.506 110.891 143.532 110.083C140.933 109.361 139.258 107.686 138.536 105.087C138.161 103.73 137.901 101.911 137.728 99.601C137.526 97.2909 137.439 95.2985 137.439 93.566L137.266 91.1404C137.266 84.8166 137.728 80.1675 138.536 77.1933C139.258 74.5945 140.933 72.9197 143.532 72.1978C144.889 71.8224 147.372 71.5625 151.184 71.3893C154.938 71.1871 158.374 71.1005 161.55 71.1005L166.142 70.9272C178.241 70.9272 185.777 71.3893 188.751 72.1978C191.35 72.9197 193.025 74.5945 193.747 77.1933Z" fill="white"/></g></g><circle cx="234.382" cy="30.7509" r="18.7509" fill="#0096CC"/><g clip-path="url(#clip3_142_33498)"><path d="M233.874 28.2172C233.337 28.2172 232.821 28.4308 232.441 28.8109C232.061 29.1911 231.847 29.7067 231.847 30.2443C231.847 30.782 232.061 31.2976 232.441 31.6777C232.821 32.0579 233.337 32.2715 233.874 32.2715C234.412 32.2715 234.927 32.0579 235.308 31.6777C235.688 31.2976 235.901 30.782 235.901 30.2443C235.901 29.7067 235.688 29.1911 235.308 28.8109C234.927 28.4308 234.412 28.2172 233.874 28.2172ZM233.874 33.6229C232.978 33.6229 232.119 33.2669 231.485 32.6333C230.852 31.9997 230.496 31.1404 230.496 30.2443C230.496 29.3483 230.852 28.4889 231.485 27.8553C232.119 27.2217 232.978 26.8658 233.874 26.8658C234.77 26.8658 235.63 27.2217 236.263 27.8553C236.897 28.4889 237.253 29.3483 237.253 30.2443C237.253 31.1404 236.897 31.9997 236.263 32.6333C235.63 33.2669 234.77 33.6229 233.874 33.6229ZM233.874 25.1765C230.496 25.1765 227.61 27.278 226.441 30.2443C227.61 33.2107 230.496 35.3122 233.874 35.3122C237.253 35.3122 240.138 33.2107 241.307 30.2443C240.138 27.278 237.253 25.1765 233.874 25.1765Z" fill="white"/></g></g><defs><filter id="filter0_ddd_142_33498" x="114.203" y="38.7187" width="213.726" height="230.957" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="11.8975"/><feGaussianBlur stdDeviation="12.889"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33498"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1.98292"/><feGaussianBlur stdDeviation="1.98292"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/><feBlend mode="normal" in2="effect1_dropShadow_142_33498" result="effect2_dropShadow_142_33498"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="5.94876"/><feGaussianBlur stdDeviation="5.94876"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="effect2_dropShadow_142_33498" result="effect3_dropShadow_142_33498"/><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow_142_33498" result="shape"/></filter><filter id="filter1_ddd_142_33498" x="59.9623" y="18.101" width="213.726" height="230.957" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="11.8975"/><feGaussianBlur stdDeviation="12.889"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_142_33498"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1.98292"/><feGaussianBlur stdDeviation="1.98292"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/><feBlend mode="normal" in2="effect1_dropShadow_142_33498" result="effect2_dropShadow_142_33498"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="5.94876"/><feGaussianBlur stdDeviation="5.94876"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="effect2_dropShadow_142_33498" result="effect3_dropShadow_142_33498"/><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow_142_33498" result="shape"/></filter><clipPath id="clip0_142_33498"><path d="M0 0H396V264H0V0Z" fill="white"/></clipPath><clipPath id="clip1_142_33498"><rect x="151.131" y="65.7754" width="139.912" height="88.1801" rx="2" fill="white"/></clipPath><clipPath id="clip2_142_33498"><rect x="96.8887" y="45.1577" width="139.912" height="88.1801" rx="2" fill="white"/></clipPath><clipPath id="clip3_142_33498"><rect width="16.217" height="16.217" fill="white" transform="translate(225.766 22.1357)"/></clipPath></defs></svg>', 'demoUrl' => 'https://smashballoon.com/youtube-feed/demo/?utm_campaign=youtube-free&utm_source=feed-type&utm_medium=youtube-feed&utm_content=view-demo', 'buyUrl' => $this->get_extension_popup_dynamic_buy_url($license_key), 'bullets' => ['heading' => __('And get much more!', 'feeds-for-youtube'), 'content' => [__('Covert videos to WP Posts', 'feeds-for-youtube'), __('Show subscribers', 'feeds-for-youtube'), __('Show video details', 'feeds-for-youtube'), __('Fast and Effective Support', 'feeds-for-youtube'), __('Always up to date', 'feeds-for-youtube'), __('30 Day Money Back Guarantee', 'feeds-for-youtube')]]],
        );
    }
    /**
     * Get dynamic heading for the extension popup depending on license state
     * 
     * @since 2.0.3
     */
    public function get_extension_popup_dynamic_heading($extension_title, $license_tier)
    {
        $title = '';
        if (!sby_is_pro()) {
            $title = sprintf(__('Upgrade to Pro to get %s', 'feeds-for-youtube'), $extension_title);
        } else if (sby_license_inactive_state()) {
            $title = sprintf(__('Activate your License to get %s', 'feeds-for-youtube'), $extension_title);
        } else if (sby_license_notices_active()) {
            $title = sprintf(__('Renew license to get %s', 'feeds-for-youtube'), $extension_title);
        } else {
            $title = sprintf(__('Upgrade to %1$s to get %2$s', 'feeds-for-youtube'), $license_tier, $extension_title);
        }
        return $title;
    }
    /**
     * Get dynamic upgrade/activate/renew URL depending on license state
     * 
     * @since 2.0.3
     */
    public function get_extension_popup_dynamic_buy_url($license_key)
    {
        if (sby_is_pro() && !empty(Util::get_license_key()) && Util::is_license_expired()) {
            return $this->license_service->get_renew_url();
        }
        return 'https://smashballoon.com/pricing/youtube-feed/?utm_campaign=youtube-free&utm_source=feed-type&utm_medium=playlist&utm_content=Upgrade';
    }
    /**
     * Get Generic text
     *
     * @return array
     *
     * @since 6.0
     */
    public static function get_generic_text()
    {
        $icons = self::builder_svg_icons();
        return array('done' => __('Done', 'feeds-for-youtube'), 'title' => __('Settings', 'feeds-for-youtube'), 'dashboard' => __('Dashboard', 'feeds-for-youtube'), 'addNew' => __('Add New', 'feeds-for-youtube'), 'addSource' => __('Add Source', 'feeds-for-youtube'), 'addAnotherSource' => __('Add another Source', 'feeds-for-youtube'), 'addSourceType' => __('Add Another Source Type', 'feeds-for-youtube'), 'previous' => __('Previous', 'feeds-for-youtube'), 'next' => __('Next', 'feeds-for-youtube'), 'finish' => __('Finish', 'feeds-for-youtube'), 'new' => __('New', 'feeds-for-youtube'), 'update' => __('Update', 'feeds-for-youtube'), 'upgrade' => __('Upgrade', 'feeds-for-youtube'), 'settings' => __('Settings', 'feeds-for-youtube'), 'back' => __('Back', 'feeds-for-youtube'), 'backAllFeeds' => __('Back to all feeds', 'feeds-for-youtube'), 'createFeed' => __('Create Feed', 'feeds-for-youtube'), 'add' => __('Add', 'feeds-for-youtube'), 'change' => __('Change', 'feeds-for-youtube'), 'getExtention' => __('Get Extension', 'feeds-for-youtube'), 'viewDemo' => __('View Demo', 'feeds-for-youtube'), 'includes' => __('Includes', 'feeds-for-youtube'), 'photos' => __('Photos', 'feeds-for-youtube'), 'photo' => __('Photo', 'feeds-for-youtube'), 'apply' => __('Apply', 'feeds-for-youtube'), 'copy' => __('Copy', 'feeds-for-youtube'), 'edit' => __('Edit', 'feeds-for-youtube'), 'duplicate' => __('Duplicate', 'feeds-for-youtube'), 'delete' => __('Delete', 'feeds-for-youtube'), 'remove' => __('Remove', 'feeds-for-youtube'), 'removeSource' => __('Remove Source', 'feeds-for-youtube'), 'shortcode' => __('Shortcode', 'feeds-for-youtube'), 'clickViewInstances' => __('Click to view Instances', 'feeds-for-youtube'), 'usedIn' => __('Used in', 'feeds-for-youtube'), 'place' => __('place', 'feeds-for-youtube'), 'places' => __('places', 'feeds-for-youtube'), 'item' => __('Item', 'feeds-for-youtube'), 'items' => __('Items', 'feeds-for-youtube'), 'learnMore' => __('Learn More', 'feeds-for-youtube'), 'location' => __('Location', 'feeds-for-youtube'), 'page' => __('Page', 'feeds-for-youtube'), 'copiedClipboard' => __('Copied to Clipboard', 'feeds-for-youtube'), 'feedImported' => __('Feed imported successfully', 'feeds-for-youtube'), 'failedToImportFeed' => __('Failed to import feed', 'feeds-for-youtube'), 'timeline' => __('Timeline', 'feeds-for-youtube'), 'help' => __('Help', 'feeds-for-youtube'), 'admin' => __('Admin', 'feeds-for-youtube'), 'member' => __('Member', 'feeds-for-youtube'), 'reset' => __('Reset', 'feeds-for-youtube'), 'preview' => __('Preview', 'feeds-for-youtube'), 'name' => __('Name', 'feeds-for-youtube'), 'id' => __('ID', 'feeds-for-youtube'), 'token' => __('Token', 'feeds-for-youtube'), 'confirm' => __('Confirm', 'feeds-for-youtube'), 'cancel' => __('Cancel', 'feeds-for-youtube'), 'clear' => __('Clear', 'feeds-for-youtube'), 'clearFeedCache' => __('Clear Feed Cache', 'feeds-for-youtube'), 'saveSettings' => __('Save Changes', 'feeds-for-youtube'), 'feedName' => __('Feed Name', 'feeds-for-youtube'), 'shortcodeText' => __('Shortcode', 'feeds-for-youtube'), 'general' => __('General', 'feeds-for-youtube'), 'feeds' => __('Feeds', 'feeds-for-youtube'), 'translation' => __('Translation', 'feeds-for-youtube'), 'advanced' => __('Advanced', 'feeds-for-youtube'), 'error' => __('Error:', 'feeds-for-youtube'), 'errorSource' => __('Source Invalid', 'feeds-for-youtube'), 'errorEncryption' => __('Encryption Error', 'feeds-for-youtube'), 'invalid' => __('Invalid', 'feeds-for-youtube'), 'reconnect' => __('Reconnect', 'feeds-for-youtube'), 'feed' => __('feed', 'feeds-for-youtube'), 'sourceNotUsedYet' => __('Source is not used yet', 'feeds-for-youtube'), 'addImage' => __('Add Image', 'feeds-for-youtube'), 'businessRequired' => __('Business Account required', 'feeds-for-youtube'), 'selectedPost' => __('Selected Post', 'feeds-for-youtube'), 'productLink' => __('Product Link', 'feeds-for-youtube'), 'enterProductLink' => __('Add your product URL here', 'feeds-for-youtube'), 'editSources' => __('Edit Sources', 'feeds-for-youtube'), 'moderateFeed' => __('Moderate your feed', 'feeds-for-youtube'), 'moderateFeedSaveExit' => __('Save and Exit', 'feeds-for-youtube'), 'moderationMode' => __('Moderation Mode', 'feeds-for-youtube'), 'moderationModeEnterPostId' => __('Or Enter Post IDs to hide manually', 'feeds-for-youtube'), 'moderationModeTextareaPlaceholder' => __('Add words here to hide any posts containing these words', 'feeds-for-youtube'), 'filtersAndModeration' => __('Filters & Moderation', 'feeds-for-youtube'), 'topRated' => __('Top Rated', 'feeds-for-youtube'), 'mostRecent' => __('Most recent', 'feeds-for-youtube'), 'moderationModePreview' => __('Moderation Mode Preview', 'feeds-for-youtube'), 'shoppableModePreview' => __('Shoppable Feed Preview', 'feeds-for-youtube'), 'feedTemplateAlert' => __('Changing a template might override your customizations', 'feeds-for-youtube'), 'tweakVideoStyles' => __('Tweak Video Styles', 'feeds-for-youtube'), 'changeVideoStyle' => __('Change video aspect ratio, show/hide elements and more.', 'feeds-for-youtube'), 'setVideoLink' => __('Set Custom Link for each video', 'feeds-for-youtube'), 'setVideoLinkDesc' => __('To set a link for each video individually, add the link and button text in the video description on YouTube in this format: </br> </br> {Link: Button Text https://my-site.com/buy-now/my-product/}', 'feeds-for-youtube'), 'licenseExpired' => __('License Expired', 'feeds-for-youtube'), 'licenseInactive' => __('Inactive', 'feeds-for-youtube'), 'renew' => __('Renew', 'feeds-for-youtube'), 'activateLicense' => __('Activate License', 'feeds-for-youtube'), 'recheckLicenseKey' => __('Re-check License Key', 'feeds-for-youtube'), 'licenseValid' => __('License Valid', 'feeds-for-youtube'), 'licenseExpired' => __('License Expired', 'feeds-for-youtube'), 'notification' => array('feedSaved' => array('type' => 'success', 'text' => __('Feed saved successfully', 'feeds-for-youtube')), 'feedSavedError' => array('type' => 'error', 'text' => __('Error saving Feed', 'feeds-for-youtube')), 'previewUpdated' => array('type' => 'success', 'text' => __('Preview updated successfully', 'feeds-for-youtube')), 'carouselLayoutUpdated' => array('type' => 'success', 'text' => __('Carousel updated successfully', 'feeds-for-youtube')), 'unkownError' => array('type' => 'error', 'text' => __('Unknown error occurred', 'feeds-for-youtube')), 'cacheCleared' => array('type' => 'success', 'text' => __('Feed cache cleared', 'feeds-for-youtube')), 'selectSourceError' => array('type' => 'error', 'text' => __('Please select a source for your feed', 'feeds-for-youtube')), 'commentCacheCleared' => array('type' => 'success', 'text' => __('Comment cache cleared', 'feeds-for-youtube')), 'licenseActivated' => array('type' => 'success', 'text' => __('License Successfully Activated', 'feeds-for-youtube')), 'licenseError' => array('type' => 'error', 'text' => __('Couldn\'t Activate License', 'feeds-for-youtube'))), 'install' => __('Install', 'feeds-for-youtube'), 'installed' => __('Installed', 'feeds-for-youtube'), 'activate' => __('Activate', 'feeds-for-youtube'), 'installedAndActivated' => __('Installed & Activated', 'feeds-for-youtube'), 'free' => __('Free', 'feeds-for-youtube'), 'invalidLicenseKey' => __('Invalid license key', 'feeds-for-youtube'), 'licenseActivated' => __('License activated', 'feeds-for-youtube'), 'licenseDeactivated' => __('License Deactivated', 'feeds-for-youtube'), 'carouselLayoutUpdated' => array('type' => 'success', 'text' => __('Carousel Layout updated', 'feeds-for-youtube')), 'getMoreFeatures' => __('Get more features with YouTube Feed Pro', 'feeds-for-youtube'), 'liteFeedUsers' => __('Lite Feed Users get 50% OFF', 'feeds-for-youtube'), 'tryDemo' => __('Try Demo', 'feeds-for-youtube'), 'displayImagesVideos' => __('Display images and videos in posts', 'feeds-for-youtube'), 'viewLikesShares' => __('View likes, shares and comments', 'feeds-for-youtube'), 'allFeedTypes' => __('All Feed Types: Photos, Albums, Events and more', 'feeds-for-youtube'), 'abilityToLoad' => __('Ability to “Load More” posts', 'feeds-for-youtube'), 'andMuchMore' => __('And Much More!', 'feeds-for-youtube'), 'ctaShowFeatures' => __('Show Features', 'feeds-for-youtube'), 'ctaHideFeatures' => __('Hide Features', 'feeds-for-youtube'), 'redirectLoading' => array('heading' => __('Redirecting to connect.smashballoon.com', 'feeds-for-youtube'), 'description' => __('You will be redirected to our app so you can connect your account in 5 seconds', 'feeds-for-youtube')), 'channelOrUsername' => __('Channel ID or Username', 'feeds-for-youtube'), 'playlistId' => __('Playlist ID', 'feeds-for-youtube'), 'searchTerm' => __('Search Term', 'feeds-for-youtube'), 'singleVideosId' => __('Single Video IDs', 'feeds-for-youtube'), 'ctaLive' => __('Show Live Streams', 'feeds-for-youtube'), 'ctaFeeds' => __('All Feed Types: Playlist, Favorites, Search', 'feeds-for-youtube'), 'ctaCustomActions' => __('Add custom actions to end of the video', 'feeds-for-youtube'), 'ctaConvertVideos' => __('Convert videos to Wordpress posts', 'feeds-for-youtube'), 'andMuchMore' => __('And Much More!', 'feeds-for-youtube'), 'sbyFreeCTAFeatures' => array(__('Add videos in a Carousel', 'feeds-for-youtube'), __('Show subscribers', 'feeds-for-youtube'), __('Show video details', 'feeds-for-youtube'), __('Fast and Effective Support', 'feeds-for-youtube'), __('Always up to date', 'feeds-for-youtube'), __('30 day money back guarantee', 'feeds-for-youtube')), 'sbyFeedCreated' => __('YouTube feed successfully created!', 'feeds-for-youtube'), 'onceDoneSWFeed' => __('Once you are done creating the YouTube feed, you can go back to Social plugin', 'feeds-for-youtube'), 'goToSocialWall' => __('Go to Social Wall', 'feeds-for-youtube'));
    }
    /**
     * Select Source Screen Text
     *
     * @return array
     *
     * @since 4.0
     */
    public static function select_source_screen_text()
    {
        return array('mainHeading' => __('Select one or more sources', 'feeds-for-youtube'), 'description' => __('Sources are Instagram accounts your feed will display content from', 'feeds-for-youtube'), 'emptySourceDescription' => __('Looks like you have not added any source.<br/>Use “Add Source” to add a new one.', 'feeds-for-youtube'), 'mainHashtagHeading' => __('Enter Public Hashtags', 'feeds-for-youtube'), 'hashtagDescription' => __('Add one or more hashtags separated by comma', 'feeds-for-youtube'), 'hashtagGetBy' => __('Fetch posts that are', 'feeds-for-youtube'), 'sourcesListPopup' => array('user' => array('mainHeading' => __('Add a source for Timeline', 'feeds-for-youtube'), 'description' => __('Select or add an account you want to display the timeline for', 'feeds-for-youtube')), 'tagged' => array('mainHeading' => __('Add a source for Mentions', 'feeds-for-youtube'), 'description' => __('Select or add an account you want to display the mentions for', 'feeds-for-youtube'))), 'perosnalAccountToolTipTxt' => array(__('Due to changes in Instagram’s new API, we can no<br/>
					longer get mentions for personal accounts. To<br/>
					enable this for your account, you will need to convert it to<br/>
					a Business account. Learn More', 'feeds-for-youtube')), 'groupsToolTip' => array(__('Due to Facebook limitations, it\'s not possible to display photo feeds from a Group, only a Page.', 'feeds-for-youtube')), 'updateHeading' => __('Update Source', 'feeds-for-youtube'), 'updateDescription' => __('Select a source from your connected Facebook Pages and Groups. Or, use "Add New" to connect a new one.', 'feeds-for-youtube'), 'updateFooter' => __('Add multiple Facebook Pages or Groups to a feed with our Multifeed extension', 'feeds-for-youtube'), 'noSources' => __('Please add a source in order to display a feed. Go to the "Settings" tab -> "Sources" section -> Click "Add New" to connect a source.', 'feeds-for-youtube'), 'multipleTypes' => array('user' => array('heading' => __('User Timeline', 'feeds-for-youtube'), 'icon' => 'user', 'description' => __('Connect an account to show posts for it.', 'feeds-for-youtube'), 'actionType' => 'addSource'), 'hashtag' => array('heading' => __('Hashtag', 'feeds-for-youtube'), 'icon' => 'hashtag', 'tooltip' => __('Add one or more hashtags separated by comma.', 'feeds-for-youtube'), 'businessRequired' => \true, 'actionType' => 'inputHashtags'), 'tagged' => array('heading' => __('Tagged', 'feeds-for-youtube'), 'icon' => 'mention', 'description' => __('Connect an account to show tagged posts. This does not give us any permission to manage your Instagram account.', 'feeds-for-youtube'), 'businessRequired' => \true, 'actionType' => 'addSource')), 'modal' => array('addNew' => __('Connect your YouTube Account', 'feeds-for-youtube'), 'selectSourceType' => __('Select Account Type', 'feeds-for-youtube'), 'connectAccount' => __('Connect an YouTube Account', 'feeds-for-youtube'), 'connectAccountDescription' => __('This does not give us permission to manage your YouTube account, it simply allows the plugin to see a list of them and retrieve their public content from the API.', 'feeds-for-youtube'), 'connect' => __('Connect', 'feeds-for-youtube'), 'enterEventToken' => __('Enter Events Access Token', 'feeds-for-youtube'), 'enterEventTokenDescription' => sprintf(__('Due to restrictions by Facebook, you need to create a Facebook app and then paste that app Access Token here. We have a guide to help you with just that, which you can read %1$shere%2$s', 'feeds-for-youtube'), '<a href="https://smashballoon.com/instagram-feed/page-token/" target="_blank" rel="noopener">', '</a>'), 'alreadyHave' => __('Already have a API Token and Access Key for your account?', 'feeds-for-youtube'), 'addManuallyLink' => __('Add Account Manually', 'feeds-for-youtube'), 'selectAccount' => __('Select an YouTube Account', 'feeds-for-youtube'), 'showing' => __('Showing', 'feeds-for-youtube'), 'facebook' => __('Facebook', 'feeds-for-youtube'), 'businesses' => __('Businesses', 'feeds-for-youtube'), 'groups' => __('Groups', 'feeds-for-youtube'), 'connectedTo' => __('connected to', 'feeds-for-youtube'), 'addManually' => __('Add a Source Manually', 'feeds-for-youtube'), 'addSource' => __('Add Source', 'feeds-for-youtube'), 'sourceType' => __('Source Type', 'feeds-for-youtube'), 'accountID' => __('Instagram Account ID', 'feeds-for-youtube'), 'fAccountID' => __('Instagram Account ID', 'feeds-for-youtube'), 'eventAccessToken' => __('Event Access Token', 'feeds-for-youtube'), 'enterID' => __('Enter ID', 'feeds-for-youtube'), 'accessToken' => __('Instagram Access Token', 'feeds-for-youtube'), 'enterToken' => __('Enter Token', 'feeds-for-youtube'), 'addApp' => __('Add Instagram App to your group', 'feeds-for-youtube'), 'addAppDetails' => __('To get posts from your group, Instagram requires the "Smash Balloon Plugin" app to be added in your group settings. Just follow the directions here:', 'feeds-for-youtube'), 'addAppSteps' => array(__('Go to your group settings page by ', 'feeds-for-youtube'), sprintf(__('Search for "Smash Balloon" and select our app %1$s(see screenshot)%2$s', 'feeds-for-youtube'), '<a href="JavaScript:void(0);" id="sbc-group-app-tooltip">', '<img class="sbc-group-app-screenshot sb-tr-1" src="' . trailingslashit(CUSTOMIZER_PLUGIN_URL) . 'assets/img/group-app.png" alt="Thumbnail Layout"></a>'), __('Click "Add" and you are done.', 'feeds-for-youtube')), 'alreadyExists' => __('Account already exists', 'feeds-for-youtube'), 'alreadyExistsExplanation' => __('The Instagram account you added is already connected as a “Business” account. Would you like to replace it with a “Personal“ account? (Note: Personal accounts cannot be used to display Mentions or Hashtag feeds.)', 'feeds-for-youtube'), 'replaceWithPersonal' => __('Replace with Personal', 'feeds-for-youtube'), 'notAdmin' => __('For groups you are not an administrator of', 'feeds-for-youtube'), 'disclaimerMentions' => __('Due to Instagram’s limitations, you need to connect a business account to display a Mentions timeline', 'feeds-for-youtube'), 'disclaimerHashtag' => __('Due to Instagram’s limitations, you need to connect a business account to display a Hashtag feed', 'feeds-for-youtube'), 'notSureToolTip' => __('Select "Personal" if displaying a regular feed of posts, as this can display feeds from either a Personal or Business account. For displaying a Hashtag or Tagged feed, you must have an Instagram Business account. If needed, you can convert a Personal account into a Business account by following the directions {link}here{link}.', 'feeds-for-youtube')), 'footer' => array('heading' => __('Add feeds for popular social platforms with <span>our other plugins</span>', 'feeds-for-youtube')), 'personal' => __('Personal', 'feeds-for-youtube'), 'business' => __('Business', 'feeds-for-youtube'), 'notSure' => __("I'm not sure", 'feeds-for-youtube'));
    }
    /**
     * For Other Platforms listed on the footer widget
     *
     * @return array
     *
     * @since 2.0
     */
    public static function builder_svg_icons()
    {
        $builder_svg_icons = array('blueRocketPremium' => '<svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.41971 14.7934L8.33305 12.2401C9.37971 11.8534 10.3597 11.3334 11.2664 10.7268L9.41971 14.7934ZM4.42638 8.33344L1.87305 7.24677L5.93971 5.4001C5.33305 6.30677 4.81305 7.28677 4.42638 8.33344ZM15.073 1.59344C15.073 1.59344 11.773 0.179436 7.99971 3.95344C6.53971 5.41344 5.66638 7.0201 5.09971 8.42677C4.91305 8.92677 5.03971 9.47344 5.40638 9.84677L6.82638 11.2601C7.19305 11.6334 7.73971 11.7534 8.23971 11.5668C9.91875 10.9266 11.4433 9.93825 12.713 8.66677C16.4864 4.89344 15.073 1.59344 15.073 1.59344ZM10.3597 6.30677C9.83971 5.78677 9.83971 4.9401 10.3597 4.4201C10.8797 3.9001 11.7264 3.9001 12.2464 4.4201C12.7597 4.9401 12.7664 5.78677 12.2464 6.30677C11.7264 6.82677 10.8797 6.82677 10.3597 6.30677ZM5.49317 14.0001L7.25305 12.2401C7.02638 12.1801 6.80638 12.0801 6.60638 11.9401L4.55317 14.0001H5.49317ZM2.6665 14.0001H3.6065L6.11971 11.4934L5.17305 10.5534L2.6665 13.0601V14.0001ZM2.6665 12.1134L4.72638 10.0601C4.58638 9.8601 4.48638 9.64677 4.42638 9.41344L2.6665 11.1734V12.1134Z" fill="#0068A0"/></svg>', 'youtube' => '<svg width="18" height="12" viewBox="0 0 18 12" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M7.33329 8.50008L11.6583 6.00008L7.33329 3.50008V8.50008ZM16.9666 1.97508C17.075 2.36675 17.15 2.89175 17.2 3.55841C17.2583 4.22508 17.2833 4.80008 17.2833 5.30008L17.3333 6.00008C17.3333 7.82508 17.2 9.16675 16.9666 10.0251C16.7583 10.7751 16.275 11.2584 15.525 11.4667C15.1333 11.5751 14.4166 11.6501 13.3166 11.7001C12.2333 11.7584 11.2416 11.7834 10.325 11.7834L8.99996 11.8334C5.50829 11.8334 3.33329 11.7001 2.47496 11.4667C1.72496 11.2584 1.24163 10.7751 1.03329 10.0251C0.924959 9.63342 0.849959 9.10842 0.799959 8.44175C0.741626 7.77508 0.716626 7.20008 0.716626 6.70008L0.666626 6.00008C0.666626 4.17508 0.799959 2.83342 1.03329 1.97508C1.24163 1.22508 1.72496 0.741748 2.47496 0.533415C2.86663 0.425081 3.58329 0.350081 4.68329 0.300081C5.76663 0.241748 6.75829 0.216748 7.67496 0.216748L8.99996 0.166748C12.4916 0.166748 14.6666 0.300081 15.525 0.533415C16.275 0.741748 16.7583 1.22508 16.9666 1.97508Z" fill="white"/></svg>', 'twitter' => '<svg viewBox="0 0 14 12" fill="none"><path d="M13.9735 1.50001C13.4602 1.73334 12.9069 1.88667 12.3335 1.96001C12.9202 1.60667 13.3735 1.04667 13.5869 0.373338C13.0335 0.706672 12.4202 0.940005 11.7735 1.07334C11.2469 0.500005 10.5069 0.166672 9.66686 0.166672C8.10019 0.166672 6.82019 1.44667 6.82019 3.02667C6.82019 3.25334 6.84686 3.47334 6.89352 3.68001C4.52019 3.56001 2.40686 2.42 1.00019 0.693338C0.753522 1.11334 0.613522 1.60667 0.613522 2.12667C0.613522 3.12 1.11352 4 1.88686 4.5C1.41352 4.5 0.973522 4.36667 0.586856 4.16667V4.18667C0.586856 5.57334 1.57352 6.73334 2.88019 6.99334C2.46067 7.10814 2.02025 7.12412 1.59352 7.04C1.77459 7.60832 2.12921 8.10561 2.60753 8.46196C3.08585 8.81831 3.66382 9.0158 4.26019 9.02667C3.24928 9.82696 1.99619 10.2595 0.706855 10.2533C0.480189 10.2533 0.253522 10.24 0.0268555 10.2133C1.29352 11.0267 2.80019 11.5 4.41352 11.5C9.66686 11.5 12.5535 7.14 12.5535 3.36C12.5535 3.23334 12.5535 3.11334 12.5469 2.98667C13.1069 2.58667 13.5869 2.08 13.9735 1.50001Z"/></svg>', 'instagram' => '<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9 4.50781C6.5 4.50781 4.50781 6.53906 4.50781 9C4.50781 11.5 6.5 13.4922 9 13.4922C11.4609 13.4922 13.4922 11.5 13.4922 9C13.4922 6.53906 11.4609 4.50781 9 4.50781ZM9 11.9297C7.39844 11.9297 6.07031 10.6406 6.07031 9C6.07031 7.39844 7.35938 6.10938 9 6.10938C10.6016 6.10938 11.8906 7.39844 11.8906 9C11.8906 10.6406 10.6016 11.9297 9 11.9297ZM14.7031 4.35156C14.7031 3.76562 14.2344 3.29688 13.6484 3.29688C13.0625 3.29688 12.5938 3.76562 12.5938 4.35156C12.5938 4.9375 13.0625 5.40625 13.6484 5.40625C14.2344 5.40625 14.7031 4.9375 14.7031 4.35156ZM17.6719 5.40625C17.5938 4 17.2812 2.75 16.2656 1.73438C15.25 0.71875 14 0.40625 12.5938 0.328125C11.1484 0.25 6.8125 0.25 5.36719 0.328125C3.96094 0.40625 2.75 0.71875 1.69531 1.73438C0.679688 2.75 0.367188 4 0.289062 5.40625C0.210938 6.85156 0.210938 11.1875 0.289062 12.6328C0.367188 16.0391 0.679688 15.25 1.69531 16.3047C2.75 17.3203 3.96094 17.6328 5.36719 17.7109C6.8125 17.7891 11.1484 17.7891 12.5938 17.7109C14 17.6328 15.25 17.3203 16.2656 16.3047C17.2812 15.25 17.5938 16.0391 17.6719 12.6328C17.75 11.1875 17.75 6.85156 17.6719 5.40625ZM15.7969 14.1562C15.5234 14.9375 14.8984 15.5234 14.1562 15.8359C12.9844 16.3047 10.25 16.1875 9 16.1875C7.71094 16.1875 4.97656 16.3047 3.84375 15.8359C3.0625 15.5234 2.47656 14.9375 2.16406 14.1562C1.69531 13.0234 1.8125 10.2891 1.8125 9C1.8125 7.75 1.69531 5.01562 2.16406 3.84375C2.47656 3.10156 3.0625 2.51562 3.84375 2.20312C4.97656 1.73438 7.71094 1.85156 9 1.85156C10.25 1.85156 12.9844 1.73438 14.1562 2.20312C14.8984 2.47656 15.4844 3.10156 15.7969 3.84375C16.2656 5.01562 16.1484 7.75 16.1484 9C16.1484 10.2891 16.2656 13.0234 15.7969 14.1562Z" fill="url(#paint0_linear)"/><defs><linearGradient id="paint0_linear" x1="6.46484" y1="33.7383" x2="43.3242" y2="-3.88672" gradientUnits="userSpaceOnUse"><stop stop-color="white"/><stop offset="0.147864" stop-color="#F6640E"/><stop offset="0.443974" stop-color="#BA03A7"/><stop offset="0.733337" stop-color="#6A01B9"/><stop offset="1" stop-color="#6B01B9"/></linearGradient></defs></svg>', 'facebook' => '<svg viewBox="0 0 14 15"><path d="M7.00016 0.860001C3.3335 0.860001 0.333496 3.85333 0.333496 7.54C0.333496 10.8733 2.7735 13.64 5.96016 14.14V9.47333H4.26683V7.54H5.96016V6.06667C5.96016 4.39333 6.9535 3.47333 8.48016 3.47333C9.20683 3.47333 9.96683 3.6 9.96683 3.6V5.24667H9.12683C8.30016 5.24667 8.04016 5.76 8.04016 6.28667V7.54H9.8935L9.5935 9.47333H8.04016V14.14C9.61112 13.8919 11.0416 13.0903 12.0734 11.88C13.1053 10.6697 13.6704 9.13043 13.6668 7.54C13.6668 3.85333 10.6668 0.860001 7.00016 0.860001Z"/></svg>', 'smash' => '<svg height="18" viewBox="0 0 28 36" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M27.2235 16.8291C27.2235 7.53469 21.1311 0 13.6131 0C6.09513 0 0 7.53469 0 16.8291C0 25.7393 5.5828 33.0095 12.6525 33.6193L11.9007 36L16.6147 35.599L14.9608 33.5775C21.8439 32.7422 27.2235 25.5639 27.2235 16.8291Z" fill="#FE544F"/><path fill-rule="evenodd" clip-rule="evenodd" d="M16.8586 5.91699L17.5137 12.6756L24.3006 12.8705L19.3911 17.4354L23.2687 23.044L16.7362 21.816L14.7557 28.3487L11.7488 22.4987L5.67719 25.2808L8.01283 19.0094L2.09131 16.0227L8.43013 13.9841L6.68099 7.73959L12.678 11.1585L16.8586 5.91699Z" fill="white"/></svg>', 'tag' => '<svg viewBox="0 0 18 18"><path d="M16.841 8.65033L9.34102 1.15033C9.02853 0.840392 8.60614 0.666642 8.16602 0.666993H2.33268C1.89066 0.666993 1.46673 0.842587 1.15417 1.15515C0.841611 1.46771 0.666016 1.89163 0.666016 2.33366V8.16699C0.665842 8.38692 0.709196 8.60471 0.79358 8.8078C0.877964 9.01089 1.00171 9.19528 1.15768 9.35033L8.65768 16.8503C8.97017 17.1603 9.39256 17.334 9.83268 17.3337C10.274 17.3318 10.6966 17.155 11.0077 16.842L16.841 11.0087C17.154 10.6975 17.3308 10.275 17.3327 9.83366C17.3329 9.61373 17.2895 9.39595 17.2051 9.19285C17.1207 8.98976 16.997 8.80538 16.841 8.65033ZM9.83268 15.667L2.33268 8.16699V2.33366H8.16602L15.666 9.83366L9.83268 15.667ZM4.41602 3.16699C4.66324 3.16699 4.90492 3.2403 5.11048 3.37766C5.31604 3.51501 5.47626 3.71023 5.57087 3.93864C5.66548 4.16705 5.69023 4.41838 5.642 4.66086C5.59377 4.90333 5.47472 5.12606 5.2999 5.30088C5.12508 5.47569 4.90236 5.59474 4.65988 5.64297C4.4174 5.69121 4.16607 5.66645 3.93766 5.57184C3.70925 5.47723 3.51403 5.31702 3.37668 5.11146C3.23933 4.90589 3.16602 4.66422 3.16602 4.41699C3.16602 6.08547 3.29771 3.76753 3.53213 3.53311C3.76655 3.29869 6.0845 3.16699 4.41602 3.16699Z"/></svg>', 'copy' => '<svg viewBox="0 0 12 13" fill="none"><path d="M10.25 0.25H4.625C3.9375 0.25 3.375 0.8125 3.375 1.5V9C3.375 9.6875 3.9375 10.25 4.625 10.25H10.25C10.9375 10.25 11.5 9.6875 11.5 9V1.5C11.5 0.8125 10.9375 0.25 10.25 0.25ZM10.25 9H4.625V1.5H10.25V9ZM0.875 8.375V7.125H2.125V8.375H0.875ZM0.875 4.9375H2.125V6.1875H0.875V4.9375ZM5.25 11.5H6.5V12.75H5.25V11.5ZM0.875 10.5625V9.3125H2.125V10.5625H0.875ZM2.125 12.75C1.4375 12.75 0.875 12.1875 0.875 11.5H2.125V12.75ZM4.3125 12.75H3.0625V11.5H4.3125V12.75ZM7.4375 12.75V11.5H8.6875C8.6875 12.1875 8.125 12.75 7.4375 12.75ZM2.125 2.75V4H0.875C0.875 3.3125 1.4375 2.75 2.125 2.75Z"/></svg>', 'duplicate' => '<svg viewBox="0 0 10 12" fill="none"><path d="M6.99997 0.5H0.999969C0.449969 0.5 -3.05176e-05 0.95 -3.05176e-05 1.5V8.5H0.999969V1.5H6.99997V0.5ZM8.49997 2.5H2.99997C2.44997 2.5 1.99997 2.95 1.99997 3.5V10.5C1.99997 11.05 2.44997 11.5 2.99997 11.5H8.49997C9.04997 11.5 9.49997 11.05 9.49997 10.5V3.5C9.49997 2.95 9.04997 2.5 8.49997 2.5ZM8.49997 10.5H2.99997V3.5H8.49997V10.5Z"/></svg>', 'edit' => '<svg width="11" height="12" viewBox="0 0 11 12" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0.25 9.06241V11.2499H2.4375L8.88917 4.79824L6.70167 2.61074L0.25 9.06241ZM10.9892 2.69824L8.80167 0.510742L7.32583 1.99241L9.51333 4.17991L10.9892 2.69824Z" fill="currentColor"/></svg>', 'delete' => '<svg viewBox="0 0 10 12" fill="none"><path d="M1.00001 10.6667C1.00001 11.4 1.60001 12 2.33334 12H7.66668C8.40001 12 9.00001 11.4 9.00001 10.6667V2.66667H1.00001V10.6667ZM2.33334 4H7.66668V10.6667H2.33334V4ZM7.33334 0.666667L6.66668 0H3.33334L2.66668 0.666667H0.333344V2H9.66668V0.666667H7.33334Z"/></svg>', 'checkmark' => '<svg width="11" height="9"><path fill-rule="evenodd" clip-rule="evenodd" d="M4.15641 5.65271L9.72487 0.0842487L10.9623 1.32169L4.15641 8.12759L0.444097 4.41528L1.68153 3.17784L4.15641 5.65271Z"/></svg>', 'checkmarklarge' => '<svg width="16" height="12" viewBox="0 0 16 12" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M6.08058 8.36133L16.0355 0.406383L15.8033 2.17415L6.08058 11.8969L0.777281 6.59357L2.54505 4.8258L6.08058 8.36133Z" fill="currentColor"></path></svg>', 'information' => '<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.3335 5H7.66683V3.66667H6.3335V5ZM7.00016 12.3333C4.06016 12.3333 1.66683 9.94 1.66683 7C1.66683 4.06 4.06016 1.66667 7.00016 1.66667C9.94016 1.66667 12.3335 4.06 12.3335 7C12.3335 9.94 9.94016 12.3333 7.00016 12.3333ZM7.00016 0.333332C6.12468 0.333332 5.25778 0.505771 4.44894 0.840802C3.6401 1.17583 2.90517 1.6669 2.28612 2.28595C1.03588 3.5362 0.333496 5.23189 0.333496 7C0.333496 8.76811 1.03588 10.4638 2.28612 11.714C2.90517 12.3331 3.6401 12.8242 4.44894 13.1592C5.25778 13.4942 6.12468 13.6667 7.00016 13.6667C8.76827 13.6667 10.464 12.9643 11.7142 11.714C12.9645 10.4638 13.6668 8.76811 13.6668 7C13.6668 6.12452 13.4944 5.25761 13.1594 4.44878C12.8243 3.63994 12.3333 2.90501 11.7142 2.28595C11.0952 1.6669 10.3602 1.17583 9.55139 0.840802C8.74255 0.505771 7.87564 0.333332 7.00016 0.333332ZM6.3335 10.3333H7.66683V6.33333H6.3335V10.3333Z" fill="#141B38"/></svg>', 'cog' => '<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.99989 9.33334C6.38105 9.33334 5.78756 9.0875 5.34998 8.64992C4.91239 8.21233 4.66656 7.61884 4.66656 7C4.66656 6.38117 4.91239 5.78767 5.34998 5.35009C5.78756 4.9125 6.38105 4.66667 6.99989 4.66667C7.61873 4.66667 8.21222 4.9125 8.64981 5.35009C9.08739 5.78767 9.33323 6.38117 9.33323 7C9.33323 7.61884 9.08739 8.21233 8.64981 8.64992C8.21222 9.0875 7.61873 9.33334 6.99989 9.33334ZM11.9532 7.64667C11.9799 7.43334 11.9999 7.22 11.9999 7C11.9999 6.78 11.9799 6.56 11.9532 6.33334L13.3599 5.24667C13.4866 5.14667 13.5199 4.96667 13.4399 4.82L12.1066 2.51334C12.0266 2.36667 11.8466 2.30667 11.6999 2.36667L10.0399 3.03334C9.69323 2.77334 9.33323 2.54667 8.91323 2.38L8.66656 0.613337C8.65302 0.534815 8.61212 0.463622 8.5511 0.412371C8.49009 0.361121 8.41291 0.333123 8.33323 0.333337H5.66656C5.49989 0.333337 5.35989 0.453337 5.33323 0.613337L5.08656 2.38C4.66656 2.54667 4.30656 2.77334 3.95989 3.03334L2.29989 2.36667C2.15323 2.30667 1.97323 2.36667 1.89323 2.51334L0.559893 4.82C0.473226 4.96667 0.513226 5.14667 0.639893 5.24667L2.04656 6.33334C2.01989 6.56 1.99989 6.78 1.99989 7C1.99989 7.22 2.01989 7.43334 2.04656 7.64667L0.639893 8.75334C0.513226 8.85334 0.473226 9.03334 0.559893 9.18L1.89323 11.4867C1.97323 11.6333 2.15323 11.6867 2.29989 11.6333L3.95989 10.96C4.30656 11.2267 4.66656 11.4533 5.08656 11.62L5.33323 13.3867C5.35989 13.5467 5.49989 13.6667 5.66656 13.6667H8.33323C8.49989 13.6667 8.63989 13.5467 8.66656 13.3867L8.91323 11.62C9.33323 11.4467 9.69323 11.2267 10.0399 10.96L11.6999 11.6333C11.8466 11.6867 12.0266 11.6333 12.1066 11.4867L13.4399 9.18C13.5199 9.03334 13.4866 8.85334 13.3599 8.75334L11.9532 7.64667Z" fill="#141B38"/></svg>', 'angleUp' => '<svg width="8" height="6" viewBox="0 0 8 6" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0.94 5.27325L4 2.21992L7.06 5.27325L8 4.33325L4 0.333252L0 4.33325L0.94 5.27325Z" fill="#434960"/></svg>', 'user_check' => '<svg viewBox="0 0 11 9"><path d="M9.55 4.25L10.25 4.955L6.985 8.25L5.25 6.5L5.95 5.795L6.985 6.835L9.55 4.25ZM4 6.5L5.5 8H0.5V7C0.5 5.895 2.29 5 4.5 5L5.445 5.055L4 6.5ZM4.5 0C5.03043 0 5.53914 0.210714 5.91421 0.585786C6.28929 0.960859 6.5 1.46957 6.5 2C6.5 2.53043 6.28929 3.03914 5.91421 3.41421C5.53914 3.78929 5.03043 4 4.5 4C3.96957 4 3.46086 3.78929 3.08579 3.41421C2.71071 3.03914 2.5 2.53043 2.5 2C2.5 1.46957 2.71071 0.960859 3.08579 0.585786C3.46086 0.210714 3.96957 0 4.5 0Z"/></svg>', 'users' => '<svg viewBox="0 0 12 8"><path d="M6 0.75C6.46413 0.75 6.90925 0.934375 7.23744 1.26256C7.56563 1.59075 7.75 2.03587 7.75 2.5C7.75 2.96413 7.56563 3.40925 7.23744 3.73744C6.90925 6.06563 6.46413 4.25 6 4.25C5.53587 4.25 5.09075 6.06563 4.76256 3.73744C4.43437 3.40925 4.25 2.96413 4.25 2.5C4.25 2.03587 4.43437 1.59075 4.76256 1.26256C5.09075 0.934375 5.53587 0.75 6 0.75ZM2.5 2C2.78 2 3.04 2.075 3.265 2.21C3.19 2.925 3.4 3.635 3.83 4.19C3.58 4.67 3.08 5 2.5 5C2.10218 5 1.72064 4.84196 1.43934 4.56066C1.15804 4.27936 1 3.89782 1 3.5C1 3.10218 1.15804 2.72064 1.43934 2.43934C1.72064 2.15804 2.10218 2 2.5 2ZM9.5 2C9.89782 2 10.2794 2.15804 10.5607 2.43934C10.842 2.72064 11 3.10218 11 3.5C11 3.89782 10.842 4.27936 10.5607 4.56066C10.2794 4.84196 9.89782 5 9.5 5C8.92 5 8.42 4.67 8.17 4.19C8.60594 3.62721 8.80828 2.9181 8.735 2.21C8.96 2.075 9.22 2 9.5 2ZM2.75 7.125C2.75 6.09 4.205 5.25 6 5.25C7.795 5.25 9.25 6.09 9.25 7.125V8H2.75V7.125ZM0 8V7.25C0 6.555 0.945 5.97 2.225 5.8C1.93 6.14 1.75 6.61 1.75 7.125V8H0ZM12 8H10.25V7.125C10.25 6.61 10.07 6.14 9.775 5.8C11.055 5.97 12 6.555 12 7.25V8Z"/></svg>', 'info' => '<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.3335 5H7.66683V3.66667H6.3335V5ZM7.00016 12.3333C4.06016 12.3333 1.66683 9.94 1.66683 7C1.66683 4.06 4.06016 1.66667 7.00016 1.66667C9.94016 1.66667 12.3335 4.06 12.3335 7C12.3335 9.94 9.94016 12.3333 7.00016 12.3333ZM7.00016 0.333332C6.12468 0.333332 5.25778 0.505771 4.44894 0.840802C3.6401 1.17583 2.90517 1.6669 2.28612 2.28595C1.03588 3.5362 0.333496 5.23189 0.333496 7C0.333496 8.76811 1.03588 10.4638 2.28612 11.714C2.90517 12.3331 3.6401 12.8242 4.44894 13.1592C5.25778 13.4942 6.12468 13.6667 7.00016 13.6667C8.76827 13.6667 10.464 12.9643 11.7142 11.714C12.9645 10.4638 13.6668 8.76811 13.6668 7C13.6668 6.12452 13.4944 5.25761 13.1594 4.44878C12.8243 3.63994 12.3333 2.90501 11.7142 2.28595C11.0952 1.6669 10.3602 1.17583 9.55139 0.840802C8.74255 0.505771 7.87564 0.333332 7.00016 0.333332ZM6.3335 10.3333H7.66683V6.33333H6.3335V10.3333Z" fill="#141B38"/></svg>', 'list' => '<svg viewBox="0 0 14 12"><path d="M0.332031 7.33341H4.33203V11.3334H0.332031V7.33341ZM9.66537 3.33341H5.66536V4.66675H9.66537V3.33341ZM0.332031 4.66675H4.33203V0.666748H0.332031V4.66675ZM5.66536 0.666748V2.00008H13.6654V0.666748H5.66536ZM5.66536 11.3334H9.66537V10.0001H5.66536V11.3334ZM5.66536 8.66675H13.6654V7.33341H5.66536"/></svg>', 'gallery' => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M2.625 9.375V3.625H13.375V9.375H2.625Z" stroke="#434960" stroke-width="1.25"/><rect x="11" y="11" width="3" height="2" rx="0.25" fill="#434960"/><path d="M6.5 11.25C6.5 11.1119 6.61193 11 6.75 11H9.25C9.38807 11 9.5 11.1119 9.5 11.25V12.75C9.5 12.8881 9.38807 13 9.25 13H6.75C6.61193 13 6.5 12.8881 6.5 12.75V11.25Z" fill="#434960"/><rect x="2" y="11" width="3" height="2" rx="0.25" fill="#434960"/></svg>', 'grid' => '<svg viewBox="0 0 12 12"><path d="M0 5.33333H5.33333V0H0V5.33333ZM0 12H5.33333V6.66667H0V12ZM6.66667 12H12V6.66667H6.66667V12ZM6.66667 0V5.33333H12V0"/></svg>', 'masonry' => '<svg viewBox="0 0 16 16"><rect x="3" y="3" width="4.5" height="5" /><rect x="3" y="9" width="4.5" height="5" /><path d="M8.5 2H13V7H8.5V2Z" /><rect x="8.5" y="8" width="4.5" height="5" /></svg>', 'carousel' => '<svg viewBox="0 0 14 11"><path d="M0.332031 2.00008H2.9987V9.33342H0.332031V2.00008ZM3.66536 10.6667H10.332V0.666748H3.66536V10.6667ZM4.9987 2.00008H8.9987V9.33342H4.9987V2.00008ZM10.9987 2.00008H13.6654V9.33342H10.9987V2.00008Z"/></svg>', 'highlight' => '<svg viewBox="0 0 16 16" fill="none"><rect x="2" y="2" width="8" height="8" fill="#434960"/><rect x="11" y="2" width="3" height="3" fill="#434960"/><rect x="11" y="6" width="3" height="4" fill="#434960"/><rect x="7" y="11" width="7" height="3" fill="#434960"/><rect x="2" y="11" width="4" height="3" fill="#434960"/></svg>', 'desktop' => '<svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M13.9998 9.66667H1.99984V1.66667H13.9998V9.66667ZM13.9998 0.333336H1.99984C1.25984 0.333336 0.666504 0.926669 0.666504 1.66667V9.66667C0.666504 10.0203 0.80698 10.3594 1.05703 10.6095C1.30708 10.8595 1.64622 11 1.99984 11H6.6665V12.3333H5.33317V13.6667H10.6665V12.3333H9.33317V11H13.9998C14.3535 11 14.6926 10.8595 14.9426 10.6095C15.1927 10.3594 15.3332 10.0203 15.3332 9.66667V1.66667C15.3332 1.31305 15.1927 0.973909 14.9426 0.72386C14.6926 0.473812 14.3535 0.333336 13.9998 0.333336Z" fill="#141B38"/></svg>', 'tablet' => '<svg width="12" height="16" viewBox="0 0 12 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M10.0013 2.66659V13.3333H2.0013L2.0013 2.66659H10.0013ZM0.667969 1.99992L0.667969 13.9999C0.667969 14.7399 1.2613 15.3333 2.0013 15.3333H10.0013C10.3549 15.3333 10.6941 15.1928 10.9441 14.9427C11.1942 14.6927 11.3346 14.3535 11.3346 13.9999V1.99992C11.3346 1.6463 11.1942 1.30716 10.9441 1.05711C10.6941 0.807062 10.3549 0.666586 10.0013 0.666586H2.0013C1.64768 0.666586 1.30854 0.807062 1.05849 1.05711C0.808444 1.30716 0.667969 1.6463 0.667969 1.99992Z" fill="#141B38"/></svg>', 'mobile' => '<svg width="10" height="16" viewBox="0 0 10 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M8.33203 12.6667H1.66536V3.33341H8.33203V12.6667ZM8.33203 0.666748H1.66536C0.925365 0.666748 0.332031 1.26008 0.332031 2.00008V16.0001C0.332031 14.3537 0.472507 14.6928 0.722555 14.9429C0.972604 15.1929 1.31174 15.3334 1.66536 15.3334H8.33203C8.68565 15.3334 9.02479 15.1929 9.27484 14.9429C9.52489 14.6928 9.66537 14.3537 9.66537 16.0001V2.00008C9.66537 1.64646 9.52489 1.30732 9.27484 1.05727C9.02479 0.807224 8.68565 0.666748 8.33203 0.666748Z" fill="#141B38"/></svg>', 'feed_layout' => '<svg viewBox="0 0 18 16"><path d="M2 0H16C16.5304 0 17.0391 0.210714 17.4142 0.585786C17.7893 0.960859 18 1.46957 18 2V14C18 14.5304 17.7893 15.0391 17.4142 15.4142C17.0391 15.7893 16.5304 16 16 16H2C1.46957 16 0.960859 15.7893 0.585786 15.4142C0.210714 15.0391 0 14.5304 0 14V2C0 1.46957 0.210714 0.960859 0.585786 0.585786C0.960859 0.210714 1.46957 0 2 0ZM2 4V8H8V4H2ZM10 4V8H16V4H10ZM2 10V14H8V10H2ZM10 10V14H16V10H10Z"/></svg>', 'feed_template' => '<svg viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16 0H2C0.9 0 0 0.9 0 2V16C0 17.1 0.9 18 2 18H16C17.1 18 18 17.1 18 16V2C18 0.9 17.1 0 16 0ZM2 16V2H8V16H2ZM16 16H10V9H16V16ZM16 7H10V2H16V7Z" fill="#141B38"/></svg>', 'color_scheme' => '<svg viewBox="0 0 18 18"><path d="M14.5 9C14.1022 9 13.7206 8.84196 13.4393 8.56066C13.158 8.27936 13 7.89782 13 7.5C13 7.10218 13.158 6.72064 13.4393 6.43934C13.7206 6.15804 14.1022 6 14.5 6C14.8978 6 15.2794 6.15804 15.5607 6.43934C15.842 6.72064 16 7.10218 16 7.5C16 7.89782 15.842 8.27936 15.5607 8.56066C15.2794 8.84196 14.8978 9 14.5 9ZM11.5 5C11.1022 5 10.7206 4.84196 10.4393 4.56066C10.158 4.27936 10 3.89782 10 3.5C10 3.10218 10.158 2.72064 10.4393 2.43934C10.7206 2.15804 11.1022 2 11.5 2C11.8978 2 12.2794 2.15804 12.5607 2.43934C12.842 2.72064 13 3.10218 13 3.5C13 3.89782 12.842 4.27936 12.5607 4.56066C12.2794 4.84196 11.8978 5 11.5 5ZM6.5 5C6.10218 5 5.72064 4.84196 5.43934 4.56066C5.15804 4.27936 5 3.89782 5 3.5C5 3.10218 5.15804 2.72064 5.43934 2.43934C5.72064 2.15804 6.10218 2 6.5 2C6.89782 2 7.27936 2.15804 7.56066 2.43934C7.84196 2.72064 8 3.10218 8 3.5C8 3.89782 7.84196 4.27936 7.56066 4.56066C7.27936 4.84196 6.89782 5 6.5 5ZM3.5 9C3.10218 9 2.72064 8.84196 2.43934 8.56066C2.15804 8.27936 2 7.89782 2 7.5C2 7.10218 2.15804 6.72064 2.43934 6.43934C2.72064 6.15804 3.10218 6 3.5 6C3.89782 6 4.27936 6.15804 4.56066 6.43934C4.84196 6.72064 5 7.10218 5 7.5C5 7.89782 4.84196 8.27936 4.56066 8.56066C4.27936 8.84196 3.89782 9 3.5 9ZM9 0C6.61305 0 4.32387 0.948211 2.63604 2.63604C0.948211 4.32387 0 6.61305 0 9C0 11.3869 0.948211 13.6761 2.63604 15.364C4.32387 17.0518 6.61305 18 9 18C9.39782 18 9.77936 17.842 10.0607 17.5607C10.342 17.2794 10.5 16.8978 10.5 16.5C10.5 16.11 10.35 15.76 10.11 15.5C9.88 15.23 9.73 14.88 9.73 14.5C9.73 14.1022 9.88804 13.7206 10.1693 13.4393C10.4506 13.158 10.8322 13 11.23 13H13C14.3261 13 15.5979 12.4732 16.5355 11.5355C17.4732 10.5979 18 9.32608 18 8C18 3.58 13.97 0 9 0Z"/></svg>', 'header' => '<svg viewBox="0 0 20 13"><path d="M1.375 0.625C0.960787 0.625 0.625 0.960786 0.625 1.375V11.5H2.875V2.875H17.125V9.625H11.5V11.875H18.625C19.0392 11.875 19.375 11.5392 19.375 11.125V1.375C19.375 0.960786 19.0392 0.625 18.625 0.625H1.375Z"/><path d="M4.375 7C4.16789 7 4 7.16789 4 7.375V12.625C4 12.8321 4.16789 13 4.375 13H9.625C9.83211 13 10 12.8321 10 12.625V7.375C10 7.16789 9.83211 7 9.625 7H4.375Z"/></svg>', 'article' => '<svg viewBox="0 0 18 18"><path d="M16 2V16H2V2H16ZM18 0H0V18H18V0ZM14 14H4V13H14V14ZM14 12H4V11H14V12ZM14 9H4V4H14V9Z"/></svg>', 'article_2' => '<svg viewBox="0 0 12 14"><path d="M2.0013 0.333496C1.64768 0.333496 1.30854 0.473972 1.05849 0.72402C0.808444 0.974069 0.667969 1.31321 0.667969 1.66683V12.3335C0.667969 12.6871 0.808444 13.0263 1.05849 13.2763C1.30854 13.5264 1.64768 13.6668 2.0013 13.6668H10.0013C10.3549 13.6668 10.6941 13.5264 10.9441 13.2763C11.1942 13.0263 11.3346 12.6871 11.3346 12.3335V4.3335L7.33463 0.333496H2.0013ZM2.0013 1.66683H6.66797V5.00016H10.0013V12.3335H2.0013V1.66683ZM3.33464 7.00016V8.3335H8.66797V7.00016H3.33464ZM3.33464 9.66683V11.0002H6.66797V9.66683H3.33464Z"/></svg>', 'videos' => '<svg width="20" height="14" viewBox="0 0 20 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M8 10L13.19 7L8 4V10ZM19.56 2.17C19.69 2.64 19.78 3.27 19.84 4.07C19.91 4.87 19.94 5.56 19.94 6.16L20 7C20 9.19 19.84 10.8 19.56 11.83C19.31 12.73 18.73 13.31 17.83 13.56C17.36 13.69 16.5 13.78 15.18 13.84C13.88 13.91 12.69 13.94 11.59 13.94L10 14C5.81 14 3.2 13.84 2.17 13.56C1.27 13.31 0.69 12.73 0.44 11.83C0.31 11.36 0.22 10.73 0.16 9.93C0.0900001 9.13 0.0599999 8.44 0.0599999 7.84L0 7C0 4.81 0.16 3.2 0.44 2.17C0.69 1.27 1.27 0.69 2.17 0.44C2.64 0.31 3.5 0.22 4.82 0.16C6.12 0.0899998 7.31 0.0599999 8.41 0.0599999L10 0C14.19 0 16.8 0.16 17.83 0.44C18.73 0.69 19.31 1.27 19.56 2.17Z" fill="#141B38"/></svg>', 'like_box' => '<svg viewBox="0 0 18 17"><path d="M17.505 7.91114C17.505 7.48908 17.3373 7.08431 17.0389 6.78587C16.7405 6.48744 16.3357 6.31977 15.9136 6.31977H10.8849L11.6488 2.68351C11.6647 2.60394 11.6727 2.51641 11.6727 2.42889C11.6727 2.10266 11.5374 1.8003 11.3226 1.58547L10.4791 0.75L5.24354 5.98559C4.94914 6.27999 4.77409 6.67783 4.77409 7.11546V15.0723C4.77409 15.4943 4.94175 15.8991 5.24019 16.1975C5.53863 16.496 5.9434 16.6636 6.36546 16.6636H13.5266C14.187 16.6636 14.7519 16.2658 14.9906 15.6929L17.3936 10.0834C17.4652 9.90034 17.505 9.70938 17.505 9.5025V7.91114ZM0 16.6636H3.18273V7.11546H0V16.6636Z"/></svg>', 'load_more' => '<svg viewBox="0 0 24 24"><path d="M20 18.5H4C3.46957 18.5 2.96086 18.2893 2.58579 17.9142C2.21071 17.5391 2 17.0304 2 16.5V7.5C2 6.96957 2.21071 6.46086 2.58579 6.08579C2.96086 5.71071 3.46957 5.5 4 5.5H20C20.5304 5.5 21.0391 5.71071 21.4142 6.08579C21.7893 6.46086 22 6.96957 22 7.5V16.5C22 17.0304 21.7893 17.5391 21.4142 17.9142C21.0391 18.2893 20.5304 18.5 20 18.5ZM4 7.5V16.5H20V7.5H4Z"/><circle cx="7.5" cy="12" r="1.5"/><circle cx="12" cy="12" r="1.5"/><circle cx="16.5" cy="12" r="1.5"/></svg>', 'subscribe' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20 18.5H4C3.46957 18.5 2.96086 18.2893 2.58579 17.9142C2.21071 17.5391 2 17.0304 2 16.5V7.5C2 6.96957 2.21071 6.46086 2.58579 6.08579C2.96086 5.71071 3.46957 5.5 4 5.5H20C20.5304 5.5 21.0391 5.71071 21.4142 6.08579C21.7893 6.46086 22 6.96957 22 7.5V16.5C22 17.0304 21.7893 17.5391 21.4142 17.9142C21.0391 18.2893 20.5304 18.5 20 18.5ZM4 7.5V16.5H20V7.5H4Z" fill="#141B38"/><path d="M9 13.75C9 13.1977 9.44772 12.75 10 12.75H14C14.5523 12.75 15 13.1977 15 13.75V15H9V13.75Z" fill="#141B38"/><path d="M13.5 10.5C13.5 11.3284 12.8284 12 12 12C11.1716 12 10.5 11.3284 10.5 10.5C10.5 9.67157 11.1716 9 12 9C12.8284 9 13.5 9.67157 13.5 10.5Z" fill="#141B38"/></svg>', 'lightbox' => '<svg viewBox="0 0 24 24"><path d="M21 17H7V3H21V17ZM21 1H7C6.46957 1 5.96086 1.21071 5.58579 1.58579C5.21071 1.96086 5 2.46957 5 3V17C5 17.5304 5.21071 18.0391 5.58579 18.4142C5.96086 18.7893 6.46957 19 7 19H21C21.5304 19 22.0391 18.7893 22.4142 18.4142C22.7893 18.0391 23 17.5304 23 17V3C23 2.46957 22.7893 1.96086 22.4142 1.58579C22.0391 1.21071 21.5304 1 21 1ZM3 5H1V21C1 21.5304 1.21071 22.0391 1.58579 22.4142C1.96086 22.7893 2.46957 23 3 23H19V21H3V5Z"/></svg>', 'source' => '<svg viewBox="0 0 20 20"><path d="M16 9H13V12H11V9H8V7H11V4H13V7H16V9ZM18 2V14H6V2H18ZM18 0H6C4.9 0 4 0.9 4 2V14C4 14.5304 4.21071 15.0391 4.58579 15.4142C4.96086 15.7893 5.46957 16 6 16H18C19.11 16 20 15.11 20 14V2C20 1.46957 19.7893 0.960859 19.4142 0.585786C19.0391 0.210714 18.5304 0 18 0ZM2 4H0V18C0 18.5304 0.210714 19.0391 0.585786 19.4142C0.960859 19.7893 1.46957 20 2 20H16V18H2V4Z"/></svg>', 'filter' => '<svg viewBox="0 0 18 12"><path d="M3 7H15V5H3V7ZM0 0V2H18V0H0ZM7 12H11V10H7V12Z"/></svg>', 'update' => '<svg width="20" height="14" viewBox="0 0 20 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M15.8335 3.66665L12.5002 6.99998H15.0002C15.0002 8.32606 14.4734 9.59783 13.5357 10.5355C12.598 11.4732 11.3262 12 10.0002 12C9.16683 12 8.3585 11.7916 7.66683 11.4166L6.45016 12.6333C7.51107 13.3085 8.74261 13.667 10.0002 13.6666C11.7683 13.6666 13.464 12.9643 14.7142 11.714C15.9644 10.4638 16.6668 8.76809 16.6668 6.99998H19.1668L15.8335 3.66665ZM5.00016 6.99998C5.00016 5.6739 5.52695 4.40213 6.46463 3.46445C7.40231 2.52676 8.67408 1.99998 10.0002 1.99998C10.8335 1.99998 11.6418 2.20831 12.3335 2.58331L13.5502 1.36665C12.4893 0.69144 11.2577 0.332963 10.0002 0.333313C8.23205 0.333313 6.53636 1.03569 5.28612 2.28593C4.03587 3.53618 3.3335 5.23187 3.3335 6.99998H0.833496L4.16683 10.3333L7.50016 6.99998" fill="currentColor"/></svg>', 'sun' => '<svg viewBox="0 0 16 15"><path d="M2.36797 12.36L3.30797 13.3L4.50797 12.1067L3.5613 11.16L2.36797 12.36ZM7.33463 14.9667H8.66797V13H7.33463V14.9667ZM8.0013 3.6667C6.94044 3.6667 5.92302 6.08813 5.17287 4.83827C4.42273 5.58842 6.0013 6.60583 6.0013 7.6667C6.0013 8.72756 4.42273 9.74498 5.17287 10.4951C5.92302 11.2453 6.94044 11.6667 8.0013 11.6667C9.06217 11.6667 10.0796 11.2453 10.8297 10.4951C11.5799 9.74498 12.0013 8.72756 12.0013 7.6667C12.0013 5.45336 10.208 3.6667 8.0013 3.6667ZM13.3346 8.33336H15.3346V7.00003H13.3346V8.33336ZM11.4946 12.1067L12.6946 13.3L13.6346 12.36L12.4413 11.16L11.4946 12.1067ZM13.6346 2.97337L12.6946 2.03337L11.4946 3.2267L12.4413 4.17336L13.6346 2.97337ZM8.66797 0.366699H7.33463V2.33337H8.66797V0.366699ZM2.66797 7.00003H0.667969V8.33336H2.66797V7.00003ZM4.50797 3.2267L3.30797 2.03337L2.36797 2.97337L3.5613 4.17336L4.50797 3.2267Z"/></svg>', 'timesSVG' => '<svg  width="14" height="14" fill="none" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!-- Font Awesome Pro 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) --><path fill="#fff" d="M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm121.6 313.1c4.7 4.7 4.7 12.3 0 17L338 377.6c-4.7 4.7-12.3 4.7-17 0L256 312l-65.1 65.6c-4.7 4.7-12.3 4.7-17 0L134.4 338c-4.7-4.7-4.7-12.3 0-17l65.6-65-65.6-65.1c-4.7-4.7-4.7-12.3 0-17l39.6-39.6c4.7-4.7 12.3-4.7 17 0l65 65.7 65.1-65.6c4.7-4.7 12.3-4.7 17 0l39.6 39.6c4.7 4.7 4.7 12.3 0 17L312 256l65.6 65.1z"/></svg>', 'checkmarkCircleSVG' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!-- Font Awesome Pro 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) --><path d="M504 256c0 136.967-111.033 248-248 248S8 392.967 8 256 119.033 8 256 8s248 111.033 248 248zM227.314 387.314l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.249-16.379-6.249-22.628 0L216 308.118l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.249 16.379 6.249 22.628.001z"/></svg>', 'moon' => '<svg viewBox="0 0 10 10"><path fill-rule="evenodd" clip-rule="evenodd" d="M9.63326 6.88308C9.26754 6.95968 8.88847 6.99996 8.5 6.99996C5.46243 6.99996 3 4.53752 3 1.49996C3 1.11148 3.04028 0.732413 3.11688 0.366699C1.28879 1.11045 0 2.9047 0 4.99996C0 7.76138 2.23858 9.99996 5 9.99996C7.09526 9.99996 8.88951 8.71117 9.63326 6.88308Z"/></svg>', 'visual' => '<svg viewBox="0 0 12 12"><path d="M3.66667 7L5.33333 9L7.66667 6L10.6667 10H1.33333L3.66667 7ZM12 10.6667V1.33333C12 0.979711 11.8595 0.640573 11.6095 0.390524C11.3594 0.140476 11.0203 0 10.6667 0H1.33333C0.979711 0 0.640573 0.140476 0.390524 0.390524C0.140476 0.640573 0 0.979711 0 1.33333V10.6667C0 11.0203 0.140476 11.3594 0.390524 11.6095C0.640573 11.8595 0.979711 12 1.33333 12H10.6667C11.0203 12 11.3594 11.8595 11.6095 11.6095C11.8595 11.3594 12 11.0203 12 10.6667Z" /></svg>', 'text' => '<svg viewBox="0 0 14 12"><path d="M12.332 11.3334H1.66536C1.31174 11.3334 0.972604 11.1929 0.722555 10.9429C0.472507 10.6928 0.332031 10.3537 0.332031 10.0001V2.00008C0.332031 1.64646 0.472507 1.30732 0.722555 1.05727C0.972604 0.807224 1.31174 0.666748 1.66536 0.666748H12.332C12.6857 0.666748 13.0248 0.807224 13.2748 1.05727C13.5249 1.30732 13.6654 1.64646 13.6654 2.00008V10.0001C13.6654 10.3537 13.5249 10.6928 13.2748 10.9429C13.0248 11.1929 12.6857 11.3334 12.332 11.3334ZM1.66536 2.00008V10.0001H12.332V2.00008H1.66536ZM2.9987 6.00008H10.9987V5.33341H2.9987V6.00008ZM2.9987 6.66675H9.66537V8.00008H2.9987V6.66675Z"/></svg>', 'background' => '<svg viewBox="0 0 14 12"><path d="M12.334 11.3334H1.66732C1.3137 11.3334 0.974557 11.1929 0.724509 10.9429C0.47446 10.6928 0.333984 10.3537 0.333984 10.0001V2.00008C0.333984 1.64646 0.47446 1.30732 0.724509 1.05727C0.974557 0.807224 1.3137 0.666748 1.66732 0.666748H12.334C12.6876 0.666748 13.0267 0.807224 13.2768 1.05727C13.5268 1.30732 13.6673 1.64646 13.6673 2.00008V10.0001C13.6673 10.3537 13.5268 10.6928 13.2768 10.9429C13.0267 11.1929 12.6876 11.3334 12.334 11.3334Z"/></svg>', 'cursor' => '<svg width="22" height="23" viewBox="0 0 22 23" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3.27319 0.929678C1.93768 1.41577 1.23799 2.91624 1.72408 4.25176L5.21476 13.8423L4.47888 13.4776L4.2112 13.3737C3.59599 13.0885 2.89287 13.0586 2.25566 13.2905C1.61846 13.5224 1.09906 13.9973 0.811108 14.6112C0.525904 15.2264 0.495991 15.9295 0.727914 16.5667C0.959838 17.2039 1.43471 17.7233 2.04864 18.0113L2.0578 18.0365L11.0971 22.1882L11.1566 22.195L11.2004 22.237C12.691 22.6974 14.291 22.6595 15.7582 22.1292L17.1546 21.6209C18.0287 21.3048 18.8318 20.8192 19.5177 20.1919C20.2036 19.5647 20.7589 18.8081 21.1517 17.9657C21.5445 17.1232 21.767 16.2115 21.8065 15.2829C21.846 14.3542 21.7017 13.4269 21.3818 12.5542L19.0734 6.21186C18.5873 4.87634 17.086 4.17696 15.7513 4.66275C15.4055 4.78863 15.1202 5.00004 14.8699 5.24193C14.2194 4.28343 12.9691 3.83656 11.8366 4.24878C11.2147 4.47512 10.7326 4.92642 10.4436 5.47383C9.85221 5.22987 9.19122 5.21452 8.58912 5.43075C8.31296 5.5352 8.05705 5.68683 7.8328 5.87888L6.59527 2.47879C6.10918 1.14327 4.60871 0.44359 3.27319 0.929678ZM3.86418 2.55341C4.31477 2.38941 4.80754 2.61919 4.97154 3.06978L8.22198 12.0003L9.84571 11.4093L8.66373 8.16184C8.49974 7.71126 8.72952 7.21848 9.18011 7.05448C9.63069 6.89048 10.1235 7.12027 10.2875 7.57085L11.4694 10.8183L13.0932 10.2273L11.9112 6.97987C11.7472 6.52928 11.977 6.0365 12.4276 5.87251C12.8782 5.70851 13.3709 5.93829 13.5349 6.38888L14.7169 9.63633L16.4169 9.01757L15.826 7.39384C15.662 6.94325 15.8917 6.45048 16.3423 6.28648C16.7921 6.12278 17.2857 6.35227 17.4497 6.80285L19.7584 13.146C20.782 15.9583 19.3759 18.9736 16.5628 19.9975L15.168 20.5051C13.9786 20.938 12.7963 20.8875 11.7096 20.5567L2.77436 16.4535C2.28158 16.2238 2.13827 15.83 2.36805 15.3372C2.59865 14.8442 2.99159 14.7011 3.48437 14.9309L8.26041 17.158L3.34781 3.66077C3.18381 3.21018 3.4136 2.71741 3.86418 2.55341Z" fill="#141B38"/></svg>', 'link' => '<svg viewBox="0 0 14 8"><path d="M1.60065 6.00008C1.60065 2.86008 2.52732 1.93341 3.66732 1.93341H6.33399V0.666748H3.66732C2.78326 0.666748 1.93542 1.01794 1.3103 1.64306C0.685174 2.26818 0.333984 3.11603 0.333984 6.00008C0.333984 4.88414 0.685174 5.73198 1.3103 6.35711C1.93542 6.98223 2.78326 7.33342 3.66732 7.33342H6.33399V6.06675H3.66732C2.52732 6.06675 1.60065 5.14008 1.60065 6.00008ZM4.33398 4.66675H9.66732V3.33342H4.33398V4.66675ZM10.334 0.666748H7.66732V1.93341H10.334C11.474 1.93341 12.4007 2.86008 12.4007 6.00008C12.4007 5.14008 11.474 6.06675 10.334 6.06675H7.66732V7.33342H10.334C11.218 7.33342 12.0659 6.98223 12.691 6.35711C13.3161 5.73198 13.6673 4.88414 13.6673 6.00008C13.6673 3.11603 13.3161 2.26818 12.691 1.64306C12.0659 1.01794 11.218 0.666748 10.334 0.666748Z"/></svg>', 'thumbnail' => '<svg viewBox="0 0 14 12"><path d="M0.332031 7.33333H4.33203V11.3333H0.332031V7.33333ZM9.66537 3.33333H5.66536V4.66666H9.66537V3.33333ZM0.332031 4.66666H4.33203V0.666664H0.332031V4.66666ZM5.66536 0.666664V2H13.6654V0.666664H5.66536ZM5.66536 11.3333H9.66537V10H5.66536V11.3333ZM5.66536 8.66666H13.6654V7.33333H5.66536"/></svg>', 'halfwidth' => '<svg viewBox="0 0 14 8"><path d="M6 0.5H0V7.5H6V0.5Z"/><path d="M14 0.75H7.5V2H14V0.75Z"/><path d="M7.5 3.25H14V4.5H7.5V3.25Z"/><path d="M11 5.75H7.5V7H11V5.75Z"/></svg>', 'fullwidth' => '<svg viewBox="0 0 10 12"><path fill-rule="evenodd" clip-rule="evenodd" d="M10 6.75V0.333328H0V6.75H10Z"/><path d="M0 8.24999H10V9.49999H0V8.24999Z"/><path d="M6 10.75H0V12H6V10.75Z"/></svg>', 'boxed' => '<svg viewBox="0 0 16 16"><path d="M14.1667 12.8905H1.83333C1.47971 12.8905 1.14057 12.75 0.890524 12.5C0.640476 12.25 0.5 11.9108 0.5 11.5572V3.33333C0.5 2.97971 0.640476 2.64057 0.890524 2.39052C1.14057 2.14048 1.47971 2 1.83333 2H14.1667C14.5203 2 14.8594 2.14048 15.1095 2.39052C15.3595 2.64057 15.5 2.97971 15.5 3.33333V11.5572C15.5 11.9108 15.3595 12.25 15.1095 12.5C14.8594 12.75 14.5203 12.8905 14.1667 12.8905ZM1.83333 3.33333V11.5572H14.1667V3.33333H1.83333Z"/><path d="M8 8H11V9H8V8Z"/><path d="M6.5 9.5H3V5.5H6.5V9.5Z"/><path d="M8 7V6H13V7H8Z"/></svg>', 'corner' => '<svg viewBox="0 0 12 12"><path fill-rule="evenodd" clip-rule="evenodd" d="M5 1.5H1.5V10.5H10.5V7C10.5 3.96243 8.03757 1.5 5 1.5ZM0 0V12H12V7C12 3.13401 8.86599 0 5 0H0Z"/></svg>', 'preview' => '<svg viewBox="0 0 16 10"><path d="M8.0013 3C7.47087 3 6.96216 3.21071 6.58709 3.58579C6.21202 3.96086 6.0013 4.46957 6.0013 5C6.0013 5.53043 6.21202 6.03914 6.58709 6.41421C6.96216 6.78929 7.47087 7 8.0013 7C8.53173 7 9.04044 6.78929 9.41551 6.41421C9.79059 6.03914 10.0013 5.53043 10.0013 5C10.0013 4.46957 9.79059 3.96086 9.41551 3.58579C9.04044 3.21071 8.53173 3 8.0013 3ZM8.0013 8.33333C7.11725 8.33333 6.2694 7.98214 5.64428 7.35702C5.01916 6.7319 4.66797 5.88406 4.66797 5C4.66797 4.11595 5.01916 3.2681 5.64428 2.64298C6.2694 2.01786 7.11725 1.66667 8.0013 1.66667C8.88536 1.66667 9.7332 2.01786 10.3583 2.64298C10.9834 3.2681 11.3346 4.11595 11.3346 5C11.3346 5.88406 10.9834 6.7319 10.3583 7.35702C9.7332 7.98214 8.88536 8.33333 8.0013 8.33333ZM8.0013 0C4.66797 0 1.8213 2.07333 0.667969 5C1.8213 7.92667 4.66797 10 8.0013 10C11.3346 10 14.1813 7.92667 15.3346 5C14.1813 2.07333 11.3346 0 8.0013 0Z"/></svg>', 'flag' => '<svg viewBox="0 0 9 9"><path d="M5.53203 1L5.33203 0H0.832031V8.5H1.83203V5H4.63203L4.83203 6H8.33203V1H5.53203Z"/></svg>', 'copy2' => '<svg viewBox="0 0 12 13"><path d="M10.25 0.25H4.625C3.9375 0.25 3.375 0.8125 3.375 1.5V9C3.375 9.6875 3.9375 10.25 4.625 10.25H10.25C10.9375 10.25 11.5 9.6875 11.5 9V1.5C11.5 0.8125 10.9375 0.25 10.25 0.25ZM10.25 9H4.625V1.5H10.25V9ZM0.875 8.375V7.125H2.125V8.375H0.875ZM0.875 4.9375H2.125V6.1875H0.875V4.9375ZM5.25 11.5H6.5V12.75H5.25V11.5ZM0.875 10.5625V9.3125H2.125V10.5625H0.875ZM2.125 12.75C1.4375 12.75 0.875 12.1875 0.875 11.5H2.125V12.75ZM4.3125 12.75H3.0625V11.5H4.3125V12.75ZM7.4375 12.75V11.5H8.6875C8.6875 12.1875 8.125 12.75 7.4375 12.75ZM2.125 2.75V4H0.875C0.875 3.3125 1.4375 2.75 2.125 2.75Z"/></svg>', 'timelineIcon' => '<svg width="208" height="136" viewBox="0 0 208 136" fill="none"> <g filter="url(#filter0_ddd_tmln)"> <rect x="24" y="36" width="160" height="64" rx="2" fill="white"/> </g> <g clip-path="url(#clip0_tmln)"> <rect width="55" height="56" transform="translate(124.8 40)" fill="#F9BBA0"/> <circle cx="200.3" cy="102.5" r="55.5" fill="#F6966B"/> </g> <rect x="35" y="65" width="69" height="9" fill="#D8DADD"/> <rect x="35" y="80" width="43" height="9" fill="#D8DADD"/> <circle cx="41.5" cy="50.5" r="6.5" fill="#D8DADD"/> <defs> <filter id="filter0_ddd_tmln" x="11" y="29" width="186" height="90" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dy="6"/> <feGaussianBlur stdDeviation="6.5"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dy="1"/> <feGaussianBlur stdDeviation="1"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dy="3"/> <feGaussianBlur stdDeviation="3"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> <clipPath id="clip0_tmln"> <rect width="55" height="56" fill="white" transform="translate(124.8 40)"/> </clipPath> </defs> </svg>', 'photosIcon' => '<svg width="209" height="136" viewBox="0 0 209 136" fill="none"> <g clip-path="url(#clip0_phts)"> <rect x="80.2002" y="44" width="48" height="48" fill="#43A6DB"/> <circle cx="70.7002" cy="78.5" r="40.5" fill="#86D0F9"/> </g> <g clip-path="url(#clip1_phts)"> <rect x="131.2" y="44" width="48" height="48" fill="#B6DDAD"/> <rect x="152.2" y="65" width="33" height="33" fill="#96CE89"/> </g> <g clip-path="url(#clip2_phts)"> <rect x="29.2002" y="44" width="48" height="48" fill="#F6966B"/> <path d="M38.6485 61L76.6485 99H7.2002L38.6485 61Z" fill="#F9BBA0"/> </g> <defs> <clipPath id="clip0_phts"> <rect x="80.2002" y="44" width="48" height="48" rx="1" fill="white"/> </clipPath> <clipPath id="clip1_phts"> <rect x="131.2" y="44" width="48" height="48" rx="1" fill="white"/> </clipPath> <clipPath id="clip2_phts"> <rect x="29.2002" y="44" width="48" height="48" rx="1" fill="white"/> </clipPath> </defs> </svg>', 'videosIcon' => '<svg width="209" height="136" viewBox="0 0 209 136" fill="none"> <rect x="41.6001" y="31" width="126" height="74" fill="#43A6DB"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M104.6 81C111.78 81 117.6 75.1797 117.6 68C117.6 60.8203 111.78 55 104.6 55C97.4204 55 91.6001 60.8203 91.6001 68C91.6001 75.1797 97.4204 81 104.6 81ZM102.348 63.2846C102.015 63.0942 101.6 63.3349 101.6 63.7188V72.2813C101.6 72.6652 102.015 72.9059 102.348 72.7154L109.84 68.4342C110.176 68.2422 110.176 67.7579 109.84 67.5659L102.348 63.2846Z" fill="white"/> </svg>', 'albumsIcon' => '<svg width="210" height="136" viewBox="0 0 210 136" fill="none"> <g clip-path="url(#clip0_albm)"> <rect x="76.1187" y="39.7202" width="57.7627" height="57.7627" fill="#43A6DB"/> <rect x="101.39" y="64.9917" width="39.7119" height="39.7119" fill="#86D0F9"/> </g> <g clip-path="url(#clip1_albm)"> <rect x="70.1016" y="32.5" width="57.7627" height="57.7627" fill="#F9BBA0"/> <path d="M81.4715 52.9575L127.2 98.6863H43.627L81.4715 52.9575Z" fill="#F6966B"/> </g> <defs> <clipPath id="clip0_albm"> <rect x="76.1187" y="39.7202" width="57.7627" height="57.7627" rx="1.20339" fill="white"/> </clipPath> <clipPath id="clip1_albm"> <rect x="70.1016" y="32.5" width="57.7627" height="57.7627" rx="1.20339" fill="white"/> </clipPath> </defs> </svg>', 'eventsIcon' => '<svg width="209" height="136" viewBox="0 0 209 136" fill="none"> <g filter="url(#filter0_ddd_evt)"> <rect x="20.5562" y="39.9375" width="160" height="64" rx="2" fill="white"/> </g> <rect x="31.6001" y="69" width="102" height="9" fill="#D8DADD"/> <rect x="31.6001" y="84" width="64" height="9" fill="#D8DADD"/> <circle cx="38.0562" cy="54.4375" r="6.5" fill="#D8DADD"/> <circle cx="173.744" cy="46.5625" r="14.5" fill="#FE544F"/> <path d="M169.275 53.5L173.775 50.875L178.275 53.5V42.625C178.275 42.0156 177.759 41.5 177.15 41.5H170.4C169.767 41.5 169.275 42.0156 169.275 42.625V53.5Z" fill="white"/> <defs> <filter id="filter0_ddd_evt" x="7.55615" y="32.9375" width="186" height="90" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dy="6"/> <feGaussianBlur stdDeviation="6.5"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dy="1"/> <feGaussianBlur stdDeviation="1"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dy="3"/> <feGaussianBlur stdDeviation="3"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> </defs> </svg>', 'reviewsIcon' => '<svg width="207" height="129" viewBox="0 0 207 129" fill="none"> <g filter="url(#filter0_ddd_rev)"> <rect x="23.5" y="32.5" width="160" height="64" rx="2" fill="white"/> </g> <path d="M61.0044 42.8004C61.048 42.6917 61.202 42.6917 61.2456 42.8004L62.7757 46.6105C62.7942 46.6568 62.8377 46.6884 62.8875 46.6917L66.9839 46.9695C67.1008 46.9774 67.1484 47.1238 67.0584 47.199L63.9077 49.8315C63.8694 49.8635 63.8528 49.9145 63.8649 49.9629L64.8666 53.9447C64.8952 56.0583 64.7707 54.1488 64.6714 56.0865L61.1941 51.9034C61.1519 51.8769 61.0981 51.8769 61.0559 51.9034L57.5786 56.0865C57.4793 54.1488 57.3548 56.0583 57.3834 53.9447L58.3851 49.9629C58.3972 49.9145 58.3806 49.8635 58.3423 49.8315L55.1916 47.199C55.1016 47.1238 55.1492 46.9774 55.2661 46.9695L59.3625 46.6917C59.4123 46.6884 59.4558 46.6568 59.4743 46.6105L61.0044 42.8004Z" fill="#FE544F"/> <path d="M76.6045 42.8004C76.6481 42.6917 76.8021 42.6917 76.8457 42.8004L78.3757 46.6105C78.3943 46.6568 78.4378 46.6884 78.4876 46.6917L82.584 46.9695C82.7009 46.9774 82.7485 47.1238 82.6585 47.199L79.5078 49.8315C79.4695 49.8635 79.4529 49.9145 79.465 49.9629L80.4667 53.9447C80.4953 56.0583 80.3708 54.1488 80.2715 56.0865L76.7942 51.9034C76.752 51.8769 76.6982 51.8769 76.656 51.9034L73.1787 56.0865C73.0794 54.1488 72.9549 56.0583 72.9835 53.9447L73.9852 49.9629C73.9973 49.9145 73.9807 49.8635 73.9424 49.8315L70.7917 47.199C70.7017 47.1238 70.7493 46.9774 70.8662 46.9695L74.9626 46.6917C75.0124 46.6884 75.0559 46.6568 75.0744 46.6105L76.6045 42.8004Z" fill="#FE544F"/> <path d="M92.2046 42.8004C92.2482 42.6917 92.4022 42.6917 92.4458 42.8004L93.9758 46.6105C93.9944 46.6568 96.0379 46.6884 96.0877 46.6917L98.1841 46.9695C98.301 46.9774 98.3486 47.1238 98.2586 47.199L95.1078 49.8315C95.0696 49.8635 95.053 49.9145 95.0651 49.9629L96.0668 53.9447C96.0954 56.0583 95.9709 54.1488 95.8716 56.0865L92.3943 51.9034C92.3521 51.8769 92.2983 51.8769 92.2561 51.9034L88.7788 56.0865C88.6795 54.1488 88.555 56.0583 88.5836 53.9447L89.5853 49.9629C89.5974 49.9145 89.5808 49.8635 89.5425 49.8315L86.3918 47.199C86.3018 47.1238 86.3494 46.9774 86.4663 46.9695L90.5627 46.6917C90.6125 46.6884 90.6559 46.6568 90.6745 46.6105L92.2046 42.8004Z" fill="#FE544F"/> <path d="M107.804 42.8004C107.848 42.6917 108.002 42.6917 108.045 42.8004L109.575 46.6105C109.594 46.6568 109.638 46.6884 109.687 46.6917L113.784 46.9695C113.901 46.9774 113.948 47.1238 113.858 47.199L110.707 49.8315C110.669 49.8635 110.653 49.9145 110.665 49.9629L111.666 53.9447C111.695 56.0583 111.57 54.1488 111.471 56.0865L107.994 51.9034C107.952 51.8769 107.898 51.8769 107.856 51.9034L104.378 56.0865C104.279 54.1488 104.155 56.0583 104.183 53.9447L105.185 49.9629C105.197 49.9145 105.18 49.8635 105.142 49.8315L101.991 47.199C101.901 47.1238 101.949 46.9774 102.066 46.9695L106.162 46.6917C106.212 46.6884 106.256 46.6568 106.274 46.6105L107.804 42.8004Z" fill="#FE544F"/> <path d="M123.404 42.8004C123.448 42.6917 123.602 42.6917 123.646 42.8004L125.176 46.6105C125.194 46.6568 125.238 46.6884 125.287 46.6917L129.384 46.9695C129.501 46.9774 129.548 47.1238 129.458 47.199L126.308 49.8315C126.269 49.8635 126.253 49.9145 126.265 49.9629L127.267 53.9447C127.295 56.0583 127.171 54.1488 127.071 56.0865L123.594 51.9034C123.552 51.8769 123.498 51.8769 123.456 51.9034L119.978 56.0865C119.879 54.1488 119.755 56.0583 119.783 53.9447L120.785 49.9629C120.797 49.9145 120.781 49.8635 120.742 49.8315L117.591 47.199C117.502 47.1238 117.549 46.9774 117.666 46.9695L121.762 46.6917C121.812 46.6884 121.856 46.6568 121.874 46.6105L123.404 42.8004Z" fill="#FE544F"/> <rect x="54.625" y="65.5" width="70" height="7" fill="#D8DADD"/> <rect x="54.625" y="78.5" width="43" height="7" fill="#D8DADD"/> <circle cx="39" cy="49" r="6.5" fill="#D8DADD"/> <defs> <filter id="filter0_ddd_rev" x="10.5" y="25.5" width="186" height="90" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dy="6"/> <feGaussianBlur stdDeviation="6.5"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dy="1"/> <feGaussianBlur stdDeviation="1"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dy="3"/> <feGaussianBlur stdDeviation="3"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> </defs> </svg>', 'featuredpostIcon' => '<svg width="207" height="129" viewBox="0 0 207 129" fill="none"> <g filter="url(#filter0_ddd_ftpst)"> <rect x="21.4282" y="34.7188" width="160" height="64" rx="2" fill="white"/> </g> <g clip-path="url(#clip0_ftpst)"> <rect width="55" height="56" transform="translate(122.228 38.7188)" fill="#43A6DB"/> <circle cx="197.728" cy="101.219" r="55.5" fill="#86D0F9"/> </g> <rect x="32.4282" y="63.7188" width="69" height="9" fill="#D8DADD"/> <rect x="32.4282" y="78.7188" width="43" height="9" fill="#D8DADD"/> <circle cx="38.9282" cy="49.2188" r="6.5" fill="#D8DADD"/> <circle cx="171.072" cy="44.7812" r="15.5" fill="#EC352F" stroke="#FEF4EF" stroke-width="2"/> <path d="M173.587 44.7578L173.283 41.9688H174.291C174.595 41.9688 174.853 41.7344 174.853 41.4062V40.2812C174.853 39.9766 174.595 39.7188 174.291 39.7188H167.916C167.587 39.7188 167.353 39.9766 167.353 40.2812V41.4062C167.353 41.7344 167.587 41.9688 167.916 41.9688H168.9L168.595 44.7578C167.47 45.2734 166.603 46.2344 166.603 47.4062C166.603 47.7344 166.837 47.9688 167.166 47.9688H170.353V50.4297C170.353 50.4531 170.353 50.4766 170.353 50.5L170.916 51.625C170.986 51.7656 171.197 51.7656 171.267 51.625L171.83 50.5C171.83 50.4766 171.853 50.4531 171.853 50.4297V47.9688H175.041C175.345 47.9688 175.603 47.7344 175.603 47.4062C175.603 46.2109 174.712 45.2734 173.587 44.7578Z" fill="white"/> <defs> <filter id="filter0_ddd_ftpst" x="8.42822" y="27.7188" width="186" height="90" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dy="6"/> <feGaussianBlur stdDeviation="6.5"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dy="1"/> <feGaussianBlur stdDeviation="1"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dy="3"/> <feGaussianBlur stdDeviation="3"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> <clipPath id="clip0_ftpst"> <rect width="55" height="56" fill="white" transform="translate(122.228 38.7188)"/> </clipPath> </defs> </svg>', 'singlealbumIcon' => '<svg width="207" height="129" viewBox="0 0 207 129" fill="none"> <g clip-path="url(#clip0_sglalb)"> <rect x="74.6187" y="36.2202" width="57.7627" height="57.7627" fill="#43A6DB"/> <rect x="99.8896" y="61.4917" width="39.7119" height="39.7119" fill="#86D0F9"/> </g> <g clip-path="url(#clip1_sglalb)"> <rect x="68.6016" y="29" width="57.7627" height="57.7627" fill="#F9BBA0"/> <path d="M79.9715 49.4575L125.7 95.1863H42.127L79.9715 49.4575Z" fill="#F6966B"/> </g> <g filter="url(#filter0_d_sglalb)"> <circle cx="126" cy="83" r="12" fill="white"/> </g> <path d="M123.584 79H122.205L120.217 80.2773V81.6055L122.088 80.4102H122.135V87H123.584V79ZM126.677 81H125.177L126.959 84L125.131 87H126.631L127.888 84.8398L129.158 87H130.646L128.806 84L130.615 81H129.119L127.888 83.2148L126.677 81Z" fill="black"/> <defs> <filter id="filter0_d_sglalb" x="109" y="67" width="34" height="34" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dy="1"/> <feGaussianBlur stdDeviation="2.5"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow" result="shape"/> </filter> <clipPath id="clip0_sglalb"> <rect x="74.6187" y="36.2202" width="57.7627" height="57.7627" rx="1.20339" fill="white"/> </clipPath> <clipPath id="clip1_sglalb"> <rect x="68.6016" y="29" width="57.7627" height="57.7627" rx="1.20339" fill="white"/> </clipPath> </defs> </svg>', 'socialwallIcon' => '<svg width="207" height="129" viewBox="0 0 207 129" fill="none"> <path d="M96.6875 47.5C96.6875 42.1484 92.3516 37.8125 87 37.8125C81.6484 37.8125 77.3125 42.1484 77.3125 47.5C77.3125 52.3438 80.8281 56.3672 85.4766 57.0703V50.3125H83.0156V47.5H85.4766V45.3906C85.4766 42.9688 86.9219 41.6016 89.1094 41.6016C90.2031 41.6016 91.2969 41.7969 91.2969 41.7969V44.1797H90.0859C88.875 44.1797 88.4844 44.9219 88.4844 45.7031V47.5H91.1797L90.75 50.3125H88.4844V57.0703C93.1328 56.3672 96.6875 52.3438 96.6875 47.5Z" fill="#2A65DB"/> <path d="M128.695 42.3828C128.461 41.4453 127.719 40.7031 126.82 40.4688C125.141 40 118.5 40 118.5 40C118.5 40 111.82 40 110.141 40.4688C109.242 40.7031 108.5 41.4453 108.266 42.3828C107.797 46.0234 107.797 47.5391 107.797 47.5391C107.797 47.5391 107.797 51.0156 108.266 52.6953C108.5 53.6328 109.242 54.3359 110.141 54.5703C111.82 55 118.5 55 118.5 55C118.5 55 125.141 55 126.82 54.5703C127.719 54.3359 128.461 53.6328 128.695 52.6953C129.164 51.0156 129.164 47.5391 129.164 47.5391C129.164 47.5391 129.164 46.0234 128.695 42.3828ZM116.312 50.7031V44.375L121.859 47.5391L116.312 50.7031Z" fill="url(#paint0_linear_sclwl)"/> <path d="M86 78.0078C83.5 78.0078 81.5078 80.0391 81.5078 82.5C81.5078 85 83.5 86.9922 86 86.9922C88.4609 86.9922 90.4922 85 90.4922 82.5C90.4922 80.0391 88.4609 78.0078 86 78.0078ZM86 85.4297C84.3984 85.4297 83.0703 84.1406 83.0703 82.5C83.0703 80.8984 84.3594 79.6094 86 79.6094C87.6016 79.6094 88.8906 80.8984 88.8906 82.5C88.8906 84.1406 87.6016 85.4297 86 85.4297ZM91.7031 77.8516C91.7031 77.2656 91.2344 76.7969 90.6484 76.7969C90.0625 76.7969 89.5938 77.2656 89.5938 77.8516C89.5938 78.4375 90.0625 78.9062 90.6484 78.9062C91.2344 78.9062 91.7031 78.4375 91.7031 77.8516ZM94.6719 78.9062C94.5938 77.5 94.2812 76.25 93.2656 75.2344C92.25 74.2188 91 73.9062 89.5938 73.8281C88.1484 73.75 83.8125 73.75 82.3672 73.8281C80.9609 73.9062 79.75 74.2188 78.6953 75.2344C77.6797 76.25 77.3672 77.5 77.2891 78.9062C77.2109 80.3516 77.2109 84.6875 77.2891 86.1328C77.3672 87.5391 77.6797 88.75 78.6953 89.8047C79.75 90.8203 80.9609 91.1328 82.3672 91.2109C83.8125 91.2891 88.1484 91.2891 89.5938 91.2109C91 91.1328 92.25 90.8203 93.2656 89.8047C94.2812 88.75 94.5938 87.5391 94.6719 86.1328C94.75 84.6875 94.75 80.3516 94.6719 78.9062ZM92.7969 87.6562C92.5234 88.4375 91.8984 89.0234 91.1562 89.3359C89.9844 89.8047 87.25 89.6875 86 89.6875C84.7109 89.6875 81.9766 89.8047 80.8438 89.3359C80.0625 89.0234 79.4766 88.4375 79.1641 87.6562C78.6953 86.5234 78.8125 83.7891 78.8125 82.5C78.8125 81.25 78.6953 78.5156 79.1641 77.3438C79.4766 76.6016 80.0625 76.0156 80.8438 75.7031C81.9766 75.2344 84.7109 75.3516 86 75.3516C87.25 75.3516 89.9844 75.2344 91.1562 75.7031C91.8984 75.9766 92.4844 76.6016 92.7969 77.3438C93.2656 78.5156 93.1484 81.25 93.1484 82.5C93.1484 83.7891 93.2656 86.5234 92.7969 87.6562Z" fill="url(#paint1_linear_swwl)"/> <path d="M127.93 78.4375C128.711 77.8516 129.414 77.1484 129.961 76.3281C129.258 76.6406 128.438 76.875 127.617 76.9531C128.477 76.4453 129.102 75.6641 129.414 74.6875C128.633 75.1562 127.734 75.5078 126.836 75.7031C126.055 74.8828 125 74.4141 123.828 74.4141C121.562 74.4141 119.727 76.25 119.727 78.5156C119.727 78.8281 119.766 79.1406 119.844 79.4531C116.445 79.2578 113.398 77.6172 111.367 75.1562C111.016 75.7422 110.82 76.4453 110.82 77.2266C110.82 78.6328 111.523 79.8828 112.656 80.625C111.992 80.5859 111.328 80.4297 110.781 80.1172V80.1562C110.781 82.1484 112.188 83.7891 116.062 84.1797C113.75 84.2578 113.359 84.3359 113.008 84.3359C112.734 84.3359 112.5 84.2969 112.227 84.2578C112.734 85.8984 114.258 87.0703 116.055 87.1094C114.648 88.2031 112.891 88.8672 110.977 88.8672C110.625 88.8672 110.312 88.8281 110 88.7891C111.797 89.9609 113.945 90.625 116.289 90.625C123.828 90.625 127.93 84.4141 127.93 78.9844C127.93 78.7891 127.93 78.6328 127.93 78.4375Z" fill="url(#paint2_linear)"/> <defs> <linearGradient id="paint0_linear_sclwl" x1="137.667" y1="33.4445" x2="109.486" y2="62.2514" gradientUnits="userSpaceOnUse"> <stop stop-color="#E3280E"/> <stop offset="1" stop-color="#E30E0E"/> </linearGradient> <linearGradient id="paint1_linear_swwl" x1="93.8998" y1="73.3444" x2="78.4998" y2="89.4444" gradientUnits="userSpaceOnUse"> <stop stop-color="#5F0EE3"/> <stop offset="0.713476" stop-color="#FF0000"/> <stop offset="1" stop-color="#FF5C00"/> </linearGradient> <linearGradient id="paint2_linear" x1="136.667" y1="68.4445" x2="108.674" y2="93.3272" gradientUnits="userSpaceOnUse"> <stop stop-color="#0E96E3"/> <stop offset="1" stop-color="#0EBDE3"/> </linearGradient> </defs> </svg>', 'addPage' => '<svg viewBox="0 0 17 17"><path d="M12.1667 9.66667H13.8333V12.1667H16.3333V13.8333H13.8333V16.3333H12.1667V13.8333H9.66667V12.1667H12.1667V9.66667ZM2.16667 0.5H13.8333C14.7583 0.5 15.5 1.24167 15.5 2.16667V8.66667C14.9917 8.375 14.4333 8.16667 13.8333 8.06667V2.16667H2.16667V13.8333H8.06667C8.16667 14.4333 8.375 14.9917 8.66667 15.5H2.16667C1.24167 15.5 0.5 14.7583 0.5 13.8333V2.16667C0.5 1.24167 1.24167 0.5 2.16667 0.5ZM3.83333 3.83333H12.1667V5.5H3.83333V3.83333ZM3.83333 7.16667H12.1667V8.06667C11.4583 8.18333 10.8083 8.45 10.2333 8.83333H3.83333V7.16667ZM3.83333 10.5H8V12.1667H3.83333V10.5Z"/></svg>', 'addWidget' => '<svg viewBox="0 0 15 16"><path d="M0 15.5H6.66667V8.83333H0V15.5ZM1.66667 10.5H5V13.8333H1.66667V10.5ZM0 7.16667H6.66667V0.5H0V7.16667ZM1.66667 2.16667H5V5.5H1.66667V2.16667ZM8.33333 0.5V7.16667H15V0.5H8.33333ZM13.3333 5.5H10V2.16667H13.3333V5.5ZM12.5 11.3333H15V13H12.5V15.5H10.8333V13H8.33333V11.3333H10.8333V8.83333H12.5V11.3333Z"/></svg>', 'plus' => '<svg width="13" height="12" viewBox="0 0 13 12"><path d="M12.3327 6.83332H7.33268V11.8333H5.66602V6.83332H0.666016V5.16666H5.66602V0.166656H7.33268V5.16666H12.3327V6.83332Z"/></svg>', 'eye1' => '<svg width="20" height="17" viewBox="0 0 20 17"><path d="M9.85801 5.5L12.4997 8.13333V8C12.4997 7.33696 12.2363 6.70107 11.7674 6.23223C11.2986 5.76339 10.6627 5.5 9.99967 5.5H9.85801ZM6.27467 6.16667L7.56634 7.45833C7.52467 7.63333 7.49967 7.80833 7.49967 8C7.49967 8.66304 7.76307 9.29893 8.23191 9.76777C8.70075 10.2366 9.33663 10.5 9.99967 10.5C10.183 10.5 10.3663 10.475 10.5413 10.4333L11.833 11.725C11.2747 12 10.658 12.1667 9.99967 12.1667C8.8946 12.1667 7.8348 11.7277 7.0534 10.9463C6.27199 10.1649 5.83301 9.10507 5.83301 8C5.83301 7.34167 5.99967 6.725 6.27467 6.16667ZM1.66634 1.55833L3.56634 3.45833L3.94134 3.83333C2.56634 4.91667 1.48301 6.33333 0.833008 8C2.27467 11.6583 5.83301 14.25 9.99967 14.25C11.2913 14.25 12.5247 14 13.6497 13.55L14.008 13.9L16.4413 16.3333L17.4997 15.275L2.72467 0.5L1.66634 1.55833ZM9.99967 3.83333C11.1047 3.83333 12.1645 4.27232 12.946 5.05372C13.7274 5.83512 14.1663 6.89493 14.1663 8C14.1663 8.53333 14.058 9.05 13.8663 9.51667L16.308 11.9583C17.558 10.9167 18.558 9.55 19.1663 8C17.7247 4.34167 14.1663 1.75 9.99967 1.75C8.83301 1.75 7.71634 1.95833 6.66634 2.33333L8.47467 4.125C8.94967 3.94167 9.45801 3.83333 9.99967 3.83333Z"/></svg>', 'boxed' => '<svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M10.6667 1.33333V10.6667H1.33333V1.33333H10.6667ZM12 0H0V12H12V0ZM9.33333 9.33333H2.66667V8.66667H9.33333V9.33333ZM9.33333 8H2.66667V7.33333H9.33333V8ZM9.33333 6H2.66667V2.66667H9.33333V6Z" fill="#434960"/></svg>', 'eyePreview' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M569.354 231.631C512.97 135.949 407.81 72 288 72 168.14 72 63.004 135.994 6.646 231.631a47.999 47.999 0 0 0 0 48.739C63.031 376.051 168.19 440 288 440c119.86 0 224.996-63.994 281.354-159.631a47.997 47.997 0 0 0 0-48.738zM288 392c-102.556 0-192.091-54.701-240-136 44.157-74.933 123.677-127.27 216.162-135.007C273.958 131.078 280 144.83 280 160c0 30.928-25.072 56-56 56s-56-25.072-56-56l.001-.042C157.794 179.043 152 200.844 152 224c0 75.111 60.889 136 136 136s136-60.889 136-136c0-31.031-10.4-59.629-27.895-82.515C451.704 164.638 498.009 205.106 528 256c-47.908 81.299-137.444 136-240 136z"/></svg>', 'regular' => '<svg width="10" height="12" viewBox="0 0 10 12" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M10 6.75005V0.333374H0V6.75005H10Z" fill="#141B38"/><path d="M0 8.25004H10V9.50004H0V8.25004Z" fill="#141B38"/><path d="M6 10.75H0V12H6V10.75Z" fill="#141B38"/></svg>', 'horizontal' => '<svg width="14" height="8" viewBox="0 0 14 8" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6 0.5H0V7.5H6V0.5Z" fill="#141B38"/><path d="M14 0.75H7.5V2H14V0.75Z" fill="#141B38"/><path d="M7.5 3.25H14V4.5H7.5V3.25Z" fill="#141B38"/><path d="M11 5.75H7.5V7H11V5.75Z" fill="#141B38"/></svg>', 'facebookShare' => '<svg viewBox="0 0 448 512"><path fill="currentColor" d="M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h137.25V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.27c-30.81 0-40.42 19.12-40.42 38.73V256h68.78l-11 71.69h-57.78V480H400a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48z"></path></svg>', 'twitterShare' => '<svg viewBox="0 0 512 512"><path fill="currentColor" d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-26.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path></svg>', 'linkedinShare' => '<svg viewBox="0 0 448 512"><path fill="currentColor" d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C26.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"></path></svg>', 'mailShare' => '<svg viewBox="0 0 512 512"><path fill="currentColor" d="M502.3 190.8c3.9-3.1 9.7-.2 9.7 4.7V400c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V195.6c0-5 5.7-7.8 9.7-4.7 22.4 17.4 52.1 39.5 154.1 113.6 21.1 15.4 56.7 47.8 92.2 47.6 35.7.3 72-32.8 92.3-47.6 102-74.1 131.6-96.3 154-113.7zM256 320c23.2.4 56.6-29.2 73.4-41.4 132.7-96.3 142.8-104.7 173.4-128.7 5.8-4.5 9.2-11.5 9.2-18.9v-19c0-26.5-21.5-48-48-48H48C21.5 64 0 85.5 0 112v19c0 7.4 3.4 14.3 9.2 18.9 30.6 23.9 40.7 32.4 173.4 128.7 16.8 12.2 50.2 41.8 73.4 41.4z"></path></svg>', 'videoStyle' => '<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16 2V16H2V2H16ZM18 0H0V18H18V0ZM14 14H4V13H14V14ZM14 12H4V11H14V12ZM14 9H4V4H14V9Z" fill="#141B38"/></svg>', 'successNotification' => '<svg viewBox="0 0 20 20"><path d="M10 0C4.5 0 0 4.5 0 10C0 15.5 4.5 20 10 20C15.5 20 20 15.5 20 10C20 4.5 15.5 0 10 0ZM8 15L3 10L4.41 8.59L8 12.17L15.59 4.58L17 6L8 15Z"/></svg>', 'errorNotification' => '<svg viewBox="0 0 20 20"><path d="M9.99997 0C4.47997 0 -3.05176e-05 4.48 -3.05176e-05 10C-3.05176e-05 15.52 4.47997 20 9.99997 20C15.52 20 20 15.52 20 10C20 4.48 15.52 0 9.99997 0ZM11 15H8.99997V13H11V15ZM11 11H8.99997V5H11V11Z"/></svg>', 'messageNotification' => '<svg viewBox="0 0 20 20"><path d="M11.0001 7H9.00012V5H11.0001V7ZM11.0001 15H9.00012V9H11.0001V15ZM10.0001 0C8.6869 0 7.38654 0.258658 6.17329 0.761205C4.96003 1.26375 3.85764 2.00035 2.92905 2.92893C1.05369 4.8043 0.00012207 7.34784 0.00012207 10C0.00012207 12.6522 1.05369 15.1957 2.92905 17.0711C3.85764 17.9997 4.96003 18.7362 6.17329 19.2388C7.38654 19.7413 8.6869 20 10.0001 20C12.6523 20 15.1958 18.9464 17.0712 17.0711C18.9466 15.1957 20.0001 12.6522 20.0001 10C20.0001 8.68678 19.7415 7.38642 19.2389 6.17317C18.7364 4.95991 17.9998 3.85752 17.0712 2.92893C16.1426 2.00035 15.0402 1.26375 13.827 0.761205C12.6137 0.258658 11.3133 0 10.0001 0Z"/></svg>', 'lightboxExperience' => '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20 16H6V2H20V16ZM20 0H6C5.46957 0 4.96086 0.210714 4.58579 0.585786C4.21071 0.960859 4 1.46957 4 2V16C4 16.5304 4.21071 17.0391 4.58579 17.4142C4.96086 17.7893 5.46957 18 6 18H20C20.5304 18 21.0391 17.7893 21.4142 17.4142C21.7893 17.0391 22 16.5304 22 16V2C22 1.46957 21.7893 0.960859 21.4142 0.585786C21.0391 0.210714 20.5304 0 20 0ZM2 4H0V20C0 20.5304 0.210714 21.0391 0.585786 21.4142C0.960859 21.7893 1.46957 22 2 22H18V20H2V4Z" fill="#141B38"/></svg>', 'albumsPreview' => '<svg width="63" height="65" viewBox="0 0 63 65" fill="none"><rect x="13.6484" y="10.2842" width="34.7288" height="34.7288" rx="1.44703" fill="#8C8F9A"/> <g filter="url(#filter0_dddalbumsPreview)"><rect x="22.1484" y="5.21962" width="34.7288" height="34.7288" rx="1.44703" transform="rotate(8 22.1484 5.21962)" fill="white"/> </g><path d="M29.0485 23.724L18.9288 28.1468L17.2674 39.9686L51.6582 44.802L52.2623 40.5031L29.0485 23.724Z" fill="#B5E5FF"/> <path d="M44.9106 25.2228L17.7194 36.7445L17.2663 39.9687L51.6571 44.802L53.4696 31.9054L44.9106 25.2228Z" fill="#43A6DB"/> <circle cx="42.9495" cy="18.3718" r="2.89406" transform="rotate(8 42.9495 18.3718)" fill="#43A6DB"/> <g filter="url(#filter1_dddalbumsPreview)"> <rect x="42.4766" y="33.9054" width="16.875" height="16.875" rx="8.4375" fill="white"/> <path d="M54.1953 42.8116H51.3828V45.6241H50.4453V42.8116H47.6328V41.8741H50.4453V39.0616H51.3828V41.8741H54.1953V42.8116Z" fill="#0068A0"/> </g> <defs> <filter id="filter0_dddalbumsPreview" x="0.86108" y="0.342124" width="58.3848" height="57.6613" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dx="-7.23516" dy="4.3411"/> <feGaussianBlur stdDeviation="4.70286"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dy="2.89406"/> <feGaussianBlur stdDeviation="1.44703"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> <filter id="filter1_dddalbumsPreview" x="25.8357" y="28.8408" width="36.4099" height="35.6864" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dx="-7.23516" dy="4.3411"/> <feGaussianBlur stdDeviation="4.70286"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dy="2.89406"/> <feGaussianBlur stdDeviation="1.44703"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> </defs> </svg>', 'featuredPostPreview' => '<svg width="47" height="48" viewBox="0 0 47 48" fill="none"> <g filter="url(#filter0_ddfeaturedpos)"> <rect x="2.09375" y="1.84264" width="34.7288" height="34.7288" rx="1.44703" fill="white"/> </g> <path d="M11.4995 19.2068L2.09375 24.9949L2.09375 36.9329H36.8225V32.5918L11.4995 19.2068Z" fill="#B5E5FF"/> <path d="M27.4168 18.4833L2.09375 33.6772V36.933H36.8225V23.9097L27.4168 18.4833Z" fill="#43A6DB"/> <circle cx="24.523" cy="11.9718" r="2.89406" fill="#43A6DB"/> <g filter="url(#filter1_ddfeaturedpos)"> <rect x="26.0312" y="25.2824" width="16.875" height="16.875" rx="8.4375" fill="white"/> <path d="M37.75 34.1886H34.9375V37.0011H34V34.1886H31.1875V33.2511H34V30.4386H34.9375V33.2511H37.75V34.1886Z" fill="#0068A0"/> </g> <defs> <filter id="filter0_ddfeaturedpos" x="0.09375" y="0.842636" width="40.7288" height="40.7288" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dx="1" dy="2"/> <feGaussianBlur stdDeviation="1.5"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow" result="shape"/> </filter> <filter id="filter1_ddfeaturedpos" x="26.0312" y="24.2824" width="22.875" height="22.875" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset dx="1" dy="2"/> <feGaussianBlur stdDeviation="1.5"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/> <feOffset/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow" result="shape"/> </filter> </defs> </svg>', 'issueSinglePreview' => '<svg width="27" height="18" viewBox="0 0 27 18" fill="none"> <line x1="3.22082" y1="2.84915" x2="8.91471" y2="8.54304" stroke="#8C8F9A" stroke-width="3"/> <path d="M3.10938 8.65422L8.80327 2.96033" stroke="#8C8F9A" stroke-width="3"/> <line x1="18.3107" y1="2.84915" x2="26.0046" y2="8.54304" stroke="#8C8F9A" stroke-width="3"/> <path d="M18.1992 8.65422L23.8931 2.96033" stroke="#8C8F9A" stroke-width="3"/> <line x1="8.64062" y1="16.3863" x2="18.0351" y2="16.3863" stroke="#8C8F9A" stroke-width="3"/> </svg>', 'playButton' => '<svg viewBox="0 0 448 512"><path fill="currentColor" d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z"></path></svg>', 'loader' => '<svg version="1.1" id="loader-1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="20px" height="20px" viewBox="0 0 50 50" style="enable-background:new 0 0 50 50;" xml:space="preserve"><path fill="#fff" d="M43.935,25.145c0-10.318-8.364-18.683-18.683-18.683c-10.318,0-18.683,8.365-18.683,18.683h6.068c0-8.071,6.543-14.615,14.615-14.615c8.072,0,14.615,6.543,14.615,14.615H43.935z"><animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 25 25" to="360 25 25" dur="0.6s" repeatCount="indefinite"/></path></svg>', 'spinner' => '<svg version="1.1" id="loader-1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="20px" height="20px" viewBox="0 0 50 50" style="enable-background:new 0 0 50 50;" xml:space="preserve"><path fill="#fff" d="M43.935,25.145c0-10.318-8.364-18.683-18.683-18.683c-10.318,0-18.683,8.365-18.683,18.683h6.068c0-8.071,6.543-14.615,14.615-14.615c8.072,0,14.615,6.543,14.615,14.615H43.935z"><animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 25 25" to="360 25 25" dur="0.6s" repeatCount="indefinite"/></path></svg>', 'follow' => '<svg viewBox="0 0 24 24"><path d="M20 18.5H4C3.46957 18.5 2.96086 18.2893 2.58579 17.9142C2.21071 17.5391 2 17.0304 2 16.5V7.5C2 6.96957 2.21071 6.46086 2.58579 6.08579C2.96086 5.71071 3.46957 5.5 4 5.5H20C20.5304 5.5 21.0391 5.71071 21.4142 6.08579C21.7893 6.46086 22 6.96957 22 7.5V16.5C22 17.0304 21.7893 17.5391 21.4142 17.9142C21.0391 18.2893 20.5304 18.5 20 18.5ZM4 7.5V16.5H20V7.5H4Z" fill="#141B38"/><path d="M9 13.75C9 13.1977 9.44772 12.75 10 12.75H14C14.5523 12.75 15 13.1977 15 13.75V15H9V13.75Z" fill="#141B38"/><path d="M13.5 10.5C13.5 11.3284 12.8284 12 12 12C11.1716 12 10.5 11.3284 10.5 10.5C10.5 9.67157 11.1716 9 12 9C12.8284 9 13.5 9.67157 13.5 10.5Z" fill="#141B38"/></svg>', 'picture' => '<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M5.5 10.5L8 13.5L11.5 9L16 15H2L5.5 10.5ZM18 16V2C18 1.46957 17.7893 0.960859 17.4142 0.585786C17.0391 0.210714 16.5304 0 16 0H2C1.46957 0 0.960859 0.210714 0.585786 0.585786C0.210714 0.960859 0 1.46957 0 2V16C0 16.5304 0.210714 17.0391 0.585786 17.4142C0.960859 17.7893 1.46957 18 2 18H16C16.5304 18 17.0391 17.7893 17.4142 17.4142C17.7893 17.0391 18 16.5304 18 16Z" fill="#141B38"/></svg>', 'caption' => '<svg viewBox="0 0 24 24" fill="none"><path d="M5 3C3.89 3 3 3.89 3 5V19C3 20.11 3.89 21 5 21H19C20.11 21 21 20.11 21 19V5C21 3.89 20.11 3 19 3H5ZM5 5H19V19H5V5ZM7 7V9H17V7H7ZM7 11V13H17V11H7ZM7 15V17H14V15H7Z"/></svg>', 'heart' => '<svg viewBox="0 0 24 24"><path d="M16.5 3C14.76 3 13.09 3.81 12 5.09C10.91 3.81 9.24 3 7.5 3C4.42 3 2 5.42 2 8.5C2 12.28 5.4 15.36 10.55 20.04L12 21.35L13.45 20.03C18.6 15.36 22 12.28 22 8.5C22 5.42 19.58 3 16.5 3ZM12.1 18.55L12 18.65L11.9 18.55C7.14 14.24 4 11.39 4 8.5C4 6.5 5.5 5 7.5 5C9.04 5 10.54 5.99 11.07 7.36H12.94C13.46 5.99 14.96 5 16.5 5C18.5 5 20 6.5 20 8.5C20 11.39 16.86 14.24 12.1 18.55Z"/></svg>', 'sort' => '<svg viewBox="0 0 24 24"><path d="M7.73062 10.9999C7.51906 10.9999 7.40314 10.7535 7.53803 10.5906L11.8066 5.43267C11.9066 5.31186 12.0918 5.31186 12.1918 5.43267L16.4604 10.5906C16.5953 10.7535 16.4794 10.9999 16.2678 10.9999H7.73062Z" fill="#141B38"/><path d="M7.80277 13C7.58005 13 7.4685 13.2693 7.626 13.4268L11.8224 17.6232C11.9201 17.7209 12.0784 17.7209 12.176 17.6232L16.3724 13.4268C16.5299 13.2693 16.4184 13 16.1957 13H7.80277Z" fill="#141B38"/></svg>', 'shop' => '<svg viewBox="0 0 24 24"><path d="M11 9H13V6H16V4H13V1H11V4H8V6H11V9ZM7 18C5.9 18 5.01 18.9 5.01 20C5.01 21.1 5.9 22 7 22C8.1 22 9 21.1 9 20C9 18.9 8.1 18 7 18ZM17 18C15.9 18 15.01 18.9 15.01 20C15.01 21.1 15.9 22 17 22C18.1 22 19 21.1 19 20C19 18.9 18.1 18 17 18ZM8.1 13H15.55C16.3 13 16.96 12.59 17.3 11.97L21.16 4.96L19.42 4L15.55 11H8.53L4.27 2H1V4H3L6.6 11.59L5.25 14.03C4.52 15.37 5.48 17 7 17H19V15H7L8.1 13Z" fill="#141B38"/></svg>', 'headerUser' => '<svg class="svg-inline--fa fa-user fa-w-16" style="margin-right: 3px;" aria-hidden="true" data-fa-processed="" data-prefix="fa" data-icon="user" role="presentation" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="currentColor" d="M96 160C96 71.634 167.635 0 256 0s160 71.634 160 160-71.635 160-160 160S96 248.366 96 160zm304 192h-28.556c-71.006 42.713-159.912 42.695-230.888 0H112C50.144 352 0 402.144 0 464v24c0 13.255 10.745 24 24 24h464c13.255 0 24-10.745 24-24v-24c0-61.856-50.144-112-112-112z"></path></svg>', 'headerPhoto' => '<svg class="svg-inline--fa fa-image fa-w-16" aria-hidden="true" data-fa-processed="" data-prefix="far" data-icon="image" role="presentation" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="currentColor" d="M464 448H48c-26.51 0-48-21.49-48-48V112c0-26.51 21.49-48 48-48h416c26.51 0 48 21.49 48 48v288c0 26.51-21.49 48-48 48zM112 120c-30.928 0-56 25.072-56 56s25.072 56 56 56 56-25.072 56-56-25.072-56-56-56zM64 384h384V272l-87.515-87.515c-4.686-4.686-12.284-4.686-16.971 0L208 320l-55.515-55.515c-4.686-4.686-12.284-4.686-16.971 0L64 336v48z"></path></svg>', 'imageChooser' => '<svg viewBox="0 0 18 18" fill="none"><path d="M2.16667 0.5C1.72464 0.5 1.30072 0.675595 0.988155 0.988155C0.675595 1.30072 0.5 1.72464 0.5 2.16667V13.8333C0.5 14.2754 0.675595 14.6993 0.988155 15.0118C1.30072 15.3244 1.72464 15.5 2.16667 15.5H9.74167C9.69167 15.225 9.66667 14.95 9.66667 14.6667C9.66667 14.1 9.76667 13.5333 9.95833 13H2.16667L5.08333 9.25L7.16667 11.75L10.0833 8L11.9417 10.475C12.75 9.95 13.7 9.66667 14.6667 9.66667C14.95 9.66667 15.225 9.69167 15.5 9.74167V2.16667C15.5 1.72464 15.3244 1.30072 15.0118 0.988155C14.6993 0.675595 14.2754 0.5 13.8333 0.5H2.16667ZM13.8333 11.3333V13.8333H11.3333V15.5H13.8333V18H15.5V15.5H18V13.8333H15.5V11.3333H13.8333Z"/></svg>', 'chevronRight' => '<svg width="7" height="10" viewBox="0 0 7 10" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M1.3332 0L0.158203 1.175L3.97487 5L0.158203 8.825L1.3332 10L6.3332 5L1.3332 0Z" fill="#0068A0"/></svg>', 'usertimelineIcon' => '<svg width="260" height="126" viewBox="0 0 260 126" fill="none" xmlns="http://www.w3.org/2000/svg"> <g clip-path="url(#usrtimlineclip0)"> <g filter="url(#usrtimlinefilter0_ddd)"> <g clip-path="url(#usrtimlineclip1)"> <rect x="64" y="23" width="131" height="113" rx="2" fill="white"/> <rect x="112.027" y="38" width="46" height="6" rx="1" fill="#DCDDE1"/> <rect x="112.027" y="49" width="28" height="6" rx="1" fill="#DCDDE1"/> <g clip-path="url(#usrtimlineclip2)"> <rect x="133.027" y="121" width="48" height="48" rx="1" fill="#F9BBA0"/> </g> <g clip-path="url(#usrtimlineclip3)"> <rect x="133.027" y="67" width="48" height="48" fill="#43A6DB"/> <circle cx="123.527" cy="101.5" r="40.5" fill="#86D0F9"/> </g> <g clip-path="url(#usrtimlineclip4)"> <rect x="79.0273" y="121" width="48" height="48" fill="#B6DDAD"/> </g> <g clip-path="url(#usrtimlineclip5)"> <rect x="79.0273" y="67" width="48" height="48" fill="#F6966B"/> <path d="M88.4756 84L126.476 122H57.0273L88.4756 84Z" fill="#F9BBA0"/> </g> <circle cx="92.0273" cy="45" r="10" fill="#DCDDE1"/> <circle cx="92.0273" cy="45" r="12" stroke="url(#usrtimlinepaint0_linear)"/> </g> </g> </g> <defs> <filter id="usrtimlinefilter0_ddd" x="51" y="16" width="157" height="139" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="6"/> <feGaussianBlur stdDeviation="6.5"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="1"/> <feGaussianBlur stdDeviation="1"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="3"/> <feGaussianBlur stdDeviation="3"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> <linearGradient id="usrtimlinepaint0_linear" x1="88.5773" y1="78.9" x2="139.127" y2="27.3" gradientUnits="userSpaceOnUse"> <stop stop-color="white"/> <stop offset="0.147864" stop-color="#F6640E"/> <stop offset="0.443974" stop-color="#BA03A7"/> <stop offset="0.733337" stop-color="#6A01B9"/> <stop offset="1" stop-color="#6B01B9"/> </linearGradient> <clipPath id="usrtimlineclip0"> <rect width="259.056" height="126" fill="white"/> </clipPath> <clipPath id="usrtimlineclip1"> <rect x="64" y="23" width="131" height="113" rx="2" fill="white"/> </clipPath> <clipPath id="usrtimlineclip2"> <rect x="133.027" y="121" width="48" height="48" rx="1" fill="white"/> </clipPath> <clipPath id="usrtimlineclip3"> <rect x="133.027" y="67" width="48" height="48" rx="1" fill="white"/> </clipPath> <clipPath id="usrtimlineclip4"> <rect x="79.0273" y="121" width="48" height="48" rx="1" fill="white"/> </clipPath> <clipPath id="usrtimlineclip5"> <rect x="79.0273" y="67" width="48" height="48" rx="1" fill="white"/> </clipPath> </defs> </svg>', 'publichashtagIcon' => '<svg width="260" height="126" viewBox="0 0 260 126" fill="none" xmlns="http://www.w3.org/2000/svg"> <g clip-path="url(#hashtagiconclip0)"> <g filter="url(#hashtagiconfilter0_ddd)"> <rect x="119.327" y="12.3203" width="80" height="91" rx="2" transform="rotate(4 119.327 12.3203)" fill="white"/> </g> <g clip-path="url(#hashtagiconclip1)"> <rect x="119.327" y="12.3203" width="80" height="80" transform="rotate(4 119.327 12.3203)" fill="#0096CC"/> </g> <path d="M130.918 88.5016L128.971 88.3655L129.441 86.6958C129.453 86.6464 129.454 86.5951 129.444 86.5452C129.435 86.4954 129.414 86.4482 129.385 86.4069C129.355 86.3657 129.317 86.3313 129.273 86.3062C129.229 86.2811 129.18 86.2659 129.129 86.2616L128.427 86.2125C128.347 86.2049 128.265 86.2255 128.198 86.2709C128.131 86.3163 128.081 86.3837 128.058 86.4616L127.572 88.2676L125.678 88.1352L126.147 86.4654C126.159 86.4172 126.16 86.3671 126.151 86.3182C126.142 86.2694 126.123 86.223 126.095 86.182C126.067 86.1411 126.031 86.1066 125.988 86.0808C125.946 86.055 125.899 86.0384 125.849 86.0322L125.148 85.9832C125.067 85.9755 124.986 85.9962 124.918 86.0416C124.851 86.087 124.801 86.1544 124.778 86.2322L124.299 88.0388L122.194 87.8916C122.112 87.8842 122.03 87.9058 121.963 87.9526C121.895 87.9994 121.846 88.0684 121.824 88.1477L121.631 88.8392C121.617 88.89 121.614 88.9433 121.624 88.9953C121.633 89.0472 121.654 89.0964 121.685 89.1391C121.716 89.1819 121.756 89.2172 121.802 89.2424C121.848 89.2676 121.9 89.282 121.952 89.2846L123.899 89.4208L123.128 92.1867L121.023 92.0396C120.941 92.0322 120.859 92.0537 120.791 92.1005C120.724 92.1473 120.675 92.2164 120.653 92.2957L120.46 92.9871C120.446 93.038 120.443 93.0913 120.452 93.1432C120.462 93.1952 120.483 93.2443 120.513 93.2871C120.544 93.3299 120.584 93.3652 120.631 93.3904C120.677 93.4156 120.728 93.43 120.781 93.4326L122.742 93.5697L122.273 95.2394C122.26 95.2896 122.259 95.3419 122.269 95.3926C122.28 95.4432 122.301 95.491 122.332 95.5325C122.362 95.5741 122.402 95.6083 122.447 95.6328C122.493 95.6573 122.543 95.6715 122.595 95.6744L123.296 95.7234C123.375 95.7269 123.452 95.7041 123.516 95.6588C123.579 95.6135 123.626 95.5481 123.649 95.4731L124.142 93.6676L126.036 93.8L125.566 95.4698C125.555 95.5179 125.553 95.5681 125.562 95.617C125.571 95.6658 125.59 95.7122 125.618 95.7531C125.646 95.7941 125.683 95.8286 125.725 95.8544C125.767 95.8802 125.815 95.8968 125.864 95.903L126.566 95.952C126.647 95.9597 126.728 95.939 126.795 95.8936C126.862 95.8482 126.912 95.7808 126.935 95.703L127.432 93.8977L129.536 94.0448C129.618 94.0522 129.7 94.0306 129.768 93.9839C129.836 93.9371 129.885 93.868 129.907 93.7887L130.096 93.097C130.11 93.0462 130.113 92.9928 130.104 92.9409C130.094 92.889 130.073 92.8398 130.043 92.797C130.012 92.7542 129.972 92.719 129.925 92.6938C129.879 92.6686 129.828 92.6542 129.775 92.6515L127.818 92.5147L128.586 89.7485L130.69 89.8956C130.772 89.903 130.854 89.8814 130.922 89.8347C130.989 89.7879 131.039 89.7188 131.061 89.6395L131.253 88.948C131.268 88.8961 131.27 88.8414 131.26 88.7883C131.25 88.7353 131.228 88.6852 131.196 88.642C131.164 88.5989 131.122 88.5637 131.073 88.5394C131.025 88.515 130.972 88.5021 130.918 88.5016ZM126.414 92.4166L124.52 92.2841L125.292 89.5181L127.186 89.6506L126.414 92.4166Z" fill="#0068A0"/> <rect x="138.037" y="88.8115" width="29" height="7" rx="1" transform="rotate(4 138.037 88.8115)" fill="#86D0F9"/> <g filter="url(#hashtagiconfilter1_ddd)"> <rect x="119.327" y="12.3203" width="80" height="91" rx="2" transform="rotate(4 119.327 12.3203)" fill="white"/> </g> <g clip-path="url(#hashtagiconclip2)"> <rect x="119.327" y="12.3203" width="80" height="80" transform="rotate(4 119.327 12.3203)" fill="#0096CC"/> <circle cx="126.556" cy="44.5" r="46.5" fill="#0068A0"/> </g> <path d="M130.918 88.5016L128.971 88.3655L129.441 86.6958C129.453 86.6464 129.454 86.5951 129.444 86.5452C129.435 86.4954 129.414 86.4482 129.385 86.4069C129.355 86.3657 129.317 86.3313 129.273 86.3062C129.229 86.2811 129.18 86.2659 129.129 86.2616L128.427 86.2125C128.347 86.2049 128.265 86.2255 128.198 86.2709C128.131 86.3163 128.081 86.3837 128.058 86.4616L127.572 88.2676L125.678 88.1352L126.147 86.4654C126.159 86.4172 126.16 86.3671 126.151 86.3182C126.142 86.2694 126.123 86.223 126.095 86.182C126.067 86.1411 126.031 86.1066 125.988 86.0808C125.946 86.055 125.899 86.0384 125.849 86.0322L125.148 85.9832C125.067 85.9755 124.986 85.9962 124.918 86.0416C124.851 86.087 124.801 86.1544 124.778 86.2322L124.299 88.0388L122.194 87.8916C122.112 87.8842 122.03 87.9058 121.963 87.9526C121.895 87.9994 121.846 88.0684 121.824 88.1477L121.631 88.8392C121.617 88.89 121.614 88.9433 121.624 88.9953C121.633 89.0472 121.654 89.0964 121.685 89.1391C121.716 89.1819 121.756 89.2172 121.802 89.2424C121.848 89.2676 121.9 89.282 121.952 89.2846L123.899 89.4208L123.128 92.1867L121.023 92.0396C120.941 92.0322 120.859 92.0537 120.791 92.1005C120.724 92.1473 120.675 92.2164 120.653 92.2957L120.46 92.9871C120.446 93.038 120.443 93.0913 120.452 93.1432C120.462 93.1952 120.483 93.2443 120.513 93.2871C120.544 93.3299 120.584 93.3652 120.631 93.3904C120.677 93.4156 120.728 93.43 120.781 93.4326L122.742 93.5697L122.273 95.2394C122.26 95.2896 122.259 95.3419 122.269 95.3926C122.28 95.4432 122.301 95.491 122.332 95.5325C122.362 95.5741 122.402 95.6083 122.447 95.6328C122.493 95.6573 122.543 95.6715 122.595 95.6744L123.296 95.7234C123.375 95.7269 123.452 95.7041 123.516 95.6588C123.579 95.6135 123.626 95.5481 123.649 95.4731L124.142 93.6676L126.036 93.8L125.566 95.4698C125.555 95.5179 125.553 95.5681 125.562 95.617C125.571 95.6658 125.59 95.7122 125.618 95.7531C125.646 95.7941 125.683 95.8286 125.725 95.8544C125.767 95.8802 125.815 95.8968 125.864 95.903L126.566 95.952C126.647 95.9597 126.728 95.939 126.795 95.8936C126.862 95.8482 126.912 95.7808 126.935 95.703L127.432 93.8977L129.536 94.0448C129.618 94.0522 129.7 94.0306 129.768 93.9839C129.836 93.9371 129.885 93.868 129.907 93.7887L130.096 93.097C130.11 93.0462 130.113 92.9928 130.104 92.9409C130.094 92.889 130.073 92.8398 130.043 92.797C130.012 92.7542 129.972 92.719 129.925 92.6938C129.879 92.6686 129.828 92.6542 129.775 92.6515L127.818 92.5147L128.586 89.7485L130.69 89.8956C130.772 89.903 130.854 89.8814 130.922 89.8347C130.989 89.7879 131.039 89.7188 131.061 89.6395L131.253 88.948C131.268 88.8961 131.27 88.8414 131.26 88.7883C131.25 88.7353 131.228 88.6852 131.196 88.642C131.164 88.5989 131.122 88.5637 131.073 88.5394C131.025 88.515 130.972 88.5021 130.918 88.5016ZM126.414 92.4166L124.52 92.2841L125.292 89.5181L127.186 89.6506L126.414 92.4166Z" fill="#0068A0"/> <rect x="138.037" y="88.8115" width="29" height="7" rx="1" transform="rotate(4 138.037 88.8115)" fill="#86D0F9"/> <g filter="url(#hashtagiconfilter2_ddd)"> <rect x="65.0557" y="21" width="80" height="91" rx="2" fill="white"/> </g> <g clip-path="url(#hashtagiconclip3)"> <rect x="65.0557" y="21" width="80" height="80" fill="#F6966B"/> <path d="M80.8025 49.333L144.136 112.666H28.3887L80.8025 49.333Z" fill="#F9BBA0"/> </g> <path d="M81.9327 96.187H79.9812L80.3328 94.4887C80.3414 94.4386 80.3391 94.3873 80.3261 94.3382C80.313 94.2892 80.2894 94.2435 80.257 94.2044C80.2246 94.1653 80.1841 94.1337 80.1383 94.1118C80.0925 94.0898 80.0425 94.078 79.9917 94.0773H79.2885C79.2072 94.0753 79.1277 94.1015 79.0636 94.1515C78.9995 94.2015 78.9547 94.2722 78.9368 94.3515L78.5782 96.187H76.6794L77.031 94.4887C77.0395 94.4398 77.0376 94.3896 77.0253 94.3415C77.013 94.2934 76.9907 94.2484 76.9598 94.2095C76.9289 94.1707 76.8902 94.1388 76.8461 94.116C76.802 94.0932 76.7535 94.08 76.704 94.0773H76.0007C75.9194 94.0753 75.84 94.1015 75.7759 94.1515C75.7117 94.2015 75.6669 94.2722 75.6491 94.3515L75.2974 96.187H73.1877C73.1054 96.1854 73.0252 96.2126 72.9609 96.264C72.8967 96.3154 72.8525 96.3877 72.836 96.4683L72.6919 97.1716C72.6813 97.2233 72.6825 97.2767 72.6954 97.3278C72.7083 97.379 72.7325 97.4266 72.7662 97.4671C72.8 97.5076 72.8425 97.54 72.8905 97.5619C72.9385 97.5838 72.9908 97.5946 73.0435 97.5936H74.995L74.4184 100.407H72.3086C72.2263 100.405 72.1461 100.432 72.0818 100.484C72.0176 100.535 71.9734 100.607 71.957 100.688L71.8128 101.391C71.8022 101.443 71.8034 101.496 71.8163 101.547C71.8292 101.599 71.8534 101.646 71.8872 101.687C71.9209 101.727 71.9634 101.76 72.0114 101.782C72.0594 101.803 72.1117 101.814 72.1644 101.813H74.13L73.7784 103.512C73.7696 103.562 73.7722 103.615 73.7858 103.664C73.7995 103.714 73.824 103.761 73.8576 103.8C73.8912 103.839 73.933 103.87 73.9801 103.892C74.0272 103.913 74.0784 103.924 74.13 103.923H74.8333C74.9116 103.921 74.9869 103.893 75.0474 103.843C75.1079 103.793 75.1501 103.725 75.1673 103.649L75.533 101.813H77.4318L77.0802 103.512C77.0717 103.56 77.0736 103.611 77.0859 103.659C77.0982 103.707 77.1205 103.752 77.1514 103.791C77.1823 103.829 77.221 103.861 77.2651 103.884C77.3092 103.907 77.3577 103.92 77.4072 103.923H78.1105C78.1918 103.925 78.2712 103.899 78.3354 103.849C78.3995 103.799 78.4443 103.728 78.4621 103.649L78.8313 101.813H80.9411C81.0234 101.815 81.1036 101.788 81.1679 101.736C81.2321 101.685 81.2763 101.612 81.2928 101.532L81.4334 100.829C81.444 100.777 81.4428 100.723 81.4299 100.672C81.417 100.621 81.3928 100.574 81.359 100.533C81.3253 100.493 81.2828 100.46 81.2348 100.438C81.1868 100.416 81.1345 100.406 81.0818 100.407H79.1197L79.6928 97.5936H81.8026C81.8849 97.5952 81.9651 97.568 82.0294 97.5166C82.0936 97.4652 82.1378 97.3929 82.1543 97.3123L82.2984 96.609C82.3093 96.5561 82.3079 96.5014 82.2942 96.4492C82.2806 96.3969 82.2551 96.3485 82.2197 96.3077C82.1844 96.2669 82.1401 96.2348 82.0903 96.2139C82.0405 96.193 81.9866 96.1838 81.9327 96.187ZM77.7132 100.407H75.8143L76.391 97.5936H78.2898L77.7132 100.407Z" fill="#FE544F"/> <rect x="89.0557" y="96" width="29" height="7" rx="1" fill="#FCE1D5"/> <g filter="url(#hashtagiconfilter3_ddd)"> <rect x="65.0557" y="21" width="80" height="91" rx="2" fill="white"/> </g> <g clip-path="url(#hashtagiconclip4)"> <rect x="65.0557" y="21" width="80" height="80" fill="#F6966B"/> <path d="M80.8025 49.333L144.136 112.666H28.3887L80.8025 49.333Z" fill="#F9BBA0"/> </g> <path d="M81.9327 96.187H79.9812L80.3328 94.4887C80.3414 94.4386 80.3391 94.3873 80.3261 94.3382C80.313 94.2892 80.2894 94.2435 80.257 94.2044C80.2246 94.1653 80.1841 94.1337 80.1383 94.1118C80.0925 94.0898 80.0425 94.078 79.9917 94.0773H79.2885C79.2072 94.0753 79.1277 94.1015 79.0636 94.1515C78.9995 94.2015 78.9547 94.2722 78.9368 94.3515L78.5782 96.187H76.6794L77.031 94.4887C77.0395 94.4398 77.0376 94.3896 77.0253 94.3415C77.013 94.2934 76.9907 94.2484 76.9598 94.2095C76.9289 94.1707 76.8902 94.1388 76.8461 94.116C76.802 94.0932 76.7535 94.08 76.704 94.0773H76.0007C75.9194 94.0753 75.84 94.1015 75.7759 94.1515C75.7117 94.2015 75.6669 94.2722 75.6491 94.3515L75.2974 96.187H73.1877C73.1054 96.1854 73.0252 96.2126 72.9609 96.264C72.8967 96.3154 72.8525 96.3877 72.836 96.4683L72.6919 97.1716C72.6813 97.2233 72.6825 97.2767 72.6954 97.3278C72.7083 97.379 72.7325 97.4266 72.7662 97.4671C72.8 97.5076 72.8425 97.54 72.8905 97.5619C72.9385 97.5838 72.9908 97.5946 73.0435 97.5936H74.995L74.4184 100.407H72.3086C72.2263 100.405 72.1461 100.432 72.0818 100.484C72.0176 100.535 71.9734 100.607 71.957 100.688L71.8128 101.391C71.8022 101.443 71.8034 101.496 71.8163 101.547C71.8292 101.599 71.8534 101.646 71.8872 101.687C71.9209 101.727 71.9634 101.76 72.0114 101.782C72.0594 101.803 72.1117 101.814 72.1644 101.813H74.13L73.7784 103.512C73.7696 103.562 73.7722 103.615 73.7858 103.664C73.7995 103.714 73.824 103.761 73.8576 103.8C73.8912 103.839 73.933 103.87 73.9801 103.892C74.0272 103.913 74.0784 103.924 74.13 103.923H74.8333C74.9116 103.921 74.9869 103.893 75.0474 103.843C75.1079 103.793 75.1501 103.725 75.1673 103.649L75.533 101.813H77.4318L77.0802 103.512C77.0717 103.56 77.0736 103.611 77.0859 103.659C77.0982 103.707 77.1205 103.752 77.1514 103.791C77.1823 103.829 77.221 103.861 77.2651 103.884C77.3092 103.907 77.3577 103.92 77.4072 103.923H78.1105C78.1918 103.925 78.2712 103.899 78.3354 103.849C78.3995 103.799 78.4443 103.728 78.4621 103.649L78.8313 101.813H80.9411C81.0234 101.815 81.1036 101.788 81.1679 101.736C81.2321 101.685 81.2763 101.612 81.2928 101.532L81.4334 100.829C81.444 100.777 81.4428 100.723 81.4299 100.672C81.417 100.621 81.3928 100.574 81.359 100.533C81.3253 100.493 81.2828 100.46 81.2348 100.438C81.1868 100.416 81.1345 100.406 81.0818 100.407H79.1197L79.6928 97.5936H81.8026C81.8849 97.5952 81.9651 97.568 82.0294 97.5166C82.0936 97.4652 82.1378 97.3929 82.1543 97.3123L82.2984 96.609C82.3093 96.5561 82.3079 96.5014 82.2942 96.4492C82.2806 96.3969 82.2551 96.3485 82.2197 96.3077C82.1844 96.2669 82.1401 96.2348 82.0903 96.2139C82.0405 96.193 81.9866 96.1838 81.9327 96.187ZM77.7132 100.407H75.8143L76.391 97.5936H78.2898L77.7132 100.407Z" fill="#FE544F"/> <rect x="89.0557" y="96" width="29" height="7" rx="1" fill="#FCE1D5"/> </g> <defs> <filter id="hashtagiconfilter0_ddd" x="100.114" y="5.45508" width="111.884" height="122.09" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="6"/> <feGaussianBlur stdDeviation="6.5"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="1"/> <feGaussianBlur stdDeviation="1"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="3"/> <feGaussianBlur stdDeviation="3"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> <filter id="hashtagiconfilter1_ddd" x="100.114" y="5.45508" width="111.884" height="122.09" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="6"/> <feGaussianBlur stdDeviation="6.5"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="1"/> <feGaussianBlur stdDeviation="1"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="3"/> <feGaussianBlur stdDeviation="3"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> <filter id="hashtagiconfilter2_ddd" x="52.0557" y="14" width="106" height="117" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="6"/> <feGaussianBlur stdDeviation="6.5"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="1"/> <feGaussianBlur stdDeviation="1"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="3"/> <feGaussianBlur stdDeviation="3"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> <filter id="hashtagiconfilter3_ddd" x="52.0557" y="14" width="106" height="117" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="6"/> <feGaussianBlur stdDeviation="6.5"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="1"/> <feGaussianBlur stdDeviation="1"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="3"/> <feGaussianBlur stdDeviation="3"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> <clipPath id="hashtagiconclip0"> <rect width="259.056" height="126" fill="white" transform="translate(0.0556641)"/> </clipPath> <clipPath id="hashtagiconclip1"> <path d="M119.211 13.9829C119.275 13.0647 120.072 12.3724 120.99 12.4366L197.47 17.7846C198.388 17.8488 199.08 18.6452 199.016 19.5634L194.528 83.7401L114.723 78.1595L119.211 13.9829Z" fill="white"/> </clipPath> <clipPath id="hashtagiconclip2"> <path d="M119.211 13.9829C119.275 13.0647 120.072 12.3724 120.99 12.4366L197.47 17.7846C198.388 17.8488 199.08 18.6452 199.016 19.5634L194.528 83.7401L114.723 78.1595L119.211 13.9829Z" fill="white"/> </clipPath> <clipPath id="hashtagiconclip3"> <path d="M65.0557 22.6667C65.0557 21.7462 65.8019 21 66.7223 21H143.389C144.309 21 145.056 21.7462 145.056 22.6667V87H65.0557V22.6667Z" fill="white"/> </clipPath> <clipPath id="hashtagiconclip4"> <path d="M65.0557 22.6667C65.0557 21.7462 65.8019 21 66.7223 21H143.389C144.309 21 145.056 21.7462 145.056 22.6667V87H65.0557V22.6667Z" fill="white"/> </clipPath> </defs> </svg>', 'taggedpostsIcon' => '<svg width="260" height="126" viewBox="0 0 260 126" fill="none" xmlns="http://www.w3.org/2000/svg"> <g clip-path="url(#taggedpostclip0)"> <g filter="url(#taggedpostfilter0_ddd)"> <g clip-path="url(#taggedpostclip1)"> <rect x="104.316" y="29.0303" width="83.0697" height="84.1212" rx="2.10303" transform="rotate(2 104.316 29.0303)" fill="white"/> <g clip-path="url(#taggedpostclip2)"> <path d="M104.063 23.0957L188.133 26.0315L185.418 103.796L101.348 100.86L104.063 23.0957Z" fill="#59AB46"/> <path d="M119.756 48.194L183.987 117.073L62.3516 112.826L119.756 48.194Z" fill="#76C064"/> </g> <path fill-rule="evenodd" clip-rule="evenodd" d="M113.109 94.8001C114.187 94.6246 115.292 94.7726 116.286 95.2254C117.279 95.6782 118.116 96.4154 118.691 97.3439C119.265 98.2723 119.552 99.3503 119.513 100.441L119.485 101.259C119.467 101.783 119.241 102.278 118.858 102.635C118.474 102.993 117.964 103.183 117.441 103.165C116.917 103.147 116.422 102.921 116.064 102.538C115.997 102.466 115.937 102.391 115.882 102.311C115.342 102.804 114.63 103.067 113.899 103.041C113.158 103.016 112.458 102.697 111.953 102.155C111.447 101.613 111.178 100.892 111.204 100.151C111.23 99.4107 111.549 98.7106 112.091 98.2052C112.633 97.6998 113.353 97.4304 114.094 97.4562C114.834 97.4821 115.535 97.8011 116.04 98.3431C116.545 98.8851 116.815 99.6057 116.789 100.346L116.76 101.164C116.753 101.362 116.826 101.556 116.961 101.701C117.097 101.847 117.285 101.932 117.483 101.939C117.682 101.946 117.875 101.874 118.021 101.738C118.166 101.603 118.252 101.415 118.259 101.216L118.287 100.399C118.317 99.55 118.094 98.7115 117.647 97.9894C117.201 97.2673 116.55 96.6939 115.777 96.3417C115.004 95.9896 114.144 95.8745 113.306 96.011C112.468 96.1475 111.689 96.5295 111.068 97.1086C110.447 97.6878 110.012 98.4381 109.817 99.2647C109.622 100.091 109.677 100.957 109.975 101.752C110.272 102.548 110.799 103.237 111.488 103.733C112.177 104.23 112.998 104.51 113.846 104.54L113.847 104.54C114.6 104.567 115.347 104.395 116.011 104.04C116.31 103.881 116.682 103.994 116.841 104.293C117.001 104.591 116.888 104.963 116.589 105.123C115.733 105.579 114.772 105.801 113.803 105.766L113.825 105.153L113.804 105.766C113.803 105.766 113.803 105.766 113.803 105.766C112.712 105.728 111.657 105.367 110.771 104.729C109.885 104.091 109.208 103.205 108.825 102.182C108.443 101.159 108.373 100.046 108.623 98.9835C108.873 97.9208 109.433 96.956 110.231 96.2114C111.03 95.4668 112.031 94.9757 113.109 94.8001ZM115.563 100.304C115.577 99.888 115.426 99.4838 115.143 99.1798C114.859 98.8757 114.466 98.6967 114.051 98.6822C113.636 98.6677 113.231 98.8189 112.927 99.1024C112.623 99.3859 112.444 99.7786 112.43 100.194C112.415 100.61 112.566 101.014 112.85 101.318C113.133 101.622 113.526 101.801 113.942 101.815C114.357 101.83 114.761 101.679 115.065 101.395C115.369 101.112 115.548 100.719 115.563 100.304Z" fill="#59AB46"/> <rect x="126.717" y="97.5381" width="30.4939" height="7.3606" rx="1.05151" transform="rotate(2 126.717 97.5381)" fill="#B6DDAD"/> </g> </g> <g filter="url(#taggedpostfilter1_ddd)"> <g clip-path="url(#taggedpostclip3)"> <rect x="70.8867" y="10.8984" width="83.0697" height="84.1212" rx="2.10303" transform="rotate(-2 70.8867 10.8984)" fill="white"/> <g clip-path="url(#taggedpostclip4)"> <path d="M70.2217 4.99609L154.292 2.06031L157.007 79.825L72.9373 82.7608L70.2217 4.99609Z" fill="#43A6DB"/> <circle cx="169.299" cy="72.169" r="48.8954" transform="rotate(-2 169.299 72.169)" fill="#0068A0"/> </g> <path fill-rule="evenodd" clip-rule="evenodd" d="M84.2452 75.8962C85.308 75.646 86.4211 75.7165 87.4438 76.0989C88.4665 76.4813 89.3529 77.1583 89.9908 78.0444C90.6287 78.9305 90.9895 79.9859 91.0276 81.0771L91.0562 81.8944C91.0745 82.4183 90.8839 82.928 90.5264 83.3114C90.1689 83.6947 89.6738 83.9204 89.1499 83.9387C88.626 83.957 88.1163 83.7664 87.733 83.4089C87.6615 83.3423 87.5956 83.2709 87.5354 83.1954C87.0315 83.7253 86.3396 84.0368 85.6081 84.0623C84.8674 84.0882 84.1468 83.8188 83.6048 83.3134C83.0628 82.8079 82.7438 82.1079 82.7179 81.3673C82.6921 80.6266 82.9615 79.906 83.4669 79.364C83.9723 78.822 84.6724 78.503 85.413 78.4771C86.1537 78.4513 86.8742 78.7207 87.4162 79.2261C87.9583 79.7315 88.2773 80.4316 88.3031 81.1722L88.3317 81.9896C88.3386 82.1883 88.4242 82.3761 88.5696 82.5117C88.715 82.6473 88.9084 82.7196 89.1071 82.7126C89.3058 82.7057 89.4936 82.6201 89.6292 82.4747C89.7648 82.3293 89.8371 82.136 89.8301 81.9372L89.8016 81.1199C89.772 80.2712 89.4913 79.4504 88.9952 78.7612C88.499 78.072 87.8096 77.5454 87.0142 77.248C86.2188 76.9506 85.353 76.8957 84.5264 77.0904C83.6998 77.285 82.9495 77.7204 82.3703 78.3415C81.7912 78.9625 81.4092 79.7414 81.2727 80.5796C81.1362 81.4177 81.2513 82.2776 81.6034 83.0503C81.9556 83.8231 82.529 84.474 83.2511 84.9209C83.9733 85.3678 84.8117 85.5905 85.6604 85.5608L85.661 85.5608C86.4142 85.5352 87.147 85.3114 87.7851 84.9114C88.0721 84.7314 88.4506 84.8182 88.6306 85.1052C88.8105 85.3922 88.7237 85.7708 88.4367 85.9507C87.6149 86.466 86.6715 86.754 85.7026 86.7869L85.6818 86.1738L85.7032 86.7868C85.703 86.7868 85.7028 86.7869 85.7026 86.7869C84.6116 86.8248 83.5339 86.5385 82.6056 85.9641C81.6771 85.3895 80.9399 84.5526 80.4871 83.559C80.0344 82.5655 79.8864 81.46 80.0619 80.3824C80.2374 79.3047 80.7285 78.3033 81.4731 77.5048C82.2178 76.7063 83.1825 76.1465 84.2452 75.8962ZM87.0771 81.215C87.0626 80.7996 86.8836 80.4069 86.5796 80.1233C86.2755 79.8398 85.8713 79.6887 85.4558 79.7032C85.0403 79.7177 84.6476 79.8966 84.3641 80.2007C84.0806 80.5047 83.9294 80.909 83.944 81.3245C83.9585 81.7399 84.1374 82.1326 84.4415 82.4162C84.7455 82.6997 85.1498 82.8508 85.5652 82.8363C85.9807 82.8218 86.3734 82.6429 86.657 82.3388C86.9405 82.0348 87.0916 81.6305 87.0771 81.215Z" fill="#0068A0"/> <rect x="98.0117" y="77.6768" width="30.4939" height="7.3606" rx="1.05151" transform="rotate(-2 98.0117 77.6768)" fill="#86D0F9"/> </g> </g> </g> <defs> <filter id="taggedpostfilter0_ddd" x="87.7112" y="21.6697" width="113.294" height="114.308" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="6.30909"/> <feGaussianBlur stdDeviation="6.83485"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="1.05151"/> <feGaussianBlur stdDeviation="1.05151"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="3.15454"/> <feGaussianBlur stdDeviation="3.15454"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> <filter id="taggedpostfilter1_ddd" x="57.217" y="0.638418" width="113.294" height="114.308" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="6.30909"/> <feGaussianBlur stdDeviation="6.83485"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="1.05151"/> <feGaussianBlur stdDeviation="1.05151"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="3.15454"/> <feGaussianBlur stdDeviation="3.15454"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> <clipPath id="taggedpostclip0"> <rect width="259.056" height="126" fill="white" transform="translate(0.111328)"/> </clipPath> <clipPath id="taggedpostclip1"> <rect x="104.316" y="29.0303" width="83.0697" height="84.1212" rx="2.10303" transform="rotate(2 104.316 29.0303)" fill="white"/> </clipPath> <clipPath id="taggedpostclip2"> <path d="M104.187 19.5933C104.221 18.626 105.032 17.8692 106 17.903L186.567 20.7164C187.534 20.7502 188.291 21.5617 188.257 22.529L185.896 90.1353L101.826 87.1995L104.187 19.5933Z" fill="white"/> </clipPath> <clipPath id="taggedpostclip3"> <rect x="70.8867" y="10.8984" width="83.0697" height="84.1212" rx="2.10303" transform="rotate(-2 70.8867 10.8984)" fill="white"/> </clipPath> <clipPath id="taggedpostclip4"> <path d="M70.0983 1.49365C70.0645 0.526345 70.8213 -0.285196 71.7886 -0.318975L152.356 -3.13244C153.323 -3.16622 154.134 -2.40945 154.168 -1.44214L156.529 66.1641L72.4591 69.0999L70.0983 1.49365Z" fill="white"/> </clipPath> </defs> </svg>', 'socialwall1Icon' => '<svg width="260" height="126" viewBox="0 0 260 126" fill="none" xmlns="http://www.w3.org/2000/svg"> <g filter="url(#social1filter0_ddd)"> <rect x="44.416" y="44.9111" width="42" height="42" rx="2.10303" transform="rotate(-5 44.416 44.9111)" fill="white"/> <path d="M66.2979 54.0796C60.8188 54.559 56.7273 59.4241 57.2092 64.933C57.645 69.914 61.6528 73.7292 66.48 74.0598L65.8699 67.0864L63.3395 67.3078L63.0868 64.4188L65.6171 64.1974L65.4245 61.9959C65.2057 59.4954 66.5698 57.9908 68.8511 57.7912C69.9369 57.6962 71.0892 57.7861 71.0892 57.7861L71.3044 60.2467L70.0492 60.3565C68.8139 60.4646 68.4925 61.2657 68.5614 62.0527L68.7252 63.9255L71.4947 63.6832L71.2991 66.6114L68.978 66.8145L69.5881 73.7878C71.9031 73.2117 73.9359 71.827 75.3195 69.8835C76.7031 67.9401 77.3464 65.566 77.1331 63.1899C76.6512 57.681 71.777 53.6003 66.2979 54.0796Z" fill="#006BFA"/> </g> <g filter="url(#social1filter1_ddd)"> <rect x="83.0967" y="39.1279" width="42" height="42" rx="2.10303" transform="rotate(-3 83.0967 39.1279)" fill="white"/> <path d="M104.886 53.6171C101.89 53.7741 99.6299 56.3334 99.7844 59.2824C99.9414 62.2783 102.454 64.5406 105.45 64.3836C108.399 64.229 110.708 61.7141 110.551 58.7182C110.396 55.7691 107.835 53.4625 104.886 53.6171ZM105.352 62.5111C103.432 62.6117 101.76 61.1504 101.657 59.1843C101.556 57.2651 103.02 55.6394 104.986 55.5363C106.905 55.4357 108.531 56.8995 108.632 58.8188C108.735 60.7848 107.271 62.4105 105.352 62.5111ZM111.71 53.0717C111.673 52.3695 111.082 51.8372 110.38 51.874C109.678 51.9108 109.146 52.502 109.182 53.2041C109.219 53.9063 109.81 54.4386 110.512 54.4018C111.215 54.365 111.747 53.7738 111.71 53.0717ZM115.334 54.1491C115.152 52.4688 114.699 50.9905 113.418 49.8372C112.137 48.6839 110.62 48.3879 108.93 48.3826C107.193 48.3798 101.997 48.6521 100.27 48.8365C98.5894 49.0184 97.1579 49.469 95.9578 50.7523C94.8045 52.0331 94.5085 53.5507 94.5032 55.2408C94.5003 56.9777 94.7726 62.1737 94.957 63.9008C95.139 65.5811 95.5895 67.0126 96.8728 68.2127C98.2005 69.3635 99.6712 69.662 101.361 69.6673C103.098 69.6701 108.294 69.3978 110.021 69.2134C111.702 69.0315 113.18 68.5785 114.333 67.2976C115.484 65.97 115.783 64.4992 115.788 62.8091C115.791 61.0722 115.518 55.8762 115.334 54.1491ZM113.637 64.7525C113.358 65.7059 112.646 66.4473 111.776 66.8684C110.401 67.5037 107.117 67.535 105.619 67.6135C104.074 67.6945 100.805 68.0066 99.418 67.516C98.4621 67.1906 97.7232 66.5252 97.2996 65.6087C96.6667 64.2806 96.6354 60.9965 96.5545 59.4517C96.476 57.9538 96.1638 54.6844 96.652 53.2506C96.9798 52.3416 97.6452 51.6026 98.5618 51.1791C99.8899 50.5462 103.174 50.5149 104.719 50.4339C106.217 50.3554 109.486 50.0433 110.92 50.5314C111.826 50.8125 112.568 51.5247 112.989 52.3944C113.624 53.7693 113.656 57.0534 113.734 58.5514C113.815 60.0961 114.127 63.3655 113.637 64.7525Z" fill="url(#social1paint0_linear)"/> </g> <g filter="url(#social1filter2_ddd)"> <rect x="122.913" y="35.2803" width="42" height="42" rx="2.10303" transform="rotate(2 122.913 35.2803)" fill="white"/> <path d="M153.831 51.3695C153.049 51.6924 152.211 51.8933 151.348 51.9732C152.246 51.4743 152.955 50.6585 153.31 49.6603C152.463 50.131 151.531 50.4487 150.555 50.6147C149.795 49.7277 148.704 49.1892 147.444 49.1453C145.096 49.0633 143.11 50.9151 143.027 53.2836C143.015 53.6234 143.044 53.9546 143.103 54.2669C139.551 53.9627 136.443 52.1432 134.425 49.4811C134.033 50.0978 133.797 50.83 133.77 51.6095C133.718 53.0986 134.421 54.444 135.555 55.234C134.845 55.2093 134.192 54.9863 133.623 54.6663L133.622 54.6963C133.55 56.775 134.968 58.5656 136.913 59.0238C136.278 59.1739 135.617 59.1748 134.982 59.0264C135.224 59.8878 135.729 60.6518 136.428 61.2111C137.126 61.7703 137.982 62.0966 138.875 62.1441C137.318 63.2909 135.417 63.8738 133.485 63.797C133.145 63.7851 132.806 63.7533 132.467 63.7014C134.323 64.987 136.557 65.7755 138.976 65.8599C146.851 66.1349 151.407 59.75 151.605 54.0835C151.611 53.8936 151.617 53.7137 151.614 53.5235C152.475 52.9531 153.221 52.2187 153.831 51.3695Z" fill="#1B90EF"/> </g> <g filter="url(#social1filter3_ddd)"> <rect x="161.295" y="39.9297" width="42" height="42" rx="2.10303" transform="rotate(3 161.295 39.9297)" fill="white"/> <path d="M179.013 64.8913L184.352 62.167L179.327 58.8995L179.013 64.8913ZM190.966 57.677C191.072 58.1532 191.129 58.7871 191.147 59.5891C191.175 60.3917 191.169 61.0823 191.137 61.6815L191.153 62.5235C191.038 64.7105 190.794 66.3099 190.461 67.3238C190.164 68.2095 189.555 68.7583 188.643 68.9609C188.167 69.0661 187.303 69.111 185.982 69.1018C184.68 69.1037 183.49 69.0714 182.391 69.0138L180.8 68.9905C176.616 68.7712 174.018 68.4748 173.004 68.1413C172.119 67.8446 171.57 67.235 171.367 66.3231C171.262 65.847 171.205 65.2131 171.187 64.4111C171.159 63.6085 171.165 62.9179 171.196 62.3187L171.181 61.4767C171.295 59.2897 171.539 57.6903 171.873 56.6764C172.169 55.7907 172.779 55.2418 173.691 55.0393C174.167 54.9341 175.031 54.8892 176.352 54.8984C177.654 54.8965 178.844 54.9288 179.942 54.9864L181.533 55.0097C185.717 55.229 188.315 55.5254 189.329 55.8589C190.215 56.1556 190.764 56.7652 190.966 57.677Z" fill="#EB2121"/> </g> <defs> <filter id="social1filter0_ddd" x="30.7463" y="33.8904" width="72.8401" height="72.8401" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="6.30909"/> <feGaussianBlur stdDeviation="6.83485"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="1.05151"/> <feGaussianBlur stdDeviation="1.05151"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="3.15454"/> <feGaussianBlur stdDeviation="3.15454"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> <filter id="social1filter1_ddd" x="69.427" y="29.5691" width="71.4799" height="71.4799" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="6.30909"/> <feGaussianBlur stdDeviation="6.83485"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="1.05151"/> <feGaussianBlur stdDeviation="1.05151"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="3.15454"/> <feGaussianBlur stdDeviation="3.15454"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> <filter id="social1filter2_ddd" x="107.778" y="27.9197" width="70.7796" height="70.7796" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="6.30909"/> <feGaussianBlur stdDeviation="6.83485"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="1.05151"/> <feGaussianBlur stdDeviation="1.05151"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="3.15454"/> <feGaussianBlur stdDeviation="3.15454"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> <filter id="social1filter3_ddd" x="145.427" y="32.5691" width="71.4799" height="71.4799" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"> <feFlood flood-opacity="0" result="BackgroundImageFix"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="6.30909"/> <feGaussianBlur stdDeviation="6.83485"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"/> <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="1.05151"/> <feGaussianBlur stdDeviation="1.05151"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.11 0"/> <feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"/> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/> <feOffset dy="3.15454"/> <feGaussianBlur stdDeviation="3.15454"/> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/> <feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"/> <feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"/> </filter> <linearGradient id="social1paint0_linear" x1="103.683" y1="88.8048" x2="145.491" y2="41.4018" gradientUnits="userSpaceOnUse"> <stop stop-color="white"/> <stop offset="0.147864" stop-color="#F6640E"/> <stop offset="0.443974" stop-color="#BA03A7"/> <stop offset="0.733337" stop-color="#6A01B9"/> <stop offset="1" stop-color="#6B01B9"/> </linearGradient> </defs> </svg>', 'chevronLeft' => '<svg width="6" height="8" viewBox="0 0 6 8" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M5.27301 0.94L4.33301 0L0.333008 4L4.33301 8L5.27301 7.06L2.21967 4L5.27301 0.94Z" fill="#434960"/></svg>', 'user' => '<svg width="8" height="8" viewBox="0 0 8 8" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M4 0C4.53043 0 5.03914 0.210714 5.41421 0.585786C5.78929 0.960859 6 1.46957 6 2C6 2.53043 5.78929 3.03914 5.41421 3.41421C5.03914 3.78929 4.53043 4 4 4C3.46957 4 2.96086 3.78929 2.58579 3.41421C2.21071 3.03914 2 2.53043 2 2C2 1.46957 2.21071 0.960859 2.58579 0.585786C2.96086 0.210714 3.46957 0 4 0ZM4 5C6.21 5 8 5.895 8 7V8H0V7C0 5.895 1.79 5 4 5Z"/></svg>', 'hashtag' => '<svg viewBox="0 0 18 18" fill="none"><path d="M17.3607 4.1775H14.0152L14.618 1.266C14.6328 1.18021 14.6288 1.09223 14.6064 1.00812C14.5839 0.924001 14.5436 0.845742 14.488 0.778722C14.4324 0.711703 14.363 0.657514 14.2845 0.619882C14.206 0.582251 14.1203 0.56207 14.0332 0.560727H12.8276C12.6883 0.557321 12.5521 0.602311 12.4422 0.688037C12.3323 0.773763 12.2555 0.894929 12.2249 1.03091L11.61 4.1775H8.3549L8.9577 1.266C8.97229 1.18215 8.96897 1.09617 8.94795 1.0137C8.92692 0.931226 8.88867 0.854142 8.83572 0.787518C8.78276 0.720894 8.71629 0.666239 8.64069 0.62715C8.56509 0.588061 8.48207 0.565423 8.3971 0.560727H7.1915C7.05216 0.557321 6.91594 0.602311 6.80604 0.688037C6.69613 0.773763 6.61933 0.894929 6.58871 1.03091L5.98591 4.1775H2.36914C2.22811 4.17466 2.09056 4.22136 1.98042 4.30947C1.87028 4.39759 1.79452 4.52153 1.76634 4.65974L1.51919 5.86533C1.50109 5.95393 1.50315 6.04546 1.52522 6.13316C1.5473 6.22085 1.58882 6.30245 1.64671 6.37192C1.7046 6.44139 1.77737 6.49694 1.85965 6.53446C1.94192 6.57199 2.03158 6.59052 2.12199 6.58869H5.46751L4.47892 11.4111H0.862146C0.721125 11.4082 0.583571 11.4549 0.473429 11.543C0.363287 11.6311 0.287532 11.7551 0.259351 11.8933L0.0122042 13.0989C-0.00589975 13.1875 -0.00383898 13.279 0.0182337 13.3667C0.0403064 13.4544 0.0818254 13.536 0.139715 13.6055C0.197605 13.6749 0.270382 13.7305 0.352656 13.768C0.43493 13.8055 0.524592 13.8241 0.615 13.8222H3.98463L3.38183 16.7338C3.36677 16.821 3.37112 16.9106 3.39459 16.996C3.41806 17.0814 3.46006 17.1606 3.51761 17.2279C3.57517 17.2953 3.64685 17.3491 3.72757 17.3856C3.80829 17.4221 3.89606 17.4403 3.98463 17.439H5.19022C5.3244 17.4356 5.45359 17.3875 5.55732 17.3023C5.66105 17.2171 5.73339 17.0998 5.76288 16.9688L6.38979 13.8222H9.64488L9.04209 16.7338C9.02749 16.8176 9.03081 16.9036 9.05184 16.9861C9.07286 17.0685 9.11111 17.1456 9.16407 17.2122C9.21702 17.2789 9.28349 17.3335 9.35909 17.3726C9.43469 17.4117 9.51771 17.4343 9.60269 17.439H10.8083C10.9476 17.4424 11.0838 17.3974 11.1937 17.3117C11.3037 17.226 11.3805 17.1048 11.4111 16.9688L12.044 13.8222H15.6608C15.8018 13.8251 15.9394 13.7784 16.0495 13.6903C16.1596 13.6022 16.2354 13.4782 16.2636 13.34L16.5047 12.1344C16.5228 12.0458 16.5207 11.9543 16.4987 11.8666C16.4766 11.7789 16.4351 11.6973 16.3772 11.6278C16.3193 11.5584 16.2465 11.5028 16.1642 11.4653C16.082 11.4278 15.9923 11.4092 15.9019 11.4111H12.5383L13.5209 6.58869H17.1376C17.2787 6.59153 17.4162 6.54483 17.5264 6.45672C17.6365 6.36861 17.7123 6.24466 17.7404 6.10645L17.9876 4.90086C18.0063 4.8102 18.0038 4.71645 17.9804 4.62689C17.957 4.53733 17.9133 4.45436 17.8527 4.3844C17.7921 4.31445 17.7162 4.2594 17.6308 4.22352C17.5455 4.18764 17.4531 4.1719 17.3607 4.1775ZM10.1271 11.4111H6.87202L7.86061 6.58869H11.1157L10.1271 11.4111Z"/></svg>', 'mention' => '<svg viewBox="0 0 18 18"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.24419 0.172937C8.99002 -0.174331 10.7996 0.00389957 12.4442 0.685088C14.0887 1.36628 15.4943 2.51983 16.4832 3.99987C17.4722 5.47992 18 7.21997 18 9.00001V10.3333C18 11.1879 17.6605 12.0075 17.0562 12.6118C16.452 13.2161 15.6324 13.5556 14.7778 13.5556C13.9232 13.5556 13.1036 13.2161 12.4993 12.6118C12.3867 12.4992 12.2833 12.3791 12.1896 12.2527C11.3384 13.0874 10.1933 13.5556 9.00001 13.5556C7.7918 13.5556 6.63307 13.0756 5.77874 12.2213C4.92441 11.3669 4.44445 10.2082 4.44445 9.00001C4.44445 7.7918 4.92441 6.63307 5.77874 5.77874C6.63307 4.92441 7.7918 4.44445 9.00001 4.44445C10.2082 4.44445 11.3669 4.92441 12.2213 5.77874C13.0756 6.63307 13.5556 7.7918 13.5556 9.00001V10.3333C13.5556 10.6575 13.6843 10.9684 13.9135 11.1976C14.1428 11.4268 14.4536 11.5556 14.7778 11.5556C15.1019 11.5556 15.4128 11.4268 15.642 11.1976C15.8712 10.9684 16 10.6575 16 10.3333V9.00001C16 7.61554 15.5895 6.26216 14.8203 5.11101C14.0511 3.95987 12.9579 3.06266 11.6788 2.53285C10.3997 2.00303 8.99224 1.86441 7.63437 2.13451C6.27651 2.4046 5.02922 3.07129 4.05026 4.05026C3.07129 5.02922 2.4046 6.27651 2.13451 7.63437C1.86441 8.99224 2.00303 10.3997 2.53285 11.6788C3.06266 12.9579 3.95987 14.0511 5.11101 14.8203C6.26216 15.5895 7.61554 16 9.00001 16L9.001 16C10.2297 16.0012 11.4363 15.6782 12.4987 15.0627C12.9766 14.7859 13.5884 14.9488 13.8653 15.4267C14.1421 15.9046 13.9792 16.5164 13.5013 16.7933C12.1329 17.586 10.5796 18.0016 8.99901 18L9.00001 17V18C8.99968 18 8.99934 18 8.99901 18C7.21933 17.9998 5.47964 17.472 3.99987 16.4832C2.51983 15.4943 1.36628 14.0887 0.685088 12.4442C0.00389957 10.7996 -0.17433 8.99002 0.172936 7.24419C0.520204 5.49836 1.37737 3.89472 2.63604 2.63604C3.89472 1.37737 5.49836 0.520204 7.24419 0.172937ZM11.5556 9.00001C11.5556 8.32223 11.2863 7.67221 10.8071 7.19295C10.3278 6.7137 9.67778 6.44445 9.00001 6.44445C8.32223 6.44445 7.67221 6.7137 7.19295 7.19295C6.7137 7.67221 6.44445 8.32223 6.44445 9.00001C6.44445 9.67778 6.7137 10.3278 7.19295 10.8071C7.67221 11.2863 8.32223 11.5556 9.00001 11.5556C9.67778 11.5556 10.3278 11.2863 10.8071 10.8071C11.2863 10.3278 11.5556 9.67778 11.5556 9.00001Z"/></svg>', 'tooltipHelpSvg' => '<svg width="20" height="21" viewBox="0 0 20 21" fill="#0068A0" xmlns="http://www.w3.org/2000/svg"><path d="M9.1665 8H10.8332V6.33333H9.1665V8ZM9.99984 17.1667C6.32484 17.1667 3.33317 14.175 3.33317 10.5C3.33317 6.825 6.32484 3.83333 9.99984 3.83333C13.6748 3.83333 16.6665 6.825 16.6665 10.5C16.6665 14.175 13.6748 17.1667 9.99984 17.1667ZM9.99984 2.16666C8.90549 2.16666 7.82186 2.38221 6.81081 2.801C5.79976 3.21979 4.8811 3.83362 4.10728 4.60744C2.54448 6.17024 1.6665 8.28986 1.6665 10.5C1.6665 12.7101 2.54448 14.8298 4.10728 16.3926C4.8811 17.1664 5.79976 17.7802 6.81081 18.199C7.82186 18.6178 8.90549 18.8333 9.99984 18.8333C12.21 18.8333 14.3296 17.9554 15.8924 16.3926C17.4552 14.8298 18.3332 12.7101 18.3332 10.5C18.3332 9.40565 18.1176 8.32202 17.6988 7.31097C17.28 6.29992 16.6662 5.38126 15.8924 4.60744C15.1186 3.83362 14.1999 3.21979 13.1889 2.801C12.1778 2.38221 11.0942 2.16666 9.99984 2.16666ZM9.1665 14.6667H10.8332V9.66666H9.1665V14.6667Z" fill="#0068A0"/></svg>', 'defaultFTIcon' => '<svg width="262" height="200" viewBox="0 0 262 200" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="262" height="200" fill="#F3F4F5"/><g filter="url(#filter0_dd_422_37685)"><rect x="21.2236" y="27.9756" width="219.552" height="149.357" rx="1.69724" fill="white"/><g clip-path="url(#clip0_422_37685)"><rect x="36.8457" y="50.9315" width="58.7049" height="31.3967" rx="1" fill="#43A6DB"/><circle cx="42.0268" cy="85.3159" r="20.1274" fill="#86D0F9"/></g><rect x="49.2236" y="86.3282" width="33.9482" height="3.26153" rx="0.606218" fill="#D0D1D7"/><rect x="58.9229" y="91.8324" width="14.5492" height="3.26153" rx="0.606218" fill="#D0D1D7"/><g clip-path="url(#clip1_422_37685)"><rect x="100.582" y="50.9315" width="58.7049" height="31.3967" rx="1" fill="#43A6DB"/><rect x="136.366" y="64.2975" width="36.0616" height="36.0616" transform="rotate(30 136.366 64.2975)" fill="#86D0F9"/></g><rect x="112.96" y="86.3282" width="33.9482" height="3.26153" rx="0.606218" fill="#D0D1D7"/><rect x="122.659" y="91.8324" width="14.5492" height="3.26153" rx="0.606218" fill="#D0D1D7"/><rect x="164.319" y="50.9315" width="58.7049" height="31.3967" rx="1" fill="#43A6DB"/><rect x="176.697" y="86.3282" width="33.9482" height="3.26153" rx="0.606218" fill="#D0D1D7"/><rect x="186.396" y="91.8324" width="14.5492" height="3.26153" rx="0.606218" fill="#D0D1D7"/><rect x="36.8457" y="109.264" width="58.7049" height="31.3967" rx="1" fill="#43A6DB"/><rect x="49.2236" y="144.661" width="33.9482" height="3.26153" rx="0.606218" fill="#D0D1D7"/><rect x="58.9229" y="150.165" width="14.5492" height="3.26153" rx="0.606218" fill="#D0D1D7"/><g clip-path="url(#clip2_422_37685)"><rect x="100.582" y="109.264" width="58.7049" height="31.3967" rx="1" fill="#43A6DB"/><rect x="91.4648" y="112.674" width="36.0616" height="36.0616" transform="rotate(30 91.4648 112.674)" fill="#86D0F9"/></g><rect x="112.96" y="144.661" width="33.9482" height="3.26153" rx="0.606218" fill="#D0D1D7"/><rect x="122.659" y="150.165" width="14.5492" height="3.26153" rx="0.606218" fill="#D0D1D7"/><g clip-path="url(#clip3_422_37685)"><rect x="164.319" y="109.264" width="58.7049" height="31.3967" rx="1" fill="#43A6DB"/><circle cx="169.028" cy="143.318" r="20.1274" fill="#86D0F9"/></g><rect x="176.697" y="144.661" width="33.9482" height="3.26153" rx="0.606218" fill="#D0D1D7"/><rect x="186.396" y="150.165" width="14.5492" height="3.26153" rx="0.606218" fill="#D0D1D7"/></g><defs><filter id="filter0_dd_422_37685" x="16.9805" y="27.127" width="228.038" height="157.843" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="3.39448"/><feGaussianBlur stdDeviation="2.12155"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_422_37685"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.84862"/><feGaussianBlur stdDeviation="0.84862"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_422_37685" result="effect2_dropShadow_422_37685"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_422_37685" result="shape"/></filter><clipPath id="clip0_422_37685"><rect x="36.8457" y="50.9315" width="58.7049" height="31.3967" rx="1" fill="white"/></clipPath><clipPath id="clip1_422_37685"><rect x="100.582" y="50.9315" width="58.7049" height="31.3967" rx="1" fill="white"/></clipPath><clipPath id="clip2_422_37685"><rect x="100.582" y="109.264" width="58.7049" height="31.3967" rx="1" fill="white"/></clipPath><clipPath id="clip3_422_37685"><rect x="164.319" y="109.264" width="58.7049" height="31.3967" rx="1" fill="white"/></clipPath></defs></svg>', 'carouselFTIcon' => '<svg width="263" height="200" viewBox="0 0 263 200" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="262" height="200" transform="translate(0.5)" fill="#F3F4F5"/><g filter="url(#filter0_dd_422_37727)"><rect x="19.3018" y="33.665" width="224.397" height="136.67" rx="1.7347" fill="white"/><g clip-path="url(#clip0_422_37727)"><rect width="59.4694" height="31.8056" transform="translate(36.5723 77.9906)" fill="#F9BBA0"/><circle cx="41.8212" cy="112.823" r="20.3895" fill="#F6966B"/></g><rect x="49.1113" y="113.796" width="34.3904" height="3.304" rx="0.614114" fill="#D0D1D7"/><rect x="58.9375" y="119.372" width="14.7387" height="3.304" rx="0.614114" fill="#D0D1D7"/><rect width="59.4694" height="31.8056" transform="translate(101.139 77.9906)" fill="#F9BBA0"/><rect x="113.678" y="113.796" width="34.3904" height="3.304" rx="0.614114" fill="#D0D1D7"/><rect x="123.504" y="119.372" width="14.7387" height="3.304" rx="0.614114" fill="#D0D1D7"/><g clip-path="url(#clip1_422_37727)"><rect width="59.4694" height="31.8056" transform="translate(165.706 77.9906)" fill="#F9BBA0"/><rect x="205.362" y="89.8845" width="36.5312" height="36.5312" transform="rotate(30 205.362 89.8845)" fill="#F6966B"/></g><rect x="178.245" y="113.796" width="34.3904" height="3.304" rx="0.614114" fill="#D0D1D7"/><rect x="188.071" y="119.372" width="14.7387" height="3.304" rx="0.614114" fill="#D0D1D7"/><circle cx="113.033" cy="143.407" r="2.54869" fill="#434960"/><circle cx="122.378" cy="143.407" r="2.54869" fill="#D0D1D7"/><circle cx="131.723" cy="143.407" r="2.54869" fill="#D0D1D7"/><circle cx="141.068" cy="143.407" r="2.54869" fill="#D0D1D7"/><circle cx="150.414" cy="143.407" r="2.54869" fill="#D0D1D7"/><path d="M39.3018 66.5037H40.957L42.525 60.8587H42.6179L44.2034 66.5037H45.8469L48.0712 58.1234H46.2593L44.9642 64.1109H44.8713L43.3148 58.1234H41.8339L40.3065 64.1109H40.2136L38.9069 58.1234H37.0833L39.3018 66.5037ZM51.3063 66.6372C53.1763 66.6372 54.001 65.557 54.1984 64.7556L54.2101 64.6975H52.6304L52.613 64.7324C52.4968 64.9763 52.0845 65.3712 51.3411 65.3712C50.441 65.3712 49.8776 64.7614 49.8602 63.7102H54.2623V63.1817C54.2623 61.2478 53.1008 59.9702 51.2366 59.9702C49.3724 59.9702 48.1818 61.2769 48.1818 63.3095V63.3153C48.1818 65.3654 49.3607 66.6372 51.3063 66.6372ZM51.2656 61.242C52.0032 61.242 52.5317 61.7182 52.6362 62.6474H49.8776C49.9822 61.7415 50.5281 61.242 51.2656 61.242ZM59.9832 66.6024C60.8195 66.6024 61.4932 66.2481 61.8184 65.6558H61.923V66.5037H63.5955V62.1364C63.5955 60.7716 62.6373 59.9702 60.9415 59.9702C59.3328 59.9702 58.2758 60.7135 58.1422 61.8344L58.1364 61.8867H59.7045L59.7161 61.8634C59.8497 61.4859 60.2388 61.2711 60.8486 61.2711C61.5455 61.2711 61.923 61.5847 61.923 62.1364V62.6649L60.3782 62.7578C58.7869 62.8507 57.8983 63.5244 57.8983 64.6743V64.6859C57.8983 65.8474 58.7637 66.6024 59.9832 66.6024ZM59.5535 64.5814V64.5697C59.5535 64.1051 59.9077 63.8322 60.6337 63.7857L61.923 63.7044V64.1748C61.923 64.8485 61.3364 65.3654 60.5524 65.3654C59.9658 65.3654 59.5535 65.0692 59.5535 64.5814ZM65.0186 66.5037H66.7144V62.9262C66.7144 62.0202 67.3242 61.4685 68.2883 61.4685C68.5496 61.4685 68.811 61.5092 69.0665 61.5672V60.0863C68.8981 60.0398 68.66 60.005 68.4335 60.005C67.603 60.005 67.0222 60.4115 66.819 61.1026H66.7144V60.1095H65.0186V66.5037ZM72.621 66.6372C74.491 66.6372 75.3157 65.557 75.5131 64.7556L75.5247 64.6975H73.9451L73.9277 64.7324C73.8115 64.9763 73.3992 65.3712 72.6558 65.3712C71.7556 65.3712 71.1923 64.7614 71.1749 63.7102H75.577V63.1817C75.577 61.2478 74.4155 59.9702 72.5513 59.9702C70.687 59.9702 69.4965 61.2769 69.4965 63.3095V63.3153C69.4965 65.3654 70.6754 66.6372 72.621 66.6372ZM72.5803 61.242C73.3179 61.242 73.8464 61.7182 73.9509 62.6474H71.1923C71.2968 61.7415 71.8427 61.242 72.5803 61.242ZM82.3955 66.6372C84.3643 66.6372 85.549 65.3944 85.549 63.3095V63.2979C85.549 61.2304 84.3469 59.9702 82.3955 59.9702C80.4442 59.9702 79.242 61.2362 79.242 63.2979V63.3095C79.242 65.3886 80.4268 66.6372 82.3955 66.6372ZM82.3955 65.3073C81.4896 65.3073 80.9785 64.5697 80.9785 63.3095V63.2979C80.9785 62.0493 81.4954 61.3001 82.3955 61.3001C83.2899 61.3001 83.8126 62.0493 83.8126 63.2979V63.3095C83.8126 64.5697 83.2957 65.3073 82.3955 65.3073ZM86.6934 66.5037H88.3892V62.8042C88.3892 61.9389 88.8654 61.3756 89.6494 61.3756C90.4509 61.3756 90.8225 61.8518 90.8225 62.752V66.5037H92.5184V62.3687C92.5184 60.8413 91.7518 59.9702 90.3289 59.9702C89.4171 59.9702 88.7841 60.4057 88.4937 61.0968H88.3892V60.1095H86.6934V66.5037ZM99.2382 66.5037H100.992V63.3734L103.913 58.1234H102.014L100.173 61.6485H100.069L98.2218 58.1234H96.3228L99.2382 63.3734V66.5037ZM106.637 66.6372C108.606 66.6372 109.791 65.3944 109.791 63.3095V63.2979C109.791 61.2304 108.589 59.9702 106.637 59.9702C104.686 59.9702 103.484 61.2362 103.484 63.2979V63.3095C103.484 65.3886 104.668 66.6372 106.637 66.6372ZM106.637 65.3073C105.731 65.3073 105.22 64.5697 105.22 63.3095V63.2979C105.22 62.0493 105.737 61.3001 106.637 61.3001C107.532 61.3001 108.054 62.0493 108.054 63.2979V63.3095C108.054 64.5697 107.537 65.3073 106.637 65.3073ZM113.049 66.6372C113.961 66.6372 114.611 66.2133 114.902 65.5164H115.006V66.5037H116.702V60.1095H115.006V63.8031C115.006 64.6685 114.553 65.2318 113.717 65.2318C112.915 65.2318 112.573 64.7614 112.573 63.8554V60.1095H110.877V64.2445C110.877 65.7661 111.615 66.6372 113.049 66.6372ZM119.67 66.5037H121.424V59.5694H123.938V58.1234H117.155V59.5694H119.67V66.5037ZM126.581 66.6372C127.493 66.6372 128.143 66.2133 128.434 65.5164H128.538V66.5037H130.234V60.1095H128.538V63.8031C128.538 64.6685 128.085 65.2318 127.249 65.2318C126.448 65.2318 126.105 64.7614 126.105 63.8554V60.1095H124.409V64.2445C124.409 65.7661 125.147 66.6372 126.581 66.6372ZM135.473 66.6024C137.07 66.6024 138.069 65.3538 138.069 63.3095V63.2979C138.069 61.242 137.093 60.005 135.473 60.005C134.596 60.005 133.881 60.4348 133.556 61.1317H133.452V57.6646H131.756V66.5037H133.452V65.5106H133.556C133.887 66.2017 134.567 66.6024 135.473 66.6024ZM134.892 65.197C133.998 65.197 133.434 64.4884 133.434 63.3153V63.3037C133.434 62.1306 134.003 61.4104 134.892 61.4104C135.786 61.4104 136.344 62.1306 136.344 63.2979V63.3095C136.344 64.4884 135.792 65.197 134.892 65.197ZM142.018 66.6372C143.888 66.6372 144.713 65.557 144.91 64.7556L144.922 64.6975H143.342L143.325 64.7324C143.209 64.9763 142.796 65.3712 142.053 65.3712C141.153 65.3712 140.589 64.7614 140.572 63.7102H144.974V63.1817C144.974 61.2478 143.813 59.9702 141.948 59.9702C140.084 59.9702 138.894 61.2769 138.894 63.3095V63.3153C138.894 65.3654 140.073 66.6372 142.018 66.6372ZM141.977 61.242C142.715 61.242 143.243 61.7182 143.348 62.6474H140.589C140.694 61.7415 141.24 61.242 141.977 61.242ZM146.618 63.7393H148.168L148.325 58.1175H146.467L146.618 63.7393ZM147.396 66.6721C148.052 66.6721 148.453 66.3004 148.453 65.7022C148.453 65.0982 148.052 64.7265 147.396 64.7265C146.746 64.7265 146.339 65.0982 146.339 65.7022C146.339 66.3004 146.746 66.6721 147.396 66.6721Z" fill="#141B38"/></g><defs><filter id="filter0_dd_422_37727" x="14.965" y="32.7977" width="233.071" height="145.343" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="3.46939"/><feGaussianBlur stdDeviation="2.16837"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_422_37727"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.867348"/><feGaussianBlur stdDeviation="0.867348"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_422_37727" result="effect2_dropShadow_422_37727"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_422_37727" result="shape"/></filter><clipPath id="clip0_422_37727"><rect width="59.4694" height="31.8056" fill="white" transform="translate(36.5723 77.9906)"/></clipPath><clipPath id="clip1_422_37727"><rect width="59.4694" height="31.8056" fill="white" transform="translate(165.706 77.9906)"/></clipPath></defs></svg>', 'cardsFTIcon' => '<svg width="262" height="200" viewBox="0 0 262 200" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="262" height="200" fill="#F3F4F5"/><g filter="url(#filter0_dd_422_37758)"><rect x="27.8926" y="39.8103" width="66.0717" height="57.1896" rx="1.58003" fill="white"/><rect x="29.8926" y="41.8103" width="62.0717" height="35.3267" rx="0.841113" fill="#B6DDAD"/><rect x="41.8301" y="82.1371" width="38.1977" height="3.66978" rx="0.682101" fill="#D0D1D7"/><rect x="52.7432" y="88.3302" width="16.3704" height="3.66978" rx="0.682101" fill="#D0D1D7"/></g><g filter="url(#filter1_dd_422_37758)"><rect x="97.9639" y="39.8103" width="66.0717" height="57.1896" rx="1.58003" fill="white"/><g clip-path="url(#clip0_422_37758)"><rect x="99.9639" y="41.8103" width="62.0717" height="35.3267" rx="0.841113" fill="#B6DDAD"/><circle cx="161.321" cy="93.5387" r="39.1117" fill="#96CE89"/></g><rect x="111.901" y="82.1371" width="38.1977" height="3.66978" rx="0.682101" fill="#D0D1D7"/><rect x="122.814" y="88.3302" width="16.3704" height="3.66978" rx="0.682101" fill="#D0D1D7"/></g><g filter="url(#filter2_dd_422_37758)"><rect x="168.036" y="39.8103" width="66.0717" height="57.1896" rx="1.58003" fill="white"/><g clip-path="url(#clip1_422_37758)"><rect x="170.036" y="41.8103" width="62.0717" height="35.3267" rx="0.841113" fill="#B6DDAD"/><circle cx="231.393" cy="93.5387" r="39.1117" fill="#96CE89"/></g><rect x="181.974" y="82.1371" width="38.1977" height="3.66978" rx="0.682101" fill="#D0D1D7"/><rect x="192.887" y="88.3302" width="16.3704" height="3.66978" rx="0.682101" fill="#D0D1D7"/></g><g filter="url(#filter3_dd_422_37758)"><rect x="27.8926" y="103" width="66.0717" height="57.1896" rx="1.58003" fill="white"/><g clip-path="url(#clip2_422_37758)"><rect x="29.8926" y="105" width="62.0717" height="35.3267" rx="0.841113" fill="#B6DDAD"/><rect x="37.042" y="152.753" width="46.2612" height="46.2612" transform="rotate(-45 37.042 152.753)" fill="#96CE89"/></g><rect x="41.8301" y="145.327" width="38.1977" height="3.66978" rx="0.682101" fill="#D0D1D7"/><rect x="52.7432" y="151.52" width="16.3704" height="3.66978" rx="0.682101" fill="#D0D1D7"/></g><g filter="url(#filter4_dd_422_37758)"><rect x="97.9639" y="103" width="66.0717" height="57.1896" rx="1.58003" fill="white"/><rect x="99.9639" y="105" width="62.0717" height="35.3267" rx="0.841113" fill="#B6DDAD"/><rect x="111.901" y="145.327" width="38.1977" height="3.66978" rx="0.682101" fill="#D0D1D7"/><rect x="122.814" y="151.52" width="16.3704" height="3.66978" rx="0.682101" fill="#D0D1D7"/></g><g filter="url(#filter5_dd_422_37758)"><rect x="168.036" y="103" width="66.0717" height="57.1896" rx="1.58003" fill="white"/><rect x="170.036" y="105" width="62.0717" height="35.3267" rx="0.841113" fill="#B6DDAD"/><rect x="181.974" y="145.327" width="38.1977" height="3.66978" rx="0.682101" fill="#D0D1D7"/><rect x="192.887" y="151.52" width="16.3704" height="3.66978" rx="0.682101" fill="#D0D1D7"/></g><defs><filter id="filter0_dd_422_37758" x="23.9425" y="39.0203" width="73.9715" height="65.0899" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="3.16007"/><feGaussianBlur stdDeviation="1.97504"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_422_37758"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.790017"/><feGaussianBlur stdDeviation="0.790017"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_422_37758" result="effect2_dropShadow_422_37758"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_422_37758" result="shape"/></filter><filter id="filter1_dd_422_37758" x="94.0138" y="39.0203" width="73.9715" height="65.0899" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="3.16007"/><feGaussianBlur stdDeviation="1.97504"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_422_37758"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.790017"/><feGaussianBlur stdDeviation="0.790017"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_422_37758" result="effect2_dropShadow_422_37758"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_422_37758" result="shape"/></filter><filter id="filter2_dd_422_37758" x="164.086" y="39.0203" width="73.9715" height="65.0899" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="3.16007"/><feGaussianBlur stdDeviation="1.97504"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_422_37758"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.790017"/><feGaussianBlur stdDeviation="0.790017"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_422_37758" result="effect2_dropShadow_422_37758"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_422_37758" result="shape"/></filter><filter id="filter3_dd_422_37758" x="23.9425" y="102.21" width="73.9715" height="65.0899" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="3.16007"/><feGaussianBlur stdDeviation="1.97504"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_422_37758"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.790017"/><feGaussianBlur stdDeviation="0.790017"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_422_37758" result="effect2_dropShadow_422_37758"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_422_37758" result="shape"/></filter><filter id="filter4_dd_422_37758" x="94.0138" y="102.21" width="73.9715" height="65.0899" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="3.16007"/><feGaussianBlur stdDeviation="1.97504"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_422_37758"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.790017"/><feGaussianBlur stdDeviation="0.790017"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_422_37758" result="effect2_dropShadow_422_37758"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_422_37758" result="shape"/></filter><filter id="filter5_dd_422_37758" x="164.086" y="102.21" width="73.9715" height="65.0899" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="3.16007"/><feGaussianBlur stdDeviation="1.97504"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_422_37758"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.790017"/><feGaussianBlur stdDeviation="0.790017"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_422_37758" result="effect2_dropShadow_422_37758"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_422_37758" result="shape"/></filter><clipPath id="clip0_422_37758"><rect x="99.9639" y="41.8103" width="62.0717" height="35.3267" rx="0.841113" fill="white"/></clipPath><clipPath id="clip1_422_37758"><rect x="170.036" y="41.8103" width="62.0717" height="35.3267" rx="0.841113" fill="white"/></clipPath><clipPath id="clip2_422_37758"><rect x="29.8926" y="105" width="62.0717" height="35.3267" rx="0.841113" fill="white"/></clipPath></defs></svg>', 'listFTIcon' => '<svg width="263" height="200" viewBox="0 0 263 200" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_422_37797)"><rect width="262" height="200" transform="translate(0.5)" fill="#F3F4F5"/><g filter="url(#filter0_dd_422_37797)"><g clip-path="url(#clip1_422_37797)"><rect x="32" y="23" width="198" height="197" rx="1.8785" fill="white"/><circle cx="53" cy="47" r="12" fill="#86D0F9"/><rect x="74" y="36" width="43" height="5" rx="1" fill="#8C8F9A"/><rect x="74" y="45" width="73" height="5" rx="1" fill="#DCDDE1"/><rect x="74" y="53" width="49" height="5" rx="1" fill="#DCDDE1"/><g clip-path="url(#clip2_422_37797)"><rect x="41" y="177.5" width="177" height="77" rx="1" fill="#43A6DB"/></g><g clip-path="url(#clip3_422_37797)"><rect x="41" y="70" width="177" height="77" rx="1" fill="#43A6DB"/><circle cx="59.5" cy="189.5" r="79.5" fill="#86D0F9"/><rect x="123.571" y="102.857" width="14.1429" height="11.5714" fill="white"/><path d="M126.999 112.5L134.784 108L126.999 103.5V112.5ZM144.339 100.755C144.534 101.46 144.669 102.405 144.759 103.605C144.864 104.805 144.909 105.84 144.909 106.74L144.999 108C144.999 111.285 144.759 113.7 144.339 115.245C143.964 116.595 143.094 117.465 141.744 117.84C141.039 118.035 139.749 118.17 137.769 118.26C135.819 118.365 134.034 118.41 132.384 118.41L129.999 118.5C123.714 118.5 119.799 118.26 118.254 117.84C116.904 117.465 116.034 116.595 115.659 115.245C115.464 114.54 115.329 113.595 115.239 112.395C115.134 111.195 115.089 110.16 115.089 109.26L114.999 108C114.999 104.715 115.239 102.3 115.659 100.755C116.034 99.4051 116.904 98.5351 118.254 98.1601C118.959 97.9651 120.249 97.8301 122.229 97.7401C124.179 97.6351 125.964 97.5901 127.614 97.5901L129.999 97.5001C136.284 97.5001 140.199 97.7401 141.744 98.1601C143.094 98.5351 143.964 99.4051 144.339 100.755Z" fill="#004D77"/></g><rect x="91.5" y="154" width="76" height="4" rx="1" fill="#DCDDE1"/><rect x="106" y="161" width="47" height="4" rx="1" fill="#DCDDE1"/></g></g></g><defs><filter id="filter0_dd_422_37797" x="27" y="22" width="208" height="207" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4"/><feGaussianBlur stdDeviation="2.5"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_422_37797"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1"/><feGaussianBlur stdDeviation="1"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_422_37797" result="effect2_dropShadow_422_37797"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_422_37797" result="shape"/></filter><clipPath id="clip0_422_37797"><rect width="262" height="200" fill="white" transform="translate(0.5)"/></clipPath><clipPath id="clip1_422_37797"><rect x="32" y="23" width="198" height="197" rx="1.8785" fill="white"/></clipPath><clipPath id="clip2_422_37797"><rect x="41" y="177.5" width="177" height="77" rx="1" fill="white"/></clipPath><clipPath id="clip3_422_37797"><rect x="41" y="70" width="177" height="77" rx="1" fill="white"/></clipPath></defs></svg>', 'galleryFTIcon' => '<svg width="262" height="200" viewBox="0 0 262 200" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="262" height="200" fill="#F3F4F5"/><g filter="url(#filter0_dd_422_37828)"><g clip-path="url(#clip0_422_37828)"><rect x="30.25" y="17" width="201" height="165.308" rx="1.8785" fill="white"/><g clip-path="url(#clip1_422_37828)"><rect width="156" height="66" transform="translate(53.25 34)" fill="#F9BBA0"/><circle cx="175" cy="149" r="91" fill="#F6966B"/><rect x="126.339" y="62.0713" width="10.8041" height="8.83974" fill="white"/><path d="M128.957 69.4377L134.904 66L128.957 62.5623V69.4377ZM142.204 60.4653C142.353 61.0039 142.456 61.7258 142.525 62.6425C142.605 63.5593 142.639 64.3499 142.639 65.0375L142.708 66C142.708 68.5095 142.525 70.3544 142.204 71.5347C141.917 72.566 141.253 73.2306 140.221 73.5171C139.683 73.666 138.697 73.7692 137.185 73.8379C135.695 73.9181 134.331 73.9525 133.071 73.9525L131.249 74.0213C126.448 74.0213 123.457 73.8379 122.277 73.5171C121.245 73.2306 120.581 72.566 120.294 71.5347C120.145 70.9961 120.042 70.2742 119.973 69.3575C119.893 68.4408 119.859 67.6501 119.859 66.9626L119.79 66C119.79 63.4905 119.973 61.6456 120.294 60.4653C120.581 59.434 121.245 58.7694 122.277 58.483C122.815 58.334 123.801 58.2309 125.313 58.1621C126.803 58.0819 128.167 58.0475 129.427 58.0475L131.249 57.9788C136.05 57.9788 139.041 58.1621 140.221 58.483C141.253 58.7694 141.917 59.434 142.204 60.4653Z" fill="#7B180E"/></g><rect x="90.7842" y="106" width="80.9307" height="4" rx="0.810951" fill="#DCDDE1"/><rect x="106.172" y="113" width="50.1561" height="4" rx="0.810951" fill="#DCDDE1"/><rect width="48.1013" height="28.6347" transform="translate(53.25 175.004)" fill="#F9BBA0"/><rect width="48.1013" height="28.6347" transform="translate(106.88 175.004)" fill="#F9BBA0"/><rect width="48.1013" height="28.6347" transform="translate(160.511 175.004)" fill="#F9BBA0"/><rect width="48.1013" height="28.6347" transform="translate(53.25 126.735)" fill="#F9BBA0"/><rect x="61.8193" y="158.37" width="30.9618" height="2.9746" rx="0.810951" fill="#D0D1D7"/><rect x="70.666" y="163.344" width="13.2693" height="2.9746" rx="0.810951" fill="#D0D1D7"/><rect width="48.1013" height="28.6347" transform="translate(106.88 126.735)" fill="#F9BBA0"/><rect x="115.449" y="158.37" width="30.9618" height="2.9746" rx="0.810951" fill="#D0D1D7"/><rect x="124.296" y="163.344" width="13.2693" height="2.9746" rx="0.810951" fill="#D0D1D7"/><rect width="48.1013" height="28.6347" transform="translate(160.511 126.735)" fill="#F9BBA0"/><rect x="169.08" y="158.37" width="30.9618" height="2.9746" rx="0.810951" fill="#D0D1D7"/><rect x="177.927" y="163.344" width="13.2693" height="2.9746" rx="0.810951" fill="#D0D1D7"/></g></g><defs><filter id="filter0_dd_422_37828" x="25.5537" y="16.0607" width="210.393" height="174.701" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="3.75701"/><feGaussianBlur stdDeviation="2.34813"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_422_37828"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="0.939252"/><feGaussianBlur stdDeviation="0.939252"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_422_37828" result="effect2_dropShadow_422_37828"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_422_37828" result="shape"/></filter><clipPath id="clip0_422_37828"><rect x="30.25" y="17" width="201" height="165.308" rx="1.8785" fill="white"/></clipPath><clipPath id="clip1_422_37828"><rect width="156" height="66" fill="white" transform="translate(53.25 34)"/></clipPath></defs></svg>', 'latestVideoFTIcon' => '<svg width="263" height="200" viewBox="0 0 263 200" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="262" height="200" transform="translate(0.5)" fill="#F3F4F5"/><g filter="url(#filter0_dd_422_37861)"><rect x="32" y="23" width="198" height="154" rx="1.8785" fill="white"/><g clip-path="url(#clip0_422_37861)"><rect width="177" height="77" transform="translate(41 67)" fill="#FFDF99"/><circle cx="59.5" cy="186.5" r="79.5" fill="#FFD066"/><rect x="123.571" y="99.8572" width="14.1429" height="11.5714" fill="white"/><path d="M126.999 109.5L134.784 105L126.999 100.5V109.5ZM144.339 97.7551C144.534 98.4601 144.669 99.4051 144.759 100.605C144.864 101.805 144.909 102.84 144.909 103.74L144.999 105C144.999 108.285 144.759 110.7 144.339 112.245C143.964 113.595 143.094 114.465 141.744 114.84C141.039 115.035 139.749 115.17 137.769 115.26C135.819 115.365 134.034 115.41 132.384 115.41L129.999 115.5C123.714 115.5 119.799 115.26 118.254 114.84C116.904 114.465 116.034 113.595 115.659 112.245C115.464 111.54 115.329 110.595 115.239 109.395C115.134 108.195 115.089 107.16 115.089 106.26L114.999 105C114.999 101.715 115.239 99.3001 115.659 97.7551C116.034 96.4051 116.904 95.5351 118.254 95.1601C118.959 94.9651 120.249 94.8301 122.229 94.7401C124.179 94.6351 125.964 94.5901 127.614 94.5901L129.999 94.5001C136.284 94.5001 140.199 94.7401 141.744 95.1601C143.094 95.5351 143.964 96.4051 144.339 97.7551Z" fill="#331F00"/></g><rect x="91.5" y="151" width="76" height="4" rx="1" fill="#DCDDE1"/><rect x="106" y="158" width="47" height="4" rx="1" fill="#DCDDE1"/><circle cx="53" cy="45" r="12" fill="#FFDF99"/><rect x="74" y="34" width="43" height="5" rx="1" fill="#8C8F9A"/><rect x="74" y="43" width="73" height="5" rx="1" fill="#DCDDE1"/><rect x="74" y="51" width="49" height="5" rx="1" fill="#DCDDE1"/></g><defs><filter id="filter0_dd_422_37861" x="27" y="22" width="208" height="164" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4"/><feGaussianBlur stdDeviation="2.5"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_422_37861"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1"/><feGaussianBlur stdDeviation="1"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_422_37861" result="effect2_dropShadow_422_37861"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_422_37861" result="shape"/></filter><clipPath id="clip0_422_37861"><rect width="177" height="77" fill="white" transform="translate(41 67)"/></clipPath></defs></svg>', 'showcaseCarouselFTIcon' => '<svg width="262" height="200" viewBox="0 0 262 200" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="262" height="200" fill="#F3F4F5"/><g filter="url(#filter0_dd_422_37882)"><rect x="32" y="23" width="198" height="168" rx="1.8785" fill="white"/><g clip-path="url(#clip0_422_37882)"><rect width="177" height="77" transform="translate(41 67)" fill="#FFDF99"/><rect x="112" y="160" width="106.426" height="113.844" transform="rotate(-45 112 160)" fill="#FFD066"/><rect x="123.571" y="99.8572" width="14.1429" height="11.5714" fill="white"/><path d="M126.999 109.5L134.784 105L126.999 100.5V109.5ZM144.339 97.7551C144.534 98.4601 144.669 99.4051 144.759 100.605C144.864 101.805 144.909 102.84 144.909 103.74L144.999 105C144.999 108.285 144.759 110.7 144.339 112.245C143.964 113.595 143.094 114.465 141.744 114.84C141.039 115.035 139.749 115.17 137.769 115.26C135.819 115.365 134.034 115.41 132.384 115.41L129.999 115.5C123.714 115.5 119.799 115.26 118.254 114.84C116.904 114.465 116.034 113.595 115.659 112.245C115.464 111.54 115.329 110.595 115.239 109.395C115.134 108.195 115.089 107.16 115.089 106.26L114.999 105C114.999 101.715 115.239 99.3001 115.659 97.7551C116.034 96.4051 116.904 95.5351 118.254 95.1601C118.959 94.9651 120.249 94.8301 122.229 94.7401C124.179 94.6351 125.964 94.5901 127.614 94.5901L129.999 94.5001C136.284 94.5001 140.199 94.7401 141.744 95.1601C143.094 95.5351 143.964 96.4051 144.339 97.7551Z" fill="#331F00"/></g><rect x="93" y="151" width="76" height="4" rx="1" fill="#DCDDE1"/><rect x="107.5" y="158" width="47" height="4" rx="1" fill="#DCDDE1"/><circle cx="119.5" cy="174.5" r="1.5" fill="#434960"/><circle cx="125.5" cy="174.5" r="1.5" fill="#D0D1D7"/><circle cx="131.5" cy="174.5" r="1.5" fill="#D0D1D7"/><circle cx="137.5" cy="174.5" r="1.5" fill="#D0D1D7"/><circle cx="143.5" cy="174.5" r="1.5" fill="#D0D1D7"/><circle cx="53" cy="45" r="12" fill="#FFDF99"/><rect x="74" y="34" width="43" height="5" rx="1" fill="#8C8F9A"/><rect x="74" y="43" width="73" height="5" rx="1" fill="#DCDDE1"/><rect x="74" y="51" width="49" height="5" rx="1" fill="#DCDDE1"/></g><defs><filter id="filter0_dd_422_37882" x="27" y="22" width="208" height="178" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4"/><feGaussianBlur stdDeviation="2.5"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_422_37882"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1"/><feGaussianBlur stdDeviation="1"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_422_37882" result="effect2_dropShadow_422_37882"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_422_37882" result="shape"/></filter><clipPath id="clip0_422_37882"><rect width="177" height="77" fill="white" transform="translate(41 67)"/></clipPath></defs></svg>', 'widgetFTIcon' => '<svg width="263" height="200" viewBox="0 0 263 200" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_422_37909)"><rect width="262" height="200" transform="translate(0.5)" fill="#F3F4F5"/><g filter="url(#filter0_dd_422_37909)"><rect x="81" y="25" width="100" height="229.726" rx="2" fill="white"/><g clip-path="url(#clip1_422_37909)"><rect width="76" height="42" transform="translate(93 45)" fill="#8C8F9A"/><circle opacity="0.5" cx="101.92" cy="97.7118" r="34.0599" fill="#D0D1D7"/></g><rect x="108.293" y="91" width="45.4132" height="4" rx="0.810951" fill="#DCDDE1"/><rect x="121.269" y="98" width="19.4628" height="4" rx="0.810951" fill="#DCDDE1"/><g clip-path="url(#clip2_422_37909)"><rect width="76" height="42" transform="translate(93 114)" fill="#8C8F9A"/><rect opacity="0.5" x="85" y="161.68" width="43" height="43" transform="rotate(-45 85 161.68)" fill="#D0D1D7"/></g><rect x="108.293" y="161" width="45.4132" height="4" rx="0.810951" fill="#DCDDE1"/><rect x="121.269" y="168" width="19.4628" height="4" rx="0.810951" fill="#DCDDE1"/><rect width="76" height="42" transform="translate(93 184)" fill="#8C8F9A"/></g></g><defs><filter id="filter0_dd_422_37909" x="76" y="24" width="110" height="239.726" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4"/><feGaussianBlur stdDeviation="2.5"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_422_37909"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1"/><feGaussianBlur stdDeviation="1"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_422_37909" result="effect2_dropShadow_422_37909"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_422_37909" result="shape"/></filter><clipPath id="clip0_422_37909"><rect width="262" height="200" fill="white" transform="translate(0.5)"/></clipPath><clipPath id="clip1_422_37909"><rect width="76" height="42" fill="white" transform="translate(93 45)"/></clipPath><clipPath id="clip2_422_37909"><rect width="76" height="42" fill="white" transform="translate(93 114)"/></clipPath></defs></svg>', 'channel' => '<svg width="140" height="120" viewBox="0 0 140 120" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_122_33876)"><rect width="140" height="120" fill="#F3F4F5"/><g filter="url(#filter0_d_122_33876)"><g clip-path="url(#clip1_122_33876)"><rect x="21" y="26" width="99" height="93.6964" rx="2.04475" fill="white"/><circle cx="37.3524" cy="43.2367" r="8.39732" fill="#D0D1D7"/><rect x="51.0537" y="37.9331" width="25.6339" height="3.53571" rx="0.883929" fill="#D0D1D7"/><rect x="51.0537" y="45.0046" width="15.0268" height="3.53571" rx="0.883929" fill="#D0D1D7"/><g clip-path="url(#clip2_122_33876)"><rect x="29.8389" y="61.3572" width="39.7768" height="30.0536" rx="0.883929" fill="#43A6DB"/><circle cx="72.2676" cy="79.0359" r="24.75" fill="#0096CC"/><path d="M47.8128 78.5939L51.6358 76.384L47.8128 74.1742V78.5939ZM56.328 72.8262C56.4237 73.1724 56.49 73.6365 56.5342 74.2258C56.5858 74.8151 56.6079 75.3233 56.6079 75.7653L56.6521 76.384C56.6521 77.9972 56.5342 79.1831 56.328 79.9418C56.1438 80.6048 55.7166 81.032 55.0536 81.2162C54.7074 81.3119 54.0739 81.3782 53.1016 81.4224C52.144 81.474 51.2675 81.4961 50.4572 81.4961L49.286 81.5403C46.1996 81.5403 44.2771 81.4224 43.5184 81.2162C42.8554 81.032 42.4282 80.6048 42.244 79.9418C42.1483 79.5956 42.082 79.1316 42.0378 78.5423C41.9862 77.953 41.9641 77.4447 41.9641 77.0028L41.9199 76.384C41.9199 74.7709 42.0378 73.5849 42.244 72.8262C42.4282 72.1633 42.8554 71.736 43.5184 71.5519C43.8646 71.4561 44.498 71.3898 45.4704 71.3456C46.428 71.2941 47.3045 71.272 48.1148 71.272L49.286 71.2278C52.3724 71.2278 54.2949 71.3456 55.0536 71.5519C55.7166 71.736 56.1438 72.1633 56.328 72.8262Z" fill="white"/></g><g clip-path="url(#clip3_122_33876)"><rect x="72.2676" y="61.3572" width="39.7768" height="30.0536" rx="0.883929" fill="#86D0F9"/><circle cx="105.857" cy="94.0625" r="24.75" fill="#43A6DB"/><path d="M90.2415 78.5939L94.0645 76.384L90.2415 74.1742V78.5939ZM98.7567 72.8262C98.8524 73.1724 98.9187 73.6365 98.9629 74.2258C99.0145 74.8151 99.0366 75.3233 99.0366 75.7653L99.0808 76.384C99.0808 77.9972 98.9629 79.1831 98.7567 79.9418C98.5725 80.6048 98.1453 81.032 97.4823 81.2162C97.1361 81.3119 96.5027 81.3782 95.5303 81.4224C94.5727 81.474 93.6962 81.4961 92.8859 81.4961L91.7147 81.5403C88.6283 81.5403 86.7058 81.4224 85.9471 81.2162C85.2841 81.032 84.8569 80.6048 84.6727 79.9418C84.577 79.5956 84.5107 79.1316 84.4665 78.5423C84.4149 77.953 84.3928 77.4447 84.3928 77.0028L84.3486 76.384C84.3486 74.7709 84.4665 73.5849 84.6727 72.8262C84.8569 72.1633 85.2841 71.736 85.9471 71.5519C86.2933 71.4561 86.9268 71.3898 87.8991 71.3456C88.8567 71.2941 89.7332 71.272 90.5435 71.272L91.7147 71.2278C94.8011 71.2278 96.7236 71.3456 97.4823 71.5519C98.1453 71.736 98.5725 72.1633 98.7567 72.8262Z" fill="white"/></g><g clip-path="url(#clip4_122_33876)"><rect x="29.8389" y="94.0625" width="39.7768" height="30.0536" rx="0.883929" fill="#0068A0"/><circle cx="28.0713" cy="129.42" r="24.75" fill="#43A6DB"/><path d="M47.8128 111.299L51.6358 109.089L47.8128 106.88V111.299ZM56.328 105.532C56.4237 105.878 56.49 106.342 56.5342 106.931C56.5858 107.52 56.6079 108.029 56.6079 108.471L56.6521 109.089C56.6521 110.703 56.5342 111.888 56.328 112.647C56.1438 113.31 55.7166 113.737 55.0536 113.921C54.7074 114.017 54.0739 114.084 53.1016 114.128C52.144 114.179 51.2675 114.201 50.4572 114.201L49.286 114.246C46.1996 114.246 44.2771 114.128 43.5184 113.921C42.8554 113.737 42.4282 113.31 42.244 112.647C42.1483 112.301 42.082 111.837 42.0378 111.248C41.9862 110.658 41.9641 110.15 41.9641 109.708L41.9199 109.089C41.9199 107.476 42.0378 106.29 42.244 105.532C42.4282 104.869 42.8554 104.441 43.5184 104.257C43.8646 104.161 44.498 104.095 45.4704 104.051C46.428 103.999 47.3045 103.977 48.1148 103.977L49.286 103.933C52.3724 103.933 54.2949 104.051 55.0536 104.257C55.7166 104.441 56.1438 104.869 56.328 105.532Z" fill="white"/></g><g clip-path="url(#clip5_122_33876)"><rect x="72.2676" y="94.0625" width="39.7768" height="30.0536" rx="0.883929" fill="#2FC5FB"/><circle cx="75.6963" cy="124.598" r="24.75" fill="#52D1FF"/><path d="M90.2415 111.299L94.0645 109.089L90.2415 106.88V111.299ZM98.7567 105.532C98.8524 105.878 98.9187 106.342 98.9629 106.931C99.0145 107.52 99.0366 108.029 99.0366 108.471L99.0808 109.089C99.0808 110.703 98.9629 111.888 98.7567 112.647C98.5725 113.31 98.1453 113.737 97.4823 113.921C97.1361 114.017 96.5027 114.084 95.5303 114.128C94.5727 114.179 93.6962 114.201 92.8859 114.201L91.7147 114.246C88.6283 114.246 86.7058 114.128 85.9471 113.921C85.2841 113.737 84.8569 113.31 84.6727 112.647C84.577 112.301 84.5107 111.837 84.4665 111.248C84.4149 110.658 84.3928 110.15 84.3928 109.708L84.3486 109.089C84.3486 107.476 84.4665 106.29 84.6727 105.532C84.8569 104.869 85.2841 104.441 85.9471 104.257C86.2933 104.161 86.9268 104.095 87.8991 104.051C88.8567 103.999 89.7332 103.977 90.5435 103.977L91.7147 103.933C94.8011 103.933 96.7236 104.051 97.4823 104.257C98.1453 104.441 98.5725 104.869 98.7567 105.532Z" fill="white"/></g></g></g></g><defs><filter id="filter0_d_122_33876" x="17.4643" y="24.2321" width="106.071" height="100.768" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1.76786"/><feGaussianBlur stdDeviation="1.76786"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_122_33876"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_122_33876" result="shape"/></filter><clipPath id="clip0_122_33876"><rect width="140" height="120" fill="white"/></clipPath><clipPath id="clip1_122_33876"><rect x="21" y="26" width="99" height="93.6964" rx="2.04475" fill="white"/></clipPath><clipPath id="clip2_122_33876"><rect x="29.8389" y="61.3572" width="39.7768" height="30.0536" rx="0.883929" fill="white"/></clipPath><clipPath id="clip3_122_33876"><rect x="72.2676" y="61.3572" width="39.7768" height="30.0536" rx="0.883929" fill="white"/></clipPath><clipPath id="clip4_122_33876"><rect x="29.8389" y="94.0625" width="39.7768" height="30.0536" rx="0.883929" fill="white"/></clipPath><clipPath id="clip5_122_33876"><rect x="72.2676" y="94.0625" width="39.7768" height="30.0536" rx="0.883929" fill="white"/></clipPath></defs></svg>', 'playlist' => '<svg width="141" height="120" viewBox="0 0 141 120" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="140" height="120" transform="translate(0.666504)" fill="#E2F5FF"/><g filter="url(#filter0_dd_2248_51227)"><g clip-path="url(#clip0_2248_51227)"><rect x="30.6665" y="33" width="91" height="60" rx="2" fill="#E78282"/><ellipse cx="97.6665" cy="65.5" rx="39" ry="39.5" fill="#DF5757"/><path d="M73.3331 66.5002L79.3881 63.0002L73.3331 59.5002V66.5002ZM86.8198 57.3652C86.9714 57.9135 87.0764 58.6485 87.1464 59.5818C87.2281 60.5152 87.2631 61.3202 87.2631 62.0202L87.3331 63.0002C87.3331 65.5552 87.1464 67.4335 86.8198 68.6352C86.5281 69.6852 85.8514 70.3618 84.8014 70.6535C84.2531 70.8052 83.2498 70.9102 81.7098 70.9802C80.1931 71.0618 78.8048 71.0968 77.5214 71.0968L75.6664 71.1668C70.7781 71.1668 67.7331 70.9802 66.5314 70.6535C65.4814 70.3618 64.8048 69.6852 64.5131 68.6352C64.3614 68.0868 64.2564 67.3518 64.1864 66.4185C64.1048 65.4852 64.0698 64.6802 64.0698 63.9802L63.9998 63.0002C63.9998 60.4452 64.1864 58.5668 64.5131 57.3652C64.8048 56.3152 65.4814 55.6385 66.5314 55.3468C67.0798 55.1952 68.0831 55.0902 69.6231 55.0202C71.1398 54.9385 72.5281 54.9035 73.8114 54.9035L75.6664 54.8335C80.5548 54.8335 83.5998 55.0202 84.8014 55.3468C85.8514 55.6385 86.5281 56.3152 86.8198 57.3652Z" fill="white"/></g><rect x="30.6665" y="33" width="91" height="60" rx="2" stroke="white" stroke-width="3"/></g><g filter="url(#filter1_dd_2248_51227)"><g clip-path="url(#clip1_2248_51227)"><rect x="20.6665" y="23" width="91" height="60" rx="2" fill="#43A6DB"/><ellipse cx="49.6665" cy="17.5" rx="39" ry="39.5" fill="#0096CC"/><rect x="71.6665" y="24" width="39" height="58" fill="#0068A0"/><path d="M81.0017 50.3363H98.335V53.0029H81.0017V50.3363ZM81.0017 45.0029H98.335V47.6696H81.0017V45.0029ZM81.0017 55.6696H93.0017V58.3363H81.0017V55.6696ZM95.6684 55.6696V63.0029L102.335 59.6696L95.6684 55.6696Z" fill="white"/></g><rect x="20.6665" y="23" width="91" height="60" rx="2" stroke="white" stroke-width="3"/></g><defs><filter id="filter0_dd_2248_51227" x="24.1665" y="30.5" width="104" height="73" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4"/><feGaussianBlur stdDeviation="2.5"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2248_51227"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1"/><feGaussianBlur stdDeviation="1"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_2248_51227" result="effect2_dropShadow_2248_51227"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_2248_51227" result="shape"/></filter><filter id="filter1_dd_2248_51227" x="14.1665" y="20.5" width="104" height="73" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4"/><feGaussianBlur stdDeviation="2.5"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2248_51227"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1"/><feGaussianBlur stdDeviation="1"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_2248_51227" result="effect2_dropShadow_2248_51227"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_2248_51227" result="shape"/></filter><clipPath id="clip0_2248_51227"><rect x="30.6665" y="33" width="91" height="60" rx="2" fill="white"/></clipPath><clipPath id="clip1_2248_51227"><rect x="20.6665" y="23" width="91" height="60" rx="2" fill="white"/></clipPath></defs></svg>', 'favorites' => '<svg width="141" height="120" viewBox="0 0 141 120" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="140" height="120" transform="translate(0.333252)" fill="#E2F5FF"/><g filter="url(#filter0_dd_2248_51232)"><g clip-path="url(#clip0_2248_51232)"><rect x="30.3333" y="33" width="91" height="60" rx="2" fill="#2FC5FB"/><ellipse cx="97.3333" cy="65.5" rx="39" ry="39.5" fill="#0096CC"/><path d="M72.9998 66.5002L79.0548 63.0002L72.9998 59.5002V66.5002ZM86.4865 57.3652C86.6382 57.9135 86.7432 58.6485 86.8132 59.5818C86.8948 60.5152 86.9298 61.3202 86.9298 62.0202L86.9998 63.0002C86.9998 65.5552 86.8132 67.4335 86.4865 68.6352C86.1948 69.6852 85.5182 70.3618 84.4682 70.6535C83.9198 70.8052 82.9165 70.9102 81.3765 70.9802C79.8598 71.0618 78.4715 71.0968 77.1882 71.0968L75.3332 71.1668C70.4448 71.1668 67.3998 70.9802 66.1982 70.6535C65.1482 70.3618 64.4715 69.6852 64.1798 68.6352C64.0282 68.0868 63.9232 67.3518 63.8532 66.4185C63.7715 65.4852 63.7365 64.6802 63.7365 63.9802L63.6665 63.0002C63.6665 60.4452 63.8532 58.5668 64.1798 57.3652C64.4715 56.3152 65.1482 55.6385 66.1982 55.3468C66.7465 55.1952 67.7498 55.0902 69.2898 55.0202C70.8065 54.9385 72.1948 54.9035 73.4782 54.9035L75.3332 54.8335C80.2215 54.8335 83.2665 55.0202 84.4682 55.3468C85.5182 55.6385 86.1948 56.3152 86.4865 57.3652Z" fill="white"/></g><rect x="30.3333" y="33" width="91" height="60" rx="2" stroke="white" stroke-width="3"/></g><g filter="url(#filter1_dd_2248_51232)"><g clip-path="url(#clip1_2248_51232)"><rect x="20.3333" y="23" width="91" height="60" rx="2" fill="#59AB46"/><ellipse cx="49.3333" cy="17.5" rx="39" ry="39.5" fill="#76C064"/><rect x="71.3333" y="24" width="39" height="58" fill="#468737"/><path d="M98.8383 55.9111C98.8383 55.4891 98.6706 55.0843 98.3722 54.7859C98.0737 54.4874 97.6689 54.3198 97.2469 54.3198H92.2182L92.982 50.6835C92.9979 50.6039 93.0059 50.5164 93.0059 50.4289C93.0059 50.1027 92.8706 49.8003 92.6558 49.5855L91.8124 48.75L86.5768 53.9856C86.2824 54.28 86.1073 54.6778 86.1073 55.1155V63.0723C86.1073 63.4943 86.275 63.8991 86.5734 64.1975C86.8719 64.496 87.2767 64.6636 87.6987 64.6636H94.8598C95.5203 64.6636 96.0852 64.2658 96.3239 63.6929L98.7269 58.0834C98.7985 57.9003 98.8383 57.7094 98.8383 57.5025V55.9111ZM81.3333 64.6636H84.516V55.1155H81.3333V64.6636Z" fill="white"/></g><rect x="20.3333" y="23" width="91" height="60" rx="2" stroke="white" stroke-width="3"/></g><defs><filter id="filter0_dd_2248_51232" x="23.8333" y="30.5" width="104" height="73" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4"/><feGaussianBlur stdDeviation="2.5"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2248_51232"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1"/><feGaussianBlur stdDeviation="1"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_2248_51232" result="effect2_dropShadow_2248_51232"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_2248_51232" result="shape"/></filter><filter id="filter1_dd_2248_51232" x="13.8333" y="20.5" width="104" height="73" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4"/><feGaussianBlur stdDeviation="2.5"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2248_51232"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1"/><feGaussianBlur stdDeviation="1"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_2248_51232" result="effect2_dropShadow_2248_51232"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_2248_51232" result="shape"/></filter><clipPath id="clip0_2248_51232"><rect x="30.3333" y="33" width="91" height="60" rx="2" fill="white"/></clipPath><clipPath id="clip1_2248_51232"><rect x="20.3333" y="23" width="91" height="60" rx="2" fill="white"/></clipPath></defs></svg>', 'search' => '<svg width="140" height="120" viewBox="0 0 140 120" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="140" height="120" fill="#E2F5FF"/><g filter="url(#filter0_d_2248_51238)"><g clip-path="url(#clip0_2248_51238)"><rect x="33.999" y="31" width="81" height="64.8" rx="1.62" fill="white"/><g clip-path="url(#clip1_2248_51238)"><rect width="81" height="48.6" transform="translate(33.999 29.3799)" fill="#43A6DB"/><circle cx="118.673" cy="58.5979" r="40.095" fill="#0096CC"/><path d="M71.8526 57.8823L78.0458 54.3023L71.8526 50.7224V57.8823ZM85.6472 48.5387C85.8023 49.0995 85.9097 49.8513 85.9813 50.806C86.0648 51.7606 86.1006 52.584 86.1006 53.3L86.1722 54.3023C86.1722 56.9157 85.9813 58.8369 85.6472 60.066C85.3488 61.14 84.6567 61.8321 83.5828 62.1304C83.0219 62.2855 81.9957 62.3929 80.4205 62.4645C78.8692 62.5481 77.4492 62.5839 76.1365 62.5839L74.2392 62.6555C69.2392 62.6555 66.1247 62.4645 64.8956 62.1304C63.8216 61.8321 63.1295 61.14 62.8312 60.066C62.6761 59.5051 62.5687 58.7534 62.4971 57.7987C62.4135 56.8441 62.3778 56.0207 62.3778 55.3047L62.3062 54.3023C62.3062 51.689 62.4971 49.7678 62.8312 48.5387C63.1295 47.4647 63.8216 46.7726 64.8956 46.4743C65.4565 46.3191 66.4827 46.2117 68.0579 46.1401C69.6092 46.0566 71.0292 46.0208 72.3418 46.0208L74.2392 45.9492C79.2391 45.9492 82.3537 46.1401 83.5828 46.4743C84.6567 46.7726 85.3488 47.4647 85.6472 48.5387Z" fill="white"/></g><rect x="40.479" y="84.46" width="42.12" height="4.86" rx="1.62" fill="#CED0D9"/></g></g><g filter="url(#filter1_dd_2248_51238)"><rect x="18" y="11" width="36" height="36" rx="18" fill="white"/><rect x="18" y="11" width="36" height="36" rx="18" stroke="white" stroke-width="2"/><circle cx="34.4814" cy="26.9956" r="7" transform="rotate(-45 34.4814 26.9956)" stroke="#0096CC" stroke-width="2"/><line x1="39.9669" y1="32.6528" x2="44.9166" y2="37.6025" stroke="#0096CC" stroke-width="2"/></g><defs><filter id="filter0_d_2248_51238" x="28.2712" y="28.1361" width="92.4557" height="76.2555" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="2.86393"/><feGaussianBlur stdDeviation="2.86393"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2248_51238"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_2248_51238" result="shape"/></filter><filter id="filter1_dd_2248_51238" x="12" y="9" width="48" height="48" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4"/><feGaussianBlur stdDeviation="2.5"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2248_51238"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1"/><feGaussianBlur stdDeviation="1"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_2248_51238" result="effect2_dropShadow_2248_51238"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_2248_51238" result="shape"/></filter><clipPath id="clip0_2248_51238"><rect x="33.999" y="31" width="81" height="64.8" rx="1.62" fill="white"/></clipPath><clipPath id="clip1_2248_51238"><rect width="81" height="48.6" fill="white" transform="translate(33.999 29.3799)"/></clipPath></defs></svg>', 'live' => '<svg width="141" height="120" viewBox="0 0 141 120" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="140" height="120" transform="translate(0.666504)" fill="#E2F5FF"/><g filter="url(#filter0_d_2248_51244)"><g clip-path="url(#clip0_2248_51244)"><rect x="23.6665" y="23" width="91" height="74" rx="1.82" fill="white"/><g clip-path="url(#clip1_2248_51244)"><rect width="91" height="54.6" transform="translate(23.6665 21.1797)" fill="#434960"/><circle cx="28.7935" cy="84.0054" r="45.045" fill="#696D80"/><line x1="23.9995" y1="75" x2="111" y2="75" stroke="#EB2121" stroke-width="2"/></g><path d="M114.684 75C114.684 76.6569 113.341 78 111.684 78C110.027 78 108.684 76.6569 108.684 75C108.684 73.3431 110.027 72 111.684 72C113.341 72 114.684 73.3431 114.684 75Z" fill="#EB2121"/><rect x="31.6665" y="83" width="60" height="6" rx="1" fill="#CED0D9"/></g></g><g filter="url(#filter1_dd_2248_51244)"><rect x="13.6665" y="9" width="36" height="36" rx="18" fill="white"/><rect x="13.6665" y="9" width="36" height="36" rx="18" stroke="white" stroke-width="2"/><path d="M26.5095 19.9378C26.6025 20.0307 26.6763 20.141 26.7266 20.2624C26.7769 20.3838 26.8028 20.5139 26.8028 20.6453C26.8028 20.7767 26.7769 20.9069 26.7266 21.0283C26.6763 21.1497 26.6025 21.2599 26.5095 21.3528C25.009 22.8536 24.166 24.889 24.166 27.0113C24.166 29.1336 25.009 31.169 26.5095 32.6698C26.6024 32.7627 26.676 32.873 26.7262 32.9944C26.7765 33.1158 26.8023 33.2458 26.8022 33.3772C26.8022 33.5085 26.7763 33.6386 26.726 33.7599C26.6757 33.8812 26.6019 33.9915 26.509 34.0843C26.4161 34.1772 26.3058 34.2508 26.1845 34.301C26.0631 34.3512 25.933 34.3771 25.8017 34.377C25.6703 34.377 25.5403 34.3511 25.419 34.3007C25.2976 34.2504 25.1874 34.1767 25.0945 34.0838C21.1885 30.1778 21.1885 23.8438 25.0945 19.9378C25.1874 19.8448 25.2977 19.7711 25.4191 19.7208C25.5405 19.6704 25.6706 19.6445 25.802 19.6445C25.9335 19.6445 26.0636 19.6704 26.185 19.7208C26.3064 19.7711 26.4167 19.8448 26.5095 19.9378ZM39.2405 19.9378C43.1465 23.8448 43.1465 30.1778 39.2405 34.0838C39.0519 34.266 38.7993 34.3668 38.5371 34.3645C38.2749 34.3622 38.0241 34.257 37.8387 34.0716C37.6533 33.8862 37.5481 33.6354 37.5459 33.3732C37.5436 33.111 37.6444 32.8584 37.8265 32.6698C39.3271 31.169 40.1701 29.1336 40.1701 27.0113C40.1701 24.889 39.3271 22.8536 37.8265 21.3528C37.6389 21.1653 37.5334 20.9109 37.5333 20.6457C37.5332 20.3804 37.6385 20.126 37.826 19.9383C38.0135 19.7507 38.2679 19.6452 38.5332 19.6451C38.7985 19.645 39.0529 19.7503 39.2405 19.9378ZM29.4765 22.8118C29.664 22.9993 29.7693 23.2537 29.7693 23.5188C29.7693 23.784 29.664 24.0383 29.4765 24.2258C29.1125 24.5898 28.8237 25.022 28.6267 25.4976C28.4297 25.9732 28.3283 26.483 28.3283 26.9978C28.3283 27.5126 28.4297 28.0224 28.6267 28.498C28.8237 28.9737 29.1125 29.4058 29.4765 29.7698C29.572 29.8621 29.6482 29.9724 29.7006 30.0944C29.753 30.2164 29.7806 30.3476 29.7818 30.4804C29.7829 30.6132 29.7576 30.7449 29.7074 30.8678C29.6571 30.9907 29.5828 31.1023 29.4889 31.1962C29.395 31.2901 29.2834 31.3644 29.1605 31.4146C29.0376 31.4649 28.9059 31.4902 28.7731 31.4891C28.6404 31.4879 28.5091 31.4603 28.3871 31.4079C28.2651 31.3555 28.1548 31.2793 28.0625 31.1838C26.9524 30.0736 26.3287 28.5679 26.3287 26.9978C26.3287 25.4278 26.9524 23.922 28.0625 22.8118C28.2501 22.6243 28.5044 22.519 28.7695 22.519C29.0347 22.519 29.289 22.6243 29.4765 22.8118ZM36.4355 22.8118C37.5457 23.922 38.1694 25.4278 38.1694 26.9978C38.1694 28.5679 37.5457 30.0736 36.4355 31.1838C36.3427 31.2767 36.2325 31.3504 36.1111 31.4007C35.9898 31.4511 35.8597 31.477 35.7284 31.477C35.597 31.4771 35.467 31.4512 35.3456 31.401C35.2242 31.3508 35.1139 31.2772 35.021 31.1843C34.9281 31.0915 34.8544 30.9812 34.8041 30.8599C34.7538 30.7386 34.7279 30.6085 34.7278 30.4772C34.7278 30.3458 34.7536 30.2158 34.8038 30.0944C34.8541 29.973 34.9277 29.8627 35.0205 29.7698C35.3846 29.4058 35.6734 28.9737 35.8704 28.498C36.0674 28.0224 36.1688 27.5126 36.1688 26.9978C36.1688 26.483 36.0674 25.9732 35.8704 25.4976C35.6734 25.022 35.3846 24.5898 35.0205 24.2258C34.833 24.0382 34.7277 23.7837 34.7278 23.5185C34.7279 23.2532 34.8334 22.9988 35.021 22.8113C35.2087 22.6238 35.4631 22.5185 35.7284 22.5186C35.9937 22.5187 36.248 22.6242 36.4355 22.8118ZM32.2485 25.5818C32.4455 25.5818 32.6406 25.6206 32.8226 25.696C33.0046 25.7714 33.1699 25.8819 33.3092 26.0212C33.4485 26.1604 33.559 26.3258 33.6344 26.5078C33.7097 26.6898 33.7485 26.8848 33.7485 27.0818C33.7485 27.2788 33.7097 27.4739 33.6344 27.6558C33.559 27.8378 33.4485 28.0032 33.3092 28.1425C33.1699 28.2818 33.0046 28.3923 32.8226 28.4676C32.6406 28.543 32.4455 28.5818 32.2485 28.5818C31.8507 28.5818 31.4692 28.4238 31.1879 28.1425C30.9066 27.8612 30.7485 27.4796 30.7485 27.0818C30.7485 26.684 30.9066 26.3025 31.1879 26.0212C31.4692 25.7399 31.8507 25.5818 32.2485 25.5818Z" fill="#EB2121"/></g><defs><filter id="filter0_d_2248_51244" x="17.2315" y="19.7825" width="103.87" height="86.87" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="3.2175"/><feGaussianBlur stdDeviation="3.2175"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2248_51244"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_2248_51244" result="shape"/></filter><filter id="filter1_dd_2248_51244" x="7.6665" y="7" width="48" height="48" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4"/><feGaussianBlur stdDeviation="2.5"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2248_51244"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1"/><feGaussianBlur stdDeviation="1"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_2248_51244" result="effect2_dropShadow_2248_51244"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_2248_51244" result="shape"/></filter><clipPath id="clip0_2248_51244"><rect x="23.6665" y="23" width="91" height="74" rx="1.82" fill="white"/></clipPath><clipPath id="clip1_2248_51244"><rect width="91" height="54.6" fill="white" transform="translate(23.6665 21.1797)"/></clipPath></defs></svg>', 'single' => '<svg width="141" height="120" viewBox="0 0 141 120" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="140" height="120" transform="translate(0.333252)" fill="#E2F5FF"/><g filter="url(#filter0_dd_2248_51250)"><g clip-path="url(#clip0_2248_51250)"><rect x="21.3333" y="25" width="98" height="70" rx="2" fill="#43A6DB"/><circle cx="21.3333" cy="77" r="60" fill="#0096CC"/></g><rect x="21.3333" y="25" width="98" height="70" rx="2" stroke="white" stroke-width="3"/></g><path d="M67.6667 63.9998L74.5867 59.9998L67.6667 55.9998V63.9998ZM83.08 53.5598C83.2533 54.1865 83.3733 55.0265 83.4533 56.0932C83.5467 57.1598 83.5867 58.0798 83.5867 58.8798L83.6667 59.9998C83.6667 62.9198 83.4533 65.0665 83.08 66.4398C82.7467 67.6398 81.9733 68.4132 80.7733 68.7465C80.1467 68.9198 79 69.0398 77.24 69.1198C75.5067 69.2132 73.92 69.2532 72.4533 69.2532L70.3333 69.3332C64.7467 69.3332 61.2667 69.1198 59.8933 68.7465C58.6933 68.4132 57.92 67.6398 57.5867 66.4398C57.4133 65.8132 57.2933 64.9732 57.2133 63.9065C57.12 62.8398 57.08 61.9198 57.08 61.1198L57 59.9998C57 57.0798 57.2133 54.9332 57.5867 53.5598C57.92 52.3598 58.6933 51.5865 59.8933 51.2532C60.52 51.0798 61.6667 50.9598 63.4267 50.8798C65.16 50.7865 66.7467 50.7465 68.2133 50.7465L70.3333 50.6665C75.92 50.6665 79.4 50.8798 80.7733 51.2532C81.9733 51.5865 82.7467 52.3598 83.08 53.5598Z" fill="white"/><defs><filter id="filter0_dd_2248_51250" x="14.8333" y="22.5" width="111" height="83" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4"/><feGaussianBlur stdDeviation="2.5"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2248_51250"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="1"/><feGaussianBlur stdDeviation="1"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"/><feBlend mode="normal" in2="effect1_dropShadow_2248_51250" result="effect2_dropShadow_2248_51250"/><feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_2248_51250" result="shape"/></filter><clipPath id="clip0_2248_51250"><rect x="21.3333" y="25" width="98" height="70" rx="2" fill="white"/></clipPath></defs></svg>', 'social_wall' => '<svg width="140" height="119" viewBox="0 0 140 119" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="140" height="119" fill="#E2F5FF"/><path d="M64.6875 39.5C64.6875 44.3438 61.1328 48.3672 56.4844 49.0703V42.3125H58.75L59.1797 39.5H56.4844V37.7031C56.4844 36.9219 56.875 36.1797 58.0859 36.1797H59.2969V33.7969C59.2969 33.7969 58.2031 33.6016 57.1094 33.6016C54.9219 33.6016 53.4766 34.9688 53.4766 37.3906V39.5H51.0156V42.3125H53.4766V49.0703C48.8281 48.3672 45.3125 44.3438 45.3125 39.5C45.3125 34.1484 49.6484 29.8125 55 29.8125C60.3516 29.8125 64.6875 34.1484 64.6875 39.5Z" fill="#006BFA"/><path d="M96.6953 34.3828C97.1641 36.0234 97.1641 39.5391 97.1641 39.5391C97.1641 39.5391 97.1641 43.0156 96.6953 44.6953C96.4609 45.6328 95.7188 46.3359 94.8203 46.5703C93.1406 47 86.5 47 86.5 47C86.5 47 79.8203 47 78.1406 46.5703C77.2422 46.3359 76.5 45.6328 76.2656 44.6953C75.7969 43.0156 75.7969 39.5391 75.7969 39.5391C75.7969 39.5391 75.7969 36.0234 76.2656 34.3828C76.5 33.4453 77.2422 32.7031 78.1406 32.4688C79.8203 32 86.5 32 86.5 32C86.5 32 93.1406 32 94.8203 32.4688C95.7188 32.7031 96.4609 33.4453 96.6953 34.3828ZM84.3125 42.7031L89.8594 39.5391L84.3125 36.375V42.7031Z" fill="#EB2121"/><path d="M54 70.0078C56.4609 70.0078 58.4922 72.0391 58.4922 74.5C58.4922 77 56.4609 78.9922 54 78.9922C51.5 78.9922 49.5078 77 49.5078 74.5C49.5078 72.0391 51.5 70.0078 54 70.0078ZM54 77.4297C55.6016 77.4297 56.8906 76.1406 56.8906 74.5C56.8906 72.8984 55.6016 71.6094 54 71.6094C52.3594 71.6094 51.0703 72.8984 51.0703 74.5C51.0703 76.1406 52.3984 77.4297 54 77.4297ZM59.7031 69.8516C59.7031 70.4375 59.2344 70.9062 58.6484 70.9062C58.0625 70.9062 57.5938 70.4375 57.5938 69.8516C57.5938 69.2656 58.0625 68.7969 58.6484 68.7969C59.2344 68.7969 59.7031 69.2656 59.7031 69.8516ZM62.6719 70.9062C62.75 72.3516 62.75 76.6875 62.6719 78.1328C62.5938 79.5391 62.2812 80.75 61.2656 81.8047C60.25 82.8203 59 83.1328 57.5938 83.2109C56.1484 83.2891 51.8125 83.2891 50.3672 83.2109C48.9609 83.1328 47.75 82.8203 46.6953 81.8047C45.6797 80.75 45.3672 79.5391 45.2891 78.1328C45.2109 76.6875 45.2109 72.3516 45.2891 70.9062C45.3672 69.5 45.6797 68.25 46.6953 67.2344C47.75 66.2188 48.9609 65.9062 50.3672 65.8281C51.8125 65.75 56.1484 65.75 57.5938 65.8281C59 65.9062 60.25 66.2188 61.2656 67.2344C62.2812 68.25 62.5938 69.5 62.6719 70.9062ZM60.7969 79.6562C61.2656 78.5234 61.1484 75.7891 61.1484 74.5C61.1484 73.25 61.2656 70.5156 60.7969 69.3438C60.4844 68.6016 59.8984 67.9766 59.1562 67.7031C57.9844 67.2344 55.25 67.3516 54 67.3516C52.7109 67.3516 49.9766 67.2344 48.8438 67.7031C48.0625 68.0156 47.4766 68.6016 47.1641 69.3438C46.6953 70.5156 46.8125 73.25 46.8125 74.5C46.8125 75.7891 46.6953 78.5234 47.1641 79.6562C47.4766 80.4375 48.0625 81.0234 48.8438 81.3359C49.9766 81.8047 52.7109 81.6875 54 81.6875C55.25 81.6875 57.9844 81.8047 59.1562 81.3359C59.8984 81.0234 60.5234 80.4375 60.7969 79.6562Z" fill="url(#paint0_linear_2248_51257)"/><path d="M95.9297 70.4375C95.9297 70.6328 95.9297 70.7891 95.9297 70.9844C95.9297 76.4141 91.8281 82.625 84.2891 82.625C81.9453 82.625 79.7969 81.9609 78 80.7891C78.3125 80.8281 78.625 80.8672 78.9766 80.8672C80.8906 80.8672 82.6484 80.2031 84.0547 79.1094C82.2578 79.0703 80.7344 77.8984 80.2266 76.2578C80.5 76.2969 80.7344 76.3359 81.0078 76.3359C81.3594 76.3359 81.75 76.2578 82.0625 76.1797C80.1875 75.7891 78.7812 74.1484 78.7812 72.1562V72.1172C79.3281 72.4297 79.9922 72.5859 80.6562 72.625C79.5234 71.8828 78.8203 70.6328 78.8203 69.2266C78.8203 68.4453 79.0156 67.7422 79.3672 67.1562C81.3984 69.6172 84.4453 71.2578 87.8438 71.4531C87.7656 71.1406 87.7266 70.8281 87.7266 70.5156C87.7266 68.25 89.5625 66.4141 91.8281 66.4141C93 66.4141 94.0547 66.8828 94.8359 67.7031C95.7344 67.5078 96.6328 67.1562 97.4141 66.6875C97.1016 67.6641 96.4766 68.4453 95.6172 68.9531C96.4375 68.875 97.2578 68.6406 97.9609 68.3281C97.4141 69.1484 96.7109 69.8516 95.9297 70.4375Z" fill="#0096CC"/><defs><linearGradient id="paint0_linear_2248_51257" x1="51.4125" y1="113.55" x2="105.527" y2="78.0397" gradientUnits="userSpaceOnUse"><stop stop-color="white"/><stop offset="0.147864" stop-color="#F6640E"/><stop offset="0.443974" stop-color="#BA03A7"/><stop offset="0.733337" stop-color="#6A01B9"/><stop offset="1" stop-color="#6B01B9"/></linearGradient></defs></svg>', 'playlistFree' => '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_39_32245)"><g filter="url(#filter0_d_39_32245)"><rect x="3" y="3" width="26.1602" height="26.1602" rx="2" fill="#0096CC"/></g><path d="M9.00146 14.002H22.0015V16.002H9.00146V14.002ZM9.00146 10.002H22.0015V12.002H9.00146V10.002ZM9.00146 18.002H18.0015V20.002H9.00146V18.002ZM20.0015 18.002V23.502L25.0015 21.002L20.0015 18.002Z" fill="white"/></g><defs><filter id="filter0_d_39_32245" x="-3" y="0" width="38.1602" height="38.1602" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="3"/><feGaussianBlur stdDeviation="3"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_39_32245"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_39_32245" result="shape"/></filter><clipPath id="clip0_39_32245"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>', 'favoritesFree' => '<svg width="33" height="32" viewBox="0 0 33 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_39_32248)"><g filter="url(#filter0_d_39_32248)"><rect x="3.3335" y="3" width="26.1602" height="26.1602" rx="2" fill="#59AB46"/></g><path d="M23.421 15.0926C23.421 14.7409 23.2813 14.4036 23.0326 14.1549C22.7839 13.9062 22.4466 13.7665 22.0949 13.7665H17.9043L18.5408 10.7363C18.5541 10.6699 18.5607 10.597 18.5607 10.5241C18.5607 10.2522 18.448 10.0003 18.269 9.82122L17.5661 9.125L13.2031 13.488C12.9578 13.7333 12.8119 14.0649 12.8119 14.4295V21.0602C12.8119 21.4119 12.9516 21.7493 13.2003 21.998C13.449 22.2467 13.7863 22.3864 14.138 22.3864H20.1057C20.656 22.3864 21.1268 22.0548 21.3257 21.5774L23.3282 16.9028C23.3878 16.7503 23.421 16.5912 23.421 16.4188V15.0926ZM8.8335 22.3864H11.4858V14.4295H8.8335V22.3864Z" fill="white"/></g><defs><filter id="filter0_d_39_32248" x="-2.6665" y="0" width="38.1602" height="38.1602" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="3"/><feGaussianBlur stdDeviation="3"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_39_32248"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_39_32248" result="shape"/></filter><clipPath id="clip0_39_32248"><rect width="32" height="32" fill="white" transform="translate(0.333496)"/></clipPath></defs></svg>', 'searchFree' => '<svg width="33" height="32" viewBox="0 0 33 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_39_32251)"><g filter="url(#filter0_d_39_32251)"><rect x="3.66675" y="3" width="26.1602" height="26.1602" rx="2" fill="#0096CC"/></g><circle cx="15.6505" cy="14.4961" r="6.125" transform="rotate(-45 15.6505 14.4961)" stroke="white" stroke-width="1.75"/><line x1="20.4503" y1="19.4462" x2="24.7813" y2="23.7773" stroke="white" stroke-width="1.75"/></g><defs><filter id="filter0_d_39_32251" x="-2.33325" y="0" width="38.1602" height="38.1602" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="3"/><feGaussianBlur stdDeviation="3"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_39_32251"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_39_32251" result="shape"/></filter><clipPath id="clip0_39_32251"><rect width="32" height="32" fill="white" transform="translate(0.666748)"/></clipPath></defs></svg>', 'liveFree' => '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_39_32540)"><g filter="url(#filter0_d_39_32540)"><rect x="3" y="3" width="26.1602" height="26.1602" rx="2" fill="#EB2121"/></g><path d="M10.9815 9.52617C11.0667 9.6113 11.1343 9.7124 11.1805 9.82368C11.2266 9.93496 11.2503 10.0542 11.2503 10.1747C11.2503 10.2952 11.2266 10.4145 11.1805 10.5257C11.1343 10.637 11.0667 10.7381 10.9815 10.8233C9.60597 12.199 8.83323 14.0648 8.83323 16.0102C8.83323 17.9556 9.60597 19.8214 10.9815 21.1972C11.0666 21.2823 11.1341 21.3834 11.1801 21.4947C11.2262 21.6059 11.2498 21.7252 11.2498 21.8456C11.2497 21.966 11.226 22.0852 11.1799 22.1964C11.1338 22.3076 11.0662 22.4087 10.981 22.4938C10.8959 22.5789 10.7948 22.6464 10.6835 22.6924C10.5723 22.7385 10.453 22.7621 10.3326 22.7621C10.2122 22.7621 10.093 22.7383 9.98178 22.6922C9.87055 22.6461 9.76951 22.5785 9.6844 22.4933C6.1039 18.9128 6.1039 13.1067 9.6844 9.52617C9.76953 9.44094 9.87063 9.37333 9.98191 9.3272C10.0932 9.28107 10.2125 9.25732 10.3329 9.25732C10.4534 9.25732 10.5727 9.28107 10.684 9.3272C10.7953 9.37333 10.8963 9.44094 10.9815 9.52617ZM22.6516 9.52617C26.2321 13.1076 26.2321 18.9128 22.6516 22.4933C22.4787 22.6603 22.2471 22.7527 22.0068 22.7506C21.7664 22.7485 21.5365 22.6521 21.3666 22.4822C21.1966 22.3122 21.1002 22.0823 21.0981 21.842C21.096 21.6016 21.1884 21.3701 21.3554 21.1972C22.7309 19.8214 23.5037 17.9556 23.5037 16.0102C23.5037 14.0648 22.7309 12.199 21.3554 10.8233C21.1834 10.6514 21.0867 10.4182 21.0866 10.175C21.0865 9.93187 21.1831 9.69863 21.3549 9.52663C21.5268 9.35462 21.76 9.25795 22.0032 9.25786C22.2463 9.25777 22.4796 9.35429 22.6516 9.52617ZM13.7012 12.1607C13.8731 12.3326 13.9696 12.5657 13.9696 12.8088C13.9696 13.0518 13.8731 13.2849 13.7012 13.4568C13.3675 13.7905 13.1028 14.1867 12.9222 14.6226C12.7416 15.0586 12.6486 15.5259 12.6486 15.9978C12.6486 16.4698 12.7416 16.937 12.9222 17.373C13.1028 17.809 13.3675 18.2052 13.7012 18.5388C13.7888 18.6234 13.8586 18.7245 13.9067 18.8364C13.9547 18.9482 13.98 19.0685 13.981 19.1902C13.9821 19.3119 13.9589 19.4326 13.9128 19.5453C13.8667 19.6579 13.7987 19.7603 13.7126 19.8464C13.6265 19.9324 13.5242 20.0005 13.4115 20.0466C13.2989 20.0927 13.1782 20.1159 13.0564 20.1148C12.9347 20.1138 12.8144 20.0885 12.7026 20.0404C12.5908 19.9924 12.4896 19.9226 12.4051 19.835C11.3874 18.8173 10.8157 17.437 10.8157 15.9978C10.8157 14.5586 11.3874 13.1784 12.4051 12.1607C12.577 11.9888 12.8101 11.8923 13.0531 11.8923C13.2962 11.8923 13.5293 11.9888 13.7012 12.1607ZM20.0803 12.1607C21.098 13.1784 21.6697 14.5586 21.6697 15.9978C21.6697 17.437 21.098 18.8173 20.0803 19.835C19.9952 19.9202 19.8942 19.9877 19.7829 20.0339C19.6717 20.08 19.5525 20.1037 19.4321 20.1038C19.3117 20.1038 19.1925 20.0801 19.0812 20.0341C18.97 19.9881 18.8689 19.9206 18.7837 19.8355C18.6985 19.7504 18.631 19.6493 18.5848 19.5381C18.5387 19.4269 18.515 19.3076 18.5149 19.1872C18.5149 19.0668 18.5386 18.9476 18.5846 18.8364C18.6306 18.7251 18.6981 18.624 18.7832 18.5388C19.1169 18.2052 19.3817 17.809 19.5623 17.373C19.7429 16.937 19.8358 16.4698 19.8358 15.9978C19.8358 15.5259 19.7429 15.0586 19.5623 14.6226C19.3817 14.1867 19.1169 13.7905 18.7832 13.4568C18.6113 13.2848 18.5148 13.0516 18.5149 12.8084C18.515 12.5653 18.6117 12.3321 18.7837 12.1602C18.9557 11.9883 19.1889 11.8918 19.4321 11.8919C19.6753 11.892 19.9084 11.9887 20.0803 12.1607ZM16.2422 14.6998C16.4228 14.6998 16.6016 14.7354 16.7684 14.8045C16.9352 14.8736 17.0868 14.9749 17.2145 15.1026C17.3422 15.2302 17.4435 15.3818 17.5126 15.5486C17.5817 15.7155 17.6172 15.8943 17.6172 16.0748C17.6172 16.2554 17.5817 16.4342 17.5126 16.601C17.4435 16.7678 17.3422 16.9194 17.2145 17.0471C17.0868 17.1748 16.9352 17.2761 16.7684 17.3452C16.6016 17.4143 16.4228 17.4498 16.2422 17.4498C15.8776 17.4498 15.5278 17.305 15.27 17.0471C15.0121 16.7892 14.8672 16.4395 14.8672 16.0748C14.8672 15.7102 15.0121 15.3604 15.27 15.1026C15.5278 14.8447 15.8776 14.6998 16.2422 14.6998Z" fill="white"/></g><defs><filter id="filter0_d_39_32540" x="-3" y="0" width="38.1602" height="38.1602" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="3"/><feGaussianBlur stdDeviation="3"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_39_32540"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_39_32540" result="shape"/></filter><clipPath id="clip0_39_32540"><rect width="32" height="32" fill="white"/></clipPath></defs></svg>', 'singleFree' => '<svg width="33" height="32" viewBox="0 0 33 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_39_32543)"><g filter="url(#filter0_d_39_32543)"><rect x="3.3335" y="3" width="26.1602" height="26.1602" rx="2" fill="#0096CC"/></g><path d="M12.3335 11.809C12.3335 11.4373 12.7247 11.1956 13.0571 11.3618L21.4391 15.5528C21.8076 15.737 21.8076 16.263 21.4391 16.4472L13.0571 20.6382C12.7247 20.8044 12.3335 20.5627 12.3335 20.191V11.809Z" fill="white"/></g><defs><filter id="filter0_d_39_32543" x="-2.6665" y="0" width="38.1602" height="38.1602" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="3"/><feGaussianBlur stdDeviation="3"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_39_32543"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_39_32543" result="shape"/></filter><clipPath id="clip0_39_32543"><rect width="32" height="32" fill="white" transform="translate(0.333496)"/></clipPath></defs></svg>', 'socialWallFree' => '<svg width="33" height="32" viewBox="0 0 33 32" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_39_32546)"><path d="M8.66683 2.18994C5.4585 2.18994 2.8335 4.80911 2.8335 8.03494C2.8335 10.9516 4.9685 13.3724 7.75683 13.8099V9.72661H6.27516V8.03494H7.75683V6.74577C7.75683 5.28161 8.626 4.47661 9.96183 4.47661C10.5977 4.47661 11.2627 4.58744 11.2627 4.58744V6.02827H10.5277C9.80433 6.02827 9.57683 6.47744 9.57683 6.93827V8.03494H11.1985L10.936 9.72661H9.57683V13.8099C10.9514 13.5928 12.2031 12.8915 13.106 11.8325C14.0088 10.7735 14.5033 9.42657 14.5002 8.03494C14.5002 4.80911 11.8752 2.18994 8.66683 2.18994Z" fill="#006BFA"/><path d="M8.66675 21.3047C7.16675 21.3047 5.97144 22.5234 5.97144 24C5.97144 25.5 7.16675 26.6953 8.66675 26.6953C10.1433 26.6953 11.3621 25.5 11.3621 24C11.3621 22.5234 10.1433 21.3047 8.66675 21.3047ZM8.66675 25.7578C7.70581 25.7578 6.90894 24.9844 6.90894 24C6.90894 23.0391 7.68237 22.2656 8.66675 22.2656C9.62769 22.2656 10.4011 23.0391 10.4011 24C10.4011 24.9844 9.62769 25.7578 8.66675 25.7578ZM12.0886 21.2109C12.0886 20.8594 11.8074 20.5781 11.4558 20.5781C11.1042 20.5781 10.823 20.8594 10.823 21.2109C10.823 21.5625 11.1042 21.8438 11.4558 21.8438C11.8074 21.8438 12.0886 21.5625 12.0886 21.2109ZM13.8699 21.8438C13.823 21 13.6355 20.25 13.0261 19.6406C12.4167 19.0312 11.6667 18.8438 10.823 18.7969C9.95581 18.75 7.35425 18.75 6.48706 18.7969C5.64331 18.8438 4.91675 19.0312 4.28394 19.6406C3.67456 20.25 3.48706 21 3.44019 21.8438C3.39331 22.7109 3.39331 25.3125 3.44019 26.1797C3.48706 27.0234 3.67456 27.75 4.28394 28.3828C4.91675 28.9922 5.64331 29.1797 6.48706 29.2266C7.35425 29.2734 9.95581 29.2734 10.823 29.2266C11.6667 29.1797 12.4167 28.9922 13.0261 28.3828C13.6355 27.75 13.823 27.0234 13.8699 26.1797C13.9167 25.3125 13.9167 22.7109 13.8699 21.8438ZM12.7449 27.0938C12.5808 27.5625 12.2058 27.9141 11.7605 28.1016C11.0574 28.3828 9.41675 28.3125 8.66675 28.3125C7.89331 28.3125 6.25269 28.3828 5.573 28.1016C5.10425 27.9141 4.75269 27.5625 4.56519 27.0938C4.28394 26.4141 4.35425 24.7734 4.35425 24C4.35425 23.25 4.28394 21.6094 4.56519 20.9062C4.75269 20.4609 5.10425 20.1094 5.573 19.9219C6.25269 19.6406 7.89331 19.7109 8.66675 19.7109C9.41675 19.7109 11.0574 19.6406 11.7605 19.9219C12.2058 20.0859 12.5574 20.4609 12.7449 20.9062C13.0261 21.6094 12.9558 23.25 12.9558 24C12.9558 24.7734 13.0261 26.4141 12.7449 27.0938Z" fill="url(#paint0_linear_39_32546)"/><path d="M30.7685 4.50016C30.3194 4.70433 29.8352 4.8385 29.3335 4.90266C29.8469 4.5935 30.2435 4.1035 30.4302 3.51433C29.946 3.806 29.4094 4.01016 28.8435 4.12683C28.3827 3.62516 27.7352 3.3335 27.0002 3.3335C25.6294 3.3335 24.5094 4.4535 24.5094 5.836C24.5094 6.03433 24.5327 6.22683 24.5735 6.40766C22.4969 6.30266 20.6477 5.30516 19.4169 3.79433C19.201 4.16183 19.0785 4.5935 19.0785 5.0485C19.0785 5.91766 19.516 6.68766 20.1927 7.12516C19.7785 7.12516 19.3935 7.0085 19.0552 6.8335V6.851C19.0552 8.06433 19.9185 9.07933 21.0619 9.30683C20.6948 9.40728 20.3094 9.42126 19.936 9.34766C20.0945 9.84494 20.4047 10.2801 20.8233 10.5919C21.2418 10.9037 21.7475 11.0765 22.2694 11.086C21.3848 11.7863 20.2884 12.1648 19.1602 12.1593C18.9619 12.1593 18.7635 12.1477 18.5652 12.1243C19.6735 12.836 20.9919 13.2502 22.4035 13.2502C27.0002 13.2502 29.526 9.43516 29.526 6.12766C29.526 6.01683 29.526 5.91183 29.5202 5.801C30.0102 5.451 30.4302 5.00766 30.7685 4.50016Z" fill="#1B90EF"/><path d="M23.5002 25.7498L26.5277 23.9998L23.5002 22.2498V25.7498ZM30.2435 21.1823C30.3193 21.4565 30.3718 21.824 30.4068 22.2907C30.4477 22.7573 30.4652 23.1598 30.4652 23.5098L30.5002 23.9998C30.5002 25.2773 30.4068 26.2165 30.2435 26.8173C30.0977 27.3423 29.7593 27.6807 29.2343 27.8265C28.9602 27.9023 28.4585 27.9548 27.6885 27.9898C26.9302 28.0307 26.236 28.0482 25.5943 28.0482L24.6668 28.0832C22.2227 28.0832 20.7002 27.9898 20.0993 27.8265C19.5743 27.6807 19.236 27.3423 19.0902 26.8173C19.0143 26.5432 18.9618 26.1757 18.9268 25.709C18.886 25.2423 18.8685 24.8398 18.8685 24.4898L18.8335 23.9998C18.8335 22.7223 18.9268 21.7832 19.0902 21.1823C19.236 20.6573 19.5743 20.319 20.0993 20.1732C20.3735 20.0973 20.8752 20.0448 21.6452 20.0098C22.4035 19.969 23.0977 19.9515 23.7393 19.9515L24.6668 19.9165C27.111 19.9165 28.6335 20.0098 29.2343 20.1732C29.7593 20.319 30.0977 20.6573 30.2435 21.1823Z" fill="#EB2121"/></g><defs><linearGradient id="paint0_linear_39_32546" x1="7.14565" y1="38.843" x2="29.2613" y2="16.268" gradientUnits="userSpaceOnUse"><stop stop-color="white"/><stop offset="0.147864" stop-color="#F6640E"/><stop offset="0.443974" stop-color="#BA03A7"/><stop offset="0.733337" stop-color="#6A01B9"/><stop offset="1" stop-color="#6B01B9"/></linearGradient><clipPath id="clip0_39_32546"><rect width="32" height="32" fill="white" transform="translate(0.666748)"/></clipPath></defs></svg>', 'spinner' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!--! Font Awesome Pro 6.1.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2022 Fonticons, Inc. --><path d="M304 48C304 74.51 282.5 96 256 96C229.5 96 208 74.51 208 48C208 21.49 229.5 0 256 0C282.5 0 304 21.49 304 48zM304 464C304 490.5 282.5 512 256 512C229.5 512 208 490.5 208 464C208 437.5 229.5 416 256 416C282.5 416 304 437.5 304 464zM0 256C0 229.5 21.49 208 48 208C74.51 208 96 229.5 96 256C96 282.5 74.51 304 48 304C21.49 304 0 282.5 0 256zM512 256C512 282.5 490.5 304 464 304C437.5 304 416 282.5 416 256C416 229.5 437.5 208 464 208C490.5 208 512 229.5 512 256zM74.98 437C56.23 418.3 56.23 387.9 74.98 369.1C93.73 350.4 124.1 350.4 142.9 369.1C161.6 387.9 161.6 418.3 142.9 437C124.1 455.8 93.73 455.8 74.98 437V437zM142.9 142.9C124.1 161.6 93.73 161.6 74.98 142.9C56.24 124.1 56.24 93.73 74.98 74.98C93.73 56.23 124.1 56.23 142.9 74.98C161.6 93.73 161.6 124.1 142.9 142.9zM369.1 369.1C387.9 350.4 418.3 350.4 437 369.1C455.8 387.9 455.8 418.3 437 437C418.3 455.8 387.9 455.8 369.1 437C350.4 418.3 350.4 387.9 369.1 369.1V369.1z"/></svg>', 'feedtype' => '<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16 2V16H2V2H16ZM18 0H0V18H18V0ZM14 14H4V13H14V14ZM14 12H4V11H14V12ZM14 9H4V4H14V9Z" fill="#141B38"/></svg>', 'filters' => '<svg width="18" height="12" viewBox="0 0 18 12" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3 7H15V5H3V7ZM0 0V2H18V0H0ZM7 12H11V10H7V12Z" fill="#141B38"/></svg>', 'tweakVideo' => '<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16 2V16H2V2H16ZM18 0H0V18H18V0ZM14 14H4V13H14V14ZM14 12H4V11H14V12ZM14 9H4V4H14V9Z" fill="#141B38"/></svg>', 'eye2' => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M7.99984 6C7.4694 6 6.9607 6.21071 6.58562 6.58579C6.21055 6.96086 5.99984 7.46957 5.99984 8C5.99984 8.53043 6.21055 9.03914 6.58562 9.41421C6.9607 9.78929 7.4694 10 7.99984 10C8.53027 10 9.03898 9.78929 9.41405 9.41421C9.78912 9.03914 9.99984 8.53043 9.99984 8C9.99984 7.46957 9.78912 6.96086 9.41405 6.58579C9.03898 6.21071 8.53027 6 7.99984 6ZM7.99984 11.3333C7.11578 11.3333 6.26794 10.9821 5.64281 10.357C5.01769 9.7319 4.6665 8.88406 4.6665 8C4.6665 7.11595 5.01769 6.2681 5.64281 5.64298C6.26794 5.01786 7.11578 4.66667 7.99984 4.66667C8.88389 4.66667 9.73174 5.01786 10.3569 5.64298C10.982 6.2681 11.3332 7.11595 11.3332 8C11.3332 8.88406 10.982 9.7319 10.3569 10.357C9.73174 10.9821 8.88389 11.3333 7.99984 11.3333ZM7.99984 3C4.6665 3 1.81984 5.07333 0.666504 8C1.81984 10.9267 4.6665 13 7.99984 13C11.3332 13 14.1798 10.9267 15.3332 8C14.1798 5.07333 11.3332 3 7.99984 3Z" fill="#141B38"/></svg>', 'times' => '<svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.66671 1.27334L8.72671 0.333344L5.00004 4.06001L1.27337 0.333344L0.333374 1.27334L4.06004 5.00001L0.333374 8.72668L1.27337 9.66668L5.00004 5.94001L8.72671 9.66668L9.66671 8.72668L5.94004 5.00001L9.66671 1.27334Z" fill="#841919"/></svg>', 'ctaBoxes' => array('live' => '<svg width="56" height="56" viewBox="0 0 56 56" fill="none" xmlns="http://www.w3.org/2000/svg"><rect x="18.2598" y="18.8797" width="33.8724" height="28.8912" transform="rotate(4 18.2598 18.8797)" fill="#8C8F9A"/><path d="M29.6665 28.6654L40.2163 34.8959L28.9021 39.5974L29.6665 28.6654Z" fill="white"/><rect x="18.2598" y="18.8797" width="33.8724" height="28.8912" transform="rotate(4 18.2598 18.8797)" stroke="white" stroke-width="1.9925"/><rect x="5.5448" y="3.05956" width="25.7622" height="25.7622" rx="12.8811" transform="rotate(4 5.5448 3.05956)" fill="#0096CC"/><path d="M13.491 11.8079C13.5568 11.8737 13.609 11.9518 13.6447 12.0377C13.6803 12.1237 13.6986 12.2158 13.6986 12.3088C13.6986 12.4019 13.6803 12.494 13.6447 12.58C13.609 12.6659 13.5568 12.744 13.491 12.8098C12.4286 13.8723 11.8317 15.3134 11.8317 16.816C11.8317 18.3186 12.4286 19.7597 13.491 20.8223C13.5567 20.8881 13.6088 20.9662 13.6444 21.0521C13.68 21.138 13.6982 21.2301 13.6982 21.3231C13.6982 21.4161 13.6798 21.5082 13.6442 21.5941C13.6086 21.68 13.5564 21.758 13.4906 21.8238C13.4248 21.8895 13.3468 21.9416 13.2608 21.9772C13.1749 22.0127 13.0828 22.031 12.9898 22.031C12.8968 22.031 12.8047 22.0126 12.7188 21.977C12.6329 21.9414 12.5549 21.8892 12.4891 21.8234C9.72367 19.0579 9.72367 14.5734 12.4891 11.8079C12.5549 11.7421 12.633 11.6899 12.7189 11.6542C12.8049 11.6186 12.897 11.6003 12.9901 11.6003C13.0831 11.6003 13.1752 11.6186 13.2612 11.6542C13.3471 11.6899 13.4252 11.7421 13.491 11.8079ZM22.5046 11.8079C25.2701 14.5741 25.2701 19.0579 22.5046 21.8234C22.3711 21.9524 22.1923 22.0237 22.0066 22.0221C21.821 22.0205 21.6434 21.9461 21.5121 21.8148C21.3809 21.6835 21.3064 21.5059 21.3048 21.3203C21.3032 21.1347 21.3745 20.9558 21.5035 20.8223C22.5659 19.7597 23.1628 18.3186 23.1628 16.816C23.1628 15.3134 22.5659 13.8723 21.5035 12.8098C21.3707 12.677 21.296 12.4969 21.2959 12.3091C21.2958 12.1213 21.3704 11.9411 21.5031 11.8083C21.6359 11.6754 21.816 11.6008 22.0038 11.6007C22.1916 11.6006 22.3718 11.6752 22.5046 11.8079ZM15.5916 13.8427C15.7244 13.9755 15.7989 14.1556 15.7989 14.3433C15.7989 14.531 15.7244 14.7111 15.5916 14.8439C15.3339 15.1016 15.1294 15.4076 14.9899 15.7443C14.8504 16.081 14.7786 16.442 14.7786 16.8065C14.7786 17.171 14.8504 17.5319 14.9899 17.8686C15.1294 18.2054 15.3339 18.5113 15.5916 18.7691C15.6593 18.8344 15.7132 18.9125 15.7503 18.9989C15.7874 19.0853 15.8069 19.1782 15.8078 19.2722C15.8086 19.3662 15.7907 19.4594 15.7551 19.5464C15.7195 19.6334 15.6669 19.7125 15.6004 19.779C15.5339 19.8454 15.4549 19.898 15.3679 19.9336C15.2809 19.9692 15.1876 19.9871 15.0936 19.9863C14.9996 19.9855 14.9067 19.966 14.8203 19.9289C14.734 19.8917 14.6558 19.8378 14.5905 19.7702C13.8045 18.9841 13.3629 17.9181 13.3629 16.8065C13.3629 15.6949 13.8045 14.6288 14.5905 13.8427C14.7233 13.71 14.9033 13.6354 15.0911 13.6354C15.2788 13.6354 15.4589 13.71 15.5916 13.8427ZM20.5187 13.8427C21.3047 14.6288 21.7462 15.6949 21.7462 16.8065C21.7462 17.9181 21.3047 18.9841 20.5187 19.7702C20.4529 19.836 20.3749 19.8882 20.289 19.9238C20.2031 19.9594 20.111 19.9777 20.018 19.9778C19.925 19.9778 19.8329 19.9595 19.747 19.924C19.6611 19.8884 19.583 19.8363 19.5172 19.7705C19.4514 19.7048 19.3992 19.6268 19.3636 19.5409C19.328 19.4549 19.3096 19.3629 19.3096 19.2699C19.3096 19.1769 19.3278 19.0848 19.3634 18.9989C19.399 18.9129 19.4511 18.8348 19.5168 18.7691C19.7746 18.5113 19.979 18.2054 20.1185 17.8686C20.258 17.5319 20.3298 17.171 20.3298 16.8065C20.3298 16.442 20.258 16.081 20.1185 15.7443C19.979 15.4076 19.7746 15.1016 19.5168 14.8439C19.3841 14.711 19.3095 14.5309 19.3096 14.3431C19.3097 14.1552 19.3843 13.9751 19.5172 13.8424C19.65 13.7096 19.8302 13.6351 20.018 13.6352C20.2058 13.6352 20.3859 13.7099 20.5187 13.8427ZM17.5542 15.8039C17.6937 15.8039 17.8318 15.8314 17.9606 15.8848C18.0895 15.9381 18.2066 16.0164 18.3052 16.115C18.4038 16.2136 18.482 16.3307 18.5354 16.4595C18.5888 16.5884 18.6162 16.7265 18.6162 16.8659C18.6162 17.0054 18.5888 17.1435 18.5354 17.2724C18.482 17.4012 18.4038 17.5183 18.3052 17.6169C18.2066 17.7155 18.0895 17.7937 17.9606 17.8471C17.8318 17.9005 17.6937 17.9279 17.5542 17.9279C17.2726 17.9279 17.0024 17.8161 16.8033 17.6169C16.6041 17.4177 16.4922 17.1476 16.4922 16.8659C16.4922 16.5843 16.6041 16.3141 16.8033 16.115C17.0024 15.9158 17.2726 15.8039 17.5542 15.8039Z" fill="white"/><rect x="5.5448" y="3.05956" width="25.7622" height="25.7622" rx="12.8811" transform="rotate(4 5.5448 3.05956)" stroke="white" stroke-width="1.76224"/></svg>', 'feeds' => '<svg width="56" height="56" viewBox="0 0 56 56" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="28.1951" height="27" transform="translate(2.66699 10.4574) rotate(-5)" fill="#8C8F9A"/><path d="M24.869 21.1557C24.8383 20.8053 24.6698 20.4815 24.4003 20.2554C24.1309 20.0293 23.7827 19.9195 23.4323 19.9502L19.2577 20.3154L19.6277 17.2413C19.6351 17.174 19.6354 17.1008 19.629 17.0281C19.6053 16.7573 19.4711 16.5161 19.2771 16.3534L18.5163 15.7211L14.5501 20.4477C14.3271 20.7135 14.2107 21.0565 14.2425 21.4198L14.8204 28.0253C14.851 28.3756 15.0196 28.6995 15.2891 28.9256C15.5585 29.1516 15.9067 29.2614 16.2571 29.2308L22.202 28.7106C22.7502 28.6627 23.1903 28.2914 23.3469 27.7985L24.9343 22.9671C24.9804 22.81 24.9996 22.6485 24.9846 22.4768L24.869 21.1557ZM10.9727 29.6931L13.6149 29.4619L12.9214 21.5354L10.2792 21.7665L10.9727 29.6931Z" fill="white"/><rect x="24.0895" y="15.6761" width="30.1951" height="30" transform="rotate(6 24.0895 15.6761)" fill="#0096CC"/><circle cx="36.1335" cy="31.0152" r="6.125" transform="rotate(-39 36.1335 31.0152)" stroke="white" stroke-width="1.75"/><line x1="40.3895" y1="36.4399" x2="44.2441" y2="41.1999" stroke="white" stroke-width="1.75"/><rect x="24.0895" y="15.6761" width="30.1951" height="30" transform="rotate(6 24.0895 15.6761)" stroke="white" stroke-width="2"/></svg>', 'customActions' => '<svg width="56" height="56" viewBox="0 0 56 56" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.12134 11.8722L5.12515 11.9593L5.2123 12.9555L6.95542 32.8794L7.04257 33.8756L8.03877 33.7884L49.8789 30.1279L50.8751 30.0407L50.788 29.0445L49.0449 9.12065L48.9577 8.12446L47.9615 8.21161L6.12134 11.8722Z" fill="#0096CC" stroke="white" stroke-width="2"/><mask id="path-2-outside-1_132_33106" maskUnits="userSpaceOnUse" x="16.8979" y="18.7396" width="34.6495" height="37.3294" fill="black"><rect fill="white" x="16.8979" y="18.7396" width="34.6495" height="37.3294"/><path fill-rule="evenodd" clip-rule="evenodd" d="M44.8846 41.958L30.1629 28.263L29.5969 48.3618L34.8984 42.9553L37.7189 49.6885L40.1327 48.6774L37.3122 41.944L44.8846 41.958Z"/></mask><path fill-rule="evenodd" clip-rule="evenodd" d="M44.8846 41.958L30.1629 28.263L29.5969 48.3618L34.8984 42.9553L37.7189 49.6885L40.1327 48.6774L37.3122 41.944L44.8846 41.958Z" fill="#8C8F9A"/><path d="M30.1629 28.263L31.5251 26.7986L28.2881 23.7874L28.1637 28.2067L30.1629 28.263ZM44.8846 41.958L44.8809 43.958L49.981 43.9674L46.2468 40.4936L44.8846 41.958ZM29.5969 48.3618L27.5977 48.3055L27.4541 53.4035L31.0249 49.762L29.5969 48.3618ZM34.8984 42.9553L36.7431 42.1826L35.5793 39.4043L33.4704 41.555L34.8984 42.9553ZM37.7189 49.6885L35.8742 50.4612L36.6469 52.3059L38.4916 51.5332L37.7189 49.6885ZM40.1327 48.6774L40.9054 50.5221L42.7501 49.7494L41.9774 47.9047L40.1327 48.6774ZM37.3122 41.944L37.3159 39.944L34.3037 39.9385L35.4675 42.7167L37.3122 41.944ZM28.8007 29.7273L43.5224 43.4223L46.2468 40.4936L31.5251 26.7986L28.8007 29.7273ZM31.5961 48.4181L32.1621 28.3193L28.1637 28.2067L27.5977 48.3055L31.5961 48.4181ZM33.4704 41.555L28.1689 46.9615L31.0249 49.762L36.3264 44.3555L33.4704 41.555ZM39.5636 48.9158L36.7431 42.1826L33.0537 43.728L35.8742 50.4612L39.5636 48.9158ZM39.36 46.8327L36.9462 47.8438L38.4916 51.5332L40.9054 50.5221L39.36 46.8327ZM35.4675 42.7167L38.288 49.4501L41.9774 47.9047L39.1569 41.1713L35.4675 42.7167ZM44.8883 39.958L37.3159 39.944L37.3085 43.944L44.8809 43.958L44.8883 39.958Z" fill="white" mask="url(#path-2-outside-1_132_33106)"/></svg>', 'convertVideos' => '<svg width="56" height="56" viewBox="0 0 56 56" fill="none" xmlns="http://www.w3.org/2000/svg"><rect x="4.7088" y="6.33766" width="30.7021" height="26.2163" transform="rotate(-5 4.7088 6.33766)" fill="#8C8F9A"/><path d="M16.8325 13.882L26.2651 17.6099L17.6232 22.9192L16.8325 13.882Z" fill="white"/><rect x="4.7088" y="6.33766" width="30.7021" height="26.2163" transform="rotate(-5 4.7088 6.33766)" stroke="white" stroke-width="1.9925"/><rect x="22.4948" y="22.8066" width="30.7021" height="26.2163" transform="rotate(5 22.4948 22.8066)" fill="#0096CC"/><g clip-path="url(#clip0_132_33117)"><path d="M37.6103 31.4991L39.1112 29.9981L44.3564 35.235L42.8471 36.736C42.415 36.4568 41.9003 36.334 41.3886 36.388C40.877 36.4421 40.3992 36.6696 40.0349 37.0329L39.4164 37.6514C38.6576 38.4184 38.5587 39.5895 39.1277 40.4636L37.6185 41.9646L35.631 39.9771L33.3218 42.278C32.9754 42.6244 30.5343 44.5129 30.1879 44.1666C29.8415 43.8202 31.7218 41.3708 32.0682 41.0244L34.3692 38.7235L32.3816 36.7277L33.8908 35.2268C34.7568 35.7958 35.9361 35.6968 36.6948 34.9299L37.3134 34.3113C38.0803 33.5526 38.1793 32.3733 37.6103 31.4991Z" fill="white"/></g><rect x="22.4948" y="22.8066" width="30.7021" height="26.2163" transform="rotate(5 22.4948 22.8066)" stroke="white" stroke-width="1.9925"/><defs><clipPath id="clip0_132_33117"><rect width="16.4941" height="16.4941" fill="white" transform="translate(29.0005 29.0084)"/></clipPath></defs></svg>'), 'blockEditorSBYLogo' => '<svg width="85" height="83" viewBox="0 0 85 83" fill="none" xmlns="http://www.w3.org/2000/svg">
			<rect x="0.741211" y="4.43494" width="65.6329" height="65.6329" rx="12" transform="rotate(-3 0.741211 4.43494)" fill="white"/><rect x="0.741211" y="4.43494" width="65.6329" height="65.6329" rx="12" transform="rotate(-3 0.741211 4.43494)" stroke="#CED0D9" stroke-width="2.5003"/><path d="M53.9905 60.4452C53.9905 68.7888 58.9735 75.931 65.7567 77.1715L65.3607 78.4257L64.9589 79.6978L66.2882 79.5848L70.7757 79.2031L72.4649 79.0594L71.3914 77.7473L70.7667 76.9839C77.1177 75.3291 81.6921 68.4326 81.6921 60.4452C81.6921 51.2906 75.6605 43.5316 67.8426 43.5316C60.025 43.5316 53.9905 51.2904 53.9905 60.4452Z" fill="#FE544F" stroke="white" stroke-width="1.78661"/><path fill-rule="evenodd" clip-rule="evenodd" d="M70.9321 50.0573L71.5556 56.491L78.0164 56.6766L73.3428 61.0221L77.0341 66.3611L70.8155 65.1921L68.9303 71.4108L66.0678 65.842L60.288 68.4904L62.5114 62.5204L56.8745 59.6772L62.9087 57.7366L61.2436 51.7922L66.9523 55.0468L70.9321 50.0573Z" fill="white"/><path d="M32.5014 38.8257L40.3553 33.7196L32.0107 29.4624L32.5014 38.8257ZM49.901 25.6612C50.1423 26.384 50.3342 27.3598 50.4933 28.6033C50.668 29.846 50.7712 30.9204 50.8203 31.8567L50.9826 33.1626C51.1617 36.5802 51.0437 39.1058 50.691 40.7361C50.3745 42.161 49.5168 43.1135 48.1327 43.5773C47.4099 43.8186 46.0752 44.0294 44.0202 44.231C41.9972 44.4465 40.1426 44.5907 38.426 44.6806L35.9497 44.9043C29.411 45.247 25.3249 45.2107 23.6946 44.858C22.2697 44.5415 21.3171 43.6838 20.8534 42.2998C20.6121 41.577 20.4201 40.6012 20.261 39.3576C20.0864 38.1149 19.9831 37.0406 19.934 36.1043L19.7717 34.7983C19.5926 31.3807 19.7106 28.8552 20.0633 27.2249C20.3799 25.8 21.2375 24.8474 22.6216 24.3837C23.3444 24.1424 24.6791 23.9316 26.7341 23.73C28.7571 23.5144 30.6117 23.3703 32.3283 23.2803L34.8047 23.0567C41.3434 22.714 45.4295 22.7502 47.0597 23.1029C48.4847 23.4195 49.4372 24.2771 49.901 25.6612Z" fill="#EB2121"/></svg>
			', 'calltoaction' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M10.8327 4.16663C12.6743 4.16663 14.166 5.65829 14.166 7.49996C14.166 8.74996 13.4993 9.80829 12.4993 10.3833V9.36663C13.0077 8.90829 13.3327 8.24163 13.3327 7.49996C13.3327 6.11663 12.216 4.99996 10.8327 4.99996C9.44935 4.99996 8.33268 6.11663 8.33268 7.49996C8.33268 8.24163 8.65768 8.90829 9.16602 9.36663V10.3833C8.16602 9.80829 7.49935 8.74996 7.49935 7.49996C7.49935 5.65829 8.99102 4.16663 10.8327 4.16663ZM16.666 17.0833C16.641 17.7666 16.0993 18.3083 15.416 18.3333H10.8327C10.516 18.3333 10.216 18.2083 9.99935 17.975L6.66602 14.475L7.28268 13.8333C7.44102 13.6583 7.66602 13.5666 7.91602 13.5666H8.08268L9.99935 15V7.49996C9.99935 7.04163 10.3743 6.66663 10.8327 6.66663C11.291 6.66663 11.666 7.04163 11.666 7.49996V11.225L12.6743 11.3333L15.9577 13.1583C16.3993 13.3583 16.666 13.8 16.666 14.2833V17.0833ZM16.666 1.66663H3.33268C2.41602 1.66663 1.66602 2.41663 1.66602 3.33329V9.99996C1.66602 10.442 1.84161 10.8659 2.15417 11.1785C2.46673 11.491 2.89065 11.6666 3.33268 11.6666H6.66602V9.99996H3.33268V3.33329H16.666V9.99996H14.9993V11.6666H16.666V11.6333L16.6993 11.6666C17.6077 11.6666 18.3327 10.9083 18.3327 9.99996V3.33329C18.3327 2.89127 18.1571 2.46734 17.8445 2.15478C17.532 1.84222 17.108 1.66663 16.666 1.66663Z" fill="#141B38"/></svg>', 'whiteBalloon' => '<svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M10.3846 0C14.5285 0 17.8865 4.15304 17.8865 9.27605C17.8865 14.0906 14.9214 18.0472 11.1275 18.5076L12.0391 19.6218L9.44076 19.8428L9.85514 18.5306C5.95841 18.1945 2.88123 14.1873 2.88123 9.27605C2.88123 4.15304 6.2408 0 10.3846 0ZM12.5354 6.98648L12.1744 3.26121L9.87004 6.15028L6.56458 4.2658L7.52868 7.7077L4.03479 8.83136L7.29867 10.4776L6.01129 13.9343L9.35787 12.4009L11.0153 15.6253L12.1069 12.0246L15.7076 12.7014L13.5702 9.61006L16.2763 7.09394L12.5354 6.98648Z" fill="white"/> </svg>');
        return $builder_svg_icons;
    }
    /**
     * Color Overrides Manager
     *
     * @return array
     *
     * @since 2.0
     */
    public static function get_color_overrides()
    {
        return [['heading' => __('Play Icon', 'youtube-feed-pro'), 'elements' => ['playiconcolor'], 'enableViewAction' => ['sections' => ['customize', 'sections', 'customize_videos', 'nested_sections', 'individual_elements', 'controls', 2, 'section'], 'id' => 'playicon_styling_title'], 'controls' => [['heading' => __('Text', 'youtube-feed-pro'), 'id' => 'videotitlecolor']]], ['heading' => __('Video Title', 'youtube-feed-pro'), 'elements' => ['videotitlecolor'], 'enableViewAction' => ['sections' => ['customize', 'sections', 'customize_videos', 'nested_sections', 'individual_elements', 'controls', 2, 'section'], 'id' => 'video_styling_title'], 'controls' => [['heading' => __('Text', 'youtube-feed-pro'), 'id' => 'videotitlecolor']]], ['heading' => __('Username', 'youtube-feed-pro'), 'elements' => ['videouserecolor'], 'enableViewAction' => ['sections' => ['customize', 'sections', 'customize_videos', 'nested_sections', 'individual_elements', 'controls', 3, 'section'], 'id' => 'user_styling_title'], 'controls' => [['heading' => __('Text', 'youtube-feed-pro'), 'id' => 'videouserecolor']]], ['heading' => __('Views Actions', 'youtube-feed-pro'), 'elements' => ['videoviewsecolor'], 'enableViewAction' => ['sections' => ['customize', 'sections', 'customize_videos', 'nested_sections', 'individual_elements', 'controls', 2, 'section'], 'id' => 'views_styling_title'], 'controls' => [['heading' => __('Text', 'youtube-feed-pro'), 'id' => 'videoviewsecolor']]], ['heading' => __('Live Stream Countdown', 'youtube-feed-pro'), 'elements' => ['videocountdowncolor'], 'enableViewAction' => ['sections' => ['customize', 'sections', 'customize_videos', 'nested_sections', 'individual_elements', 'controls', 2, 'section'], 'id' => 'countdown_styling_title'], 'controls' => [['heading' => __('Text', 'youtube-feed-pro'), 'id' => 'videocountdowncolor']]], ['heading' => __('Likes and Comments Summary', 'youtube-feed-pro'), 'elements' => ['videostatscolor'], 'enableViewAction' => ['sections' => ['customize', 'sections', 'customize_videos', 'nested_sections', 'individual_elements', 'controls', 2, 'section'], 'id' => 'stats_styling_title'], 'controls' => [['heading' => __('Text', 'youtube-feed-pro'), 'id' => 'videostatscolor']]], ['heading' => __('Date', 'youtube-feed-pro'), 'elements' => ['videodatecolor'], 'enableViewAction' => ['sections' => ['customize', 'sections', 'customize_videos', 'nested_sections', 'individual_elements', 'controls', 2, 'section'], 'id' => 'date_styling_title'], 'controls' => [['heading' => __('Text', 'youtube-feed-pro'), 'id' => 'videodatecolor']]], ['heading' => __('Description', 'youtube-feed-pro'), 'elements' => ['videodescriptioncolor'], 'enableViewAction' => ['sections' => ['customize', 'sections', 'customize_videos', 'nested_sections', 'individual_elements', 'controls', 2, 'section'], 'id' => 'description_styling_title'], 'controls' => [['heading' => __('Text', 'youtube-feed-pro'), 'id' => 'videodescriptioncolor']]]];
    }
    /**
     * Plugins information for plugin install modal in all feeds page on select source flow
     *
     * @since 6.0
     *
     * @return array
     */
    public function install_plugins_popup()
    {
        // get the WordPress's core list of installed plugins
        if (!function_exists('get_plugins')) {
            require_once CUSTOMIZER_ABSPATH . 'wp-admin/includes/plugin.php';
        }
        $installed_plugins = get_plugins();
        $is_facebook_installed = \false;
        $facebook_plugin = 'custom-facebook-feed/custom-facebook-feed.php';
        if (isset($installed_plugins['custom-facebook-feed-pro/custom-facebook-feed.php'])) {
            $is_facebook_installed = \true;
            $facebook_plugin = 'custom-facebook-feed-pro/custom-facebook-feed.php';
        } elseif (isset($installed_plugins['custom-facebook-feed/custom-facebook-feed.php'])) {
            $is_facebook_installed = \true;
        }
        $is_twitter_installed = \false;
        $twitter_plugin = 'custom-twitter-feeds/custom-twitter-feed.php';
        if (isset($installed_plugins['custom-twitter-feeds-pro/custom-twitter-feed.php'])) {
            $is_twitter_installed = \true;
            $twitter_plugin = 'custom-twitter-feeds-pro/custom-twitter-feed.php';
        } elseif (isset($installed_plugins['custom-twitter-feeds/custom-twitter-feed.php'])) {
            $is_twitter_installed = \true;
        }
        $is_youtube_installed = \false;
        $youtube_plugin = 'feeds-for-youtube/youtube-feed-pro.php';
        if (isset($installed_plugins['youtube-feed-pro/youtube-feed-pro.php'])) {
            $is_youtube_installed = \true;
            $youtube_plugin = 'youtube-feed-pro/youtube-feed-pro.php';
        } elseif (isset($installed_plugins['feeds-for-youtube/youtube-feed-pro.php'])) {
            $is_youtube_installed = \true;
        }
        return array('facebook' => array('displayName' => __('Facebook', 'feeds-for-youtube'), 'name' => __('Facebook Feed', 'feeds-for-youtube'), 'author' => __('By Smash Balloon', 'feeds-for-youtube'), 'description' => __('To display a Facebook feed, our Facebook plugin is required. </br> It provides a clean and beautiful way to add your Facebook posts to your website. Grab your visitors attention and keep them engaged with your site longer.', 'feeds-for-youtube'), 'dashboard_permalink' => admin_url('admin.php?page=cff-feed-builder'), 'svgIcon' => '<svg viewBox="0 0 14 15"  width="36" height="36"><path d="M7.00016 0.860001C3.3335 0.860001 0.333496 3.85333 0.333496 7.54C0.333496 10.8733 2.7735 13.64 5.96016 14.14V9.47333H4.26683V7.54H5.96016V6.06667C5.96016 4.39333 6.9535 3.47333 8.48016 3.47333C9.20683 3.47333 9.96683 3.6 9.96683 3.6V5.24667H9.12683C8.30016 5.24667 8.04016 5.76 8.04016 6.28667V7.54H9.8935L9.5935 9.47333H8.04016V14.14C9.61112 13.8919 11.0416 13.0903 12.0734 11.88C13.1053 10.6697 13.6704 9.13043 13.6668 7.54C13.6668 3.85333 10.6668 0.860001 7.00016 0.860001Z" fill="rgb(0, 107, 250)"/></svg>', 'installed' => $is_facebook_installed, 'activated' => is_plugin_active($facebook_plugin), 'plugin' => $facebook_plugin, 'download_plugin' => 'https://downloads.wordpress.org/plugin/custom-facebook-feed.zip'), 'twitter' => array('displayName' => __('Twitter', 'feeds-for-youtube'), 'name' => __('Twitter Feed', 'feeds-for-youtube'), 'author' => __('By Smash Balloon', 'feeds-for-youtube'), 'description' => __('Custom Twitter Feeds is a highly customizable way to display tweets from your Twitter account. Promote your latest content and update your site content automatically.', 'feeds-for-youtube'), 'dashboard_permalink' => admin_url('admin.php?page=custom-twitter-feeds'), 'svgIcon' => '<svg width="36" height="36" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M33.6905 9C32.5355 9.525 31.2905 9.87 30.0005 10.035C31.3205 9.24 32.3405 7.98 32.8205 6.465C31.5755 7.215 30.1955 7.74 28.7405 8.04C27.5555 6.75 25.8905 6 26.0005 6C20.4755 6 17.5955 8.88 17.5955 12.435C17.5955 12.945 17.6555 13.44 17.7605 13.905C12.4205 13.635 7.66555 11.07 4.50055 7.185C3.94555 8.13 3.63055 9.24 3.63055 10.41C3.63055 12.645 4.75555 14.625 6.49555 15.75C5.43055 15.75 4.44055 15.45 3.57055 15V15.045C3.57055 18.165 5.79055 20.775 8.73055 21.36C7.78664 21.6183 6.79569 21.6543 5.83555 21.465C6.24296 22.7437 7.04085 23.8626 8.11707 24.6644C9.19329 25.4662 10.4937 25.9105 11.8355 25.935C9.56099 27.7357 6.74154 28.709 3.84055 28.695C3.33055 28.695 2.82055 28.665 2.31055 28.605C5.16055 30.435 8.55055 31.5 12.1805 31.5C26.0005 31.5 30.4955 21.69 30.4955 13.185C30.4955 12.9 30.4955 12.63 30.4805 12.345C31.7405 11.445 32.8205 10.305 33.6905 9Z" fill="#1B90EF"/></svg>', 'installed' => $is_twitter_installed, 'activated' => is_plugin_active($twitter_plugin), 'plugin' => $twitter_plugin, 'download_plugin' => 'https://downloads.wordpress.org/plugin/custom-twitter-feeds.zip'), 'youtube' => array('displayName' => __('YouTube', 'feeds-for-youtube'), 'name' => __('Feeds for YouTube', 'feeds-for-youtube'), 'author' => __('By Smash Balloon', 'feeds-for-youtube'), 'description' => __('To display a YouTube feed, our YouTube plugin is required. It provides a simple yet powerful way to display videos from YouTube on your website, Increasing engagement with your channel while keeping visitors on your website.', 'feeds-for-youtube'), 'dashboard_permalink' => admin_url('admin.php?page=youtube-feed'), 'svgIcon' => '<svg width="36" height="36" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M15 22.5L22.785 18L15 13.5V22.5ZM32.34 10.755C32.535 11.46 32.67 12.405 32.76 13.605C32.865 14.805 32.91 15.84 32.91 16.74L33 18C33 21.285 32.76 23.7 32.34 25.245C31.965 26.595 31.095 27.465 29.745 27.84C29.04 28.035 27.75 28.17 25.77 28.26C23.82 28.365 22.035 28.41 20.385 28.41L18 28.5C11.715 28.5 7.8 28.26 6.255 27.84C4.905 27.465 6.035 26.595 3.66 25.245C3.465 24.54 3.33 23.595 3.24 22.395C3.135 21.195 3.09 20.16 3.09 19.26L3 18C3 14.715 3.24 12.3 3.66 10.755C6.035 9.405 4.905 8.535 6.255 8.16C6.96 7.965 8.25 7.83 10.23 7.74C12.18 7.635 13.965 7.59 15.615 7.59L18 7.5C24.285 7.5 28.2 7.74 29.745 8.16C31.095 8.535 31.965 9.405 32.34 10.755Z" fill="#EB2121"/></svg>', 'installed' => $is_youtube_installed, 'activated' => is_plugin_active($youtube_plugin), 'plugin' => $youtube_plugin, 'download_plugin' => 'https://downloads.wordpress.org/plugin/feeds-for-youtube.zip'));
    }
    /**
     * Gets a list of info
     * Used in multiple places in the feed creator
     * Other Platforms + Social Links
     * Upgrade links
     *
     * @return array
     *
     * @since 6.0
     */
    public static function get_smashballoon_info()
    {
        $smash_info = array('colorSchemes' => array('facebook' => '#006BFA', 'twitter' => '#1B90EF', 'instagram' => '#BA03A7', 'youtube' => '#EB2121', 'linkedin' => '#007bb6', 'mail' => '#666', 'smash' => '#EB2121'), 'upgrade' => array('name' => __('Upgrade to Pro', 'feeds-for-youtube'), 'icon' => 'instagram', 'link' => 'https://smashballoon.com/instagram-feed/'), 'platforms' => array(array('name' => __('Facebook Feed', 'feeds-for-youtube'), 'icon' => 'facebook', 'link' => 'https://smashballoon.com/instagram-feed/?utm_campaign=instagram-pro&utm_source=balloon&utm_medium=instagram'), array('name' => __('Twitter Feed', 'feeds-for-youtube'), 'icon' => 'twitter', 'link' => 'https://smashballoon.com/custom-twitter-feeds/?utm_campaign=instagram-pro&utm_source=balloon&utm_medium=twitter'), array('name' => __('YouTube Feed', 'feeds-for-youtube'), 'icon' => 'youtube', 'link' => 'https://smashballoon.com/youtube-feed/?utm_campaign=instagram-pro&utm_source=balloon&utm_medium=youtube'), array('name' => __('Social Wall Plugin', 'feeds-for-youtube'), 'icon' => 'smash', 'link' => 'https://smashballoon.com/social-wall/?utm_campaign=instagram-pro&utm_source=balloon&utm_medium=social-wall ')), 'socialProfiles' => array('facebook' => 'https://www.facebook.com/SmashBalloon/', 'twitter' => 'https://twitter.com/smashballoon'), 'morePlatforms' => array('instagram', 'youtube', 'twitter'));
        return $smash_info;
    }
    /**
     * Text specific to onboarding. Will return an associative array 'active' => false
     * if onboarding has been dismissed for the user or there aren't any legacy feeds.
     *
     * @return array
     *
     * @since 4.0
     */
    public function get_onboarding_text()
    {
        // TODO: return if no legacy feeds
        $statuses_option = get_option($this->config->statuses_option, array());
        if (!isset($statuses_option['legacy_onboarding'])) {
            return array('active' => \false);
        }
        if ($statuses_option['legacy_onboarding']['active'] === \false || self::onboarding_status() === 'dismissed') {
            return array('active' => \false);
        }
        $type = $statuses_option['legacy_onboarding']['type'];
        $text = array('active' => \true, 'type' => $type, 'legacyFeeds' => array('heading' => __('Legacy Feed Settings', 'feeds-for-youtube'), 'description' => sprintf(__('These settings will impact %1$s legacy feeds on your site. You can learn more about what legacy feeds are and how they differ from new feeds %2$shere%3$s.', 'feeds-for-youtube'), '<span class="cff-fb-count-placeholder"></span>', '<a href="https://smashballoon.com/doc/facebook-legacy-feeds/" target="_blank" rel="noopener">', '</a>')), 'getStarted' => __('You can now create and customize feeds individually. Click "Add New" to get started.', 'feeds-for-youtube'));
        if ($type === 'single') {
            $text['tooltips'] = array(array('step' => 1, 'heading' => __('How you create a feed has changed', 'feeds-for-youtube'), 'p' => __('You can now create and customize feeds individually without using shortcode options.', 'feeds-for-youtube') . ' ' . __('Click "Add New" to get started.', 'feeds-for-youtube'), 'pointer' => 'top'), array('step' => 2, 'heading' => __('Your existing feed is here', 'feeds-for-youtube'), 'p' => __('You can edit your existing feed from here, and all changes will only apply to this feed.', 'feeds-for-youtube'), 'pointer' => 'top'));
        } else {
            $text['tooltips'] = array(array('step' => 1, 'heading' => __('How you create a feed has changed', 'feeds-for-youtube'), 'p' => __('You can now create and customize feeds individually without using shortcode options.', 'feeds-for-youtube') . ' ' . __('Click "Add New" to get started.', 'feeds-for-youtube'), 'pointer' => 'top'), array('step' => 2, 'heading' => __('Your existing feeds are under "Legacy" feeds', 'feeds-for-youtube'), 'p' => __('You can edit the settings for any existing "legacy" feed (i.e. any feed created prior to this update) here.', 'feeds-for-youtube') . ' ' . __('This works just like the old settings page and affects all legacy feeds on your site.', 'feeds-for-youtube')), array('step' => 3, 'heading' => __('Existing feeds work as normal', 'feeds-for-youtube'), 'p' => __('You don\'t need to update or change any of your existing feeds. They will continue to work as usual.', 'feeds-for-youtube') . ' ' . __('This update only affects how new feeds are created and customized.', 'feeds-for-youtube')));
        }
        return $text;
    }
    /**
     * Check if On
     * Function to check if a shortcode options is set to ON or TRUE
     *
     * @access public
     * @static
     * @since 2.0
     * @return boolean
     */
    static function check_if_on($value)
    {
        return isset($value) && !empty($value) && ($value == 'true' || $value == 'on') ? \true : \false;
    }
    public function get_customizer_onboarding_text()
    {
        if (self::onboarding_status('customizer') === 'dismissed') {
            return array('active' => \false);
        }
        $text = array('active' => \true, 'type' => 'customizer', 'tooltips' => array(array('step' => 1, 'heading' => __('Embedding a Feed', 'feeds-for-youtube'), 'p' => __('After you are done customizing the feed, click here to add it to a page or a widget.', 'feeds-for-youtube'), 'pointer' => 'top'), array('step' => 2, 'heading' => __('Customize', 'feeds-for-youtube'), 'p' => __('Change your feed layout, color scheme, or customize individual feed sections here.', 'feeds-for-youtube'), 'pointer' => 'top'), array('step' => 3, 'heading' => __('Settings', 'feeds-for-youtube'), 'p' => __('Update your feed type, filter your posts, or change advanced settings here.', 'feeds-for-youtube'), 'pointer' => 'top')));
        return $text;
    }
    /**
     * Text related to the feed customizer
     *
     * @return array
     *
     * @since 6.0
     */
    public function get_customize_screens_text()
    {
        $text = array(
            'common' => array('preview' => __('Preview', 'feeds-for-youtube'), 'help' => __('Help', 'feeds-for-youtube'), 'embed' => __('Embed', 'feeds-for-youtube'), 'save' => __('Save', 'feeds-for-youtube'), 'sections' => __('Sections', 'feeds-for-youtube'), 'enable' => __('Enable', 'feeds-for-youtube'), 'background' => __('Background', 'feeds-for-youtube'), 'text' => __('Text', 'feeds-for-youtube'), 'inherit' => __('Inherit from Theme', 'feeds-for-youtube'), 'size' => __('Size', 'feeds-for-youtube'), 'color' => __('Color', 'feeds-for-youtube'), 'height' => __('Height', 'feeds-for-youtube'), 'placeholder' => __('Placeholder', 'feeds-for-youtube'), 'select' => __('Select', 'feeds-for-youtube'), 'enterText' => __('Enter Text', 'feeds-for-youtube'), 'hoverState' => __('Hover State', 'feeds-for-youtube'), 'sourceCombine' => __('Combine sources from multiple platforms using our Social Wall plugin', 'feeds-for-youtube')),
            'tabs' => array('customize' => __('Customize', 'feeds-for-youtube'), 'settings' => __('Settings', 'feeds-for-youtube')),
            'overview' => array('feedLayout' => __('Feed Layout', 'feeds-for-youtube'), 'colorScheme' => __('Color Scheme', 'feeds-for-youtube'), 'header' => __('Header', 'feeds-for-youtube'), 'posts' => __('Posts', 'feeds-for-youtube'), 'likeBox' => __('Like Box', 'feeds-for-youtube'), 'loadMore' => __('Load More Button', 'feeds-for-youtube')),
            'feedLayoutScreen' => array('layout' => __('Layout', 'feeds-for-youtube'), 'list' => __('List', 'feeds-for-youtube'), 'grid' => __('Grid', 'feeds-for-youtube'), 'masonry' => __('Masonry', 'feeds-for-youtube'), 'carousel' => __('Carousel', 'feeds-for-youtube'), 'feedHeight' => __('Feed Height', 'feeds-for-youtube'), 'number' => __('Number of Posts', 'feeds-for-youtube'), 'columns' => __('Columns', 'feeds-for-youtube'), 'desktop' => __('Desktop', 'feeds-for-youtube'), 'tablet' => __('Tablet', 'feeds-for-youtube'), 'mobile' => __('Mobile', 'feeds-for-youtube'), 'bottomArea' => array('heading' => __('Tweak Post Styles', 'feeds-for-youtube'), 'description' => __('Change post background, border radius, shadow etc.', 'feeds-for-youtube'))),
            'colorSchemeScreen' => array('scheme' => __('Scheme', 'feeds-for-youtube'), 'light' => __('Light', 'feeds-for-youtube'), 'dark' => __('Dark', 'feeds-for-youtube'), 'custom' => __('Custom', 'feeds-for-youtube'), 'customPalette' => __('Custom Palette', 'feeds-for-youtube'), 'background2' => __('Background 2', 'feeds-for-youtube'), 'text2' => __('Text 2', 'feeds-for-youtube'), 'link' => __('Link', 'feeds-for-youtube'), 'bottomArea' => array('heading' => __('Overrides', 'feeds-for-youtube'), 'description' => __('Colors that have been overridden from individual post element settings will not change. To change them, you will have to reset overrides.', 'feeds-for-youtube'), 'ctaButton' => __('Reset Overrides.', 'feeds-for-youtube'))),
            'headerScreen' => array('headerType' => __('Header Type', 'feeds-for-youtube'), 'visual' => __('Visual', 'feeds-for-youtube'), 'coverPhoto' => __('Cover Photo', 'feeds-for-youtube'), 'nameAndAvatar' => __('Name and avatar', 'feeds-for-youtube'), 'about' => __('About (bio and Likes)', 'feeds-for-youtube'), 'displayOutside' => __('Display outside scrollable area', 'feeds-for-youtube'), 'icon' => __('Icon', 'feeds-for-youtube'), 'iconImage' => __('Icon Image', 'feeds-for-youtube'), 'iconColor' => __('Icon Color', 'feeds-for-youtube')),
            // all Lightbox in common
            // all Load More in common
            'likeBoxScreen' => array('small' => __('Small', 'feeds-for-youtube'), 'large' => __('Large', 'feeds-for-youtube'), 'coverPhoto' => __('Cover Photo', 'feeds-for-youtube'), 'customWidth' => __('Custom Width', 'feeds-for-youtube'), 'defaultSetTo' => __('By default, it is set to auto', 'feeds-for-youtube'), 'width' => __('Width', 'feeds-for-youtube'), 'customCTA' => __('Custom CTA', 'feeds-for-youtube'), 'customCTADescription' => __('This toggles the custom CTA like "Show now" and "Contact"', 'feeds-for-youtube'), 'showFans' => __('Show Fans', 'feeds-for-youtube'), 'showFansDescription' => __('Show visitors which of their friends follow your page', 'feeds-for-youtube'), 'displayOutside' => __('Display outside scrollable area', 'feeds-for-youtube'), 'displayOutsideDescription' => __('Make the like box fixed by moving it outside the scrollable area', 'feeds-for-youtube')),
            'postsScreen' => array('thumbnail' => __('Thumbnail', 'feeds-for-youtube'), 'half' => __('Half width', 'feeds-for-youtube'), 'full' => __('Full width', 'feeds-for-youtube'), 'useFull' => __('Use full width layout when post width is less than 500px', 'feeds-for-youtube'), 'postStyle' => __('Post Style', 'feeds-for-youtube'), 'editIndividual' => __('Edit Individual Elements', 'feeds-for-youtube'), 'individual' => array('description' => __('Hide or show individual elements of a post or edit their options', 'feeds-for-youtube'), 'name' => __('Name', 'feeds-for-youtube'), 'edit' => __('Edit', 'feeds-for-youtube'), 'postAuthor' => __('Post Author', 'feeds-for-youtube'), 'postText' => __('Post Text', 'feeds-for-youtube'), 'date' => __('Date', 'feeds-for-youtube'), 'photosVideos' => __('Photos/Videos', 'feeds-for-youtube'), 'likesShares' => __('Likes, Shares and Comments', 'feeds-for-youtube'), 'eventTitle' => __('Event Title', 'feeds-for-youtube'), 'eventDetails' => __('Event Details', 'feeds-for-youtube'), 'postAction' => __('Post Action Links', 'feeds-for-youtube'), 'sharedPostText' => __('Shared Post Text', 'feeds-for-youtube'), 'sharedLinkBox' => __('Shared Link Box', 'feeds-for-youtube'), 'postTextDescription' => __('The main text of the Instagram post', 'feeds-for-youtube'), 'maxTextLength' => __('Maximum Text Length', 'feeds-for-youtube'), 'characters' => __('Characters', 'feeds-for-youtube'), 'linkText' => __('Link text to Instagram post', 'feeds-for-youtube'), 'postDateDescription' => __('The date of the post', 'feeds-for-youtube'), 'format' => __('Format', 'feeds-for-youtube'), 'custom' => __('Custom', 'feeds-for-youtube'), 'learnMoreFormats' => '<a href="https://smashballoon.com/doc/date-formatting-reference/" target="_blank" rel="noopener">' . __('Learn more about custom formats', 'feeds-for-youtube') . '</a>', 'addTextBefore' => __('Add text before date', 'feeds-for-youtube'), 'addTextBeforeEG' => __('E.g. Posted', 'feeds-for-youtube'), 'addTextAfter' => __('Add text after date', 'feeds-for-youtube'), 'addTextAfterEG' => __('E.g. - posted date', 'feeds-for-youtube'), 'timezone' => __('Timezone', 'feeds-for-youtube'), 'tzDescription' => __('Timezone settings are global across all feeds. To update it use the global settings.', 'feeds-for-youtube'), 'tzCTAText' => __('Go to Global Settings', 'feeds-for-youtube'), 'photosVideosDescription' => __('Any photos or videos in your posts', 'feeds-for-youtube'), 'useOnlyOne' => __('Use only one image per post', 'feeds-for-youtube'), 'postActionLinksDescription' => __('The "View on Instagram" and "Share" links at the bottom of each post', 'feeds-for-youtube'), 'viewOnFBLink' => __('View on Instagram link', 'feeds-for-youtube'), 'viewOnFBLinkDescription' => __('Toggle "View on Instagram" link below each post', 'feeds-for-youtube'), 'customizeText' => __('Customize Text', 'feeds-for-youtube'), 'shareLink' => __('Share Link', 'feeds-for-youtube'), 'shareLinkDescription' => __('Toggle "Share" link below each post', 'feeds-for-youtube'), 'likesSharesDescription' => __('The comments box displayed at the bottom of each timeline post', 'feeds-for-youtube'), 'iconTheme' => __('Icon Theme', 'feeds-for-youtube'), 'auto' => __('Auto', 'feeds-for-youtube'), 'light' => __('Light', 'feeds-for-youtube'), 'dark' => __('Dark', 'feeds-for-youtube'), 'expandComments' => __('Expand comments box by default', 'feeds-for-youtube'), 'hideComment' => __('Hide comment avatars', 'feeds-for-youtube'), 'showLightbox' => __('Show comments in lightbox', 'feeds-for-youtube'), 'eventTitleDescription' => __('The title of an event', 'feeds-for-youtube'), 'eventDetailsDescription' => __('The information associated with an event', 'feeds-for-youtube'), 'textSize' => __('Text Size', 'feeds-for-youtube'), 'textColor' => __('Text Color', 'feeds-for-youtube'), 'sharedLinkBoxDescription' => __("The link info box that's created when a link is shared in a Instagram post", 'feeds-for-youtube'), 'boxStyle' => __('Box Style', 'feeds-for-youtube'), 'removeBackground' => __('Remove background/border', 'feeds-for-youtube'), 'linkTitle' => __('Link Title', 'feeds-for-youtube'), 'linkURL' => __('Link URL', 'feeds-for-youtube'), 'linkDescription' => __('Link Description', 'feeds-for-youtube'), 'chars' => __('chars', 'feeds-for-youtube'), 'sharedPostDescription' => __('The description text associated with shared photos, videos, or links', 'feeds-for-youtube')), 'postType' => __('Post Type', 'feeds-for-youtube'), 'boxed' => __('boxed', 'feeds-for-youtube'), 'regular' => __('Regular', 'feeds-for-youtube'), 'indvidualProperties' => __('Indvidual Properties', 'feeds-for-youtube'), 'backgroundColor' => __('Background Color', 'feeds-for-youtube'), 'borderRadius' => __('Border Radius', 'feeds-for-youtube'), 'boxShadow' => __('Box Shadow', 'feeds-for-youtube')),
            'shoppableFeedScreen' => array('heading1' => __('Make your Instagram Feed Shoppable', 'feeds-for-youtube'), 'description1' => __('This feature links the post to the one specificed in your caption.<br/><br/>Don’t want to add links to the caption? You can add links manually to each post.<br/><br/>Enable it to get started.', 'feeds-for-youtube'), 'heading2' => __('Tap “Add” or “Update” on an<br/>image to add/update it’s URL', 'feeds-for-youtube')),
        );
        $text['onboarding'] = $this->get_customizer_onboarding_text();
        return $text;
    }
    public static function get_social_wall_links()
    {
        return array('<a href="' . esc_url(admin_url('admin.php?page=sby-feed-builder')) . '">' . __('All Feeds', 'feeds-for-youtube') . '</a>', '<a href="' . esc_url(admin_url('admin.php?page=youtube-feed-settings')) . '">' . __('Settings', 'feeds-for-youtube') . '</a>', '<a href="' . esc_url(admin_url('admin.php?page=youtube-feed-single-videos')) . '">' . __('Single Videos', 'feeds-for-youtube') . '</a>', '<a href="' . esc_url(admin_url('admin.php?page=youtube-feed-about')) . '">' . __('About Us', 'feeds-for-youtube') . '</a>', '<a href="' . esc_url(admin_url('admin.php?page=youtube-feed-support')) . '">' . __('Support', 'feeds-for-youtube') . '</a>');
    }
    /**
     * Returns an associate array of all existing feeds along with their data
     *
     * @return array
     *
     * @since 6.0
     */
    public function get_feed_list($feeds_args = array(), $force = \false)
    {
        if (!empty($_GET['feed_id']) && \false === $force) {
            return array();
        }
        $sources_list = $this->saver_manager->get_source_list();
        $feeds_data = $this->DB->feeds_query($feeds_args);
        $this->format_feed_locator_data($feeds_data, $sources_list);
        return $feeds_data;
    }
    /**
     * Returns an associate array of all existing sources along with their data
     *
     * @return array
     *
     * @since 4.0
     */
    public function get_legacy_feed_list()
    {
        if (!empty($_GET['feed_id'])) {
            return array();
        }
        $statuses = get_option($this->config->statuses_option, array());
        $sources_list = $this->saver_manager->get_source_list();
        if (empty($statuses['support_legacy_shortcode'])) {
            return array();
        }
        $args = array('html_location' => array('header', 'footer', 'sidebar', 'content'), 'group_by' => 'shortcode_atts', 'page' => 1);
        $feeds_data = $this->feed_locator->legacy_feed_locator_query($args);
        if (empty($feeds_data)) {
            $feeds_data = $this->feed_locator->legacy_feed_locator_query($args);
        }
        $this->format_feed_locator_data($feeds_data, $sources_list, \true);
        $feeds_data = array_values($feeds_data);
        // if there were no feeds found in the locator table we still want the legacy settings to be available
        // if it appears as though they had used version 3.x or under at some point.
        if (empty($feeds_data) && !is_array($statuses['support_legacy_shortcode']) && $statuses['support_legacy_shortcode']) {
            $feeds_data = array(array('feed_id' => __('Legacy Feed', 'feeds-for-youtube') . ' ' . __('(unknown location)', 'feeds-for-youtube'), 'feed_name' => __('Legacy Feed', 'feeds-for-youtube') . ' ' . __('(unknown location)', 'feeds-for-youtube'), 'shortcode' => '[instagram-feed]', 'feed_type' => '', 'instance_count' => \false, 'location_summary' => array()));
        }
        return $feeds_data;
    }
    private function format_feed_locator_data(&$feeds_data, $sources_list, $legacy = \false)
    {
        $i = 0;
        foreach ($feeds_data as $single_feed) {
            $default_type = $this->get_default_feed_type($single_feed['id']);
            $args = array('html_location' => array('content'), 'group_by' => $legacy ? 'shortcode_atts' : 'post_id');
            if (\true === $legacy) {
                $args['shortcode_atts'] = $single_feed['shortcode_atts'];
            } else {
                $args['feed_id'] = $single_feed['id'];
            }
            $content_locations = $this->feed_locator->legacy_feed_locator_query($args);
            if (count($content_locations) < \Smashballoon\Customizer\DB::RESULTS_PER_PAGE) {
                $args = array('feed_id' => $legacy ? $single_feed['feed_id'] : $single_feed['id'], 'html_location' => array('header', 'footer', 'sidebar'), 'group_by' => 'html_location');
                $other_locations = $this->feed_locator->legacy_feed_locator_query($args);
                $combined_locations = array_merge($other_locations, $content_locations);
            } else {
                $combined_locations = $content_locations;
            }
            $locations = array();
            foreach ($combined_locations as $location) {
                $page_text = get_the_title($location['post_id']);
                if ($location['html_location'] === 'header') {
                    $html_location = __('Header', 'feeds-for-youtube');
                } elseif ($location['html_location'] === 'footer') {
                    $html_location = __('Footer', 'feeds-for-youtube');
                } elseif ($location['html_location'] === 'sidebar') {
                    $html_location = __('Sidebar', 'feeds-for-youtube');
                } else {
                    $html_location = __('Content', 'feeds-for-youtube');
                }
                $shortcode_atts = json_decode($location['shortcode_atts'], \true);
                $shortcode_atts = is_array($shortcode_atts) ? $shortcode_atts : array();
                $full_shortcode_string = '[youtube-feed';
                foreach ($shortcode_atts as $key => $value) {
                    if (!empty($value)) {
                        if (is_array($value)) {
                            $value = implode(',', $value);
                        }
                        $full_shortcode_string .= ' ' . esc_html($key) . '="' . esc_html($value) . '"';
                    }
                }
                $full_shortcode_string .= ']';
                $locations[] = array('link' => esc_url(get_the_permalink($location['post_id'])), 'page_text' => $page_text, 'html_location' => $html_location, 'shortcode' => $full_shortcode_string);
            }
            $shortcode_atts = json_decode($legacy ? $feeds_data[$i]['shortcode_atts'] : "", \true);
            $shortcode_atts = is_array($shortcode_atts) ? $shortcode_atts : array();
            $full_shortcode_string = '[youtube-feed';
            foreach ($shortcode_atts as $key => $value) {
                if (!empty($value)) {
                    if (is_array($value)) {
                        $value = implode(',', $value);
                    }
                    $full_shortcode_string .= ' ' . esc_html($key) . '="' . esc_html($value) . '"';
                }
            }
            $full_shortcode_string .= ']';
            $feeds_data[$i]['instance_count'] = count($locations);
            $feeds_data[$i]['location_summary'] = $locations;
            $feeds_data[$i]['feed_type'] = $default_type;
            if (\true === $legacy) {
                $feeds_data[$i]['shortcode'] = $full_shortcode_string;
                $feeds_data[$i]['feed_name'] = self::get_legacy_feed_name($sources_list, $feeds_data[$i]['feed_id']);
                if (isset($shortcode_atts['feedtype'])) {
                    $feeds_data[$i]['feed_type'] = $shortcode_atts['feedtype'];
                } elseif (isset($shortcode_atts['type'])) {
                    if (strpos($shortcode_atts['type'], ',') === \false) {
                        $feeds_data[$i]['feed_type'] = $shortcode_atts['type'];
                    }
                }
                if (isset($feeds_data[$i]['id'])) {
                    unset($feeds_data[$i]['id']);
                }
                if (isset($feeds_data[$i]['html_location'])) {
                    unset($feeds_data[$i]['html_location']);
                }
                if (isset($feeds_data[$i]['last_update'])) {
                    unset($feeds_data[$i]['last_update']);
                }
                if (isset($feeds_data[$i]['post_id'])) {
                    unset($feeds_data[$i]['post_id']);
                }
                if (!empty($shortcode_atts['feed'])) {
                    $reindex = \true;
                    unset($feeds_data[$i]);
                }
                if (isset($feeds_data[$i]['shortcode_atts'])) {
                    unset($feeds_data[$i]['shortcode_atts']);
                }
            }
            $i++;
        }
    }
    private function get_default_feed_type($feed_id)
    {
        $this->feed_saver->set_feed_id($feed_id);
        $settings = $this->feed_saver->get_feed_settings();
        $default_type = 'timeline';
        if (isset($settings['feedtype'])) {
            $default_type = $settings['feedtype'];
        } elseif (isset($settings['type'])) {
            $default_type = $settings['type'];
        }
        return $default_type;
    }
    public static function get_legacy_feed_name($sources_list, $source_id)
    {
        foreach ($sources_list as $source) {
            if ($source['account_id'] === $source_id) {
                return $source['username'];
            }
        }
        return $source_id;
    }
    /**
     * Status of the onboarding sequence for specific user
     *
     * @return string|boolean
     *
     * @since 6.0
     */
    public static function onboarding_status($type = 'newuser')
    {
        $onboarding_statuses = get_user_meta(get_current_user_id(), 'sby_onboarding', \true);
        $status = \false;
        if (!empty($onboarding_statuses)) {
            $statuses = maybe_unserialize($onboarding_statuses);
            $status = isset($statuses[$type]) ? $statuses[$type] : \false;
        }
        return $status;
    }
    /**
     * Update status of onboarding sequence for specific user
     *
     * @since 6.0
     */
    public static function update_onboarding_meta($value, $type = 'newuser')
    {
        $onboarding_statuses = get_user_meta(get_current_user_id(), 'sby_onboarding', \true);
        if (!empty($onboarding_statuses)) {
            $statuses = maybe_unserialize($onboarding_statuses);
            $statuses[$type] = $value;
        } else {
            $statuses = array($type => $value);
        }
        $statuses = maybe_serialize($statuses);
        update_user_meta(get_current_user_id(), 'sby_onboarding', $statuses);
    }
    public static function add_customizer_att($atts)
    {
        if (!is_array($atts)) {
            $atts = array();
        }
        $atts['feedtype'] = 'customizer';
        return $atts;
    }
    public static function add_legacy_customizer_att()
    {
        $atts = array();
        $atts['feed'] = 'legacy';
        $atts['customizer'] = \true;
        $atts['feedtype'] = 'customizer';
        return $atts;
    }
    /**
     * Check API key status
     *
     * @since 2.0
     */
    public static function check_api_key_status()
    {
        // get the database settings
        global $sby_settings;
        return isset($sby_settings['api_key']) && strlen($sby_settings['api_key']) >= 9;
    }
    /**
     * Check connected accounts status
     *
     * @since 2.0
     */
    public static function check_connected_account_status()
    {
        // get the database settings
        global $sby_settings;
        if (isset($sby_settings['connected_accounts']) && !empty($sby_settings['connected_accounts'])) {
            return \true;
        }
        return;
    }
    public static function get_youtube_account_connect_url()
    {
        $vars = new SBY_Vars();
        $oauth_processor_url = $vars->oauth_processor_url();
        return $oauth_processor_url . admin_url('admin.php?page=sby-feed-builder');
    }
    /**
     * Get channel ID for prefill account info
     *
     * @since 2.0
     */
    public static function get_prefilled_channel_id()
    {
        $channel_id = null;
        if (isset($_GET['sby_access_token'])) {
            $access_token = sanitize_text_field($_GET['sby_access_token']);
            $refresh_token = sanitize_text_field($_GET['sby_refresh_token']);
            $channel_param = 'mine=true';
            $access_credentials = 'access_token=' . $access_token;
            $url = 'https://www.googleapis.com/youtube/v3/channels?part=id,snippet&' . $channel_param . '&' . $access_credentials;
            $args = array('timeout' => 60);
            $response = wp_remote_get(esc_url_raw($url), $args);
            if (!is_wp_error($response)) {
                // certain ways of representing the html for double quotes causes errors so replaced here.
                $response = json_decode(str_replace('%22', '&rdquo;', $response['body']), \true);
                $data = isset($response['kind']) ? $response : \false;
                if ($data && !empty($data['items'])) {
                    $channel_id = $data['items'][0]['id'];
                }
            }
        }
        return $channel_id;
    }
    /**
     * Get different feedtypes tooltip content
     *
     * @since 2.0
     */
    public function get_feedtypes_tooltip_content()
    {
        return array('channel' => 'Enter any channel ID or username to display all of an accounts latest videos starting with the most recently published. You can find the ID or User Name of your YouTube Channel from the URL. In each URL format, the text you need to use is highlighted below: <ul><li>Channel Handles: https://www.youtube.com/<span class="sbc-tltp-highlighted-text">@yourchannel</span></li><li>Channel ID: https://www.youtube.com/channel/ <span class="sbc-tltp-highlighted-text">UC1a2b3c4D5F6g7i8j9k</span></li> <li>Username: https://www.youtube.com/user/ <span class="sbc-tltp-highlighted-text">your_user_name</span></li></ul>', 'playlist' => 'Enter any playlist ID to display videos from a playlist starting with the most recently published. You can find the ID of your YouTube playlist from the URL. The text you need to use is highlighted below: <ul><li>https://www.youtube.com/playlist?list= <span class="sbc-tltp-highlighted-text">PLLLm1a2b3c4D6g7i8j9k_1a2b3c4D57i8j9k</span></li></ul>', 'favorites' => 'Displays all videos marked as "favorites" by a YouTube account starting with the most recently published. You can find the channel ID or User Name of your YouTube Channel from the URL. In each URL format, the text you need to use is highlighted below: <ul><li>Channel ID: https://www.youtube.com/channel/ <span class="sbc-tltp-highlighted-text">UC1a2b3c4D5F6g7i8j9k</span></li> <li>Username: https://www.youtube.com/user/ <span class="sbc-tltp-highlighted-text">your_user_name</span></li></ul>', 'search' => 'Enter any search term or phrase. Separate multiple terms with commas. You can add your own additional query vars using the <a href="https://smashballoon.com/youtube-feed/custom-search-guide/" target="_blank">guide on our website</a> and the input field above.', 'live' => 'Displays a single upcoming or currently playing live streaming video from a channel. You can find the channel ID or User Name of your YouTube Channel from the URL. In each URL format, the text you need to use is highlighted below: <ul><li>Channel ID: https://www.youtube.com/channel/ <span class="sbc-tltp-highlighted-text">UC1a2b3c4D5F6g7i8j9k</span></li> Username: <span class="sbc-tltp-highlighted-text">https://www.youtube.com/user/ <span class="sbc-tltp-highlighted-text">your_user_name</span></li></ul>', 'single' => 'Displays individual videos sorted in order here. Display multiple single videos by using a comma separated list. You can find the Video ID of your individual videos from the URL. The text you need to use is highlighted below: <ul><li>https://www.youtube.com/watch?v= <span class="sbc-tltp-highlighted-text">ahL3sbPK1U8</span></li></ul>');
    }
    /**
     * Feed Builder Wrapper.
     *
     * @since 6.0
     */
    public function feed_builder()
    {
        include_once CUSTOMIZER_ABSPATH . 'templates/builder.php';
    }
    /**
     * For types listed on the top of the select feed type screen
     *
     * @return array
     *
     * @since 6.0
     */
    public function get_feed_types()
    {
        $feed_types = array(array('type' => 'channel', 'title' => __('Channel', 'feeds-for-youtube'), 'description' => __('A feed of videos from any YouTube channel', 'feeds-for-youtube'), 'icon' => 'channel'));
        $pro_feed_types = $this->get_advanced_feed_types();
        $feed_types = array_merge($feed_types, $pro_feed_types);
        return $feed_types;
    }
    /**
     * Get Advanced Pro Only Feed Types 
     *
     * @return array
     *
     * @since 2.0
     */
    public function get_advanced_feed_types()
    {
        $svg_icons = $this->builder_svg_icons();
        $feed_types = array(array('type' => 'playlist', 'title' => __('Playlist', 'feeds-for-youtube') . $svg_icons['blueRocketPremium'], 'description' => __('Display videos from any YouTube playlist', 'feeds-for-youtube'), 'icon' => 'playlist'), array('type' => 'favorites', 'title' => __('Favorites', 'feeds-for-youtube') . $svg_icons['blueRocketPremium'], 'description' => __('Display a feed of favorited videos from any user', 'feeds-for-youtube'), 'icon' => 'favorites'), array('type' => 'search', 'title' => __('Search', 'feeds-for-youtube') . $svg_icons['blueRocketPremium'], 'description' => __('Videos which match specific advanced search criteria', 'feeds-for-youtube'), 'icon' => 'search'), array('type' => 'live', 'title' => __('Live Streams', 'feeds-for-youtube') . $svg_icons['blueRocketPremium'], 'description' => __('Upcoming and currently playing live stream videos', 'feeds-for-youtube'), 'icon' => 'live'), array('type' => 'single', 'title' => __('Single Videos', 'feeds-for-youtube') . $svg_icons['blueRocketPremium'], 'description' => __('Display a curated list of single videos', 'feeds-for-youtube'), 'icon' => 'single'), array('type' => 'social_wall', 'title' => __('Social Wall', 'feeds-for-youtube') . $svg_icons['blueRocketPremium'], 'description' => __('Combine sources from multiple social media platforms', 'feeds-for-youtube'), 'icon' => 'social_wall'));
        return $feed_types;
    }
    /**
     * @return string
     *
     * @since 2.1
     */
    public static function oauth_connet_url()
    {
        $nonce = wp_create_nonce('sby_con');
        $admin_email = get_option('admin_email', '');
        if (is_user_logged_in()) {
            $current_user = wp_get_current_user();
            $user_email = $current_user->user_email;
        }
        $user_email = isset($user_email) ? $user_email : $admin_email;
        $pro = sby_is_pro() ? '&pro=1' : '';
        $email = sby_is_pro() ? '' : '&email=' . $user_email;
        return 'https://connect.smashballoon.com/auth/yt/?return_uri=' . admin_url('admin.php?page=sby-feed-builder&channel-id-prefill=true') . $email . $pro . '&ver=' . SBYVER . '&nonce=' . $nonce;
    }
    public static function oauth_connet_parameters()
    {
        $nonce = wp_create_nonce('sby_con');
        $admin_email = get_option('admin_email', '');
        if (is_user_logged_in()) {
            $current_user = wp_get_current_user();
            $user_email = $current_user->user_email;
        }
        $user_email = isset($user_email) ? $user_email : $admin_email;
        $pro = sby_is_pro() ? 1 : 0;
        return array('connect_site_url' => 'https://connect.smashballoon.com/auth/yt/', 'return_uri' => admin_url('admin.php?page=sby-feed-builder&channel-id-prefill=true'), 'nonce' => $nonce, 'email' => $user_email, 'pro' => $pro, 'version' => SBYVER);
    }
    /**
     * Get select source screen text in the feed creation flow
     *
     * @since 2.0
     */
    public static function get_sources_screen_texts()
    {
        $svgIcons = self::builder_svg_icons();
        return array('channel' => array('title' => __('Channel ID or Username', 'feeds-for-youtube'), 'placeholder' => __('Enter Channel Handle, ID or Username. For example: @yourchannel or Uc1a2458ff29305kufo', 'feeds-for-youtube'), 'description' => __('Enter any channel ID or username to display all of an accounts latest videos starting with the most recently published. You can find the ID or User Name of your YouTube Channel from the URL. In each URL format, the text you need to use is highlighted below:', 'feeds-for-youtube'), 'lists' => array('<strong>Channel Handles:</strong> https://www.youtube.com/<span class="sbc-list-highlight">@yourchannel</span>', '<strong>Channel ID:</strong> https://www.youtube.com/channel/<span class="sbc-list-highlight">UC1a2b3c4D5F6g7i8j9k</span>', '<strong>Username:</strong> https://www.youtube.com/user/<span class="sbc-list-highlight">your_user_name</span>'), 'footerText' => __('Can’t find the channel ID or username for your account? <br> Connect your YouTube account and we will prefill it for you.', 'feeds-for-youtube'), 'connect' => $svgIcons['youtube'] . __('Connect', 'feeds-for-youtube'), 'connectURL' => self::oauth_connet_url()), 'playlist' => array('title' => __('Playlist ID', 'feeds-for-youtube'), 'placeholder' => __('Enter Playlist ID. For example: PLLLm1a2b3c4D6g7i8j9k_1a2b3c4D57i8j9k', 'feeds-for-youtube'), 'description' => __('Enter any playlist ID to display videos from a playlist starting with the most recently published. You can find the ID of your YouTube playlist from the URL. The text you need to use is highlighted below:', 'feeds-for-youtube'), 'lists' => array('https://www.youtube.com/playlist?list=<span class="sbc-list-highlight">PLLLm1a2b3c4D6g7i8j9k_1a2b3c4D57i8j9k</span>')), 'favorites' => array('title' => __('Channel ID or Username', 'feeds-for-youtube'), 'placeholder' => __('Enter Channel ID or Username. For example: Uc1a2458ff29305kufo', 'feeds-for-youtube'), 'description' => __('Displays all videos marked as "favorites" by a YouTube account starting with the most recently published. You can find the channel ID or User Name of your YouTube Channel from the URL. In each URL format, the text you need to use is highlighted below:', 'feeds-for-youtube'), 'lists' => array('<strong>Channel ID:</strong> https://www.youtube.com/channel/<span class="sbc-list-highlight">UC1a2b3c4D5F6g7i8j9k</span>', '<strong>Username:</strong> https://www.youtube.com/user/<span class="sbc-list-highlight">your_user_name</span>'), 'footerText' => __('Can’t find the channel ID or username for your account? <br> Connect your YouTube account and we will prefill it for you.', 'feeds-for-youtube'), 'connect' => $svgIcons['youtube'] . __('Connect', 'feeds-for-youtube'), 'connectURL' => self::oauth_connet_url()), 'search' => array('title' => __('Search Term', 'feeds-for-youtube'), 'placeholder' => __('Enter Search Term', 'feeds-for-youtube'), 'description' => __('Enter any search term or phrase. Separate multiple terms with commas. You can add your own additional query vars using the <a href="https://smashballoon.com/youtube-feed/custom-search-guide/" target="_blank">guide on our website</a> and the input field above.', 'feeds-for-youtube')), 'live' => array('title' => __('Add Channel ID for Livestream', 'feeds-for-youtube'), 'placeholder' => __('Enter Channel ID or Username. For example: Uc1a2458ff29305kufo', 'feeds-for-youtube'), 'description' => __('Displays a single upcoming or currently playing live streaming video from a channel. You can find the channel ID or User Name of your YouTube Channel from the URL. In each URL format, the text you need to use is highlighted below:', 'feeds-for-youtube'), 'lists' => array('<strong>Channel ID:</strong> https://www.youtube.com/channel/<span class="sbc-list-highlight">UC1a2b3c4D5F6g7i8j9k</span>', '<strong>Username:</strong> https://www.youtube.com/user/<span class="sbc-list-highlight">your_user_name</span>'), 'footerText' => __('Can’t find the channel ID or username for your account? <br> Connect your YouTube account and we will prefill it for you.', 'feeds-for-youtube'), 'connect' => $svgIcons['youtube'] . __('Connect', 'feeds-for-youtube'), 'connectURL' => self::oauth_connet_url()), 'single' => array('title' => __('One or more Video IDs', 'feeds-for-youtube'), 'placeholder' => __('Enter Invididual Video IDs. For example: k0JPrxa0_7U, dzYP01CPC6E', 'feeds-for-youtube'), 'description' => __('Displays individual videos sorted in order here. Display multiple single videos by using a comma separated list. You can find the Video ID of your individual videos from the URL. The text you need to use is highlighted below:', 'feeds-for-youtube'), 'lists' => array('https://www.youtube.com/watch?v=<span class="sbc-list-highlight">ahL3sbPK1U8</span>')));
    }
    /**
     * API Key popup screen texts
     */
    public function api_key_popup_screen_texts()
    {
        return array('title' => __('API Key Required', 'feeds-for-youtube'), 'description' => __('In order to make sure your channel, search and other feeds are up to date, the plugin requires a personal API key. It is free to create and only takes a few minutes.', 'feeds-for-youtube'), 'enterAPIKey' => __('Enter or Paste API Key', 'feeds-for-youtube'), 'enterAccessToken' => __('Enter or Paste Access Token', 'feeds-for-youtube'), 'btnOne' => __('Add API Key (Recommended)', 'feeds-for-youtube'), 'learnMoreLink' => 'https://smashballoon.com/doc/youtube-api-key/?youtube', 'btnTwo' => __('Connect a YouTube account instead', 'feeds-for-youtube'), 'btnThree' => __('Cannot connect a YouTube account? Connect Manually', 'feeds-for-youtube'), 'connectYouTubeAccount' => __('Connect YouTube Account', 'feeds-for-youtube'), 'back' => __('Back', 'feeds-for-youtube'), 'note' => __('Note: Connecting a YouTube account instead of API key might not allow you access to a few features like viewing likes and comments for videos.', 'feeds-for-youtube'), 'errorMsg' => __('Entered API Key is invalid. You can double check the API Key or learn more about generating them here', 'feeds-for-youtube'), 'errorMsgAccessToken' => __('Entered Access Token is invalid. You can double check the Access Token or learn more about generating them <a href="https://smashballoon.com/youtube-feed/token" target="_blank">here</a>', 'feeds-for-youtube'), 'add' => __('Add', 'feeds-for-youtube'), 'learnMore' => __('Learn more about how to create and add an API Key here', 'feeds-for-youtube'), 'manualConnectionTitle' => __('Connect with an Access Token', 'feeds-for-youtube'), 'manualConnectionDescription' => __('Cannot connect a YouTube account from the plugin? Try connecting from our website <a href="https://smashballoon.com/youtube-feed/token" target="_blank">here</a>, and paste the generated access token below.', 'feeds-for-youtube'), 'secondModalTitle' => __('Are you sure you want to connect a YouTube account?', 'feeds-for-youtube'), 'secondModalDescription' => __('Due to limitations of YouTube API, connecting via YouTube account will also display private, unpublished and draft videos. To avoid showing those videos, we recommend you use an API key.', 'feeds-for-youtube'));
    }
}
